/*-
 * Copyright (c) 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that: (1) source distributions retain this entire copyright
 * notice and comment, and (2) distributions including binaries display
 * the following acknowledgement:  ``This product includes software
 * developed by the University of California, Berkeley and its contributors''
 * in the documentation or other materials provided with the distribution
 * and in all advertising materials mentioning features or use of this
 * software. Neither the name of the University nor the names of its
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#if defined(LIBC_SCCS) && !defined(lint)
static char sccsid[] = "@(#)sigsetjmp.c	5.1 (Berkeley) 5/27/90";
#endif /* LIBC_SCCS and not lint */

#define KERNEL
#include "ixemul.h"

#include <setjmp.h>

int
sigsetjmp(sigjmp_buf env, int savemask)
{
	return((env[0] = savemask) ? setjmp(env + 1) : _setjmp(env + 1));
}

void volatile
siglongjmp(sigjmp_buf env, int val)
{
	if (env[0])
		longjmp(env + 1, val);
	else
		_longjmp(env + 1, val);
}
