#include <inline/mathieeedoubbas.h>

/*
 * modf(value, iptr): return fractional part of value, and stores the
 * integral part into iptr (a pointer to double).
 */

double
modf (double value, double *iptr)
{
  /* if value negative */
  if (IEEEDPTst (value) < 0)
    {
      /* in that case, the integer part is calculated by ceil() */
      *iptr = IEEEDPCeil (value);
      return IEEEDPSub (*iptr, value);
    }
  else
    {

      /* if positive, we go for the floor() */
      *iptr = IEEEDPFloor (value);
      return IEEEDPSub (value, *iptr);
    }
}
