/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that: (1) source distributions retain this entire copyright
 * notice and comment, and (2) distributions including binaries display
 * the following acknowledgement:  ``This product includes software
 * developed by the University of California, Berkeley and its contributors''
 * in the documentation or other materials provided with the distribution
 * and in all advertising materials mentioning features or use of this
 * software. Neither the name of the University nor the names of its
 * contributors may be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#if defined(LIBC_SCCS) && !defined(lint)
static char sccsid[] = "@(#)alarm.c	5.4 (Berkeley) 6/1/90";
#endif /* LIBC_SCCS and not lint */

#define KERNEL
#include "ixemul.h"

/*
 * Backwards compatible alarm.
 */
#include <sys/time.h>

int
alarm(int secs)
{
  struct itimerval it, oitv;
  register struct itimerval *itp = &it;

  timerclear(&itp->it_interval);
  itp->it_value.tv_sec = secs;
  itp->it_value.tv_usec = 0;

  if (syscall (SYS_setitimer, ITIMER_REAL, itp, &oitv) < 0)
    return (-1);

  if (oitv.it_value.tv_usec)
    oitv.it_value.tv_sec++;

  return oitv.it_value.tv_sec;
}
