/* shell.c generated by valac 0.56.17, the Vala compiler
 * generated from shell.vala, do not modify */

/* Shell command functions.

   Copyright (c) 1997-2020 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <estr.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef struct _Block11Data Block11Data;
#define _immutable_estr_unref0(var) ((var == NULL) ? NULL : (var = (immutable_estr_unref (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_BUFFER (buffer_get_type ())
#define BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUFFER, Buffer))
#define BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUFFER, BufferClass))
#define IS_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUFFER))
#define IS_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUFFER))
#define BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUFFER, BufferClass))

typedef struct _Buffer Buffer;
typedef struct _BufferClass BufferClass;

#define TYPE_REGION (region_get_type ())
#define REGION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGION, Region))
#define REGION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGION, RegionClass))
#define IS_REGION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGION))
#define IS_REGION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGION))
#define REGION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGION, RegionClass))

typedef struct _Region Region;
typedef struct _RegionClass RegionClass;
#define _region_unref0(var) ((var == NULL) ? NULL : (var = (region_unref (var), NULL)))
typedef void (*BufferWriter) (gpointer user_data);
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	FLAGS_NEED_RESYNC = 1 << 0,
	FLAGS_SET_UNIARG = 1 << 1,
	FLAGS_UNIARG_EMPTY = 1 << 2,
	FLAGS_DEFINING_MACRO = 1 << 3
} Flags;

#define TYPE_FLAGS (flags_get_type ())
typedef gboolean (*Function) (glong uniarg, GeeQueue* args);

#define TYPE_LISP_FUNC (lisp_func_get_type ())
#define LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LISP_FUNC, LispFunc))
#define LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LISP_FUNC, LispFuncClass))
#define IS_LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LISP_FUNC))
#define IS_LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LISP_FUNC))
#define LISP_FUNC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LISP_FUNC, LispFuncClass))

typedef struct _LispFunc LispFunc;
typedef struct _LispFuncClass LispFuncClass;
#define _lisp_func_unref0(var) ((var == NULL) ? NULL : (var = (lisp_func_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Block11Data {
	int _ref_count_;
	Estr* res;
};

VALA_EXTERN Buffer* cur_bp;
VALA_EXTERN Flags lastflag;

VALA_EXTERN gboolean pipe_command (const gchar* cmd,
                       ImmutableEstr* instr,
                       gboolean do_insert,
                       gboolean do_replace);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
VALA_EXTERN void minibuf_write (const gchar* fmt,
                    ...);
VALA_EXTERN gpointer buffer_ref (gpointer instance);
VALA_EXTERN void buffer_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_buffer (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_buffer (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_buffer (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_buffer (const GValue* value);
VALA_EXTERN GType buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Buffer, buffer_unref)
VALA_EXTERN gboolean buffer_warn_if_no_mark (Buffer* self);
VALA_EXTERN gpointer region_ref (gpointer instance);
VALA_EXTERN void region_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_region (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_region (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_region (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_region (const GValue* value);
VALA_EXTERN GType region_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Region, region_unref)
VALA_EXTERN Region* region_calculate (void);
VALA_EXTERN void buffer_goto_offset (Buffer* self,
                         gsize o);
VALA_EXTERN gsize region_get_start (Region* self);
VALA_EXTERN gsize region_size (Region* self);
VALA_EXTERN gboolean buffer_replace_estr (Buffer* self,
                              gsize del,
                              ImmutableEstr* es);
VALA_EXTERN void write_temp_buffer (const gchar* name,
                        gboolean show,
                        BufferWriter func,
                        gpointer func_target);
static void ____lambda133_ (Block11Data* _data11_);
VALA_EXTERN gboolean buffer_insert_estr (Buffer* self,
                             ImmutableEstr* es);
static void _____lambda133__buffer_writer (gpointer self);
VALA_EXTERN gchar* minibuf_read_shell_command (void);
VALA_EXTERN gchar* minibuf_read (const gchar* fmt,
                     const gchar* value,
                     ...);
VALA_EXTERN gboolean funcall (const gchar* name,
                  glong* maybe_uniarg,
                  GeeQueue* args);
VALA_EXTERN void shell_init (void);
static gboolean __lambda132_ (glong uniarg,
                       GeeQueue* args);
VALA_EXTERN gboolean bool_arg (GeeQueue* args,
                   gboolean* val);
VALA_EXTERN GType flags_get_type (void) G_GNUC_CONST ;
static gboolean ___lambda132__function (glong uniarg,
                                 GeeQueue* args);
VALA_EXTERN LispFunc* lisp_func_new (const gchar* name,
                         Function func,
                         gboolean interactive,
                         const gchar* doc);
VALA_EXTERN LispFunc* lisp_func_construct (GType object_type,
                               const gchar* name,
                               Function func,
                               gboolean interactive,
                               const gchar* doc);
VALA_EXTERN gpointer lisp_func_ref (gpointer instance);
VALA_EXTERN void lisp_func_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_lisp_func (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_lisp_func (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_lisp_func (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_lisp_func (const GValue* value);
VALA_EXTERN GType lisp_func_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LispFunc, lisp_func_unref)
static gboolean __lambda134_ (glong uniarg,
                       GeeQueue* args);
VALA_EXTERN ImmutableEstr* buffer_get_region (Buffer* self,
                                  Region* r);
static gboolean ___lambda134__function (glong uniarg,
                                 GeeQueue* args);

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
#line 20 "src/shell.vala"
	g_atomic_int_inc (&_data11_->_ref_count_);
#line 20 "src/shell.vala"
	return _data11_;
#line 215 "shell.c"
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
#line 20 "src/shell.vala"
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
#line 20 "src/shell.vala"
		_immutable_estr_unref0 (_data11_->res);
#line 20 "src/shell.vala"
		g_slice_free (Block11Data, _data11_);
#line 229 "shell.c"
	}
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
#line 1609 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1610 "glib-2.0.vapi"
	res = (guint8*) self;
#line 1610 "glib-2.0.vapi"
	res_length1 = -1;
#line 1610 "glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1611 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1611 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1611 "glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1612 "glib-2.0.vapi"
	_tmp2_ = res;
#line 1612 "glib-2.0.vapi"
	_tmp2__length1 = res_length1;
#line 1612 "glib-2.0.vapi"
	if (result_length1) {
#line 1612 "glib-2.0.vapi"
		*result_length1 = _tmp2__length1;
#line 267 "shell.c"
	}
#line 1612 "glib-2.0.vapi"
	result = _tmp2_;
#line 1612 "glib-2.0.vapi"
	return result;
#line 273 "shell.c"
}

static gint
_vala_g_bytes_get_length (GBytes* self)
{
	gint result;
#line 5999 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 6001 "glib-2.0.vapi"
	result = (gint) g_bytes_get_size (self);
#line 6001 "glib-2.0.vapi"
	return result;
#line 286 "shell.c"
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1214 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1215 "glib-2.0.vapi"
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
#line 1215 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1217 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1217 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 308 "shell.c"
		gchar* _tmp2_;
#line 1218 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1218 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1218 "glib-2.0.vapi"
		return result;
#line 316 "shell.c"
	} else {
#line 1220 "glib-2.0.vapi"
		result = -1;
#line 1220 "glib-2.0.vapi"
		return result;
#line 322 "shell.c"
	}
}

static void
____lambda133_ (Block11Data* _data11_)
{
	Buffer* _tmp0_;
	Estr* _tmp1_;
#line 57 "src/shell.vala"
	_tmp0_ = cur_bp;
#line 57 "src/shell.vala"
	_tmp1_ = _data11_->res;
#line 57 "src/shell.vala"
	buffer_insert_estr (_tmp0_, (ImmutableEstr*) _tmp1_);
#line 337 "shell.c"
}

static void
_____lambda133__buffer_writer (gpointer self)
{
#line 54 "src/shell.vala"
	____lambda133_ (self);
#line 345 "shell.c"
}

gboolean
pipe_command (const gchar* cmd,
              ImmutableEstr* instr,
              gboolean do_insert,
              gboolean do_replace)
{
	Block11Data* _data11_;
	GSubprocessFlags flags = 0U;
	GBytes* input = NULL;
	GBytes* output = NULL;
	GBytes* _tmp12_;
	gboolean _tmp23_ = FALSE;
	Estr* _tmp24_;
	GError* _inner_error0_ = NULL;
	gboolean result;
#line 20 "src/shell.vala"
	g_return_val_if_fail (cmd != NULL, FALSE);
#line 20 "src/shell.vala"
	_data11_ = g_slice_new0 (Block11Data);
#line 20 "src/shell.vala"
	_data11_->_ref_count_ = 1;
#line 21 "src/shell.vala"
	flags = G_SUBPROCESS_FLAGS_STDOUT_PIPE;
#line 22 "src/shell.vala"
	input = NULL;
#line 23 "src/shell.vala"
	if (instr != NULL) {
#line 375 "shell.c"
		gchar* _tmp0_;
		gchar* _tmp1_;
		guint8* _tmp2_;
		gint _tmp2__length1;
		gint _tmp3_ = 0;
		guint8* _tmp4_;
		gint _tmp4__length1;
		GBytes* _tmp5_;
#line 24 "src/shell.vala"
		_tmp0_ = immutable_estr_get_text (instr);
#line 24 "src/shell.vala"
		_tmp1_ = _tmp0_;
#line 24 "src/shell.vala"
		_tmp2_ = string_get_data ((const gchar*) _tmp1_, &_tmp3_);
#line 24 "src/shell.vala"
		_tmp2__length1 = _tmp3_;
#line 24 "src/shell.vala"
		_tmp4_ = _tmp2_;
#line 24 "src/shell.vala"
		_tmp4__length1 = _tmp2__length1;
#line 24 "src/shell.vala"
		_tmp5_ = g_bytes_new_static (_tmp4_, _tmp4__length1);
#line 24 "src/shell.vala"
		_g_bytes_unref0 (input);
#line 24 "src/shell.vala"
		input = _tmp5_;
#line 25 "src/shell.vala"
		flags |= G_SUBPROCESS_FLAGS_STDIN_PIPE;
#line 404 "shell.c"
	}
	{
		GSubprocess* process = NULL;
		GSubprocess* _tmp6_;
		GSubprocess* _tmp7_;
		GBytes* _tmp8_;
		GBytes* _tmp9_ = NULL;
		GBytes* _tmp10_;
#line 29 "src/shell.vala"
		_tmp6_ = g_subprocess_new (flags, &_inner_error0_, "/bin/sh", "-c", cmd, NULL);
#line 29 "src/shell.vala"
		process = _tmp6_;
#line 29 "src/shell.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 419 "shell.c"
			goto __catch0_g_error;
		}
#line 30 "src/shell.vala"
		_tmp7_ = process;
#line 30 "src/shell.vala"
		_tmp8_ = input;
#line 30 "src/shell.vala"
		g_subprocess_communicate (_tmp7_, _tmp8_, NULL, &_tmp9_, NULL, &_inner_error0_);
#line 30 "src/shell.vala"
		_g_bytes_unref0 (output);
#line 30 "src/shell.vala"
		output = _tmp9_;
#line 30 "src/shell.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 30 "src/shell.vala"
			_g_object_unref0 (process);
#line 436 "shell.c"
			goto __catch0_g_error;
		}
#line 31 "src/shell.vala"
		_tmp10_ = output;
#line 31 "src/shell.vala"
		_vala_assert (_tmp10_ != NULL, "output != null");
#line 28 "src/shell.vala"
		_g_object_unref0 (process);
#line 445 "shell.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 28 "src/shell.vala"
		g_clear_error (&_inner_error0_);
#line 33 "src/shell.vala"
		result = FALSE;
#line 33 "src/shell.vala"
		_g_bytes_unref0 (output);
#line 33 "src/shell.vala"
		_g_bytes_unref0 (input);
#line 33 "src/shell.vala"
		block11_data_unref (_data11_);
#line 33 "src/shell.vala"
		_data11_ = NULL;
#line 33 "src/shell.vala"
		return result;
#line 464 "shell.c"
	}
	__finally0:
#line 28 "src/shell.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 469 "shell.c"
		gboolean _tmp11_ = FALSE;
#line 28 "src/shell.vala"
		_g_bytes_unref0 (output);
#line 28 "src/shell.vala"
		_g_bytes_unref0 (input);
#line 28 "src/shell.vala"
		block11_data_unref (_data11_);
#line 28 "src/shell.vala"
		_data11_ = NULL;
#line 28 "src/shell.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 28 "src/shell.vala"
		g_clear_error (&_inner_error0_);
#line 28 "src/shell.vala"
		return _tmp11_;
#line 485 "shell.c"
	}
#line 35 "src/shell.vala"
	_data11_->res = NULL;
#line 36 "src/shell.vala"
	_tmp12_ = output;
#line 36 "src/shell.vala"
	if (_tmp12_ != NULL) {
#line 493 "shell.c"
		GBytes* _tmp13_;
		gsize _tmp14_ = 0;
		guint8* _tmp15_;
		GBytes* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		ImmutableEstr* _tmp19_;
		ImmutableEstr* _tmp20_;
		Estr* _tmp21_;
		Estr* _tmp22_;
#line 37 "src/shell.vala"
		_tmp13_ = output;
#line 37 "src/shell.vala"
		_tmp15_ = g_bytes_get_data (_tmp13_, &_tmp14_);
#line 37 "src/shell.vala"
		_tmp16_ = output;
#line 37 "src/shell.vala"
		_tmp17_ = _vala_g_bytes_get_length (_tmp16_);
#line 37 "src/shell.vala"
		_tmp18_ = _tmp17_;
#line 37 "src/shell.vala"
		_tmp19_ = immutable_estr_of ((const gchar*) _tmp15_, (gsize) _tmp18_, IMMUTABLE_ESTR_eol_lf);
#line 37 "src/shell.vala"
		_tmp20_ = _tmp19_;
#line 37 "src/shell.vala"
		_tmp21_ = estr_copy (_tmp20_);
#line 37 "src/shell.vala"
		_immutable_estr_unref0 (_data11_->res);
#line 37 "src/shell.vala"
		_data11_->res = _tmp21_;
#line 37 "src/shell.vala"
		_immutable_estr_unref0 (_tmp20_);
#line 38 "src/shell.vala"
		_tmp22_ = _data11_->res;
#line 38 "src/shell.vala"
		estr_set_eol_from_text (_tmp22_);
#line 530 "shell.c"
	}
#line 40 "src/shell.vala"
	_tmp24_ = _data11_->res;
#line 40 "src/shell.vala"
	if (_tmp24_ == NULL) {
#line 40 "src/shell.vala"
		_tmp23_ = TRUE;
#line 538 "shell.c"
	} else {
		Estr* _tmp25_;
		gsize _tmp26_;
		gsize _tmp27_;
#line 40 "src/shell.vala"
		_tmp25_ = _data11_->res;
#line 40 "src/shell.vala"
		_tmp26_ = immutable_estr_get_length ((ImmutableEstr*) _tmp25_);
#line 40 "src/shell.vala"
		_tmp27_ = _tmp26_;
#line 40 "src/shell.vala"
		_tmp23_ = _tmp27_ == ((gsize) 0);
#line 551 "shell.c"
	}
#line 40 "src/shell.vala"
	if (_tmp23_) {
#line 41 "src/shell.vala"
		minibuf_write ("(Shell command succeeded with no output)", NULL);
#line 557 "shell.c"
	} else {
#line 43 "src/shell.vala"
		if (do_insert) {
#line 561 "shell.c"
			gsize del = 0UL;
			gboolean _tmp28_ = FALSE;
			Buffer* _tmp36_;
			Estr* _tmp37_;
#line 44 "src/shell.vala"
			del = (gsize) 0;
#line 45 "src/shell.vala"
			if (do_replace) {
#line 570 "shell.c"
				Buffer* _tmp29_;
#line 45 "src/shell.vala"
				_tmp29_ = cur_bp;
#line 45 "src/shell.vala"
				_tmp28_ = !buffer_warn_if_no_mark (_tmp29_);
#line 576 "shell.c"
			} else {
#line 45 "src/shell.vala"
				_tmp28_ = FALSE;
#line 580 "shell.c"
			}
#line 45 "src/shell.vala"
			if (_tmp28_) {
#line 584 "shell.c"
				Region* r = NULL;
				Region* _tmp30_;
				Buffer* _tmp31_;
				Region* _tmp32_;
				gsize _tmp33_;
				gsize _tmp34_;
				Region* _tmp35_;
#line 46 "src/shell.vala"
				_tmp30_ = region_calculate ();
#line 46 "src/shell.vala"
				r = _tmp30_;
#line 47 "src/shell.vala"
				_tmp31_ = cur_bp;
#line 47 "src/shell.vala"
				_tmp32_ = r;
#line 47 "src/shell.vala"
				_tmp33_ = region_get_start (_tmp32_);
#line 47 "src/shell.vala"
				_tmp34_ = _tmp33_;
#line 47 "src/shell.vala"
				buffer_goto_offset (_tmp31_, _tmp34_);
#line 48 "src/shell.vala"
				_tmp35_ = r;
#line 48 "src/shell.vala"
				del = region_size (_tmp35_);
#line 45 "src/shell.vala"
				_region_unref0 (r);
#line 612 "shell.c"
			}
#line 50 "src/shell.vala"
			_tmp36_ = cur_bp;
#line 50 "src/shell.vala"
			_tmp37_ = _data11_->res;
#line 50 "src/shell.vala"
			buffer_replace_estr (_tmp36_, del, (ImmutableEstr*) _tmp37_);
#line 620 "shell.c"
		} else {
			gint eol_pos = 0;
			Estr* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gboolean _tmp41_ = FALSE;
			gboolean more_than_one_line = FALSE;
#line 52 "src/shell.vala"
			_tmp38_ = _data11_->res;
#line 52 "src/shell.vala"
			_tmp39_ = immutable_estr_get_text ((ImmutableEstr*) _tmp38_);
#line 52 "src/shell.vala"
			_tmp40_ = _tmp39_;
#line 52 "src/shell.vala"
			eol_pos = string_last_index_of_char ((const gchar*) _tmp40_, (gunichar) '\n', 0);
#line 53 "src/shell.vala"
			if (eol_pos != -1) {
#line 638 "shell.c"
				Estr* _tmp42_;
				gsize _tmp43_;
				gsize _tmp44_;
#line 53 "src/shell.vala"
				_tmp42_ = _data11_->res;
#line 53 "src/shell.vala"
				_tmp43_ = immutable_estr_get_length ((ImmutableEstr*) _tmp42_);
#line 53 "src/shell.vala"
				_tmp44_ = _tmp43_;
#line 53 "src/shell.vala"
				_tmp41_ = ((gsize) eol_pos) != (_tmp44_ - 1);
#line 650 "shell.c"
			} else {
#line 53 "src/shell.vala"
				_tmp41_ = FALSE;
#line 654 "shell.c"
			}
#line 53 "src/shell.vala"
			more_than_one_line = _tmp41_;
#line 54 "src/shell.vala"
			write_temp_buffer ("*Shell Command Output*", more_than_one_line, _____lambda133__buffer_writer, _data11_);
#line 59 "src/shell.vala"
			if (!more_than_one_line) {
#line 662 "shell.c"
				Estr* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
#line 60 "src/shell.vala"
				_tmp45_ = _data11_->res;
#line 60 "src/shell.vala"
				_tmp46_ = immutable_estr_get_text ((ImmutableEstr*) _tmp45_);
#line 60 "src/shell.vala"
				_tmp47_ = _tmp46_;
#line 60 "src/shell.vala"
				minibuf_write ("%s", _tmp47_, NULL);
#line 674 "shell.c"
			}
		}
	}
#line 64 "src/shell.vala"
	result = TRUE;
#line 64 "src/shell.vala"
	_g_bytes_unref0 (output);
#line 64 "src/shell.vala"
	_g_bytes_unref0 (input);
#line 64 "src/shell.vala"
	block11_data_unref (_data11_);
#line 64 "src/shell.vala"
	_data11_ = NULL;
#line 64 "src/shell.vala"
	return result;
#line 690 "shell.c"
}

gchar*
minibuf_read_shell_command (void)
{
	gchar* ms = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp7_;
	gchar* result;
#line 68 "src/shell.vala"
	_tmp0_ = minibuf_read ("Shell command: ", "", NULL);
#line 68 "src/shell.vala"
	ms = _tmp0_;
#line 69 "src/shell.vala"
	_tmp1_ = ms;
#line 69 "src/shell.vala"
	if (_tmp1_ == NULL) {
#line 70 "src/shell.vala"
		funcall ("keyboard-quit", NULL, NULL);
#line 71 "src/shell.vala"
		result = NULL;
#line 71 "src/shell.vala"
		_g_free0 (ms);
#line 71 "src/shell.vala"
		return result;
#line 721 "shell.c"
	}
#line 74 "src/shell.vala"
	_tmp3_ = ms;
#line 74 "src/shell.vala"
	_tmp4_ = strlen (_tmp3_);
#line 74 "src/shell.vala"
	_tmp5_ = _tmp4_;
#line 74 "src/shell.vala"
	if (_tmp5_ == 0) {
#line 74 "src/shell.vala"
		_tmp2_ = NULL;
#line 733 "shell.c"
	} else {
		const gchar* _tmp6_;
#line 74 "src/shell.vala"
		_tmp6_ = ms;
#line 74 "src/shell.vala"
		_tmp2_ = _tmp6_;
#line 740 "shell.c"
	}
#line 74 "src/shell.vala"
	_tmp7_ = g_strdup (_tmp2_);
#line 74 "src/shell.vala"
	result = _tmp7_;
#line 74 "src/shell.vala"
	_g_free0 (ms);
#line 74 "src/shell.vala"
	return result;
#line 750 "shell.c"
}

static gboolean
__lambda132_ (glong uniarg,
              GeeQueue* args)
{
	gboolean ok = FALSE;
	gchar* cmd = NULL;
	const gchar* _tmp1_;
	gboolean insert = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	const gchar* _tmp5_;
	gboolean result;
#line 82 "src/shell.vala"
	ok = TRUE;
#line 83 "src/shell.vala"
	cmd = NULL;
#line 84 "src/shell.vala"
	if (args != NULL) {
#line 771 "shell.c"
		gpointer _tmp0_;
#line 85 "src/shell.vala"
		_tmp0_ = gee_queue_poll (args);
#line 85 "src/shell.vala"
		_g_free0 (cmd);
#line 85 "src/shell.vala"
		cmd = (gchar*) _tmp0_;
#line 779 "shell.c"
	}
#line 86 "src/shell.vala"
	_tmp1_ = cmd;
#line 86 "src/shell.vala"
	if (_tmp1_ == NULL) {
#line 785 "shell.c"
		gchar* _tmp2_;
#line 87 "src/shell.vala"
		_tmp2_ = minibuf_read_shell_command ();
#line 87 "src/shell.vala"
		_g_free0 (cmd);
#line 87 "src/shell.vala"
		cmd = _tmp2_;
#line 793 "shell.c"
	}
#line 89 "src/shell.vala"
	_tmp4_ = bool_arg (args, &_tmp3_);
#line 89 "src/shell.vala"
	insert = _tmp3_;
#line 89 "src/shell.vala"
	if (!_tmp4_) {
#line 90 "src/shell.vala"
		insert = (lastflag & FLAGS_SET_UNIARG) == FLAGS_SET_UNIARG;
#line 803 "shell.c"
	}
#line 92 "src/shell.vala"
	_tmp5_ = cmd;
#line 92 "src/shell.vala"
	if (_tmp5_ != NULL) {
#line 809 "shell.c"
		const gchar* _tmp6_;
#line 93 "src/shell.vala"
		_tmp6_ = cmd;
#line 93 "src/shell.vala"
		ok = pipe_command (_tmp6_, NULL, insert, FALSE);
#line 815 "shell.c"
	}
#line 94 "src/shell.vala"
	result = ok;
#line 94 "src/shell.vala"
	_g_free0 (cmd);
#line 94 "src/shell.vala"
	return result;
#line 823 "shell.c"
}

static gboolean
___lambda132__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda132_ (uniarg, args);
#line 79 "src/shell.vala"
	return result;
#line 834 "shell.c"
}

static gboolean
__lambda134_ (glong uniarg,
              GeeQueue* args)
{
	gchar* cmd = NULL;
	const gchar* _tmp5_;
	gboolean insert = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_;
	gboolean ok = FALSE;
	const gchar* _tmp9_;
	gboolean result;
#line 113 "src/shell.vala"
	cmd = NULL;
#line 114 "src/shell.vala"
	if (args != NULL) {
#line 853 "shell.c"
		gpointer _tmp0_;
		gchar* _tmp1_;
		gpointer _tmp2_;
		gchar* _tmp3_;
		gpointer _tmp4_;
#line 116 "src/shell.vala"
		_tmp0_ = gee_queue_poll (args);
#line 116 "src/shell.vala"
		_tmp1_ = (gchar*) _tmp0_;
#line 116 "src/shell.vala"
		_g_free0 (_tmp1_);
#line 117 "src/shell.vala"
		_tmp2_ = gee_queue_poll (args);
#line 117 "src/shell.vala"
		_tmp3_ = (gchar*) _tmp2_;
#line 117 "src/shell.vala"
		_g_free0 (_tmp3_);
#line 118 "src/shell.vala"
		_tmp4_ = gee_queue_poll (args);
#line 118 "src/shell.vala"
		_g_free0 (cmd);
#line 118 "src/shell.vala"
		cmd = (gchar*) _tmp4_;
#line 877 "shell.c"
	}
#line 120 "src/shell.vala"
	_tmp5_ = cmd;
#line 120 "src/shell.vala"
	if (_tmp5_ == NULL) {
#line 883 "shell.c"
		gchar* _tmp6_;
#line 121 "src/shell.vala"
		_tmp6_ = minibuf_read_shell_command ();
#line 121 "src/shell.vala"
		_g_free0 (cmd);
#line 121 "src/shell.vala"
		cmd = _tmp6_;
#line 891 "shell.c"
	}
#line 123 "src/shell.vala"
	_tmp8_ = bool_arg (args, &_tmp7_);
#line 123 "src/shell.vala"
	insert = _tmp7_;
#line 123 "src/shell.vala"
	if (!_tmp8_) {
#line 124 "src/shell.vala"
		insert = (lastflag & FLAGS_SET_UNIARG) == FLAGS_SET_UNIARG;
#line 901 "shell.c"
	}
#line 126 "src/shell.vala"
	ok = TRUE;
#line 127 "src/shell.vala"
	_tmp9_ = cmd;
#line 127 "src/shell.vala"
	if (_tmp9_ != NULL) {
#line 909 "shell.c"
		Buffer* _tmp10_;
#line 128 "src/shell.vala"
		_tmp10_ = cur_bp;
#line 128 "src/shell.vala"
		if (buffer_warn_if_no_mark (_tmp10_)) {
#line 129 "src/shell.vala"
			ok = FALSE;
#line 917 "shell.c"
		} else {
			const gchar* _tmp11_;
			Buffer* _tmp12_;
			Region* _tmp13_;
			Region* _tmp14_;
			ImmutableEstr* _tmp15_;
			ImmutableEstr* _tmp16_;
#line 131 "src/shell.vala"
			_tmp11_ = cmd;
#line 131 "src/shell.vala"
			_tmp12_ = cur_bp;
#line 131 "src/shell.vala"
			_tmp13_ = region_calculate ();
#line 131 "src/shell.vala"
			_tmp14_ = _tmp13_;
#line 131 "src/shell.vala"
			_tmp15_ = buffer_get_region (_tmp12_, _tmp14_);
#line 131 "src/shell.vala"
			_tmp16_ = _tmp15_;
#line 131 "src/shell.vala"
			ok = pipe_command (_tmp11_, _tmp16_, insert, TRUE);
#line 131 "src/shell.vala"
			_immutable_estr_unref0 (_tmp16_);
#line 131 "src/shell.vala"
			_region_unref0 (_tmp14_);
#line 943 "shell.c"
		}
	}
#line 133 "src/shell.vala"
	result = ok;
#line 133 "src/shell.vala"
	_g_free0 (cmd);
#line 133 "src/shell.vala"
	return result;
#line 952 "shell.c"
}

static gboolean
___lambda134__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda134_ (uniarg, args);
#line 110 "src/shell.vala"
	return result;
#line 963 "shell.c"
}

void
shell_init (void)
{
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
	LispFunc* _tmp2_;
	LispFunc* _tmp3_;
#line 79 "src/shell.vala"
	_tmp0_ = lisp_func_new ("shell-command", ___lambda132__function, TRUE, "Execute string COMMAND in inferior shell; display output, if any.\n" \
"With prefix argument, insert the command's output at point.\n" \
"\n" \
"Command is executed synchronously.  The output appears in the buffer\n" \
"`*Shell Command Output*'.  If the output is short enough to display\n" \
"in the echo area, it is shown there, but it is nonetheless available\n" \
"in buffer `*Shell Command Output*' even though that buffer is not\n" \
"automatically displayed.\n" \
"\n" \
"The optional second argument OUTPUT-BUFFER, if non-nil,\n" \
"says to insert the output in the current buffer.");
#line 79 "src/shell.vala"
	_tmp1_ = _tmp0_;
#line 79 "src/shell.vala"
	_lisp_func_unref0 (_tmp1_);
#line 110 "src/shell.vala"
	_tmp2_ = lisp_func_new ("shell-command-on-region", ___lambda134__function, TRUE, "Execute string command in inferior shell with region as input.\n" \
"Normally display output (if any) in temp buffer `*Shell Command Output" \
"*';\n" \
"Prefix arg means replace the region with it.  Return the exit code of\n" \
"command.\n" \
"\n" \
"If the command generates output, the output may be displayed\n" \
"in the echo area or in a buffer.\n" \
"If the output is short enough to display in the echo area, it is shown" \
"\n" \
"there.  Otherwise it is displayed in the buffer `*Shell Command Output" \
"*'.\n" \
"The output is available in that buffer in both cases.");
#line 110 "src/shell.vala"
	_tmp3_ = _tmp2_;
#line 110 "src/shell.vala"
	_lisp_func_unref0 (_tmp3_);
#line 985 "shell.c"
}

