/*
 * This file is part of LibEuFin.
 * Copyright (C) 2025 Taler Systems S.A.

 * LibEuFin is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation; either version 3, or
 * (at your option) any later version.

 * LibEuFin is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Affero General
 * Public License for more details.

 * You should have received a copy of the GNU Affero General Public
 * License along with LibEuFin; see the file COPYING.  If not, see
 * <http://www.gnu.org/licenses/>
 */

package tech.libeufin.ebisync.db

import kotlinx.coroutines.flow.Flow
import org.slf4j.Logger
import org.slf4j.LoggerFactory
import tech.libeufin.common.db.*
import tech.libeufin.common.*
import tech.libeufin.ebics.EbicsDAO
import java.util.*
import java.util.concurrent.ConcurrentHashMap

private val logger: Logger = LoggerFactory.getLogger("libeufin-ebisync-db")

class Database(
    dbConfig: DatabaseConfig
): DbPool(dbConfig, "libeufin-ebisync") {
    // DAOs
    val ebics = EbicsDAO(this)
}