/* This code is machine-generated.  See its source for license
   information. This software is derived from software
   distributed under the GNU GPL version 3 or later. */

/* User-specified code, initial vm2 part: beginning. */

/* User-specified code, initial vm2 part: end */

/* These two macros are convenient for making VM-specific identifiers
   using VM-independent macros from a public header, without polluting
   the global namespace. */
#define JITTER_VM_PREFIX_LOWER_CASE structuredvm
#define JITTER_VM_PREFIX_UPPER_CASE STRUCTUREDVM

//#include <config.h>

#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>

/* Early C code from the user. */

#   include <stdio.h>
  /* End of the early C code from the user. */

#include <jitter/jitter.h>
#include <jitter/jitter-instruction.h>

#define JITTER_THIS_CAN_INCLUDE_JITTER_EXECUTOR_H
#include <jitter/jitter-executor.h>

#ifdef JITTER_ENABLE_ASSEMBLY
#include <jitter/jitter-machine-common.h>
#include <jitter/machine/jitter-machine.h>
#endif // #ifdef JITTER_ENABLE_ASSEMBLY
#include <jitter/jitter-fatal.h>
#include <jitter/jitter-malloc.h>

#include "structuredvm-vm.h"
//#include "structuredvm-meta-instructions.h"
//#include "structuredvm-specialized-instructions.h"
//#include "structuredvm-state.h"

/* Include stack data structure support. */
#include <jitter/jitter-stack.h>

/* Include patch-in definitions, only if patch-in is enabled.  We knoe whether it is
   by checking JITTER_HAVE_PATCH_IN , defined in jitter/jitter-patch-in.h . */
#include <jitter/jitter-patch-in.h>
#ifdef JITTER_HAVE_PATCH_IN
# include <jitter/jitter-fast-branch.h>

  JITTER_DEFECT_DESCRIPTOR_DECLARATIONS_(structuredvm);
  JITTER_PATCH_IN_DESCRIPTOR_DECLARATIONS_(structuredvm);
#endif // #ifdef JITTER_HAVE_PATCH_IN

/* Always include fast-branch definitions, which use patch-ins where possible
   or consist in fallback definitions otherwise. */
#include <jitter/jitter-fast-branch.h>

#define JITTER_FAST_BRANCH_PREFIX structuredvm_

/* Most of the needed macros are in jitter-executor.h .  This however
   needs to be here, as it relies on a prefix to be substituted. */
#define JITTER_STATE_BACKING  \
  (jitter_original_state->structuredvm_state_backing)
/* Expand to an l-value evaluating to the pending_notification field for
   the current state. */
#define JITTER_PENDING_NOTIFICATIONS  \
  (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA->pending_notifications)
/* Expand to an l-value evaluating to the pending field of the struct
   jitter_signal_notification element for the given signal, for the
   current state. */
#define JITTER_PENDING_SIGNAL_NOTIFICATION(signal_id)  \
  ((STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA->pending_signal_notifications + (signal_id))->pending)

/* Expand to the i-th fast register as an lvalue.  This is used internally,
   always with a literal index . */
#define JITTER_FAST_REGISTER(class, index)                             \
  (JITTER_CONCATENATE_FOUR(jitter_state_runtime.jitter_fast_register_, \
                           class, _, index))

/* Expand to the 0-th fast r-register as an lvalue. */
#define JITTER_FAST_REGISTER_r_0 JITTER_FAST_REGISTER(r, 0)

/* Expand to the 1-th fast r-register as an lvalue. */
#define JITTER_FAST_REGISTER_r_1 JITTER_FAST_REGISTER(r, 1)

/* Expand to a slow register lvalue, given an offset in bytes from the base. */
#define JITTER_SLOW_REGISTER_FROM_OFFSET(c, offset)               \
  (* ((JITTER_CONCATENATE_TWO(structuredvm_register_, c) * restrict)  \
      (((char *) jitter_array_base) + offset)))

/* Expand to the i-th register, which must be a slow register, as an lvalue.
   The given index must be a register index counting from 0 and including fast
   regusters as well, if there are any.  For example if an r class had 3 fast
   registers then the first slow register would be %r3, to be accessed as
   JITTER_SLOW_REGISTER(r, 3).  It would be invalid to access %r0, %r1 and
   %r2 which this macro, as %r0, %r1 and %r2 would be fast. */
#define JITTER_SLOW_REGISTER(c, i)                                          \
  JITTER_SLOW_REGISTER_FROM_OFFSET(c, STRUCTUREDVM_SLOW_REGISTER_OFFSET(c, i))

/* It's not possible to have a single macro JITTER_REGISTER taking an index and
   expanding to either a fast or a slow register lvalue, due to CPP conditional
   limitations.  This restriction is unfortunate, but we have to live with it
   as long as we don't switch to a different preprocessor.
   What we can have is a set of zero-argument macros each expanding to a register
   lvalue, for *a limited number* of registers.  Here we define access macros for
   every fast register plus a reasonable number (currently 32) of slow registers,
   per class. */
#define JITTER_REGISTER_r_0    JITTER_FAST_REGISTER(r, 0)
#define JITTER_REGISTER_r_1    JITTER_FAST_REGISTER(r, 1)
#define JITTER_REGISTER_r_2    JITTER_SLOW_REGISTER(r, 2)
#define JITTER_REGISTER_r_3    JITTER_SLOW_REGISTER(r, 3)
#define JITTER_REGISTER_r_4    JITTER_SLOW_REGISTER(r, 4)
#define JITTER_REGISTER_r_5    JITTER_SLOW_REGISTER(r, 5)
#define JITTER_REGISTER_r_6    JITTER_SLOW_REGISTER(r, 6)
#define JITTER_REGISTER_r_7    JITTER_SLOW_REGISTER(r, 7)
#define JITTER_REGISTER_r_8    JITTER_SLOW_REGISTER(r, 8)
#define JITTER_REGISTER_r_9    JITTER_SLOW_REGISTER(r, 9)
#define JITTER_REGISTER_r_10   JITTER_SLOW_REGISTER(r, 10)
#define JITTER_REGISTER_r_11   JITTER_SLOW_REGISTER(r, 11)
#define JITTER_REGISTER_r_12   JITTER_SLOW_REGISTER(r, 12)
#define JITTER_REGISTER_r_13   JITTER_SLOW_REGISTER(r, 13)
#define JITTER_REGISTER_r_14   JITTER_SLOW_REGISTER(r, 14)
#define JITTER_REGISTER_r_15   JITTER_SLOW_REGISTER(r, 15)
#define JITTER_REGISTER_r_16   JITTER_SLOW_REGISTER(r, 16)
#define JITTER_REGISTER_r_17   JITTER_SLOW_REGISTER(r, 17)
#define JITTER_REGISTER_r_18   JITTER_SLOW_REGISTER(r, 18)
#define JITTER_REGISTER_r_19   JITTER_SLOW_REGISTER(r, 19)
#define JITTER_REGISTER_r_20   JITTER_SLOW_REGISTER(r, 20)
#define JITTER_REGISTER_r_21   JITTER_SLOW_REGISTER(r, 21)
#define JITTER_REGISTER_r_22   JITTER_SLOW_REGISTER(r, 22)
#define JITTER_REGISTER_r_23   JITTER_SLOW_REGISTER(r, 23)
#define JITTER_REGISTER_r_24   JITTER_SLOW_REGISTER(r, 24)
#define JITTER_REGISTER_r_25   JITTER_SLOW_REGISTER(r, 25)
#define JITTER_REGISTER_r_26   JITTER_SLOW_REGISTER(r, 26)
#define JITTER_REGISTER_r_27   JITTER_SLOW_REGISTER(r, 27)
#define JITTER_REGISTER_r_28   JITTER_SLOW_REGISTER(r, 28)
#define JITTER_REGISTER_r_29   JITTER_SLOW_REGISTER(r, 29)
#define JITTER_REGISTER_r_30   JITTER_SLOW_REGISTER(r, 30)
#define JITTER_REGISTER_r_31   JITTER_SLOW_REGISTER(r, 31)
#define JITTER_REGISTER_r_32   JITTER_SLOW_REGISTER(r, 32)
#define JITTER_REGISTER_r_33   JITTER_SLOW_REGISTER(r, 33)


#ifdef JITTER_DISPATCH_NO_THREADING

/* Reserve the scratch register, if any. */
#ifdef JITTER_SCRATCH_REGISTER
  register union jitter_word
  jitter_residual_argument_scratch_register_variable asm (JITTER_STRINGIFY(JITTER_SCRATCH_REGISTER));
#endif // #ifdef JITTER_SCRATCH_REGISTER

/* Reserve The Array base register. */
#ifndef JITTER_BASE_REGISTER
# error "the machine does not define JITTER_BASE_REGISTER"
#else
register char * restrict
structuredvm_array_base_register_variable asm (JITTER_STRINGIFY(JITTER_BASE_REGISTER));
#endif // #ifndef JITTER_BASE_REGISTER

/* Reserve registers for our 3 residual arguments.  If this particular VM doesn't
   need all of those supported by the assembly machine then reserve only the first
   ones.  If, on the other hand, we need more residual arguments than we have
   available registers, use CPP macros to map the remaining residual arguments
   to memory locations relative to the base, with constant offsets. */

/* Define a macro for the 0-th residual as a register, or as a residual
   memory slot.  Also define a macro expanding to inline asm code with
   output constraints on the appropriate register or memory, to let GCC
   know that its value has been changed by unknown code. */
#if (0 < JITTER_RESIDUAL_REGISTER_NO)
  register union jitter_word
  jitter_residual_argument_0_register_variable asm (JITTER_STRINGIFY(JITTER_RESIDUAL_REGISTER_0));
# define JITTER_RESIDUAL_ARGUMENT_0               \
    jitter_residual_argument_0_register_variable
# define JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY                 \
    JITTER_MARK_REGISTER_AS_SET_BY_ASSEMBLY(jitter_residual_argument_0_register_variable)
#else
# define JITTER_RESIDUAL_ARGUMENT_0  \
    (* (union jitter_word *)                 \
       (jitter_array_base + STRUCTUREDVM_RESIDUAL_OFFSET(0)))
# define JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY                    \
    JITTER_MARK_MEMORY_AS_SET_BY_ASSEMBLY(JITTER_RESIDUAL_ARGUMENT_0)
#endif // #if (0 < JITTER_RESIDUAL_REGISTER_NO)

/* Define a macro for the 1-th residual as a register, or as a residual
   memory slot.  Also define a macro expanding to inline asm code with
   output constraints on the appropriate register or memory, to let GCC
   know that its value has been changed by unknown code. */
#if (1 < JITTER_RESIDUAL_REGISTER_NO)
  register union jitter_word
  jitter_residual_argument_1_register_variable asm (JITTER_STRINGIFY(JITTER_RESIDUAL_REGISTER_1));
# define JITTER_RESIDUAL_ARGUMENT_1               \
    jitter_residual_argument_1_register_variable
# define JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY                 \
    JITTER_MARK_REGISTER_AS_SET_BY_ASSEMBLY(jitter_residual_argument_1_register_variable)
#else
# define JITTER_RESIDUAL_ARGUMENT_1  \
    (* (union jitter_word *)                 \
       (jitter_array_base + STRUCTUREDVM_RESIDUAL_OFFSET(1)))
# define JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY                    \
    JITTER_MARK_MEMORY_AS_SET_BY_ASSEMBLY(JITTER_RESIDUAL_ARGUMENT_1)
#endif // #if (1 < JITTER_RESIDUAL_REGISTER_NO)

/* Define a macro for the 2-th residual as a register, or as a residual
   memory slot.  Also define a macro expanding to inline asm code with
   output constraints on the appropriate register or memory, to let GCC
   know that its value has been changed by unknown code. */
#if (2 < JITTER_RESIDUAL_REGISTER_NO)
  register union jitter_word
  jitter_residual_argument_2_register_variable asm (JITTER_STRINGIFY(JITTER_RESIDUAL_REGISTER_2));
# define JITTER_RESIDUAL_ARGUMENT_2               \
    jitter_residual_argument_2_register_variable
# define JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY                 \
    JITTER_MARK_REGISTER_AS_SET_BY_ASSEMBLY(jitter_residual_argument_2_register_variable)
#else
# define JITTER_RESIDUAL_ARGUMENT_2  \
    (* (union jitter_word *)                 \
       (jitter_array_base + STRUCTUREDVM_RESIDUAL_OFFSET(2)))
# define JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY                    \
    JITTER_MARK_MEMORY_AS_SET_BY_ASSEMBLY(JITTER_RESIDUAL_ARGUMENT_2)
#endif // #if (2 < JITTER_RESIDUAL_REGISTER_NO)

/* The global register values we reserve in this compilation unit are
   callee-save: the called function is supposed to save them before
   setting them, and restore them to their previous value before
   returning to the caller.  Of course this is not done automatically
   in this compilation unit, so we have to do it by hand.  Notice that
   every variable allocated to a register by GCC will not use the
   registers we reserved, so we can be sure that, if we save our
   global register variables before setting them for the first time,
   their values will be the ones we want to retain. */

/* The buffer where I keep the original register values needs to hold
   every residual register, plus possibly the scratch register and the
   residual base; those two registers are not always used, but allocating
   just two words more costs essentially nothing and lets me simplify
   the code a little.  The two words are not written or read unless
   needed. */
#define STRUCTUREDVM_REGISTER_BUFFER_ELEMENT_NO (JITTER_RESIDUAL_REGISTER_NO + 2)
__attribute__ ((noinline, cold))

static void
structuredvm_save_registers (union jitter_word *buffer)
{
  buffer [0].pointer = (union jitter_word*) structuredvm_array_base_register_variable;
#ifdef JITTER_SCRATCH_REGISTER
  buffer [1] = jitter_residual_argument_scratch_register_variable;
#endif // #ifdef JITTER_SCRATCH_REGISTER
#if (0 < JITTER_RESIDUAL_REGISTER_NO)
  buffer [0 + 2] = JITTER_RESIDUAL_ARGUMENT_0;
#endif // #if (0 < JITTER_RESIDUAL_REGISTER_NO)
#if (1 < JITTER_RESIDUAL_REGISTER_NO)
  buffer [1 + 2] = JITTER_RESIDUAL_ARGUMENT_1;
#endif // #if (1 < JITTER_RESIDUAL_REGISTER_NO)
#if (2 < JITTER_RESIDUAL_REGISTER_NO)
  buffer [2 + 2] = JITTER_RESIDUAL_ARGUMENT_2;
#endif // #if (2 < JITTER_RESIDUAL_REGISTER_NO)
}

__attribute__ ((noinline, cold))
static void
structuredvm_restore_registers (const union jitter_word *buffer)
{
  structuredvm_array_base_register_variable = (char *) buffer [0].pointer;
#ifdef JITTER_SCRATCH_REGISTER
  jitter_residual_argument_scratch_register_variable = buffer [1];
#endif // #ifdef JITTER_SCRATCH_REGISTER
#if (0 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_RESIDUAL_ARGUMENT_0 = buffer [0 + 2];
#endif // #if (0 < JITTER_RESIDUAL_REGISTER_NO)
#if (1 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_RESIDUAL_ARGUMENT_1 = buffer [1 + 2];
#endif // #if (1 < JITTER_RESIDUAL_REGISTER_NO)
#if (2 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_RESIDUAL_ARGUMENT_2 = buffer [2 + 2];
#endif // #if (2 < JITTER_RESIDUAL_REGISTER_NO)
}

#endif // #ifdef JITTER_DISPATCH_NO_THREADING


/* Wrapper definition of the top operation for the TOS-optimized stack "mainstack". */
#define JITTER_TOP_MAINSTACK()  \
  JITTER_STACK_TOS_TOP(jitter_int, jitter_state_runtime. , mainstack)

/* Wrapper definition of the under_top operation for the TOS-optimized stack "mainstack". */
#define JITTER_UNDER_TOP_MAINSTACK()  \
  JITTER_STACK_TOS_UNDER_TOP(jitter_int, jitter_state_runtime. , mainstack)

/* Wrapper definition of the at_depth operation for the TOS-optimized stack "mainstack". */
#define JITTER_AT_DEPTH_MAINSTACK(x0)  \
  JITTER_STACK_TOS_AT_DEPTH(jitter_int, jitter_state_runtime. , mainstack, x0)

/* Wrapper definition of the at_nonzero_depth operation for the TOS-optimized stack "mainstack". */
#define JITTER_AT_NONZERO_DEPTH_MAINSTACK(x0)  \
  JITTER_STACK_TOS_AT_NONZERO_DEPTH(jitter_int, jitter_state_runtime. , mainstack, x0)

/* Wrapper definition of the set_at_depth operation for the TOS-optimized stack "mainstack". */
#define JITTER_SET_AT_DEPTH_MAINSTACK(x0, x1)  \
  JITTER_STACK_TOS_SET_AT_DEPTH(jitter_int, jitter_state_runtime. , mainstack, x0, x1)

/* Wrapper definition of the set_at_nonzero_depth operation for the TOS-optimized stack "mainstack". */
#define JITTER_SET_AT_NONZERO_DEPTH_MAINSTACK(x0, x1)  \
  JITTER_STACK_TOS_SET_AT_NONZERO_DEPTH(jitter_int, jitter_state_runtime. , mainstack, x0, x1)

/* Wrapper definition of the push_unspecified operation for the TOS-optimized stack "mainstack". */
#define JITTER_PUSH_UNSPECIFIED_MAINSTACK()  \
  JITTER_STACK_TOS_PUSH_UNSPECIFIED(jitter_int, jitter_state_runtime. , mainstack)

/* Wrapper definition of the push operation for the TOS-optimized stack "mainstack". */
#define JITTER_PUSH_MAINSTACK(x0)  \
  JITTER_STACK_TOS_PUSH(jitter_int, jitter_state_runtime. , mainstack, x0)

/* Wrapper definition of the drop operation for the TOS-optimized stack "mainstack". */
#define JITTER_DROP_MAINSTACK()  \
  JITTER_STACK_TOS_DROP(jitter_int, jitter_state_runtime. , mainstack)

/* Wrapper definition of the dup operation for the TOS-optimized stack "mainstack". */
#define JITTER_DUP_MAINSTACK()  \
  JITTER_STACK_TOS_DUP(jitter_int, jitter_state_runtime. , mainstack)

/* Wrapper definition of the swap operation for the TOS-optimized stack "mainstack". */
#define JITTER_SWAP_MAINSTACK()  \
  JITTER_STACK_TOS_SWAP(jitter_int, jitter_state_runtime. , mainstack)

/* Wrapper definition of the quake operation for the TOS-optimized stack "mainstack". */
#define JITTER_QUAKE_MAINSTACK()  \
  JITTER_STACK_TOS_QUAKE(jitter_int, jitter_state_runtime. , mainstack)

/* Wrapper definition of the over operation for the TOS-optimized stack "mainstack". */
#define JITTER_OVER_MAINSTACK()  \
  JITTER_STACK_TOS_OVER(jitter_int, jitter_state_runtime. , mainstack)

/* Wrapper definition of the tuck operation for the TOS-optimized stack "mainstack". */
#define JITTER_TUCK_MAINSTACK()  \
  JITTER_STACK_TOS_TUCK(jitter_int, jitter_state_runtime. , mainstack)

/* Wrapper definition of the nip operation for the TOS-optimized stack "mainstack". */
#define JITTER_NIP_MAINSTACK()  \
  JITTER_STACK_TOS_NIP(jitter_int, jitter_state_runtime. , mainstack)

/* Wrapper definition of the rot operation for the TOS-optimized stack "mainstack". */
#define JITTER_ROT_MAINSTACK()  \
  JITTER_STACK_TOS_ROT(jitter_int, jitter_state_runtime. , mainstack)

/* Wrapper definition of the mrot operation for the TOS-optimized stack "mainstack". */
#define JITTER_MROT_MAINSTACK()  \
  JITTER_STACK_TOS_MROT(jitter_int, jitter_state_runtime. , mainstack)

/* Wrapper definition of the roll operation for the TOS-optimized stack "mainstack". */
#define JITTER_ROLL_MAINSTACK(x0)  \
  JITTER_STACK_TOS_ROLL(jitter_int, jitter_state_runtime. , mainstack, x0)

/* Wrapper definition of the mroll operation for the TOS-optimized stack "mainstack". */
#define JITTER_MROLL_MAINSTACK(x0)  \
  JITTER_STACK_TOS_MROLL(jitter_int, jitter_state_runtime. , mainstack, x0)

/* Wrapper definition of the slide operation for the TOS-optimized stack "mainstack". */
#define JITTER_SLIDE_MAINSTACK(x0, x1)  \
  JITTER_STACK_TOS_SLIDE(jitter_int, jitter_state_runtime. , mainstack, x0, x1)

/* Wrapper definition of the whirl operation for the TOS-optimized stack "mainstack". */
#define JITTER_WHIRL_MAINSTACK(x0)  \
  JITTER_STACK_TOS_WHIRL(jitter_int, jitter_state_runtime. , mainstack, x0)

/* Wrapper definition of the bulge operation for the TOS-optimized stack "mainstack". */
#define JITTER_BULGE_MAINSTACK(x0)  \
  JITTER_STACK_TOS_BULGE(jitter_int, jitter_state_runtime. , mainstack, x0)

/* Wrapper definition of the height operation for the TOS-optimized stack "mainstack". */
#define JITTER_HEIGHT_MAINSTACK()  \
  JITTER_STACK_TOS_HEIGHT(jitter_int, jitter_state_runtime. , mainstack)

/* Wrapper definition of the set_height operation for the TOS-optimized stack "mainstack". */
#define JITTER_SET_HEIGHT_MAINSTACK(x0)  \
  JITTER_STACK_TOS_SET_HEIGHT(jitter_int, jitter_state_runtime. , mainstack, x0)

/* Wrapper definition of the reverse operation for the TOS-optimized stack "mainstack". */
#define JITTER_REVERSE_MAINSTACK(x0)  \
  JITTER_STACK_TOS_REVERSE(jitter_int, jitter_state_runtime. , mainstack, x0)

/* Wrapper definition of the unary operation for the TOS-optimized stack "mainstack". */
#define JITTER_UNARY_MAINSTACK(x0)  \
  JITTER_STACK_TOS_UNARY(jitter_int, jitter_state_runtime. , mainstack, x0)

/* Wrapper definition of the binary operation for the TOS-optimized stack "mainstack". */
#define JITTER_BINARY_MAINSTACK(x0)  \
  JITTER_STACK_TOS_BINARY(jitter_int, jitter_state_runtime. , mainstack, x0)

/* Late C code from the user. */

    static const char *structured_fixnum_format_string = "%" JITTER_PRIi "\n";
  
static jitter_int
structured_input (void)
{
#define STRUCTURED_PROMPT "> "
  printf (STRUCTURED_PROMPT);
  jitter_int res;
  int scanf_result;
  while ((scanf_result = scanf ("%" JITTER_PRIi, & res)) != 1)
    {
      printf ("Invalid input: expecting an integer.\n" STRUCTURED_PROMPT);
    }
  return res;
#undef STRUCTURED_PROMPT
}
  /* End of the late C code from the user. */

/* The definition of this is machine-generated in structuredvm-vm2.c , and the
   function is not intended for the user.  If initializing then set
   structuredvm_threads and structuredvm_thread_sizes and just return, ignoring
   the other fieldsp and s.  If not initializing then actually enter VM code
   starting from the given program point in the pointed state. */
static void
structuredvm_execute_or_initialize (bool jitter_initialize,
                                structuredvm_program_point jitter_initial_program_point,
                                struct structuredvm_state * const jitter_original_state)
  __attribute__ ((noclone, noinline));

void
structuredvm_execute_executable_routine (const struct jitter_executable_routine *er,
                                     struct structuredvm_state *s)
{
  structuredvm_make_place_for_slow_registers (s, er->slow_register_per_class_no);
  jitter_program_point initial_program_point
    = STRUCTUREDVM_EXECUTABLE_ROUTINE_BEGINNING (er);
  structuredvm_execute_or_initialize (false, initial_program_point, s);
}


/* Threads or pointers to native code blocks of course don't exist with
   switch-dispatching. */
#ifndef JITTER_DISPATCH_SWITCH
const jitter_thread *
structuredvm_threads;

const jitter_thread *
structuredvm_thread_ends;

const long *
structuredvm_thread_sizes;
#endif // #ifndef JITTER_DISPATCH_SWITCH

void
structuredvm_initialize_threads (void)
{
  structuredvm_execute_or_initialize (true, NULL, NULL);
}

void
structuredvm_branch_to_program_point (structuredvm_program_point p, struct structuredvm_state *s)
{
  structuredvm_execute_or_initialize (false, p, s);
}

static void
structuredvm_execute_or_initialize (bool jitter_initialize,
                                structuredvm_program_point jitter_initial_program_point,
                                struct structuredvm_state * const jitter_original_state)
{
#ifdef JITTER_DISPATCH_NO_THREADING
  /* Save the values in the registers we reserved as global variables,
     since from the point of view of the other C compilation units such
     registers are callee-save.  FIXME: this is not really needed when
     initializing, if I've been careful; but for the time being I want
     to play it safe. */
  union jitter_word jitter_register_buffer [STRUCTUREDVM_REGISTER_BUFFER_ELEMENT_NO];
  structuredvm_save_registers (jitter_register_buffer);
#endif // #ifdef JITTER_DISPATCH_NO_THREADING

#ifdef JITTER_HAVE_PATCH_IN
  /* Generate the single patch-in header for this executor as a
     global asm statement.  This expands into a global definition in
     assembly in a separate subsection, and relies on toplevel C
     definitions not being reordered: structuredvm_execute_or_initialize
     will add to the same global.  Do the same for defects. */
  JITTER_DEFECT_HEADER(structuredvm);
  JITTER_PATCH_IN_HEADER(structuredvm);
#endif // #ifdef JITTER_HAVE_PATCH_IN

#ifndef JITTER_DISPATCH_SWITCH
  JITTER_DATA_LOCATION_HEADER(structuredvm);
#endif // #ifndef JITTER_DISPATCH_SWITCH

  /* Initialization.  This is only called once at startup. */
  if (__builtin_expect (jitter_initialize, false))
    {
      /* Make sure that vm1 and vm2 were macroexpanded consistently
         with respect to instrumentation macros.  This relies on the
         enum values for each feature working as individual bits in a
         bitmask: see the comment in jitter/jitter-vm.h . */
      enum jitter_vm_instrumentation correct_instrumentation
        = jitter_vm_instrumentation_none;
#if defined (JITTER_PROFILE_COUNT)
      correct_instrumentation |= jitter_vm_instrumentation_count;
#endif
#if defined (JITTER_PROFILE_SAMPLE)
      correct_instrumentation |= jitter_vm_instrumentation_sample;
#endif
      if (structuredvm_vm_configuration->instrumentation != correct_instrumentation)
        jitter_fatal ("vm1 and vm2 were compiled with different profiling "
                      "instrumentation macros.  Please recompile with coherent "
                      "CPPFLAGS");

#if defined (JITTER_PROFILE_SAMPLE)
    /* Initialise the sample-profile subsystem, once and for all. */
    structuredvm_profile_sample_initialize ();
#endif // #if defined (JITTER_PROFILE_SAMPLE)

#ifndef JITTER_DISPATCH_SWITCH
      /* FIXME: I can do this with only one relocation, by keeping
         a pointer to the first VM instruction beginning in a static
         variable, and then having a static vector of offsets with
         respect to the first pointer.  This will slightly complicate
         my initialization code, but should make startup faster.
         FIXME: that won't work on AVR, according to the GCC
         documentation.  Do I care?  Probably not, since AVRs can't
         address more than 2^16 bytes, which is too little to run my
         VMs. */
      static const jitter_thread structuredvm_the_threads []
        = {
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eINVALID),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eBEGINBASICBLOCK),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eEXITVM),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eDATALOCATIONS),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eNOP),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eUNREACHABLE0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eUNREACHABLE1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eUNREACHABLE2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(b__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr1___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr1___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rrR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rrR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__n0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__n0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__nR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__nR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beqi_mstack__n_m1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beqi_mstack__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beqi_mstack__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beqi_mstack__n2__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beqi_mstack__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beqr_mstack___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beqr_mstack___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beqr_mstack___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bf_mstack__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr1___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr1___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rrR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rrR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__n0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__n0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__nR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__nR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr1___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr1___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rrR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rrR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__n0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__n0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__nR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__nR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bger_mstack___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bger_mstack___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bger_mstack___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr1___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr1___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rrR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rrR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__n0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__n0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__nR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__nR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr1___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr1___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rrR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rrR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__n0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__n0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__nR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__nR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr1___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr1___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rrR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rrR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__n0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__n0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__nR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__nR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneqi_mstack__n_m1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneqi_mstack__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneqi_mstack__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneqi_mstack__n2__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneqi_mstack__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneqr_mstack___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneqr_mstack___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneqr_mstack___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bt_mstack__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(copy_mto_mr_mstack___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(copy_mto_mr_mstack___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(copy_mto_mr_mstack___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(different_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(differenti_mstack__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(differenti_mstack__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(differenti_mstack__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(differenti_mstack__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(drop_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(dup_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(equal_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(equali_mstack__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(equali_mstack__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(equali_mstack__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(equali_mstack__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(exitvm),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(greater_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(greaterorequal_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(input___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(input___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(input___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(input_mstack__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(isnonzero_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(less_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lessorequal_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(logicaland_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(logicalnot_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(logicalor_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minusi_mstack__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minusi_mstack__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minusi_mstack__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minusr_mstack___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minusr_mstack___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minusr_mstack___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n_m1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n_m1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n_m1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plusi_mstack__n_m1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plusi_mstack__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plusi_mstack__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plusi_mstack__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pop_mstack___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pop_mstack___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pop_mstack___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(print___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(print___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(print___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(print__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(print_mstack__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack__n_m1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbeqr_mstack___rr0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbeqr_mstack___rr0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbeqr_mstack___rr0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbeqr_mstack___rr1___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbeqr_mstack___rr1___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbeqr_mstack___rr1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbeqr_mstack___rrR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbeqr_mstack___rrR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbeqr_mstack___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbger_mstack___rr0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbger_mstack___rr0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbger_mstack___rr0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbger_mstack___rr1___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbger_mstack___rr1___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbger_mstack___rr1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbger_mstack___rrR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbger_mstack___rrR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbger_mstack___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(unreachable),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Ab__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr0___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr0___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr0___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr0__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr0__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr1___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr1___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr1___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr1__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr1__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rrR___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rrR___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rrR___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rrR__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rrR__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__n0___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__n0___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__n0___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__n0__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__n0__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__nR___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__nR___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__nR___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__nR__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__nR__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abeqi_mstack__n_m1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abeqi_mstack__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abeqi_mstack__n1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abeqi_mstack__n2__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abeqi_mstack__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abeqr_mstack___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abeqr_mstack___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abeqr_mstack___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abf_mstack__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr0___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr0___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr0___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr0__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr0__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr1___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr1___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr1___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr1__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr1__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rrR___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rrR___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rrR___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rrR__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rrR__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__n0___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__n0___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__n0___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__n0__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__n0__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__nR___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__nR___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__nR___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__nR__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__nR__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr0___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr0___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr0___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr0__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr0__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr1___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr1___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr1___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr1__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr1__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rrR___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rrR___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rrR___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rrR__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rrR__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__n0___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__n0___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__n0___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__n0__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__n0__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__nR___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__nR___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__nR___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__nR__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__nR__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abger_mstack___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abger_mstack___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abger_mstack___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr0___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr0___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr0___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr0__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr0__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr1___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr1___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr1___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr1__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr1__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rrR___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rrR___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rrR___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rrR__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rrR__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__n0___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__n0___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__n0___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__n0__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__n0__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__nR___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__nR___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__nR___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__nR__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__nR__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr0___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr0___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr0___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr0__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr0__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr1___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr1___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr1___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr1__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr1__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rrR___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rrR___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rrR___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rrR__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rrR__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__n0___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__n0___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__n0___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__n0__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__n0__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__nR___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__nR___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__nR___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__nR__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__nR__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr0___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr0___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr0___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr0__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr0__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr1___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr1___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr1___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr1__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr1__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rrR___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rrR___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rrR___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rrR__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rrR__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__n0___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__n0___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__n0___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__n0__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__n0__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__nR___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__nR___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__nR___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__nR__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__nR__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abneqi_mstack__n_m1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abneqi_mstack__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abneqi_mstack__n1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abneqi_mstack__n2__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abneqi_mstack__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abneqr_mstack___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abneqr_mstack___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abneqr_mstack___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abt_mstack__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbeqr_mstack___rr0___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbeqr_mstack___rr0___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbeqr_mstack___rr0___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbeqr_mstack___rr1___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbeqr_mstack___rr1___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbeqr_mstack___rr1___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbeqr_mstack___rrR___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbeqr_mstack___rrR___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbeqr_mstack___rrR___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbger_mstack___rr0___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbger_mstack___rr0___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbger_mstack___rr0___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbger_mstack___rr1___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbger_mstack___rr1___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbger_mstack___rr1___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbger_mstack___rrR___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbger_mstack___rrR___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbger_mstack___rrR___rrR__fR_A_mno_mfast_mbranches)
          };
      static const jitter_thread structuredvm_the_thread_ends []
        = {
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eINVALID),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eBEGINBASICBLOCK),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eEXITVM),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eDATALOCATIONS),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eNOP),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eUNREACHABLE0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eUNREACHABLE1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eUNREACHABLE2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(b__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr1___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr1___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rrR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rrR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__n0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__n0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__nR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__nR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(beqi_mstack__n_m1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(beqi_mstack__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(beqi_mstack__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(beqi_mstack__n2__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(beqi_mstack__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(beqr_mstack___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(beqr_mstack___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(beqr_mstack___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bf_mstack__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr1___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr1___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rrR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rrR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__n0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__n0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__nR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__nR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr1___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr1___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rrR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rrR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__n0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__n0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__nR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__nR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bger_mstack___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bger_mstack___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bger_mstack___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr1___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr1___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rrR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rrR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__n0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__n0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__nR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__nR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr1___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr1___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rrR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rrR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__n0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__n0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__nR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__nR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr1___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr1___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr1__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr1__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rrR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rrR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rrR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rrR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__n0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__n0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__n0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__n0__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__n0__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__nR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__nR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__nR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bneqi_mstack__n_m1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bneqi_mstack__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bneqi_mstack__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bneqi_mstack__n2__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bneqi_mstack__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bneqr_mstack___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bneqr_mstack___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bneqr_mstack___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bt_mstack__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(copy_mto_mr_mstack___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(copy_mto_mr_mstack___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(copy_mto_mr_mstack___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(different_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(differenti_mstack__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(differenti_mstack__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(differenti_mstack__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(differenti_mstack__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(drop_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(dup_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(equal_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(equali_mstack__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(equali_mstack__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(equali_mstack__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(equali_mstack__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(exitvm),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(greater_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(greaterorequal_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(input___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(input___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(input___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(input_mstack__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(isnonzero_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(less_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lessorequal_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(logicaland_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(logicalnot_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(logicalor_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minusi_mstack__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minusi_mstack__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minusi_mstack__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minusr_mstack___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minusr_mstack___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minusr_mstack___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n_m1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n_m1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n_m1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR__n1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR__n1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plusi_mstack__n_m1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plusi_mstack__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plusi_mstack__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plusi_mstack__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pop_mstack___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pop_mstack___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pop_mstack___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(print___rr0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(print___rr1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(print___rrR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(print__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(print_mstack__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mstack___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mstack___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mstack___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mstack__n0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mstack__n1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mstack__n_m1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mstack__n2),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mstack__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mstack__lR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbeqr_mstack___rr0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbeqr_mstack___rr0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbeqr_mstack___rr0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbeqr_mstack___rr1___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbeqr_mstack___rr1___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbeqr_mstack___rr1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbeqr_mstack___rrR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbeqr_mstack___rrR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbeqr_mstack___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbger_mstack___rr0___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbger_mstack___rr0___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbger_mstack___rr0___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbger_mstack___rr1___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbger_mstack___rr1___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbger_mstack___rr1___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbger_mstack___rrR___rr0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbger_mstack___rrR___rr1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbger_mstack___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR__n2___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR__n2___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus___rr0___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus___rr0___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus___rr0___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus___rr1___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus___rr1___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus___rr1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus___rrR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus___rrR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus__nR___rr0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus__nR___rr1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus_mstack),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(unreachable),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Ab__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rr0___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rr0___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rr0___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rr0__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rr0__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rr1___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rr1___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rr1___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rr1__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rr1__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rrR___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rrR___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rrR___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rrR__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rrR__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe__n0___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe__n0___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe__n0___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe__n0__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe__n0__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe__nR___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe__nR___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe__nR___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe__nR__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe__nR__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abeqi_mstack__n_m1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abeqi_mstack__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abeqi_mstack__n1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abeqi_mstack__n2__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abeqi_mstack__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abeqr_mstack___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abeqr_mstack___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abeqr_mstack___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abf_mstack__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rr0___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rr0___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rr0___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rr0__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rr0__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rr1___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rr1___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rr1___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rr1__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rr1__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rrR___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rrR___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rrR___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rrR__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rrR__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg__n0___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg__n0___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg__n0___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg__n0__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg__n0__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg__nR___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg__nR___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg__nR___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg__nR__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg__nR__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rr0___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rr0___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rr0___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rr0__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rr0__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rr1___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rr1___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rr1___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rr1__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rr1__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rrR___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rrR___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rrR___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rrR__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rrR__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge__n0___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge__n0___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge__n0___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge__n0__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge__n0__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge__nR___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge__nR___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge__nR___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge__nR__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge__nR__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abger_mstack___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abger_mstack___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abger_mstack___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rr0___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rr0___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rr0___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rr0__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rr0__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rr1___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rr1___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rr1___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rr1__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rr1__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rrR___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rrR___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rrR___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rrR__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rrR__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl__n0___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl__n0___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl__n0___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl__n0__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl__n0__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl__nR___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl__nR___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl__nR___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl__nR__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl__nR__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rr0___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rr0___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rr0___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rr0__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rr0__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rr1___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rr1___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rr1___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rr1__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rr1__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rrR___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rrR___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rrR___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rrR__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rrR__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able__n0___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able__n0___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able__n0___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able__n0__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able__n0__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able__nR___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able__nR___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able__nR___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able__nR__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able__nR__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rr0___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rr0___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rr0___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rr0__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rr0__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rr1___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rr1___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rr1___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rr1__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rr1__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rrR___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rrR___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rrR___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rrR__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rrR__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne__n0___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne__n0___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne__n0___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne__n0__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne__n0__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne__nR___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne__nR___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne__nR___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne__nR__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne__nR__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abneqi_mstack__n_m1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abneqi_mstack__n0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abneqi_mstack__n1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abneqi_mstack__n2__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abneqi_mstack__nR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abneqr_mstack___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abneqr_mstack___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abneqr_mstack___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abt_mstack__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbeqr_mstack___rr0___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbeqr_mstack___rr0___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbeqr_mstack___rr0___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbeqr_mstack___rr1___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbeqr_mstack___rr1___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbeqr_mstack___rr1___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbeqr_mstack___rrR___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbeqr_mstack___rrR___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbeqr_mstack___rrR___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbger_mstack___rr0___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbger_mstack___rr0___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbger_mstack___rr0___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbger_mstack___rr1___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbger_mstack___rr1___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbger_mstack___rr1___rrR__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbger_mstack___rrR___rr0__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbger_mstack___rrR___rr1__fR_A_mno_mfast_mbranches),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbger_mstack___rrR___rrR__fR_A_mno_mfast_mbranches)
          };
      static const long
      structuredvm_the_thread_sizes [STRUCTUREDVM_SPECIALIZED_INSTRUCTION_NO]
        = {
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eINVALID))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eINVALID))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eBEGINBASICBLOCK))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eBEGINBASICBLOCK))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eEXITVM))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eEXITVM))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eDATALOCATIONS))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eDATALOCATIONS))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eNOP))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eNOP))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eUNREACHABLE0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eUNREACHABLE0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eUNREACHABLE1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eUNREACHABLE1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eUNREACHABLE2))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eUNREACHABLE2))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(b__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(b__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr0___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr0___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr0___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr0___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr0___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr0___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr0__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr0__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr0__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr0__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr1___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr1___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr1___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr1___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr1___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr1___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr1__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr1__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rr1__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr1__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rrR___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rrR___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rrR___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rrR___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rrR___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rrR___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rrR__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rrR__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be___rrR__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rrR__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__n0___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__n0___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__n0___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__n0___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__n0___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__n0___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__n0__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__n0__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__n0__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__n0__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__nR___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__nR___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__nR___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__nR___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__nR___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__nR___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__nR__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__nR__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(be__nR__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__nR__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(beqi_mstack__n_m1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beqi_mstack__n_m1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(beqi_mstack__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beqi_mstack__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(beqi_mstack__n1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beqi_mstack__n1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(beqi_mstack__n2__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beqi_mstack__n2__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(beqi_mstack__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beqi_mstack__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(beqr_mstack___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beqr_mstack___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(beqr_mstack___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beqr_mstack___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(beqr_mstack___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beqr_mstack___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bf_mstack__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bf_mstack__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr0___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr0___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr0___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr0___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr0___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr0___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr0__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr0__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr0__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr0__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr1___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr1___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr1___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr1___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr1___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr1___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr1__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr1__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rr1__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr1__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rrR___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rrR___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rrR___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rrR___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rrR___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rrR___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rrR__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rrR__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg___rrR__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rrR__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__n0___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__n0___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__n0___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__n0___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__n0___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__n0___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__n0__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__n0__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__n0__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__n0__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__nR___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__nR___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__nR___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__nR___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__nR___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__nR___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__nR__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__nR__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bg__nR__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__nR__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr0___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr0___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr0___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr0___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr0___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr0___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr0__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr0__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr0__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr0__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr1___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr1___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr1___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr1___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr1___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr1___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr1__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr1__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rr1__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr1__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rrR___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rrR___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rrR___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rrR___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rrR___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rrR___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rrR__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rrR__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge___rrR__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rrR__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__n0___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__n0___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__n0___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__n0___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__n0___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__n0___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__n0__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__n0__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__n0__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__n0__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__nR___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__nR___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__nR___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__nR___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__nR___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__nR___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__nR__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__nR__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bge__nR__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__nR__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bger_mstack___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bger_mstack___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bger_mstack___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bger_mstack___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bger_mstack___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bger_mstack___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr0___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr0___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr0___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr0___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr0___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr0___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr0__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr0__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr0__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr0__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr1___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr1___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr1___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr1___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr1___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr1___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr1__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr1__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rr1__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr1__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rrR___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rrR___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rrR___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rrR___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rrR___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rrR___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rrR__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rrR__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl___rrR__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rrR__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__n0___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__n0___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__n0___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__n0___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__n0___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__n0___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__n0__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__n0__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__n0__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__n0__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__nR___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__nR___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__nR___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__nR___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__nR___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__nR___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__nR__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__nR__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bl__nR__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__nR__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr0___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr0___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr0___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr0___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr0___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr0___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr0__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr0__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr0__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr0__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr1___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr1___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr1___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr1___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr1___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr1___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr1__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr1__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rr1__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr1__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rrR___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rrR___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rrR___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rrR___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rrR___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rrR___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rrR__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rrR__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble___rrR__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rrR__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__n0___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__n0___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__n0___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__n0___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__n0___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__n0___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__n0__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__n0__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__n0__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__n0__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__nR___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__nR___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__nR___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__nR___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__nR___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__nR___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__nR__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__nR__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(ble__nR__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__nR__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr0___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr0___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr0___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr0___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr0___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr0___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr0__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr0__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr0__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr0__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr1___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr1___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr1___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr1___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr1___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr1___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr1__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr1__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rr1__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr1__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rrR___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rrR___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rrR___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rrR___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rrR___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rrR___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rrR__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rrR__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne___rrR__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rrR__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__n0___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__n0___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__n0___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__n0___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__n0___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__n0___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__n0__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__n0__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__n0__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__n0__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__nR___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__nR___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__nR___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__nR___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__nR___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__nR___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__nR__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__nR__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bne__nR__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__nR__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bneqi_mstack__n_m1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneqi_mstack__n_m1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bneqi_mstack__n0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneqi_mstack__n0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bneqi_mstack__n1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneqi_mstack__n1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bneqi_mstack__n2__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneqi_mstack__n2__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bneqi_mstack__nR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneqi_mstack__nR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bneqr_mstack___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneqr_mstack___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bneqr_mstack___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneqr_mstack___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bneqr_mstack___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneqr_mstack___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(bt_mstack__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bt_mstack__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(copy_mto_mr_mstack___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(copy_mto_mr_mstack___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(copy_mto_mr_mstack___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(copy_mto_mr_mstack___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(copy_mto_mr_mstack___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(copy_mto_mr_mstack___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(different_mstack))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(different_mstack))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(differenti_mstack__n0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(differenti_mstack__n0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(differenti_mstack__n1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(differenti_mstack__n1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(differenti_mstack__n2))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(differenti_mstack__n2))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(differenti_mstack__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(differenti_mstack__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0___rr0___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rr0___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0___rr0___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rr0___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0___rr0___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rr0___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0___rr1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rr1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0___rr1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rr1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0___rr1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rr1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0___rrR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rrR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0___rrR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rrR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0___rrR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rrR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0__n2___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0__n2___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0__n2___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0__n2___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0__n2___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0__n2___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0__nR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0__nR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0__nR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0__nR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr0__nR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0__nR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1___rr0___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rr0___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1___rr0___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rr0___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1___rr0___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rr0___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1___rr1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rr1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1___rr1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rr1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1___rr1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rr1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1___rrR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rrR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1___rrR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rrR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1___rrR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rrR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1__n2___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1__n2___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1__n2___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1__n2___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1__n2___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1__n2___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1__nR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1__nR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1__nR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1__nR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rr1__nR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1__nR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR___rr0___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rr0___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR___rr0___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rr0___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR___rr0___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rr0___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR___rr1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rr1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR___rr1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rr1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR___rr1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rr1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR___rrR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rrR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR___rrR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rrR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR___rrR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rrR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR__n2___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR__n2___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR__n2___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR__n2___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR__n2___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR__n2___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR__nR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR__nR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR__nR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR__nR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided___rrR__nR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR__nR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR___rr0___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rr0___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR___rr0___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rr0___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR___rr0___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rr0___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR___rr1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rr1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR___rr1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rr1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR___rr1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rr1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR___rrR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rrR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR___rrR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rrR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR___rrR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rrR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR__n2___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR__n2___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR__n2___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR__n2___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR__n2___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR__n2___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR__nR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR__nR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR__nR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR__nR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided__nR__nR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR__nR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(divided_mstack))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided_mstack))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(drop_mstack))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(drop_mstack))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(dup_mstack))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(dup_mstack))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(equal_mstack))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(equal_mstack))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(equali_mstack__n0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(equali_mstack__n0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(equali_mstack__n1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(equali_mstack__n1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(equali_mstack__n2))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(equali_mstack__n2))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(equali_mstack__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(equali_mstack__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(exitvm))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(exitvm))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(greater_mstack))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(greater_mstack))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(greaterorequal_mstack))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(greaterorequal_mstack))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(input___rr0__retR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(input___rr0__retR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(input___rr1__retR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(input___rr1__retR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(input___rrR__retR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(input___rrR__retR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(input_mstack__retR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(input_mstack__retR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(isnonzero_mstack))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(isnonzero_mstack))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(less_mstack))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(less_mstack))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(lessorequal_mstack))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lessorequal_mstack))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(logicaland_mstack))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(logicaland_mstack))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(logicalnot_mstack))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(logicalnot_mstack))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(logicalor_mstack))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(logicalor_mstack))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0___rr0___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rr0___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0___rr0___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rr0___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0___rr0___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rr0___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0___rr1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rr1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0___rr1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rr1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0___rr1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rr1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0___rrR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rrR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0___rrR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rrR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0___rrR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rrR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0__n1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__n1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0__n1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__n1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0__n1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__n1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0__n2___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__n2___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0__n2___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__n2___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0__n2___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__n2___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0__nR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__nR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0__nR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__nR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr0__nR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__nR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1___rr0___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rr0___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1___rr0___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rr0___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1___rr0___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rr0___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1___rr1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rr1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1___rr1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rr1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1___rr1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rr1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1___rrR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rrR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1___rrR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rrR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1___rrR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rrR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1__n1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__n1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1__n1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__n1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1__n1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__n1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1__n2___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__n2___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1__n2___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__n2___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1__n2___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__n2___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1__nR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__nR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1__nR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__nR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rr1__nR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__nR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR___rr0___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rr0___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR___rr0___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rr0___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR___rr0___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rr0___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR___rr1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rr1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR___rr1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rr1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR___rr1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rr1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR___rrR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rrR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR___rrR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rrR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR___rrR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rrR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR__n1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__n1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR__n1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__n1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR__n1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__n1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR__n2___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__n2___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR__n2___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__n2___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR__n2___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__n2___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR__nR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__nR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR__nR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__nR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus___rrR__nR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__nR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR___rr0___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rr0___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR___rr0___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rr0___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR___rr0___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rr0___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR___rr1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rr1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR___rr1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rr1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR___rr1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rr1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR___rrR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rrR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR___rrR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rrR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR___rrR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rrR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR__n1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__n1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR__n1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__n1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR__n1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__n1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR__n2___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__n2___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR__n2___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__n2___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR__n2___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__n2___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR__nR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__nR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR__nR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__nR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus__nR__nR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__nR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minus_mstack))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus_mstack))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minusi_mstack__n1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minusi_mstack__n1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minusi_mstack__n2))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minusi_mstack__n2))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minusi_mstack__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minusi_mstack__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minusr_mstack___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minusr_mstack___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minusr_mstack___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minusr_mstack___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(minusr_mstack___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minusr_mstack___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov___rr0___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rr0___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov___rr0___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rr0___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov___rr0___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rr0___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov___rr1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rr1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov___rr1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rr1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov___rr1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rr1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov___rrR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rrR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov___rrR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rrR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov___rrR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rrR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n0___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n0___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n0___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n0___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n0___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n0___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n_m1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n_m1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n_m1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n_m1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n_m1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n_m1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n2___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n2___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n2___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n2___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__n2___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n2___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__nR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__nR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__nR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__nR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(mov__nR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__nR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0___rr0___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rr0___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0___rr0___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rr0___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0___rr0___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rr0___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0___rr1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rr1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0___rr1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rr1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0___rr1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rr1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0___rrR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rrR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0___rrR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rrR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0___rrR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rrR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0__n1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__n1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0__n1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__n1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0__n1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__n1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0__n2___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__n2___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0__n2___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__n2___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0__n2___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__n2___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0__nR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__nR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0__nR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__nR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr0__nR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__nR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1___rr0___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rr0___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1___rr0___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rr0___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1___rr0___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rr0___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1___rr1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rr1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1___rr1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rr1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1___rr1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rr1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1___rrR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rrR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1___rrR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rrR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1___rrR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rrR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1__n1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__n1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1__n1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__n1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1__n1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__n1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1__n2___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__n2___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1__n2___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__n2___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1__n2___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__n2___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1__nR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__nR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1__nR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__nR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rr1__nR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__nR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR___rr0___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rr0___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR___rr0___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rr0___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR___rr0___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rr0___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR___rr1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rr1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR___rr1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rr1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR___rr1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rr1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR___rrR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rrR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR___rrR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rrR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR___rrR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rrR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR__n1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__n1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR__n1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__n1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR__n1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__n1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR__n2___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__n2___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR__n2___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__n2___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR__n2___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__n2___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR__nR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__nR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR__nR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__nR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus___rrR__nR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__nR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR___rr0___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rr0___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR___rr0___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rr0___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR___rr0___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rr0___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR___rr1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rr1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR___rr1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rr1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR___rr1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rr1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR___rrR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rrR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR___rrR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rrR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR___rrR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rrR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR__n1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__n1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR__n1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__n1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR__n1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__n1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR__n2___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__n2___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR__n2___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__n2___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR__n2___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__n2___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR__nR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__nR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR__nR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__nR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus__nR__nR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__nR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plus_mstack))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus_mstack))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plusi_mstack__n_m1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plusi_mstack__n_m1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plusi_mstack__n1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plusi_mstack__n1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plusi_mstack__n2))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plusi_mstack__n2))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(plusi_mstack__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plusi_mstack__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pop_mstack___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pop_mstack___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pop_mstack___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pop_mstack___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pop_mstack___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pop_mstack___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(print___rr0__retR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(print___rr0__retR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(print___rr1__retR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(print___rr1__retR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(print___rrR__retR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(print___rrR__retR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(print__nR__retR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(print__nR__retR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(print_mstack__retR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(print_mstack__retR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mstack___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mstack___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mstack___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mstack__n0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack__n0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mstack__n1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack__n1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mstack__n_m1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack__n_m1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mstack__n2))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack__n2))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mstack__nR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack__nR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mstack__lR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack__lR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbeqr_mstack___rr0___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbeqr_mstack___rr0___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbeqr_mstack___rr0___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbeqr_mstack___rr0___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbeqr_mstack___rr0___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbeqr_mstack___rr0___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbeqr_mstack___rr1___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbeqr_mstack___rr1___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbeqr_mstack___rr1___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbeqr_mstack___rr1___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbeqr_mstack___rr1___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbeqr_mstack___rr1___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbeqr_mstack___rrR___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbeqr_mstack___rrR___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbeqr_mstack___rrR___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbeqr_mstack___rrR___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbeqr_mstack___rrR___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbeqr_mstack___rrR___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbger_mstack___rr0___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbger_mstack___rr0___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbger_mstack___rr0___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbger_mstack___rr0___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbger_mstack___rr0___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbger_mstack___rr0___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbger_mstack___rr1___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbger_mstack___rr1___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbger_mstack___rr1___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbger_mstack___rr1___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbger_mstack___rr1___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbger_mstack___rr1___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbger_mstack___rrR___rr0__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbger_mstack___rrR___rr0__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbger_mstack___rrR___rr1__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbger_mstack___rrR___rr1__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mbger_mstack___rrR___rrR__fR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbger_mstack___rrR___rrR__fR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr0___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr0___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr0___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr0___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr0___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr0___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rrR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rrR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rrR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rrR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rrR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rrR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr0___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr0___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr0___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr0___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr0___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr0___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rrR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rrR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rrR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rrR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rrR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rrR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr0___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr0___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr0___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr0___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr0___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr0___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rrR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rrR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rrR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rrR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rrR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rrR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0___rr0___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rr0___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0___rr0___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rr0___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0___rr0___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rr0___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0___rr1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rr1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0___rr1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rr1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0___rr1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rr1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0___rrR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rrR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0___rrR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rrR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0___rrR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rrR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0__n2___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0__n2___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0__n2___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0__n2___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0__n2___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0__n2___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0__nR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0__nR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0__nR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0__nR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr0__nR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0__nR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1___rr0___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rr0___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1___rr0___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rr0___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1___rr0___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rr0___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1___rr1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rr1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1___rr1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rr1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1___rr1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rr1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1___rrR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rrR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1___rrR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rrR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1___rrR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rrR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1__n2___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1__n2___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1__n2___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1__n2___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1__n2___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1__n2___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1__nR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1__nR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1__nR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1__nR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rr1__nR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1__nR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR___rr0___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rr0___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR___rr0___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rr0___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR___rr0___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rr0___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR___rr1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rr1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR___rr1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rr1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR___rr1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rr1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR___rrR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rrR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR___rrR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rrR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR___rrR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rrR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR__n2___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR__n2___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR__n2___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR__n2___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR__n2___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR__n2___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR__nR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR__nR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR__nR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR__nR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder___rrR__nR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR__nR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR___rr0___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rr0___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR___rr0___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rr0___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR___rr0___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rr0___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR___rr1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rr1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR___rr1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rr1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR___rr1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rr1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR___rrR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rrR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR___rrR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rrR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR___rrR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rrR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR__n2___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR__n2___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR__n2___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR__n2___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR__n2___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR__n2___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR__nR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR__nR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR__nR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR__nR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder__nR__nR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR__nR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(remainder_mstack))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder_mstack))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0___rr0___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rr0___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0___rr0___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rr0___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0___rr0___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rr0___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0___rr1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rr1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0___rr1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rr1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0___rr1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rr1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0___rrR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rrR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0___rrR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rrR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0___rrR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rrR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0__n2___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0__n2___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0__n2___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0__n2___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0__n2___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0__n2___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0__nR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0__nR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0__nR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0__nR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr0__nR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0__nR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1___rr0___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rr0___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1___rr0___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rr0___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1___rr0___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rr0___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1___rr1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rr1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1___rr1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rr1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1___rr1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rr1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1___rrR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rrR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1___rrR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rrR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1___rrR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rrR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1__n2___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1__n2___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1__n2___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1__n2___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1__n2___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1__n2___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1__nR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1__nR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1__nR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1__nR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rr1__nR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1__nR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR___rr0___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rr0___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR___rr0___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rr0___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR___rr0___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rr0___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR___rr1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rr1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR___rr1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rr1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR___rr1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rr1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR___rrR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rrR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR___rrR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rrR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR___rrR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rrR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR__n2___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR__n2___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR__n2___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR__n2___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR__n2___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR__n2___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR__nR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR__nR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR__nR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR__nR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times___rrR__nR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR__nR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR___rr0___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rr0___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR___rr0___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rr0___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR___rr0___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rr0___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR___rr1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rr1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR___rr1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rr1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR___rr1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rr1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR___rrR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rrR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR___rrR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rrR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR___rrR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rrR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR__n2___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR__n2___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR__n2___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR__n2___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR__n2___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR__n2___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR__nR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR__nR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR__nR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR__nR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times__nR__nR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR__nR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(times_mstack))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times_mstack))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus___rr0___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rr0___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus___rr0___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rr0___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus___rr0___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rr0___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus___rr1___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rr1___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus___rr1___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rr1___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus___rr1___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rr1___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus___rrR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rrR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus___rrR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rrR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus___rrR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rrR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus__nR___rr0))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus__nR___rr0))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus__nR___rr1))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus__nR___rr1))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus__nR___rrR))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus__nR___rrR))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(uminus_mstack))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus_mstack))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(unreachable))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(unreachable))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Ab__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Ab__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rr0___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr0___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rr0___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr0___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rr0___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr0___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rr0__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr0__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rr0__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr0__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rr1___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr1___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rr1___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr1___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rr1___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr1___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rr1__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr1__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rr1__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr1__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rrR___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rrR___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rrR___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rrR___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rrR___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rrR___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rrR__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rrR__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe___rrR__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rrR__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe__n0___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__n0___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe__n0___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__n0___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe__n0___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__n0___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe__n0__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__n0__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe__n0__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__n0__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe__nR___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__nR___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe__nR___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__nR___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe__nR___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__nR___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe__nR__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__nR__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abe__nR__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__nR__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abeqi_mstack__n_m1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abeqi_mstack__n_m1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abeqi_mstack__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abeqi_mstack__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abeqi_mstack__n1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abeqi_mstack__n1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abeqi_mstack__n2__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abeqi_mstack__n2__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abeqi_mstack__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abeqi_mstack__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abeqr_mstack___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abeqr_mstack___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abeqr_mstack___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abeqr_mstack___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abeqr_mstack___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abeqr_mstack___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abf_mstack__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abf_mstack__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rr0___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr0___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rr0___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr0___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rr0___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr0___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rr0__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr0__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rr0__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr0__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rr1___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr1___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rr1___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr1___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rr1___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr1___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rr1__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr1__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rr1__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr1__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rrR___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rrR___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rrR___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rrR___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rrR___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rrR___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rrR__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rrR__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg___rrR__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rrR__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg__n0___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__n0___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg__n0___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__n0___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg__n0___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__n0___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg__n0__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__n0__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg__n0__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__n0__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg__nR___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__nR___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg__nR___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__nR___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg__nR___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__nR___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg__nR__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__nR__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abg__nR__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__nR__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rr0___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr0___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rr0___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr0___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rr0___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr0___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rr0__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr0__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rr0__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr0__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rr1___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr1___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rr1___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr1___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rr1___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr1___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rr1__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr1__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rr1__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr1__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rrR___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rrR___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rrR___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rrR___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rrR___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rrR___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rrR__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rrR__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge___rrR__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rrR__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge__n0___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__n0___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge__n0___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__n0___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge__n0___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__n0___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge__n0__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__n0__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge__n0__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__n0__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge__nR___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__nR___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge__nR___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__nR___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge__nR___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__nR___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge__nR__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__nR__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abge__nR__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__nR__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abger_mstack___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abger_mstack___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abger_mstack___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abger_mstack___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abger_mstack___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abger_mstack___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rr0___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr0___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rr0___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr0___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rr0___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr0___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rr0__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr0__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rr0__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr0__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rr1___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr1___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rr1___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr1___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rr1___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr1___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rr1__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr1__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rr1__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr1__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rrR___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rrR___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rrR___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rrR___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rrR___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rrR___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rrR__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rrR__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl___rrR__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rrR__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl__n0___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__n0___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl__n0___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__n0___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl__n0___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__n0___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl__n0__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__n0__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl__n0__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__n0__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl__nR___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__nR___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl__nR___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__nR___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl__nR___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__nR___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl__nR__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__nR__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abl__nR__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__nR__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rr0___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr0___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rr0___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr0___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rr0___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr0___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rr0__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr0__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rr0__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr0__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rr1___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr1___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rr1___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr1___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rr1___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr1___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rr1__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr1__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rr1__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr1__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rrR___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rrR___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rrR___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rrR___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rrR___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rrR___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rrR__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rrR__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able___rrR__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rrR__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able__n0___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__n0___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able__n0___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__n0___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able__n0___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__n0___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able__n0__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__n0__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able__n0__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__n0__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able__nR___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__nR___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able__nR___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__nR___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able__nR___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__nR___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able__nR__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__nR__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Able__nR__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__nR__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rr0___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr0___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rr0___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr0___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rr0___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr0___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rr0__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr0__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rr0__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr0__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rr1___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr1___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rr1___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr1___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rr1___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr1___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rr1__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr1__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rr1__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr1__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rrR___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rrR___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rrR___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rrR___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rrR___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rrR___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rrR__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rrR__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne___rrR__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rrR__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne__n0___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__n0___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne__n0___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__n0___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne__n0___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__n0___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne__n0__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__n0__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne__n0__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__n0__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne__nR___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__nR___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne__nR___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__nR___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne__nR___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__nR___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne__nR__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__nR__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abne__nR__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__nR__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abneqi_mstack__n_m1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abneqi_mstack__n_m1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abneqi_mstack__n0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abneqi_mstack__n0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abneqi_mstack__n1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abneqi_mstack__n1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abneqi_mstack__n2__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abneqi_mstack__n2__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abneqi_mstack__nR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abneqi_mstack__nR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abneqr_mstack___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abneqr_mstack___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abneqr_mstack___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abneqr_mstack___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abneqr_mstack___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abneqr_mstack___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Abt_mstack__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abt_mstack__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbeqr_mstack___rr0___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbeqr_mstack___rr0___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbeqr_mstack___rr0___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbeqr_mstack___rr0___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbeqr_mstack___rr0___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbeqr_mstack___rr0___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbeqr_mstack___rr1___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbeqr_mstack___rr1___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbeqr_mstack___rr1___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbeqr_mstack___rr1___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbeqr_mstack___rr1___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbeqr_mstack___rr1___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbeqr_mstack___rrR___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbeqr_mstack___rrR___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbeqr_mstack___rrR___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbeqr_mstack___rrR___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbeqr_mstack___rrR___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbeqr_mstack___rrR___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbger_mstack___rr0___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbger_mstack___rr0___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbger_mstack___rr0___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbger_mstack___rr0___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbger_mstack___rr0___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbger_mstack___rr0___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbger_mstack___rr1___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbger_mstack___rr1___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbger_mstack___rr1___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbger_mstack___rr1___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbger_mstack___rr1___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbger_mstack___rr1___rrR__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbger_mstack___rrR___rr0__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbger_mstack___rrR___rr0__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbger_mstack___rrR___rr1__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbger_mstack___rrR___rr1__fR_A_mno_mfast_mbranches))),
            (long) ((jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbger_mstack___rrR___rrR__fR_A_mno_mfast_mbranches))
                    - (jitter_int) (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbger_mstack___rrR___rrR__fR_A_mno_mfast_mbranches)))
          };
      structuredvm_thread_sizes = structuredvm_the_thread_sizes;
      structuredvm_threads = structuredvm_the_threads;
      structuredvm_thread_ends = structuredvm_the_thread_ends;
#ifdef JITTER_PROFILE
      fprintf (stderr, "VM instruction range: ");
      fprintf (stderr, "[%p, ", && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eINVALID));
      fprintf (stderr, "%p)", && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_Apushr_mbger_mstack___rrR___rrR__fR_A_mno_mfast_mbranches));
      fprintf (stderr, "\n");
#endif // #ifdef JITTER_PROFILE
#endif // #ifndef JITTER_DISPATCH_SWITCH

      /* Back to regular C, without our reserved registers if any; I can share
         the end code with the non-initialization case. */
#ifdef JITTER_HAVE_PATCH_IN
      //JITTER_DUMP_PATCH_IN_DESCRIPTORS(structuredvm);
#endif // #ifdef JITTER_HAVE_PATCH_IN
      goto jitter_possibly_restore_registers_and_return_label;
    }


  /* Here is the actual *executor* initialization, to be run before
     actually running the code. */

/* Selectively suppress suprious -Wmaybe-uninitialized .
   The indirect jump hack I use in profiling mode in order to
   have a large gap inside a function introduced by assembler without
   being restricted by jump offset limits (intentionally) tricks GCC
   into believing that the indirect jump may reach any instruction label;
   GCC would then warn that some locals might be used uninitialized,
   by skipping over their initialization.  This however is not possible,
   and I want to selectively silence the warning for the variables in
   question. */
//#pragma GCC diagnostic push
//#pragma GCC diagnostic ignored "-Wmaybe-uninitialized"

  /* Wrap functions and globals used within VM instructions, if needed.
     This is a trick to keep instructions readable while avoiding PC-relative
     addressing, which would mess up replicated code. */
#ifdef JITTER_REPLICATE

  /* Protect the C globals used in VM instructions so that they are always
     referred thru a pointer (from a register or the stack) set in the
     non-replicated part.  This is necessary on architectures where I can't
     force global references to pass thru a GOT.
     [FIXME: possibly don't do this on architectures that don't need it.] */

  typeof (structuredvm_states) * volatile _my_volatile_pointer_to_structuredvm_states = & structuredvm_states;
  typeof (structuredvm_states) * const restrict _my_pointer_to_structuredvm_states __attribute__ ((unused))
     = _my_volatile_pointer_to_structuredvm_states;
# undef structuredvm_states
# define structuredvm_states (* _my_pointer_to_structuredvm_states)

  typeof (structured_fixnum_format_string) * volatile _my_volatile_pointer_to_structured_fixnum_format_string = & structured_fixnum_format_string;
  typeof (structured_fixnum_format_string) * const restrict _my_pointer_to_structured_fixnum_format_string __attribute__ ((unused))
     = _my_volatile_pointer_to_structured_fixnum_format_string;
# undef structured_fixnum_format_string
# define structured_fixnum_format_string (* _my_pointer_to_structured_fixnum_format_string)

  /* Similarly, wrap the C functions used in VM instructions, so that they are
     always called thru a function pointer.  This is necessary on architectures
     where call instructions represent the callee as a PC-relative address.
     Unfortunately C has a special quirky syntax for function pointers, so I
     can't just use the code above.  [FIXME: don't do this on architectures
     that don't need it.] */
  typeof (structured_input) * volatile _my_volatile_pointer_to_structured_input = & structured_input;
  typeof (structured_input) * const _my_structured_input __attribute__ ((unused))
     = * _my_volatile_pointer_to_structured_input;
# undef structured_input
# define structured_input _my_structured_input

  typeof (printf) * volatile _my_volatile_pointer_to_printf = & printf;
  typeof (printf) * const _my_printf __attribute__ ((unused))
     = * _my_volatile_pointer_to_printf;
# undef printf
# define printf _my_printf

/* See the comment above about spurious -Wmaybe-uninitialized warnings. */
//#pragma GCC diagnostic pop
#endif // #ifdef JITTER_REPLICATE


  /* Make an automatic struct holding a copy of the state whose pointer was given.
     The idea is that the copy should be in registers, as far as possible. */
  struct structuredvm_state_runtime jitter_state_runtime
    = jitter_original_state->structuredvm_state_runtime;

  /* Initialize a pointer to The Array base.  This pointer will be in a
     global register variable with no-threading dispatch, and with
     other dispatches in an automatic variable, still hopefully kept
     in a register. */
/* About the pragma, look for "-Wmaybe-uninitialized" in the comments above. FIXME: this is to avoid a GCC warning with profiling.  Check with profiling on. */
//#pragma GCC diagnostic push
//#pragma GCC diagnostic ignored "-Wmaybe-uninitialized"
#ifdef JITTER_DISPATCH_NO_THREADING
# define jitter_array_base structuredvm_array_base_register_variable
#else
  char * restrict jitter_array_base __attribute__ ((unused));
#endif // #ifdef JITTER_DISPATCH_NO_THREADING
//#pragma GCC diagnostic pop
  jitter_array_base
    = (((char *) jitter_original_state->structuredvm_state_backing.jitter_array)
       + JITTER_ARRAY_BIAS);

  /* Declare the instruction pointer from the thread array, unless the dispatching
     model is no-threading, in which case no thread array even exists. */
  structuredvm_program_point jitter_ip = NULL; /* Invalidate to catch errors. */
#ifdef JITTER_REPLICATE
  /* Save an instruction address within this function, to jump to at VM exit
     time; that way we can be sure that at exit time we are back to
     non-replicated code, and stuff like PC-relative addressing work again
     without special tricks.  This variable may safely (and actually should,
     for performance) be kept on the stack.  We need it to be volatile to
     prevent the compiler from being too clever and jump to it using a
     PC-relative displacement from replicated code.   It must not be static,
     since non-automatic variables are problematic to access from replicated
     code, which might use PC-relative addressing. */
  volatile typeof (&& jitter_exit_vm_label) restrict
  jitter_saved_exit_non_replicated_code_pointer = &&jitter_exit_vm_label;
  JITTER_MARK_MEMORY_AS_SET_BY_ASSEMBLY(jitter_saved_exit_non_replicated_code_pointer);
#endif // #ifdef JITTER_REPLICATE


#ifdef JITTER_REPLICATE
  /* FIXME: comment. */
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(input___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(input___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(input___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(input___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(input___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(input___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(input___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(input___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(input___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(input___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(input___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(input___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(input_mstack__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(input_mstack__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(input_mstack__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(input_mstack__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print___rr0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(print___rr0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print___rr0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print___rr0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print___rr1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(print___rr1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print___rr1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print___rr1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print___rrR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(print___rrR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print___rrR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print___rrR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print__nR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(print__nR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print__nR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print__nR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print_mstack__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(print_mstack__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print_mstack__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(print_mstack__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Ab__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Ab__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Ab__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Ab__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr0___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abe___rr0___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr0___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr0___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr0___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abe___rr0___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr0___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr0___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr0___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abe___rr0___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr0___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr0___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr0__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abe___rr0__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr0__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr0__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr0__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abe___rr0__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr0__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr0__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr1___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abe___rr1___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr1___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr1___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr1___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abe___rr1___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr1___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr1___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr1___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abe___rr1___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr1___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr1___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr1__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abe___rr1__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr1__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr1__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr1__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abe___rr1__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr1__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rr1__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rrR___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abe___rrR___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rrR___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rrR___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rrR___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abe___rrR___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rrR___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rrR___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rrR___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abe___rrR___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rrR___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rrR___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rrR__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abe___rrR__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rrR__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rrR__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rrR__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abe___rrR__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rrR__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe___rrR__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__n0___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abe__n0___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__n0___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__n0___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__n0___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abe__n0___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__n0___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__n0___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__n0___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abe__n0___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__n0___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__n0___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__n0__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abe__n0__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__n0__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__n0__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__n0__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abe__n0__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__n0__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__n0__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__nR___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abe__nR___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__nR___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__nR___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__nR___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abe__nR___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__nR___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__nR___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__nR___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abe__nR___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__nR___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__nR___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__nR__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abe__nR__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__nR__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__nR__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__nR__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abe__nR__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__nR__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abe__nR__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abeqi_mstack__n_m1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abeqi_mstack__n_m1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abeqi_mstack__n_m1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abeqi_mstack__n_m1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abeqi_mstack__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abeqi_mstack__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abeqi_mstack__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abeqi_mstack__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abeqi_mstack__n1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abeqi_mstack__n1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abeqi_mstack__n1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abeqi_mstack__n1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abeqi_mstack__n2__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abeqi_mstack__n2__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abeqi_mstack__n2__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abeqi_mstack__n2__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abeqi_mstack__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abeqi_mstack__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abeqi_mstack__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abeqi_mstack__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abeqr_mstack___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abeqr_mstack___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abeqr_mstack___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abeqr_mstack___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abeqr_mstack___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abeqr_mstack___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abeqr_mstack___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abeqr_mstack___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abeqr_mstack___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abeqr_mstack___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abeqr_mstack___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abeqr_mstack___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abf_mstack__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abf_mstack__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abf_mstack__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abf_mstack__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr0___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abg___rr0___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr0___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr0___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr0___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abg___rr0___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr0___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr0___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr0___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abg___rr0___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr0___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr0___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr0__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abg___rr0__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr0__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr0__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr0__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abg___rr0__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr0__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr0__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr1___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abg___rr1___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr1___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr1___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr1___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abg___rr1___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr1___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr1___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr1___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abg___rr1___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr1___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr1___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr1__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abg___rr1__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr1__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr1__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr1__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abg___rr1__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr1__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rr1__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rrR___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abg___rrR___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rrR___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rrR___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rrR___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abg___rrR___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rrR___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rrR___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rrR___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abg___rrR___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rrR___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rrR___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rrR__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abg___rrR__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rrR__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rrR__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rrR__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abg___rrR__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rrR__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg___rrR__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__n0___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abg__n0___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__n0___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__n0___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__n0___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abg__n0___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__n0___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__n0___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__n0___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abg__n0___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__n0___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__n0___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__n0__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abg__n0__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__n0__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__n0__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__n0__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abg__n0__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__n0__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__n0__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__nR___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abg__nR___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__nR___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__nR___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__nR___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abg__nR___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__nR___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__nR___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__nR___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abg__nR___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__nR___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__nR___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__nR__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abg__nR__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__nR__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__nR__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__nR__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abg__nR__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__nR__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abg__nR__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr0___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abge___rr0___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr0___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr0___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr0___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abge___rr0___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr0___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr0___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr0___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abge___rr0___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr0___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr0___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr0__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abge___rr0__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr0__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr0__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr0__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abge___rr0__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr0__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr0__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr1___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abge___rr1___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr1___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr1___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr1___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abge___rr1___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr1___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr1___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr1___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abge___rr1___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr1___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr1___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr1__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abge___rr1__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr1__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr1__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr1__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abge___rr1__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr1__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rr1__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rrR___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abge___rrR___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rrR___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rrR___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rrR___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abge___rrR___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rrR___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rrR___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rrR___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abge___rrR___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rrR___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rrR___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rrR__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abge___rrR__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rrR__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rrR__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rrR__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abge___rrR__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rrR__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge___rrR__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__n0___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abge__n0___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__n0___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__n0___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__n0___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abge__n0___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__n0___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__n0___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__n0___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abge__n0___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__n0___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__n0___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__n0__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abge__n0__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__n0__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__n0__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__n0__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abge__n0__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__n0__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__n0__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__nR___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abge__nR___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__nR___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__nR___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__nR___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abge__nR___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__nR___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__nR___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__nR___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abge__nR___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__nR___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__nR___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__nR__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abge__nR__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__nR__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__nR__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__nR__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abge__nR__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__nR__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abge__nR__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abger_mstack___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abger_mstack___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abger_mstack___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abger_mstack___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abger_mstack___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abger_mstack___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abger_mstack___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abger_mstack___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abger_mstack___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abger_mstack___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abger_mstack___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abger_mstack___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr0___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abl___rr0___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr0___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr0___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr0___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abl___rr0___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr0___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr0___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr0___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abl___rr0___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr0___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr0___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr0__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abl___rr0__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr0__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr0__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr0__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abl___rr0__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr0__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr0__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr1___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abl___rr1___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr1___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr1___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr1___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abl___rr1___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr1___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr1___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr1___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abl___rr1___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr1___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr1___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr1__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abl___rr1__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr1__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr1__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr1__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abl___rr1__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr1__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rr1__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rrR___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abl___rrR___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rrR___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rrR___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rrR___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abl___rrR___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rrR___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rrR___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rrR___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abl___rrR___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rrR___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rrR___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rrR__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abl___rrR__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rrR__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rrR__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rrR__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abl___rrR__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rrR__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl___rrR__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__n0___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abl__n0___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__n0___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__n0___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__n0___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abl__n0___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__n0___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__n0___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__n0___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abl__n0___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__n0___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__n0___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__n0__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abl__n0__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__n0__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__n0__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__n0__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abl__n0__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__n0__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__n0__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__nR___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abl__nR___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__nR___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__nR___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__nR___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abl__nR___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__nR___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__nR___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__nR___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abl__nR___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__nR___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__nR___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__nR__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abl__nR__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__nR__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__nR__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__nR__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abl__nR__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__nR__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abl__nR__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr0___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Able___rr0___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr0___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr0___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr0___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Able___rr0___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr0___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr0___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr0___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Able___rr0___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr0___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr0___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr0__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Able___rr0__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr0__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr0__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr0__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Able___rr0__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr0__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr0__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr1___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Able___rr1___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr1___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr1___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr1___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Able___rr1___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr1___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr1___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr1___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Able___rr1___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr1___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr1___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr1__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Able___rr1__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr1__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr1__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr1__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Able___rr1__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr1__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rr1__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rrR___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Able___rrR___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rrR___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rrR___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rrR___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Able___rrR___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rrR___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rrR___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rrR___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Able___rrR___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rrR___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rrR___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rrR__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Able___rrR__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rrR__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rrR__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rrR__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Able___rrR__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rrR__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able___rrR__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__n0___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Able__n0___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__n0___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__n0___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__n0___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Able__n0___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__n0___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__n0___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__n0___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Able__n0___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__n0___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__n0___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__n0__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Able__n0__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__n0__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__n0__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__n0__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Able__n0__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__n0__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__n0__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__nR___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Able__nR___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__nR___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__nR___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__nR___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Able__nR___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__nR___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__nR___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__nR___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Able__nR___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__nR___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__nR___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__nR__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Able__nR__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__nR__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__nR__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__nR__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Able__nR__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__nR__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Able__nR__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr0___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abne___rr0___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr0___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr0___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr0___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abne___rr0___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr0___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr0___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr0___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abne___rr0___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr0___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr0___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr0__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abne___rr0__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr0__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr0__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr0__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abne___rr0__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr0__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr0__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr1___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abne___rr1___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr1___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr1___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr1___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abne___rr1___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr1___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr1___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr1___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abne___rr1___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr1___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr1___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr1__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abne___rr1__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr1__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr1__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr1__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abne___rr1__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr1__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rr1__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rrR___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abne___rrR___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rrR___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rrR___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rrR___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abne___rrR___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rrR___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rrR___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rrR___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abne___rrR___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rrR___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rrR___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rrR__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abne___rrR__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rrR__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rrR__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rrR__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abne___rrR__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rrR__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne___rrR__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__n0___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abne__n0___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__n0___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__n0___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__n0___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abne__n0___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__n0___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__n0___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__n0___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abne__n0___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__n0___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__n0___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__n0__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abne__n0__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__n0__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__n0__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__n0__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abne__n0__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__n0__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__n0__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__nR___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abne__nR___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__nR___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__nR___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__nR___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abne__nR___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__nR___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__nR___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__nR___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abne__nR___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__nR___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__nR___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__nR__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abne__nR__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__nR__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__nR__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__nR__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abne__nR__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__nR__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abne__nR__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abneqi_mstack__n_m1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abneqi_mstack__n_m1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abneqi_mstack__n_m1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abneqi_mstack__n_m1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abneqi_mstack__n0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abneqi_mstack__n0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abneqi_mstack__n0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abneqi_mstack__n0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abneqi_mstack__n1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abneqi_mstack__n1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abneqi_mstack__n1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abneqi_mstack__n1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abneqi_mstack__n2__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abneqi_mstack__n2__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abneqi_mstack__n2__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abneqi_mstack__n2__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abneqi_mstack__nR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abneqi_mstack__nR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abneqi_mstack__nR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abneqi_mstack__nR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abneqr_mstack___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abneqr_mstack___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abneqr_mstack___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abneqr_mstack___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abneqr_mstack___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abneqr_mstack___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abneqr_mstack___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abneqr_mstack___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abneqr_mstack___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abneqr_mstack___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abneqr_mstack___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abneqr_mstack___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abt_mstack__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Abt_mstack__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abt_mstack__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Abt_mstack__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbeqr_mstack___rr0___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Apushr_mbeqr_mstack___rr0___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbeqr_mstack___rr0___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbeqr_mstack___rr0___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbeqr_mstack___rr0___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Apushr_mbeqr_mstack___rr0___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbeqr_mstack___rr0___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbeqr_mstack___rr0___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbeqr_mstack___rr0___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Apushr_mbeqr_mstack___rr0___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbeqr_mstack___rr0___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbeqr_mstack___rr0___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbeqr_mstack___rr1___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Apushr_mbeqr_mstack___rr1___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbeqr_mstack___rr1___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbeqr_mstack___rr1___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbeqr_mstack___rr1___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Apushr_mbeqr_mstack___rr1___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbeqr_mstack___rr1___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbeqr_mstack___rr1___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbeqr_mstack___rr1___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Apushr_mbeqr_mstack___rr1___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbeqr_mstack___rr1___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbeqr_mstack___rr1___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbeqr_mstack___rrR___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Apushr_mbeqr_mstack___rrR___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbeqr_mstack___rrR___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbeqr_mstack___rrR___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbeqr_mstack___rrR___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Apushr_mbeqr_mstack___rrR___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbeqr_mstack___rrR___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbeqr_mstack___rrR___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbeqr_mstack___rrR___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Apushr_mbeqr_mstack___rrR___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbeqr_mstack___rrR___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbeqr_mstack___rrR___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbger_mstack___rr0___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Apushr_mbger_mstack___rr0___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbger_mstack___rr0___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbger_mstack___rr0___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbger_mstack___rr0___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Apushr_mbger_mstack___rr0___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbger_mstack___rr0___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbger_mstack___rr0___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbger_mstack___rr0___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Apushr_mbger_mstack___rr0___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbger_mstack___rr0___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbger_mstack___rr0___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbger_mstack___rr1___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Apushr_mbger_mstack___rr1___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbger_mstack___rr1___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbger_mstack___rr1___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbger_mstack___rr1___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Apushr_mbger_mstack___rr1___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbger_mstack___rr1___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbger_mstack___rr1___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbger_mstack___rr1___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Apushr_mbger_mstack___rr1___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbger_mstack___rr1___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbger_mstack___rr1___rrR__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbger_mstack___rrR___rr0__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Apushr_mbger_mstack___rrR___rr0__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbger_mstack___rrR___rr0__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbger_mstack___rrR___rr0__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbger_mstack___rrR___rr1__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Apushr_mbger_mstack___rrR___rr1__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbger_mstack___rrR___rr1__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbger_mstack___rrR___rr1__fR_A_mno_mfast_mbranches)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbger_mstack___rrR___rrR__fR_A_mno_mfast_mbranches)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_Apushr_mbger_mstack___rrR___rrR__fR_A_mno_mfast_mbranches);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbger_mstack___rrR___rrR__fR_A_mno_mfast_mbranches)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_Apushr_mbger_mstack___rrR___rrR__fR_A_mno_mfast_mbranches)));
#endif // #ifdef JITTER_REPLICATE
  /* Initialization C code from the user */
  /* End of the initialization C code from the user */


  /* Execute architecture-specific execution-beginning code, if any.
     Make sure it is safe to expand the macro without do..while
     (false). */
  {}; JITTER_EXECUTION_BEGINNING_; {};

#if defined (JITTER_PROFILE_SAMPLE)
    /* Start sample-profiling: this starts the periodic timer signal,
       whose handler will look at the current instruction field within
       the special-purpose struct in the Array. */
    structuredvm_profile_sample_start (STRUCTUREDVM_OWN_STATE);
#endif // #if defined (JITTER_PROFILE_SAMPLE)

  /* Jump to the first instruction.  If replication is enabled this point
     marks the boundary between the ordinary world of C compiled code and
     the more fragile replicated code, where PC-relative address does
     not work as intended (which prevents the use of global and static
     variables, string literals and possibly large literal constants), and
     GDB gets easily confused. */
  jitter_ip = jitter_initial_program_point;

  /* This is the actual jump to the first instruction: it's not an
     inline asm constraint lie like below. */

# if   defined(JITTER_DISPATCH_SWITCH)
    goto jitter_dispatching_switch_label;
# elif (defined(JITTER_DISPATCH_DIRECT_THREADING)  \
        || defined(JITTER_DISPATCH_MINIMAL_THREADING))
    goto * (jitter_ip->label);
# elif defined(JITTER_DISPATCH_NO_THREADING)
    /* On no-threading we only use jitter_ip for the first instruction.
       Make it an alias for the base, which will be enough to satisfy
       inline assembly code which pretends to alter the instruction
       pointer in ways invisible to the compiler.
       At least in my tests this trick frees up one hardware register,
       which is not surprising. */
    goto * jitter_ip;
#   define jitter_ip structuredvm_array_base_register_variable
# else
#   error "unknown dispatch"
# endif // if ... dispatch
  /* FIXME: comment: this is the fake dispatch routine. */
 /* The label is unused (from the compiler's point of view) for simple
    dispatches when not profiling.  (In reality it is always unused.)
    FIXME: comment. */
 jitter_dispatch_label: __attribute__ ((hot, unused))
#if   defined(JITTER_DISPATCH_SWITCH)
  /* This code is unreachable, but the compiler does not know it.  FIXME: comment. */
  goto jitter_dispatching_switch_label;
#elif defined(JITTER_DISPATCH_DIRECT_THREADING)
  /* Again this code is unreachable, but the compiler does not know it.  FIXME: comment. */
  goto * jitter_ip;
#endif
#ifdef JITTER_REPLICATE
  asm volatile ("\njitter_dispatch_label_asm:\n" :);
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eINVALID));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eBEGINBASICBLOCK));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eEXITVM));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eDATALOCATIONS));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eNOP));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eUNREACHABLE0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eUNREACHABLE1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eUNREACHABLE2));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(b__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr0___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr0___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr0___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr0__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr0__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr1___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr1___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr1___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr1__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rr1__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rrR___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rrR___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rrR___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rrR__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be___rrR__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__n0___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__n0___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__n0___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__n0__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__n0__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__nR___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__nR___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__nR___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__nR__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(be__nR__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beqi_mstack__n_m1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beqi_mstack__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beqi_mstack__n1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beqi_mstack__n2__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beqi_mstack__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beqr_mstack___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beqr_mstack___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(beqr_mstack___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bf_mstack__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr0___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr0___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr0___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr0__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr0__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr1___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr1___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr1___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr1__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rr1__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rrR___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rrR___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rrR___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rrR__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg___rrR__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__n0___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__n0___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__n0___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__n0__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__n0__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__nR___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__nR___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__nR___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__nR__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bg__nR__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr0___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr0___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr0___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr0__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr0__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr1___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr1___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr1___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr1__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rr1__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rrR___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rrR___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rrR___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rrR__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge___rrR__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__n0___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__n0___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__n0___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__n0__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__n0__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__nR___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__nR___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__nR___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__nR__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bge__nR__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bger_mstack___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bger_mstack___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bger_mstack___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr0___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr0___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr0___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr0__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr0__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr1___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr1___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr1___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr1__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rr1__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rrR___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rrR___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rrR___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rrR__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl___rrR__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__n0___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__n0___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__n0___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__n0__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__n0__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__nR___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__nR___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__nR___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__nR__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bl__nR__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr0___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr0___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr0___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr0__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr0__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr1___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr1___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr1___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr1__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rr1__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rrR___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rrR___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rrR___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rrR__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble___rrR__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__n0___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__n0___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__n0___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__n0__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__n0__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__nR___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__nR___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__nR___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__nR__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(ble__nR__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr0___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr0___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr0___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr0__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr0__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr1___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr1___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr1___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr1__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rr1__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rrR___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rrR___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rrR___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rrR__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne___rrR__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__n0___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__n0___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__n0___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__n0__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__n0__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__nR___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__nR___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__nR___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__nR__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bne__nR__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneqi_mstack__n_m1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneqi_mstack__n0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneqi_mstack__n1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneqi_mstack__n2__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneqi_mstack__nR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneqr_mstack___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneqr_mstack___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bneqr_mstack___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(bt_mstack__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(copy_mto_mr_mstack___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(copy_mto_mr_mstack___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(copy_mto_mr_mstack___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(different_mstack));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(differenti_mstack__n0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(differenti_mstack__n1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(differenti_mstack__n2));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(differenti_mstack__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rr0___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rr0___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rr0___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rr1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rr1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rr1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rrR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rrR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0___rrR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0__n2___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0__n2___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0__n2___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0__nR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0__nR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr0__nR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rr0___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rr0___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rr0___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rr1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rr1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rr1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rrR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rrR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1___rrR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1__n2___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1__n2___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1__n2___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1__nR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1__nR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rr1__nR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rr0___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rr0___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rr0___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rr1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rr1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rr1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rrR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rrR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR___rrR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR__n2___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR__n2___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR__n2___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR__nR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR__nR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided___rrR__nR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rr0___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rr0___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rr0___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rr1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rr1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rr1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rrR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rrR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR___rrR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR__n2___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR__n2___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR__n2___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR__nR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR__nR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided__nR__nR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(divided_mstack));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(drop_mstack));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(dup_mstack));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(equal_mstack));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(equali_mstack__n0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(equali_mstack__n1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(equali_mstack__n2));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(equali_mstack__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(exitvm));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(greater_mstack));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(greaterorequal_mstack));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(input___rr0__retR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(input___rr1__retR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(input___rrR__retR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(input_mstack__retR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(isnonzero_mstack));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(less_mstack));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(lessorequal_mstack));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(logicaland_mstack));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(logicalnot_mstack));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(logicalor_mstack));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rr0___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rr0___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rr0___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rr1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rr1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rr1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rrR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rrR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0___rrR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__n1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__n1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__n1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__n2___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__n2___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__n2___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__nR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__nR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr0__nR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rr0___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rr0___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rr0___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rr1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rr1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rr1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rrR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rrR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1___rrR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__n1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__n1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__n1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__n2___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__n2___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__n2___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__nR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__nR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rr1__nR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rr0___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rr0___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rr0___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rr1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rr1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rr1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rrR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rrR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR___rrR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__n1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__n1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__n1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__n2___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__n2___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__n2___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__nR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__nR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus___rrR__nR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rr0___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rr0___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rr0___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rr1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rr1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rr1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rrR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rrR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR___rrR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__n1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__n1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__n1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__n2___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__n2___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__n2___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__nR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__nR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus__nR__nR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minus_mstack));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minusi_mstack__n1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minusi_mstack__n2));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minusi_mstack__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minusr_mstack___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minusr_mstack___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(minusr_mstack___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rr0___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rr0___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rr0___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rr1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rr1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rr1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rrR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rrR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov___rrR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n0___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n0___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n0___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n_m1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n_m1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n_m1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n2___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n2___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__n2___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__nR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__nR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(mov__nR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rr0___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rr0___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rr0___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rr1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rr1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rr1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rrR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rrR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0___rrR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__n1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__n1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__n1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__n2___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__n2___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__n2___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__nR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__nR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr0__nR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rr0___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rr0___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rr0___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rr1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rr1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rr1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rrR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rrR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1___rrR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__n1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__n1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__n1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__n2___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__n2___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__n2___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__nR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__nR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rr1__nR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rr0___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rr0___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rr0___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rr1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rr1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rr1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rrR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rrR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR___rrR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__n1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__n1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__n1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__n2___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__n2___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__n2___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__nR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__nR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus___rrR__nR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rr0___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rr0___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rr0___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rr1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rr1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rr1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rrR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rrR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR___rrR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__n1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__n1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__n1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__n2___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__n2___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__n2___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__nR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__nR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus__nR__nR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plus_mstack));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plusi_mstack__n_m1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plusi_mstack__n1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plusi_mstack__n2));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(plusi_mstack__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pop_mstack___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pop_mstack___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pop_mstack___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(print___rr0__retR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(print___rr1__retR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(print___rrR__retR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(print__nR__retR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(print_mstack__retR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack__n0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack__n1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack__n_m1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack__n2));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack__nR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mstack__lR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbeqr_mstack___rr0___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbeqr_mstack___rr0___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbeqr_mstack___rr0___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbeqr_mstack___rr1___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbeqr_mstack___rr1___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbeqr_mstack___rr1___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbeqr_mstack___rrR___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbeqr_mstack___rrR___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbeqr_mstack___rrR___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbger_mstack___rr0___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbger_mstack___rr0___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbger_mstack___rr0___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbger_mstack___rr1___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbger_mstack___rr1___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbger_mstack___rr1___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbger_mstack___rrR___rr0__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbger_mstack___rrR___rr1__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mbger_mstack___rrR___rrR__fR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr0___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr0___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr0___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rr1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rrR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rrR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr0___rrR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr0___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr0___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr0___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rr1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rrR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rrR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rr1___rrR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr0___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr0___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr0___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rr1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rrR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rrR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pushr_mminusr_mpop_mstack___rrR___rrR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rr0___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rr0___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rr0___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rr1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rr1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rr1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rrR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rrR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0___rrR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0__n2___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0__n2___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0__n2___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0__nR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0__nR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr0__nR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rr0___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rr0___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rr0___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rr1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rr1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rr1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rrR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rrR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1___rrR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1__n2___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1__n2___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1__n2___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1__nR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1__nR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rr1__nR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rr0___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rr0___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rr0___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rr1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rr1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rr1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rrR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rrR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR___rrR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR__n2___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR__n2___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR__n2___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR__nR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR__nR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder___rrR__nR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rr0___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rr0___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rr0___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rr1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rr1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rr1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rrR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rrR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR___rrR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR__n2___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR__n2___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR__n2___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR__nR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR__nR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder__nR__nR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(remainder_mstack));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rr0___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rr0___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rr0___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rr1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rr1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rr1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rrR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rrR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0___rrR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0__n2___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0__n2___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0__n2___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0__nR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0__nR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr0__nR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rr0___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rr0___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rr0___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rr1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rr1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rr1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rrR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rrR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1___rrR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1__n2___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1__n2___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1__n2___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1__nR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1__nR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rr1__nR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rr0___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rr0___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rr0___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rr1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rr1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rr1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rrR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rrR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR___rrR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR__n2___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR__n2___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR__n2___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR__nR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR__nR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times___rrR__nR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rr0___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rr0___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rr0___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rr1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rr1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rr1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rrR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rrR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR___rrR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR__n2___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR__n2___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR__n2___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR__nR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR__nR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times__nR__nR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(times_mstack));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rr0___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rr0___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rr0___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rr1___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rr1___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rr1___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rrR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rrR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus___rrR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus__nR___rr0));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus__nR___rr1));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus__nR___rrR));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(uminus_mstack));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(unreachable));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Ab__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr0___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr0___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr0___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr0__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr0__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr1___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr1___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr1___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr1__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rr1__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rrR___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rrR___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rrR___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rrR__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe___rrR__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__n0___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__n0___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__n0___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__n0__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__n0__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__nR___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__nR___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__nR___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__nR__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abe__nR__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abeqi_mstack__n_m1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abeqi_mstack__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abeqi_mstack__n1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abeqi_mstack__n2__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abeqi_mstack__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abeqr_mstack___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abeqr_mstack___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abeqr_mstack___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abf_mstack__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr0___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr0___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr0___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr0__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr0__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr1___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr1___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr1___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr1__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rr1__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rrR___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rrR___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rrR___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rrR__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg___rrR__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__n0___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__n0___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__n0___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__n0__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__n0__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__nR___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__nR___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__nR___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__nR__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abg__nR__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr0___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr0___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr0___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr0__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr0__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr1___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr1___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr1___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr1__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rr1__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rrR___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rrR___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rrR___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rrR__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge___rrR__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__n0___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__n0___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__n0___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__n0__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__n0__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__nR___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__nR___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__nR___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__nR__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abge__nR__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abger_mstack___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abger_mstack___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abger_mstack___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr0___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr0___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr0___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr0__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr0__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr1___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr1___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr1___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr1__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rr1__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rrR___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rrR___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rrR___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rrR__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl___rrR__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__n0___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__n0___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__n0___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__n0__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__n0__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__nR___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__nR___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__nR___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__nR__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abl__nR__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr0___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr0___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr0___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr0__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr0__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr1___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr1___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr1___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr1__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rr1__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rrR___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rrR___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rrR___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rrR__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able___rrR__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__n0___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__n0___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__n0___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__n0__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__n0__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__nR___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__nR___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__nR___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__nR__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Able__nR__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr0___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr0___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr0___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr0__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr0__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr1___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr1___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr1___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr1__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rr1__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rrR___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rrR___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rrR___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rrR__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne___rrR__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__n0___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__n0___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__n0___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__n0__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__n0__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__nR___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__nR___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__nR___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__nR__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abne__nR__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abneqi_mstack__n_m1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abneqi_mstack__n0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abneqi_mstack__n1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abneqi_mstack__n2__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abneqi_mstack__nR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abneqr_mstack___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abneqr_mstack___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abneqr_mstack___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Abt_mstack__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbeqr_mstack___rr0___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbeqr_mstack___rr0___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbeqr_mstack___rr0___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbeqr_mstack___rr1___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbeqr_mstack___rr1___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbeqr_mstack___rr1___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbeqr_mstack___rrR___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbeqr_mstack___rrR___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbeqr_mstack___rrR___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbger_mstack___rr0___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbger_mstack___rr0___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbger_mstack___rr0___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbger_mstack___rr1___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbger_mstack___rr1___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbger_mstack___rr1___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbger_mstack___rrR___rr0__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbger_mstack___rrR___rr1__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_Apushr_mbger_mstack___rrR___rrR__fR_A_mno_mfast_mbranches));
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(jitter_exit_vm_label);
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_TO_(jitter_possibly_restore_registers_and_return_label);
  goto jitter_dispatch_label;
#endif // #ifdef JITTER_REPLICATE

#ifdef JITTER_DISPATCH_SWITCH
  /* This is the dispatching switch.  At the beginning of the first VM
     VM instruction and at the end of each other, control jumps here. */
 jitter_dispatching_switch_label:
  switch (jitter_ip->fixnum)
    {
#endif // #ifdef JITTER_DISPATCH_SWITCH

JITTER_INSTRUCTION_PROLOG_(!INVALID, _eINVALID, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  0
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !INVALID
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eINVALID
{

jitter_fatal ("reached the !INVALID instruction");
}
JITTER_INSTRUCTION_EPILOG_(!INVALID, _eINVALID, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

JITTER_INSTRUCTION_PROLOG_(!BEGINBASICBLOCK, _eBEGINBASICBLOCK, hot)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  1
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !BEGINBASICBLOCK
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eBEGINBASICBLOCK
{

#ifdef JITTER_DISPATCH_MINIMAL_THREADING
  JITTER_SET_IP (jitter_ip + 1);
#endif // #ifdef JITTER_DISPATCH_MINIMAL_THREADING

}
JITTER_INSTRUCTION_EPILOG_(!BEGINBASICBLOCK, _eBEGINBASICBLOCK, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

JITTER_INSTRUCTION_PROLOG_(!EXITVM, _eEXITVM, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  2
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !EXITVM
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eEXITVM
{

JITTER_EXIT();
}
JITTER_INSTRUCTION_EPILOG_(!EXITVM, _eEXITVM, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

JITTER_INSTRUCTION_PROLOG_(!DATALOCATIONS, _eDATALOCATIONS, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  3
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !DATALOCATIONS
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eDATALOCATIONS
{
#ifndef JITTER_DISPATCH_SWITCH
#ifndef JITTER_DISPATCH_NO_THREADING
  JITTER_DATA_LOCATION_DATUM ("instruction pointer", jitter_ip);
#endif // #ifndef JITTER_DISPATCH_NO_THREADING
  JITTER_DATA_LOCATION_DATUM ("base", jitter_array_base);
#ifdef JITTER_DISPATCH_NO_THREADING
#ifdef JITTER_SCRATCH_REGISTER
  JITTER_DATA_LOCATION_DATUM ("scratch", jitter_residual_argument_scratch_register_variable);
#endif // #ifdef JITTER_SCRATCH_REGISTER

#endif // #ifdef JITTER_DISPATCH_NO_THREADING
#ifdef JITTER_DISPATCH_NO_THREADING
#if (0 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_DATA_LOCATION_DATUM ("residual 0", jitter_residual_argument_0_register_variable);
#endif // #if (0 < JITTER_RESIDUAL_REGISTER_NO)
#if (1 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_DATA_LOCATION_DATUM ("residual 1", jitter_residual_argument_1_register_variable);
#endif // #if (1 < JITTER_RESIDUAL_REGISTER_NO)
#if (2 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_DATA_LOCATION_DATUM ("residual 2", jitter_residual_argument_2_register_variable);
#endif // #if (2 < JITTER_RESIDUAL_REGISTER_NO)
#endif // #ifdef JITTER_DISPATCH_NO_THREADING
#if    defined(JITTER_DISPATCH_SWITCH)                    \
    || defined(JITTER_DISPATCH_DIRECT_THREADING)          \
    || defined(JITTER_DISPATCH_MINIMAL_THREADING)         \
    || (   defined(JITTER_DISPATCH_NO_THREADING)          \
        && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE))

  JITTER_DATA_LOCATION_DATUM ("link register", jitter_state_runtime._jitter_link);
#endif // link register
  JITTER_DATA_LOCATION_DATUM ("mainstack top", 
     JITTER_STACK_TOS_TOP_NAME (whatever, jitter_state_runtime., mainstack));
  JITTER_DATA_LOCATION_DATUM ("mainstack undertop ptr", 
     JITTER_STACK_TOS_UNDER_TOP_POINTER_NAME (whatever, jitter_state_runtime., mainstack));
JITTER_DATA_LOCATION_DATUM("%%r0", JITTER_REGISTER_r_0);
JITTER_DATA_LOCATION_DATUM("%%r1", JITTER_REGISTER_r_1);
#endif // #ifndef JITTER_DISPATCH_SWITCH
}
JITTER_INSTRUCTION_EPILOG_(!DATALOCATIONS, _eDATALOCATIONS, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

JITTER_INSTRUCTION_PROLOG_(!NOP, _eNOP, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  4
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !NOP
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eNOP
{

  /* Do nothing. */;
}
JITTER_INSTRUCTION_EPILOG_(!NOP, _eNOP, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

JITTER_INSTRUCTION_PROLOG_(!UNREACHABLE0, _eUNREACHABLE0, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  5
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !UNREACHABLE0
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eUNREACHABLE0
{

jitter_fatal ("reached the !UNREACHABLE0 instruction");
}
JITTER_INSTRUCTION_EPILOG_(!UNREACHABLE0, _eUNREACHABLE0, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

JITTER_INSTRUCTION_PROLOG_(!UNREACHABLE1, _eUNREACHABLE1, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  6
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !UNREACHABLE1
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eUNREACHABLE1
{

jitter_fatal ("reached the !UNREACHABLE1 instruction");
}
JITTER_INSTRUCTION_EPILOG_(!UNREACHABLE1, _eUNREACHABLE1, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

JITTER_INSTRUCTION_PROLOG_(!UNREACHABLE2, _eUNREACHABLE2, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  7
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !UNREACHABLE2
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eUNREACHABLE2
{

jitter_fatal ("reached the !UNREACHABLE2 instruction");
}
JITTER_INSTRUCTION_EPILOG_(!UNREACHABLE2, _eUNREACHABLE2, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  /* Ordinary specialized instructions. */
  JITTER_INSTRUCTION_PROLOG_(b/fR, b__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       8
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         b/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME b__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for b/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for b/fR . */

    JITTER_BRANCH_FAST(JITTER_ARGF0);
  
    /* End of the user code for b/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the b/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(b/fR, b__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(be/%r0/%r0/fR, be___rr0___rr0__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       9
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%r0/%r0/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rr0___rr0__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%r0/%r0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for be/%r0/%r0/fR . */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for be/%r0/%r0/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the be/%r0/%r0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(be/%r0/%r0/fR, be___rr0___rr0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(be/%r0/%r1/fR, be___rr0___rr1__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       10
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%r0/%r1/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rr0___rr1__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%r0/%r1/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for be/%r0/%r1/fR . */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for be/%r0/%r1/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the be/%r0/%r1/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(be/%r0/%r1/fR, be___rr0___rr1__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(be/%r0/%rR/fR, be___rr0___rrR__fR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       11
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%r0/%rR/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rr0___rrR__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%r0/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for be/%r0/%rR/fR . */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for be/%r0/%rR/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the be/%r0/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(be/%r0/%rR/fR, be___rr0___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(be/%r0/n0/fR, be___rr0__n0__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       12
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%r0/n0/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rr0__n0__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%r0/n0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for be/%r0/n0/fR . */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for be/%r0/n0/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the be/%r0/n0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(be/%r0/n0/fR, be___rr0__n0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(be/%r0/nR/fR, be___rr0__nR__fR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       13
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%r0/nR/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rr0__nR__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%r0/nR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for be/%r0/nR/fR . */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for be/%r0/nR/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the be/%r0/nR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(be/%r0/nR/fR, be___rr0__nR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(be/%r1/%r0/fR, be___rr1___rr0__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       14
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%r1/%r0/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rr1___rr0__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%r1/%r0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for be/%r1/%r0/fR . */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for be/%r1/%r0/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the be/%r1/%r0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(be/%r1/%r0/fR, be___rr1___rr0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(be/%r1/%r1/fR, be___rr1___rr1__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       15
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%r1/%r1/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rr1___rr1__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%r1/%r1/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for be/%r1/%r1/fR . */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for be/%r1/%r1/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the be/%r1/%r1/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(be/%r1/%r1/fR, be___rr1___rr1__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(be/%r1/%rR/fR, be___rr1___rrR__fR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       16
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%r1/%rR/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rr1___rrR__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%r1/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for be/%r1/%rR/fR . */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for be/%r1/%rR/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the be/%r1/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(be/%r1/%rR/fR, be___rr1___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(be/%r1/n0/fR, be___rr1__n0__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       17
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%r1/n0/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rr1__n0__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%r1/n0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for be/%r1/n0/fR . */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for be/%r1/n0/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the be/%r1/n0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(be/%r1/n0/fR, be___rr1__n0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(be/%r1/nR/fR, be___rr1__nR__fR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       18
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%r1/nR/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rr1__nR__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%r1/nR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for be/%r1/nR/fR . */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for be/%r1/nR/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the be/%r1/nR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(be/%r1/nR/fR, be___rr1__nR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(be/%rR/%r0/fR, be___rrR___rr0__fR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       19
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%rR/%r0/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rrR___rr0__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%rR/%r0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for be/%rR/%r0/fR . */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for be/%rR/%r0/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the be/%rR/%r0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(be/%rR/%r0/fR, be___rrR___rr0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(be/%rR/%r1/fR, be___rrR___rr1__fR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       20
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%rR/%r1/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rrR___rr1__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%rR/%r1/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for be/%rR/%r1/fR . */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for be/%rR/%r1/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the be/%rR/%r1/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(be/%rR/%r1/fR, be___rrR___rr1__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(be/%rR/%rR/fR, be___rrR___rrR__fR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       21
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%rR/%rR/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rrR___rrR__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%rR/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_2
    JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[3])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for be/%rR/%rR/fR . */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for be/%rR/%rR/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the be/%rR/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(be/%rR/%rR/fR, be___rrR___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(be/%rR/n0/fR, be___rrR__n0__fR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       22
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%rR/n0/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rrR__n0__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%rR/n0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for be/%rR/n0/fR . */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for be/%rR/n0/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the be/%rR/n0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(be/%rR/n0/fR, be___rrR__n0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(be/%rR/nR/fR, be___rrR__nR__fR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       23
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/%rR/nR/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be___rrR__nR__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/%rR/nR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_2
    JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[3])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for be/%rR/nR/fR . */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for be/%rR/nR/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the be/%rR/nR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(be/%rR/nR/fR, be___rrR__nR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(be/n0/%r0/fR, be__n0___rr0__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       24
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/n0/%r0/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be__n0___rr0__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/n0/%r0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for be/n0/%r0/fR . */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for be/n0/%r0/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the be/n0/%r0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(be/n0/%r0/fR, be__n0___rr0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(be/n0/%r1/fR, be__n0___rr1__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       25
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/n0/%r1/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be__n0___rr1__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/n0/%r1/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for be/n0/%r1/fR . */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for be/n0/%r1/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the be/n0/%r1/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(be/n0/%r1/fR, be__n0___rr1__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(be/n0/%rR/fR, be__n0___rrR__fR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       26
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/n0/%rR/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be__n0___rrR__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/n0/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for be/n0/%rR/fR . */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for be/n0/%rR/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the be/n0/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(be/n0/%rR/fR, be__n0___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(be/n0/n0/fR, be__n0__n0__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       27
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/n0/n0/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be__n0__n0__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/n0/n0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for be/n0/n0/fR . */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for be/n0/n0/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the be/n0/n0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(be/n0/n0/fR, be__n0__n0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(be/n0/nR/fR, be__n0__nR__fR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       28
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/n0/nR/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be__n0__nR__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/n0/nR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for be/n0/nR/fR . */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for be/n0/nR/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the be/n0/nR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(be/n0/nR/fR, be__n0__nR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(be/nR/%r0/fR, be__nR___rr0__fR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       29
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/nR/%r0/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be__nR___rr0__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/nR/%r0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for be/nR/%r0/fR . */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for be/nR/%r0/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the be/nR/%r0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(be/nR/%r0/fR, be__nR___rr0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(be/nR/%r1/fR, be__nR___rr1__fR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       30
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/nR/%r1/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be__nR___rr1__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/nR/%r1/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for be/nR/%r1/fR . */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for be/nR/%r1/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the be/nR/%r1/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(be/nR/%r1/fR, be__nR___rr1__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(be/nR/%rR/fR, be__nR___rrR__fR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       31
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/nR/%rR/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be__nR___rrR__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/nR/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_2
    JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[3])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for be/nR/%rR/fR . */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for be/nR/%rR/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the be/nR/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(be/nR/%rR/fR, be__nR___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(be/nR/n0/fR, be__nR__n0__fR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       32
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/nR/n0/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be__nR__n0__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/nR/n0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for be/nR/n0/fR . */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for be/nR/n0/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the be/nR/n0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(be/nR/n0/fR, be__nR__n0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(be/nR/nR/fR, be__nR__nR__fR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       33
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         be/nR/nR/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME be__nR__nR__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for be/nR/nR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_2
    JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[3])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for be/nR/nR/fR . */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for be/nR/nR/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the be/nR/nR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(be/nR/nR/fR, be__nR__nR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(beqi-stack/n-1/fR, beqi_mstack__n_m1__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       34
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         beqi-stack/n-1/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME beqi_mstack__n_m1__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for beqi-stack/n-1/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = -1L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF1 0
    /* JITTER_ARG1 is intentionally not defined for a fast label. */

#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = -1L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for beqi-stack/n-1/fR . */

    jitter_int top = JITTER_TOP_MAINSTACK();
    JITTER_DROP_MAINSTACK();
    JITTER_BRANCH_FAST_IF_EQUAL(top, JITTER_ARGN0, JITTER_ARGF1);
  
    /* End of the user code for beqi-stack/n-1/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the beqi-stack/n-1/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(beqi-stack/n-1/fR, beqi_mstack__n_m1__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(beqi-stack/n0/fR, beqi_mstack__n0__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       35
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         beqi-stack/n0/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME beqi_mstack__n0__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for beqi-stack/n0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF1 0
    /* JITTER_ARG1 is intentionally not defined for a fast label. */

#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for beqi-stack/n0/fR . */

    jitter_int top = JITTER_TOP_MAINSTACK();
    JITTER_DROP_MAINSTACK();
    JITTER_BRANCH_FAST_IF_EQUAL(top, JITTER_ARGN0, JITTER_ARGF1);
  
    /* End of the user code for beqi-stack/n0/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the beqi-stack/n0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(beqi-stack/n0/fR, beqi_mstack__n0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(beqi-stack/n1/fR, beqi_mstack__n1__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       36
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         beqi-stack/n1/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME beqi_mstack__n1__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for beqi-stack/n1/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 1L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF1 0
    /* JITTER_ARG1 is intentionally not defined for a fast label. */

#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 1L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for beqi-stack/n1/fR . */

    jitter_int top = JITTER_TOP_MAINSTACK();
    JITTER_DROP_MAINSTACK();
    JITTER_BRANCH_FAST_IF_EQUAL(top, JITTER_ARGN0, JITTER_ARGF1);
  
    /* End of the user code for beqi-stack/n1/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the beqi-stack/n1/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(beqi-stack/n1/fR, beqi_mstack__n1__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(beqi-stack/n2/fR, beqi_mstack__n2__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       37
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         beqi-stack/n2/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME beqi_mstack__n2__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for beqi-stack/n2/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 2L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF1 0
    /* JITTER_ARG1 is intentionally not defined for a fast label. */

#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 2L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for beqi-stack/n2/fR . */

    jitter_int top = JITTER_TOP_MAINSTACK();
    JITTER_DROP_MAINSTACK();
    JITTER_BRANCH_FAST_IF_EQUAL(top, JITTER_ARGN0, JITTER_ARGF1);
  
    /* End of the user code for beqi-stack/n2/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the beqi-stack/n2/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(beqi-stack/n2/fR, beqi_mstack__n2__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(beqi-stack/nR/fR, beqi_mstack__nR__fR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       38
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         beqi-stack/nR/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME beqi_mstack__nR__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for beqi-stack/nR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF1 0
    /* JITTER_ARG1 is intentionally not defined for a fast label. */

#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for beqi-stack/nR/fR . */

    jitter_int top = JITTER_TOP_MAINSTACK();
    JITTER_DROP_MAINSTACK();
    JITTER_BRANCH_FAST_IF_EQUAL(top, JITTER_ARGN0, JITTER_ARGF1);
  
    /* End of the user code for beqi-stack/nR/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the beqi-stack/nR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(beqi-stack/nR/fR, beqi_mstack__nR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(beqr-stack/%r0/fR, beqr_mstack___rr0__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       39
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         beqr-stack/%r0/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME beqr_mstack___rr0__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for beqr-stack/%r0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF1 0
    /* JITTER_ARG1 is intentionally not defined for a fast label. */

#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for beqr-stack/%r0/fR . */

    jitter_int top = JITTER_TOP_MAINSTACK();
    JITTER_DROP_MAINSTACK();
    JITTER_BRANCH_FAST_IF_EQUAL(top, JITTER_ARGN0, JITTER_ARGF1);
  
    /* End of the user code for beqr-stack/%r0/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the beqr-stack/%r0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(beqr-stack/%r0/fR, beqr_mstack___rr0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(beqr-stack/%r1/fR, beqr_mstack___rr1__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       40
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         beqr-stack/%r1/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME beqr_mstack___rr1__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for beqr-stack/%r1/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF1 0
    /* JITTER_ARG1 is intentionally not defined for a fast label. */

#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for beqr-stack/%r1/fR . */

    jitter_int top = JITTER_TOP_MAINSTACK();
    JITTER_DROP_MAINSTACK();
    JITTER_BRANCH_FAST_IF_EQUAL(top, JITTER_ARGN0, JITTER_ARGF1);
  
    /* End of the user code for beqr-stack/%r1/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the beqr-stack/%r1/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(beqr-stack/%r1/fR, beqr_mstack___rr1__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(beqr-stack/%rR/fR, beqr_mstack___rrR__fR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       41
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         beqr-stack/%rR/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME beqr_mstack___rrR__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for beqr-stack/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF1 0
    /* JITTER_ARG1 is intentionally not defined for a fast label. */

#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for beqr-stack/%rR/fR . */

    jitter_int top = JITTER_TOP_MAINSTACK();
    JITTER_DROP_MAINSTACK();
    JITTER_BRANCH_FAST_IF_EQUAL(top, JITTER_ARGN0, JITTER_ARGF1);
  
    /* End of the user code for beqr-stack/%rR/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the beqr-stack/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(beqr-stack/%rR/fR, beqr_mstack___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bf-stack/fR, bf_mstack__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       42
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bf-stack/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bf_mstack__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bf-stack/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bf-stack/fR . */

    jitter_int top = JITTER_TOP_MAINSTACK();
    JITTER_DROP_MAINSTACK();
    JITTER_BRANCH_FAST_IF_ZERO(top, JITTER_ARGF0);
  
    /* End of the user code for bf-stack/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bf-stack/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bf-stack/fR, bf_mstack__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bg/%r0/%r0/fR, bg___rr0___rr0__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       43
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bg/%r0/%r0/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bg___rr0___rr0__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bg/%r0/%r0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bg/%r0/%r0/fR . */

    JITTER_BRANCH_FAST_IF_GREATER_SIGNED(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for bg/%r0/%r0/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bg/%r0/%r0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bg/%r0/%r0/fR, bg___rr0___rr0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bg/%r0/%r1/fR, bg___rr0___rr1__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       44
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bg/%r0/%r1/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bg___rr0___rr1__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bg/%r0/%r1/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a fast
        register. */
#   define JITTER_ARG1  JITTER_FAST_REGISTER(r, 1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bg/%r0/%r1/fR . */

    JITTER_BRANCH_FAST_IF_GREATER_SIGNED(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for bg/%r0/%r1/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bg/%r0/%r1/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bg/%r0/%r1/fR, bg___rr0___rr1__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bg/%r0/%rR/fR, bg___rr0___rrR__fR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       45
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bg/%r0/%rR/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bg___rr0___rrR__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bg/%r0/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bg/%r0/%rR/fR . */

    JITTER_BRANCH_FAST_IF_GREATER_SIGNED(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for bg/%r0/%rR/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bg/%r0/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bg/%r0/%rR/fR, bg___rr0___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bg/%r0/n0/fR, bg___rr0__n0__fR, hot)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       46
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bg/%r0/n0/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bg___rr0__n0__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bg/%r0/n0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a nonresidual literal. */
#   define JITTER_ARG1  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bg/%r0/n0/fR . */

    JITTER_BRANCH_FAST_IF_GREATER_SIGNED(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for bg/%r0/n0/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bg/%r0/n0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bg/%r0/n0/fR, bg___rr0__n0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bg/%r0/nR/fR, bg___rr0__nR__fR, cold)
  {
    /* This specialized instruction is not a replacement. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   define JITTER_BRANCH_FAST_AND_LINK_INTERNAL _JITTER_BRANCH_FAST_AND_LINK_INTERNAL
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       47
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         bg/%r0/nR/fR

#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME bg___rr0__nR__fR

  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for bg/%r0/nR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a fast
        register. */
#   define JITTER_ARG0  JITTER_FAST_REGISTER(r, 0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#if defined (JITTER_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
  /* Force the compiler not move sample-profiling instrumentation
     beyond this point; this way the actual user code is timed.
     This is still not perfect, as residuals are materialised before
     we arrive here, but should be adequate at least for slow VM
     instructions. */
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
#endif
#if defined (JITTER_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (STRUCTUREDVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

/* User-specified code, instruction-beginning-c part: beginning. */

/* User-specified code, instruction-beginning-c part: end */


    /* User code for bg/%r0/nR/fR . */

    JITTER_BRANCH_FAST_IF_GREATER_SIGNED(JITTER_ARGN0, JITTER_ARGN1, JITTER_ARGF2);
  
    /* End of the user code for bg/%r0/nR/fR . */

/* User-specified code, instruction-end-c part: beginning. */

/* User-specified code, instruction-end-c part: end */

    /* Undefine the bg/%r0/nR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

  }
 JITTER_INSTRUCTION_EPILOG_(bg/%r0/nR/fR, bg___rr0__nR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  JITTER_INSTRUCTION_PROLOG_(bg/%r1/%r0/fR, bg__