/*
 GNU Maverik - a system for managing display and interaction in 
               Virtual Environment applications.
 Copyright (C) 1999-2001 Advanced Interfaces Group

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA


 The authors can be contacted via:
 www   - http://aig.cs.man.ac.uk
 email - maverik@aig.cs.man.ac.uk
 mail  - Advanced Interfaces Group, Room 2.94, Kilburn Building, 
         University of Manchester, Manchester, M13 9PL, UK
*/

#ifndef _MAV_GFX_INCLUDE
#define _MAV_GFX_INCLUDE

#ifdef __cplusplus
extern "C" {
#endif

/* Window manager routines */

void mav_gfxWindowOpen(int id, int x, int y, int w, int h, char *name, char *disp, int wmp, int sb, int qb, int ms, int ab, int stenb, int desta, int *wret, int *hret);
void mav_gfxWindowClose(int id);
void mav_gfxWindowSet(int id);
void mav_gfxWindowBuffersSwap(void);
void mav_gfxWindowResGet(int *x, int *y);
int  mav_gfxWindowEventGet(int *info);
int  mav_gfxWindowEventPeek(void);
int  mav_gfxWindowPointerGet(int id, int *x, int *y, int *rx, int *ry, int *buts);
void mav_gfxWindowPointerSet(int win, int x, int y);
int  mav_gfxWindowKeyGet(int key);
int  mav_gfxWindowFontSet(char *s, int font, int *width);
void mav_gfxWindowStringDisplay(char *s, int font);



/* Graphics routines */

#define MAV_PROJECTION 1
#define MAV_MODELVIEW 2
#define MAV_PROJANDVIEW 3
#define MAV_FRONT 1
#define MAV_BACK 2
#define MAV_BLEND_OFF 0
#define MAV_BLEND_1 1
#define MAV_POLYGON_LINE 0
#define MAV_POLYGON_FILL 1
#define MAV_ACCUM_ACCUM 1
#define MAV_ACCUM_LOAD 2
#define MAV_ACCUM_RETURN 3
#define MAV_ACCUM_ADD 4
#define MAV_ACCUM_MULT 5
#define MAV_DLISTS_COMPILE 1
#define MAV_DLISTS_COMPILE_AND_EXECUTE 2
#define MAV_FOG_NONE 0
#define MAV_FOG_LINEAR 1
#define MAV_FOG_EXP 2
#define MAV_FOG_EXP2 3

void mav_gfxClipPlaneSet(int id, MAV_clipPlane cp);
void mav_gfxClipPlanesSet(MAV_clipPlanes *cp);
void mav_gfxClipPlaneEnable(int id);
void mav_gfxClipPlaneDisable(int id);
void mav_gfxClearC(void);
void mav_gfxClearZ(void);
void mav_gfxClearA(void);
void mav_gfxClearCZ(void);
void mav_gfxBackgroundColourSet(float r, float g, float b);
void mav_gfxDepthTestSet(int v);
void mav_gfxDepthMaskSet(int v);
void mav_gfxNormalizeSet(int v);
void mav_gfxBackfaceCullSet(int v);
int  mav_gfxBackfaceCullGet(void);
void mav_gfxBufferReadSet(int buf);
void mav_gfxPixelRead(int x, int y, int w, int h, unsigned long *d);
void mav_gfxPixelReadUByte(int x, int y, int w, int h, unsigned char *d);
void mav_gfxPixelDraw(int w, int h, float *v);
void mav_gfxViewPortSet(int x, int y, int w, int h);
void mav_gfxRasterPosSet(MAV_vector v);
void mav_gfxRasterPos2DSet(float x, float y);
void mav_gfxLineWidthSet(float wd);
float mav_gfxLineWidthGet(void);
void mav_gfxLineStippleSet(int factor, unsigned short pattern);
void mav_gfxFogSet(int type, float data1, float data2, float r, float g, float b);
int mav_gfxVisualInfoGet(int *r, int *g, int *b, int *a, int *d, int *db, int *ar, int *ag, int *ab, int *aa, int *sb, int *msb);
void mav_gfxPolygonModeSet(int v);
void mav_gfxMultiSampleSet(int v);
void mav_gfxFinish(void);
void mav_gfxFlush(void);

void mav_gfxMatrixMode(int mode);
void mav_gfxMatrixLoad(MAV_matrix m);
void mav_gfxMatrixPush(void);
void mav_gfxMatrixPop(void);
void mav_gfxMatrixMult(MAV_matrix m);
void mav_gfxMatrixTranslate(MAV_vector v);
void mav_gfxMatrixScale(float x, float y, float z);
void mav_gfxPerspectiveSet(float ncp, float fcp, float fov, float aspect);
void mav_gfxOrthogonalSet(float left, float right, float top, float bottom, float nr, float fr);
MAV_matrix mav_gfxMatrixGet(void);

void mav_gfxPolygonBegin(void);
void mav_gfxPolygonEnd(void);
void mav_gfxTrianglesBegin(void);
void mav_gfxTrianglesEnd(void);
void mav_gfxStripQBegin(void);
void mav_gfxStripQEnd(void);
void mav_gfxStripTBegin(void);
void mav_gfxStripTEnd(void);
void mav_gfxLineClosedBegin(void);
void mav_gfxLineClosedEnd(void);
void mav_gfxLineBegin(void);
void mav_gfxLineEnd(void);
void mav_gfxMeshTBegin(void);
void mav_gfxMeshTEnd(void);

void mav_gfxVertex(MAV_vector v);
void mav_gfxNormal(MAV_vector n);
void mav_gfxTexCoord(MAV_texCoord t);

void mav_gfxColouringModeUse(MAV_palette *p, int mode);
void mav_gfxColourSet(MAV_colour col);
void mav_gfxColourUse(MAV_colour col);
void mav_gfxMaterialSet(MAV_material mat);
void mav_gfxMaterialUse(MAV_material mat);
void mav_gfxTextureSet(MAV_texture *tex, MAV_texEnvFn pTexEnv);
void mav_gfxTextureUse(MAV_texture tex, MAV_texEnvFn pTexEnv);
void mav_gfxLightingModelSet(MAV_lightingModel lm);
void mav_gfxLightingModelUse(MAV_lightingModel lm);
void mav_gfxLightSet(MAV_light l);
void mav_gfxLightUse(MAV_light l);
void mav_gfxLightPos(MAV_light l);

void mav_gfxBlendSet(int v);
void mav_gfxTextureEnv1Set(int v);
void mav_gfxTextureEnv2Set(int v);
void mav_gfxAccumSet(int mode, float val);

int  mav_gfxListsNew(int range);
void mav_gfxListNew(int list, int mode);
void mav_gfxListEnd(void);
void mav_gfxListExec(int list);
void mav_gfxListsExec(int n, int *lists);
void mav_gfxListsDelete(int list, int range);



/* Voodoo specific routines */

void mav_gfx3DfxModeSet(int fullscreen);
int  mav_gfx3DfxBoardSet(int bd);



/* Options */

extern int mav_opt_trackMatrix;
extern int mav_opt_texComps;



/* Info on graphics vendor */

extern char *mav_gfx_vendor;
extern char *mav_gfx_renderer;
extern char *mav_gfx_version;



/* Module initialise */

int mav_gfxModuleInit(void);
char *mav_gfxModuleID(void);

#ifdef __cplusplus
}
#endif
#endif
