/*
 * Decompiled with CFR 0.152.
 */
package org.domterm;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.domterm.Backend;
import org.domterm.ClassBackend;
import org.domterm.ProcessBackend;
import org.domterm.util.StringBufferedWriter;
import org.domterm.util.WTDebug;

public class DomHttpServer
implements HttpHandler {
    static int verbose = 0;
    Map<String, Session> sessionMap = new HashMap<String, Session>();
    public static int serverBacklog = 0;
    HttpServer httpServer = HttpServer.create();
    int port;
    Object endMonitor;
    String[] backendArgs;
    private byte[] inputBuffer;
    private int inputLength;
    static String domtermPath;
    static int runBrowser;

    public DomHttpServer(int n, String[] stringArray) throws IOException, UnknownHostException {
        this.httpServer.bind(new InetSocketAddress(n), serverBacklog);
        this.httpServer.setExecutor(null);
        this.backendArgs = stringArray;
        this.httpServer.createContext("/", this);
    }

    public static void setExitOnClose(boolean bl) {
        runBrowser = bl ? 0 : -1;
    }

    private void readAll(HttpExchange httpExchange) throws IOException {
        InputStream inputStream = httpExchange.getRequestBody();
        byte[] byArray = new byte[1024];
        int n = 0;
        while (true) {
            int n2;
            int n3;
            if ((n3 = byArray.length - n) == 0) {
                byte[] byArray2 = new byte[3 * byArray.length >> 1];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                byArray = byArray2;
                n3 = byArray.length - n;
            }
            if ((n2 = inputStream.read(byArray, n, n3)) <= 0) break;
            n += n2;
        }
        this.inputBuffer = byArray;
        this.inputLength = n;
        inputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        Closeable closeable;
        Object object;
        Object object2;
        URI uRI = httpExchange.getRequestURI();
        String string = uRI.toString();
        Headers headers = httpExchange.getResponseHeaders();
        if ("/".equals(string)) {
            string = "/domterm/#ajax";
            headers.add("Location", string);
            httpExchange.sendResponseHeaders(307, -1L);
            return;
        }
        if (string.startsWith("/domterm/")) {
            if ((string = string.substring(8)).equals("/")) {
                string = "/repl-client.html";
            }
            if ("/open.txt".equals(string)) {
                this.readAll(httpExchange);
                String string2 = new String(this.inputBuffer, 0, this.inputLength, StandardCharsets.UTF_8);
                Session session = new Session(this, httpExchange);
                Backend backend = session.backend;
                if (string2.startsWith("VERSION=")) {
                    backend.addVersionInfo(string2.substring(8));
                }
                backend.versionInfo = backend.versionInfo + ";DomHttpServer";
                try {
                    session.termWriter = new ReplWriter(session);
                    backend.run(session.termWriter);
                    backend.sendSessionName();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                String string3 = "key=" + session.key;
                byte[] byArray = string3.getBytes();
                httpExchange.getResponseHeaders().set("Content-Type", "text/plain");
                httpExchange.sendResponseHeaders(200, byArray.length);
                OutputStream outputStream = httpExchange.getResponseBody();
                outputStream.write(byArray);
                outputStream.close();
                return;
            }
            if (string.startsWith("/io-")) {
                int n;
                byte[] byArray;
                String string4 = string.substring(4);
                Session session = this.sessionMap.get(string4);
                this.readAll(httpExchange);
                Backend backend = session.backend;
                this.processInput(session);
                ReplWriter replWriter = session.termWriter;
                Closeable closeable2 = replWriter;
                synchronized (closeable2) {
                    byArray = replWriter.bytes;
                    n = replWriter.numBytes;
                    replWriter.bytes = ReplWriter.noBytes;
                    replWriter.numBytes = 0;
                }
                httpExchange.sendResponseHeaders(200, n);
                closeable2 = httpExchange.getResponseBody();
                ((OutputStream)closeable2).write(byArray, 0, n);
                ((OutputStream)closeable2).close();
                if (session.termWriter.closed) {
                    session.close();
                }
                return;
            }
            if (string.startsWith("/close-")) {
                object2 = string.substring(7);
                object = this.sessionMap.get(object2);
                ((Session)object).close();
            } else {
                object2 = this.getClass().getResource(string);
                if (object2 != null) {
                    URLConnection uRLConnection = ((URL)object2).openConnection();
                    object = uRLConnection;
                    if (uRLConnection != null && (closeable = ((URLConnection)object).getInputStream()) != null) {
                        int n;
                        int n2 = ((URLConnection)object).getContentLength();
                        String string5 = ((URLConnection)object).getContentType();
                        if (string5 == null || string5.equals("content/unknown")) {
                            if (string.endsWith(".js")) {
                                string5 = "application/javascript";
                            } else if (string.endsWith(".css")) {
                                string5 = "text/css";
                            }
                        }
                        headers.add("Content-Type", string5);
                        httpExchange.sendResponseHeaders(200, n2);
                        OutputStream outputStream = httpExchange.getResponseBody();
                        byte[] byArray = new byte[2048];
                        while ((n = ((InputStream)closeable).read(byArray)) >= 0) {
                            outputStream.write(byArray, 0, n);
                        }
                        outputStream.close();
                        return;
                    }
                }
            }
        }
        object2 = "The requested URL " + string + " was not found on this server.\r\n";
        object = ((String)object2).getBytes();
        httpExchange.sendResponseHeaders(404, ((byte[])object).length);
        closeable = httpExchange.getResponseBody();
        ((OutputStream)closeable).write((byte[])object);
        ((OutputStream)closeable).close();
    }

    public void start() {
        this.httpServer.start();
        this.port = this.httpServer.getAddress().getPort();
    }

    public void stop() {
        this.httpServer.stop(0);
        this.httpServer = null;
    }

    public int getPort() {
        return this.port;
    }

    public static void fatal(String string) {
        System.err.println(string);
        System.exit(-1);
    }

    protected Backend createBackend(Object object) {
        return this.createBackend();
    }

    protected Backend createBackend() {
        String[] stringArray;
        int n;
        WTDebug.init();
        Backend backend = null;
        String[] stringArray2 = this.backendArgs;
        int n2 = 32;
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray = stringArray2[n];
            if (stringArray.equals("--pty") || stringArray.equals("-e")) {
                n2 = 84;
                continue;
            }
            if (stringArray.equals("--shell") || stringArray.equals("--pipe") || stringArray.equals("--process")) {
                n2 = 83;
                continue;
            }
            if (stringArray.equals("--class")) {
                if (n + 1 == stringArray2.length) {
                    DomHttpServer.fatal("missing class name");
                }
                Method method = null;
                String string = stringArray2[n + 1];
                try {
                    method = ClassBackend.getMainMethod(string);
                }
                catch (Throwable throwable) {
                    DomHttpServer.fatal("caught " + throwable + " trying to load class " + string);
                }
                String[] stringArray3 = new String[stringArray2.length - n - 2];
                System.arraycopy(stringArray2, n + 2, stringArray3, 0, stringArray3.length);
                backend = new ClassBackend(method, stringArray3);
                break;
            }
            if (stringArray.length() != 0 && stringArray.charAt(0) != '-') break;
            DomHttpServer.fatal("unknown argument '" + (String)stringArray + "'");
        }
        if (backend == null) {
            stringArray = new String[stringArray2.length - n];
            System.arraycopy(stringArray2, n, stringArray, 0, stringArray.length);
            if (n2 == 84 || n2 == 32) {
                try {
                    Class.forName("org.domterm.pty.PTY");
                    n2 = 84;
                }
                catch (Throwable throwable) {
                    if (n2 == 32) {
                        n2 = 83;
                        System.err.println("(no pty in java.library.path - using --process)");
                    }
                    DomHttpServer.fatal("caught " + throwable);
                }
            }
            try {
                backend = n2 == 83 ? new ProcessBackend(stringArray) : ProcessBackend.tryPtyOrProcessBackend(stringArray, domtermPath);
            }
            catch (Throwable throwable) {
                DomHttpServer.fatal("caught " + throwable);
            }
        }
        return backend;
    }

    private void processInput(Session session) {
        Backend backend = session.backend;
        int n = 0;
        int n2 = this.inputLength;
        int n3 = -1;
        byte[] byArray = this.inputBuffer;
        int n4 = 0;
        while (true) {
            if (n4 == n2 || (byArray[n4] & 0xFF) == 253 || session.pendingEvent != null) {
                int n5;
                if (n4 > n) {
                    String string = new String(byArray, n, n4 - n, StandardCharsets.UTF_8);
                    if (verbose > 0) {
                        WTDebug.println("received msg [" + WTDebug.toQuoted(string) + "]");
                    }
                    backend.processInputCharacters(string);
                }
                n = n4;
                if (n4 == n2) break;
                if (session.pendingEvent == null) {
                    // empty if block
                }
                for (n5 = ++n4; n5 < n2 && byArray[n5] != 10; ++n5) {
                }
                String string = new String(byArray, n4, n5 - n4, StandardCharsets.UTF_8);
                if (session.pendingEvent != null) {
                    string = session.pendingEvent + string;
                }
                if (n5 == n2) {
                    session.pendingEvent = string;
                    break;
                }
                session.pendingEvent = null;
                int n6 = string.indexOf(32);
                String string2 = n6 < 0 ? string : string.substring(0, n6);
                String string3 = n6 < 0 ? "" : string.substring(n6 + 1);
                session.reportEvent(string2, string3);
                n4 = n5;
                n = n5 + 1;
            }
            ++n4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        String[] stringArray2;
        int n;
        int n2 = 32;
        String string = null;
        domtermPath = System.getProperty("java.library.path");
        if (domtermPath != null && domtermPath.endsWith("/lib")) {
            domtermPath = domtermPath.substring(0, domtermPath.length() - 4);
        }
        int n3 = -1;
        for (n = 0; n < stringArray.length; ++n) {
            stringArray2 = stringArray[n];
            if (stringArray2.equals("--port")) {
                if (n + 1 == stringArray.length) {
                    DomHttpServer.fatal("missing port number");
                }
                stringArray2 = stringArray[++n];
                try {
                    n3 = Integer.parseInt((String)stringArray2);
                }
                catch (Exception exception) {
                    DomHttpServer.fatal("bad port number '" + (String)stringArray2 + "'");
                }
                continue;
            }
            if (stringArray2.startsWith("--domterm-path=")) {
                domtermPath = stringArray2.substring(15);
                continue;
            }
            if (stringArray2.equals("--browser")) {
                runBrowser = 0;
                continue;
            }
            if (stringArray2.startsWith("--browser=")) {
                runBrowser = 0;
                string = stringArray2.substring(10);
                continue;
            }
            if (stringArray2.equals("--firefox")) {
                runBrowser = 1;
                continue;
            }
            if (stringArray2.equals("--chrome")) {
                runBrowser = 2;
                continue;
            }
            if (!stringArray2.equals("--qtdomterm") && !stringArray2.equals("--qtwebengine")) break;
            runBrowser = 3;
        }
        stringArray2 = new String[stringArray.length - n];
        System.arraycopy(stringArray, n, stringArray2, 0, stringArray2.length);
        if (n3 == -1) {
            n3 = runBrowser >= 0 ? 0 : 8025;
        }
        try {
            Object object;
            DomHttpServer domHttpServer = new DomHttpServer(n3, stringArray2);
            domHttpServer.start();
            n3 = domHttpServer.getPort();
            String string2 = "http://localhost:" + n3 + "/domterm/#ajax";
            if (runBrowser == 0) {
                if (string == null) {
                    Desktop.getDesktop().browse(new URI(string2));
                } else {
                    object = Runtime.getRuntime().exec(new String[]{string, string2});
                }
            } else if (runBrowser == 1) {
                object = DomHttpServer.firefoxCommand();
                Process process = Runtime.getRuntime().exec(new String[]{object, string2});
            } else if (runBrowser == 2) {
                object = DomHttpServer.chromeCommand();
                String string3 = "--app=" + string2;
                Process process = Runtime.getRuntime().exec(new String[]{object, string3});
            } else if (runBrowser == 3) {
                object = domtermPath + "/bin/qtdomterm";
                Process process = Runtime.getRuntime().exec(new String[]{object, "--connect", "localhost:" + n3});
                process.waitFor();
            } else {
                System.out.println("DomTerm server started on port: " + n3 + ".");
                System.out.println("Point your browser at " + string2);
                object = new BufferedReader(new InputStreamReader(System.in));
                System.out.print("Please press a key to stop the server.");
                ((BufferedReader)object).readLine();
            }
            if (runBrowser >= 0) {
                object = domHttpServer.endMonitor = new Object();
                synchronized (object) {
                    domHttpServer.endMonitor.wait();
                }
            }
            domHttpServer.stop();
            System.exit(0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new RuntimeException(throwable);
        }
    }

    public static String chromeCommand() {
        String string = "google-chrome";
        String string2 = System.getenv("CHROME_BIN");
        if (string2 != null && new File(string2).exists()) {
            string = string2;
        }
        return string;
    }

    public static String firefoxCommand() {
        String string = "firefox";
        String string2 = "/Applications/Firefox.app/Contents/MacOS/firefox";
        if (new File(string2).exists()) {
            string = string2;
        }
        return string;
    }

    static {
        runBrowser = -1;
    }

    static class ReplWriter
    extends StringBufferedWriter {
        private static byte[] noBytes = new byte[0];
        Session session;
        byte[] bytes = noBytes;
        int numBytes = 0;
        boolean closed;
        int limit = 2000;
        public static final int MASK28 = 0xFFFFFFF;
        int countWritten;
        int countConfirmed;

        ReplWriter(Session session) {
            super(true);
            this.session = session;
        }

        @Override
        protected synchronized void writeRaw(String string) throws IOException {
            byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
            int n = byArray.length;
            int n2 = this.numBytes + n;
            if (this.bytes == noBytes) {
                this.bytes = byArray;
            } else {
                if (n2 > this.bytes.length) {
                    int n3 = 3 * this.numBytes >> 1;
                    if (n2 > n3) {
                        n3 = n2;
                    }
                    byte[] byArray2 = new byte[n3];
                    System.arraycopy(this.bytes, 0, byArray2, 0, this.numBytes);
                    this.bytes = byArray2;
                }
                System.arraycopy(byArray, 0, this.bytes, this.numBytes, n);
            }
            this.numBytes = n2;
            this.countWritten = this.countWritten + n & 0xFFFFFFF;
            while ((this.countWritten - this.countConfirmed & 0xFFFFFFF) > 3000) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public synchronized void updateConfirmed(int n) {
            this.countConfirmed = n;
            this.notifyAll();
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            if (this.session != null) {
                this.write("\u001b[99;99u");
                super.close();
                this.session = null;
            }
        }
    }

    static class Session {
        String key;
        Backend backend;
        static int counter;
        ReplWriter termWriter;
        String pendingEvent = null;
        DomHttpServer server;

        public Session(DomHttpServer domHttpServer, HttpExchange httpExchange) {
            this.server = domHttpServer;
            this.key = Integer.toString(++counter);
            this.backend = domHttpServer.createBackend();
            domHttpServer.sessionMap.put(this.key, this);
        }

        public void reportEvent(String string, String string2) {
            if (string.equals("RECEIVED")) {
                try {
                    int n = Integer.parseInt(string2);
                    this.termWriter.updateConfirmed(n);
                }
                catch (Throwable throwable) {}
            } else {
                this.backend.reportEvent(string, string2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.server.sessionMap.remove(this.key);
            this.backend.close(this.server.sessionMap.isEmpty());
            if (this.server.endMonitor != null) {
                Object object = this.server.endMonitor;
                synchronized (object) {
                    this.server.endMonitor.notifyAll();
                }
            } else if (runBrowser >= 0) {
                this.server.stop();
            }
        }

        public String toString() {
            return "Session-" + this.key;
        }
    }
}

