SCRIPT_NAME=elf
ELFSIZE=64
TEMPLATE_NAME=elf
OUTPUT_FORMAT="elf64-sparc"
NO_REL_RELOCS=yes
MAXPAGESIZE="CONSTANT (MAXPAGESIZE)"
COMMONPAGESIZE="CONSTANT (COMMONPAGESIZE)"
ARCH="sparc:v9"
MACHINE=
DATA_PLT=
GENERATE_SHLIB_SCRIPT=yes
GENERATE_PIE_SCRIPT=yes
NOP=0x01000000
NO_SMALL_DATA=yes
TEXT_START_ADDR=0x100000

# Treat a host that matches the target with the possible exception of "64"
# and "v7", "v8", "v9" in the name as if it were native.
if test `echo "$host" | sed -e 's/64//;s/v[789]//'` \
 = `echo "$target" | sed -e 's/64//;s/v[789]//'`; then
  case " $EMULATION_LIBPATH " in
    *" ${EMULATION_NAME} "*)
      NATIVE=yes
      ;;
  esac
fi

# Linux modifies the default library search path
# to first include a 64-bit specific directory.  It's put
# in slightly different places on the two systems.
# Look for 64 bit target libraries in /lib64, /usr/lib64 etc., first
# on Linux.
case "$EMULATION_NAME" in
  *64*)
    case "$target" in
      sparc*-linux*)
	LIBPATH_SUFFIX=64 ;;
    esac
    ;;
esac
