;; this shows how read-string can be used.

(require "scm_dir:readstring.scm")

(define (readstring-test)
  (let ((pbd (vector-ref (smg$create_pasteboard) 1))
	(vd (vector-ref (smg$create_virtual_display 10 70) 1))
	(kbd (vector-ref (smg$create_virtual_keyboard) 1)))
    (smg$paste_virtual_display vd pbd 2 2)
    (smg$put_chars vd "Edit" 2 4)
    (smg$put_chars vd ">" 2 9)
    (smg$put_chars vd "<" 2 30)
    (smg$put_chars vd "Press DO or Ctrl-Z to exit." 10 2)
    (let loop ((res (read-string vd kbd  "default" 20 2 10
				 (list SMG$K_TRM_CTRLM SMG$K_TRM_DO
				       SMG$K_TRM_CTRLZ))))
      (smg$put_chars vd "Last:" 5 4)
      (smg$put_chars vd (string-append (car res)
				       (make-string
					(- 20 (string-length (car res))) #\_))
		     5 10)
      (if (not (or (= (cdr res) SMG$K_TRM_DO)
		   (= (cdr res) SMG$K_TRM_CTRLZ)))
	  (loop (read-string vd kbd (car res) 20 2 10
			     (list SMG$K_TRM_CTRLM SMG$K_TRM_DO
				   SMG$K_TRM_CTRLZ)))))
    (smg$set_physical_cursor pbd 24 1)
    (smg$delete_pasteboard pbd 0)
    (smg$delete_virtual_keyboard kbd)
    (smg$delete_virtual_display vd)
    ))

(readstring-test)
