;;; JACAL: Symbolic Mathematics System.        -*-scheme-*-
;;; Copyright 1989, 1990, 1991, 1992, 1993 Aubrey Jaffer.
;;; See the file "COPYING" for terms applying to this program.

(define *jacal-version* "1a4")

(slib:load (in-vicinity (program-vicinity) "types"))
			;Variables and type conversions.
(define (math:exit b) (cleanup-handlers!) (error "error in math system"))
	;error handling when not running (math) [read-eval-print loop]
;(define *diagnostic-output* (current-output-port))
(slib:load (in-vicinity (program-vicinity) "grammar"))
			;grammar, I/O, test, and error routines.
;;; These get set in "modeinit.scm"
		;grammars to use if none is loaded.
(define *input-grammar* (get-grammar 'scheme))
(define *output-grammar* (get-grammar 'scheme))
(define *echo-grammar* (get-grammar 'null))
(define Language #f)
(define math:debug #f)
(define math:phases #f)
(define math:trace #f)
(define linkradicals #f)
(define Horner #f)
(define page-height #f)
(define page-width #f)
(define newextstr #f)
(define newlabelstr #f)
(define newlabelsym #f)
(define % #f)

;(define *symdefs* '())			;":" environment.
(define *symdefs* (make-hash-table 37))	;":" environment.
(slib:load (in-vicinity (program-vicinity) "sect"))
			;variable naming
(slib:load (in-vicinity (program-vicinity) "sexp"))
			;read-eval-print loop.  Conversion from
			;sexpression to internal form and back.
(slib:load (in-vicinity (program-vicinity) "poly"))
			;Routines which operate on internal data type POLY.
(slib:load (in-vicinity (program-vicinity) "elim"))
			;Routines which eliminate variables.
(slib:load (in-vicinity (program-vicinity) "vect"))
			;Routines which operate on lists of POLY (mtrx).
(slib:load (in-vicinity (program-vicinity) "norm"))
			;Differentials, finite differentials,
			;factoring, and logical operations.
(slib:load (in-vicinity (program-vicinity) "builtin"))
			;Routines defined for sexpressions.
(define (info:describe obj)		;autoload for info
  (slib:load (in-vicinity jacal-vicinity "info"))
  (info:describe obj))
(define (info:example obj)		;autoload for info
  (slib:load (in-vicinity jacal-vicinity "info"))
  (info:example obj))
(define (definfo . args)		;autoload for info
  (slib:load (in-vicinity jacal-vicinity "info"))
  (apply definfo args))
(slib:load (in-vicinity (program-vicinity) "ext"))
			;Field extension creation and simplification.
(slib:load (in-vicinity (program-vicinity) "parse"))
			;General parser
(slib:load (in-vicinity (program-vicinity) "unparse"))
			;infix printer.
;;; These routines test the core mathematical routines;
;;; Beware if they produce warnings or errors.
(poly:test)		;Test for routines in "poly"
(elim:test)		;Test for routines in "bunch"
;(factor:test)
;(mtrx:test)

(newline)
(display "JACAL version ") (display *jacal-version*)
(display ", Copyright 1989, 1990, 1991, 1992, 1993 Aubrey Jaffer
JACAL comes with ABSOLUTELY NO WARRANTY; for details type `(terms)'.
This is free software, and you are welcome to redistribute it
under certain conditions; type `(terms)' for details.
")
(display ";;; Type (math) to begin.")
(newline)
(force-output)
