.TH libtext 3I "12 August 1988" "InterViews" "InterViews Reference Manual"
.SH NAME
libtext \- InterViews text library
.SH SYNOPSIS
.B #include <InterViews/Text/\fIclass\fP.h>
.br
.B "CC ... \-ltext \-lInterViews \-lX \-lm"
.SH DESCRIPTION
The InterViews \fIlibtext\fP library
provides support for both structured and unstructured textual
interfaces.
\fIText\fP is the base class for structured text objects; predefined
subclasses include simple text objects (\fBWord\fP, \fBWhitespace\fP,
\fBLinebreak\fP), and composite objects (\fBSentence\fP,
\fBTextList\fP, \fBParagraph\fP, \fBDisplay\fP).  Composite structured
text objects arrange their components to take best advantage of
available screen space.  \fITextBlock\fP is an Interactor that
displays a structured text object.  A \fILayout\fP defines a chain of
TextBlocks into which a structured text object is composed.  Layouts
can be used to define multiple column and multiple page documents.
.PP
Unstructured text support is provided by the \fIStringEdit\fP and
\fITextViewer\fP classes.  A StringEdit object is an Interactor that
displays a single line of editable text; it is suitable for
incorporation into interface components, such as dialog boxes, which
require a small amount of textual input.  A TextViewer object displays
an array of lines of text and supports horizontal and vertical
scrolling.  Functions to insert and delete text are provided.  Styling
options include boldface, underlining, and inverted colors.
.SH SEE ALSO
libInterViews(3I)
