.TH TextViewer 3I "11 December 1987" "InterViews" "InterViews Reference Manual"
.SH NAME
TextViewer \- array of text lines
.SH SYNOPSIS
.B #include <InterViews/Text/textviewer.h>
.SH DESCRIPTION
A TextViewer is an interactor that manages an arbitrarily large array of
lines of text, each line being of arbitrary length.  TextViewer uses a
\fIperspective\fP to implement scrolling in both x and y directions.  The
amount of the text array that will be visible is a function of size of the
TextViewer's canvas and the font used.  TextViewer can use either a fixed
width or a proportionally spaced font.
.P
TextViewer maintains two markers in the text: \fIcaret\fP is the `text
cursor', usually corresponding to the current user `focus', and \fIdot\fP is
the point at which characters are inserted and deleted.  TextViewer
coordinates are character positions, with the upper left corner of the
text buffer corresponding to row one, column one.
.SH PUBLIC DATA
.TP
.B "StyleSet style"
The set of style flags to apply to subsequently drawn text.  Styles can be
added to and removed from a StyleSet object.  Styles defined include
\fIHighlighted\fP, \fIReversed\fP, \fIBold\fP and \fIUnderlined\fP.  The
default value is no styling.
.TP
.B "CaretStyle caretstyle"
The visual appearance of the symbol that marks the location of \fIcaret\fP.
Available styles include \fINone\fP, \fIBar\fP, \fIBlock\fP,
\fIOutline\fP, and \fIUnderline\fP.  The default is None.
.TP
.B "boolean overwrite"
If \fIoverwrite\fP is true (the default), characters added to the
TextViewer will replace
existing text.  If false, existing text will be moved to the right to make
room.
.TP
.B "boolean buffer"
If \fIbuffer\fP is true (the default), the TextViewer will not display
new text until a \fIFlush()\fP operation is performed or the TextViewer is
redrawn.  If false, new characters appear immediately.
.TP
.B "boolean viewcaret"
If \fIviewcaret\fP is true (the default), the TextViewer will automatically
scroll itself so that \fIcaret\fP is always visible.
.SH PUBLIC OPERATIONS
.TP
.B "TextViewer(Painter* = stdpaint, int cols = 80, int rows = 24)"
Create a new TextViewer, optionally specifying the default size of the array
and the painter.  The font is taken from the painter.  A TextViewer's shape
is infinitely stretchable and shrinkable.
.TP
.B "Caret()"
.ns
.TP
.B "Caret(Coord row, Coord col)"
.ns
.TP
.B "NoCaret()"
Set the position of \fIcaret\fP to (\fIrow\fP, \fIcol\fP) or to \fIdot\fP,
or turn it off.  Note that turning the caret off is not the same as
setting \fIcaretstyle\fP to None.
.TP
.B "View()"
.ns
.TP
.B "View(Coord row, Coord col)"
Scroll so that (\fIrow\fP, \fIcol\fP) or \fIdot\fP is as near to the
centre of the screen as possible.
.TP
.B "GoTo(Coord row, Coord col)"
.ns
.TP
.B "GetPos(Coord& row, Coord& col)"
Set or get the position of \fIdot\fP.
.TP
.B "Margin(int margin)"
.ns
.TP
.B "Indent(int count)"
Set the current margin or adjust it by \fIcount\fP (either positive or
negative).  Subsequent NewLine calls will insert spaces (unstyled) at the
left of the buffer, according to the new margin.
.TP
.B "Insert(int rows, int cols)"
Insert or delete an area before \fIdot\fP, which will be adjusted so
that it stays just following the affected area.  Inserted lines will be
empty and space characters will be added as needed to satisfy the column
requirements.  Deleted text is lost.  TextViewer tries to optimize screen
redrawing caused by Insert.
.TP
.B "String(const char*)"
.ns
.TP
.B "String(const char*, int)"
.ns
.TP
.B "Spaces(int count)"
Insert a string, a substring or \fIcount\fP space characters at dot,
which will be moved to follow the insertion.  If
\fIoverwrite\fP is true the new text will replace any existing characters.
It is is false, existing text will be moved to the right to accommodate the
new text.  The line can grow arbitrarily long.
.TP
.B "Tab(int spacing)"
Insert space characters up to the next multiple of \fIspacing\fP.
.TP
.B "NewLine()"
Move \fIdot\fP to the beginning of the next line.  If \fIoverwrite\fP is
true, a new blank line will be created, and any text following \fIdot\fP
on the current line will be moved to the new line.  If \fIoverwrite\fP is
false, the current line will be truncated to \fIdot\fP.
.TP
.B "Rubout(int count)"
Remove up to \fIcount\fP characters before \fIdot\fP.  Rubout will not pass
the beginning of the line.
.TP
.B "EndLine()"
.ns
.TP
.B "EndText()"
Delete any text following dot on the current line or in the whole buffer.
.TP
.B "Flush()"
Redraw the parts of the screen that were affected by previous text
modifications made while \fIbuffer\fP was true.
