.TH Transformer 3I "15 June 1987" "InterViews" "InterViews Reference Manual"
.SH NAME
Transformer \- transformation matrix for Painter
.SH SYNOPSIS
.B #include <InterViews/transformer.h>
.SH DESCRIPTION
A transformer object is a transformation matrix for use
in translating coordinates.
Most users will not need to access a transformer directly;
the \fIPainter\fP(3I) operations will be sufficient.
.SH PUBLIC OPERATIONS
.TP
.B "Transformer(Transformer* = nil)"
Create a copy of the given transformer.  The identity transformer
is returned by default.
.TP
.B "Transformer(float a00, float a01, float a10, float a11, float a20, float a21)"
Create a matrix with the given values.
.TP
.B "void GetEntries(float& a00, float& a01, float& a10, float& a11, float& a20, float& a21)"
Get the transformer's matrix entries.
.TP
.B "void Rotate(float angle)"
Modify the matrix to rotate coordinates by \fIangle\fP degrees.
.TP
.B "boolean Rotated()"
.ns
.TP
.B "boolean Rotated90()"
Rotated returns \fItrue\fP if
coordinates would be rotated when transformed.
Rotated90 returns \fItrue\fP only if the angle of rotation is 90 degrees.
.TP
.B "void Scale(float sx, float sy)"
Modify the matrix to multiply coordinates by \fIsx\fP and \fIsy\fP.
.TP
.B "boolean Scaled()"
.ns
.TP
.B "boolean Stretched()"
Scaled returns \fItrue\fP if coordinates are scaled when transformed.
Stretched returns \fItrue\fP if the scaling is not the same
in both dimensions.
.TP
.B "void Translate(float dx, float dy)"
Add (\fIdx\fP,\ \fIdy\fP) to coordinates after multiplying by the matrix.
.TP
.B "boolean Translated()"
Return \fItrue\fP if coordinates are translated when transformed.
.TP
.B "void Transform(Coord& x, Coord& y)"
.ns
.TP
.B "void Transform(Coord x, Coord y, Coord& tx, Coord& ty)"
.ns
.TP
.B "void Transform(float x, float y, float& tx, float& ty)"
.ns
.TP
.B "void TransformList(Coord x[], Coord y[], int n)"
.ns
.TP
.B "void TransformList(Coord x[], Coord y[], int n, Coord tx[], Coord ty[])"
Transform a point or set of points using the transformer's matrix.
.TP
.B "void InvTransform(Coord& tx, Coord& ty)"
.ns
.TP
.B "void InvTransform(Coord tx, Coord ty, Coord& x, Coord& y)"
.ns
.TP
.B "void InvTransform(float tx, float ty, float& x, float& y)"
.ns
.TP
.B "void InvTransformList(Coord tx[], Coord ty[], int n)"
.ns
.TP
.B "void InvTransformList(Coord tx[], Coord ty[], int n, Coord x[], Coord y[])"
Perform a reverse transformation on a point or set of points.
.TP
.B "void Premultiply(Transformer*)"
.ns
.TP
.B "void Postmultiply(Transformer*)"
Multiply in place the transformer's matrix by the given transformer's matrix.
.SH "SEE ALSO"
Painter(2I)
