.TH StringTable 3I "15 August 1988" "InterViews" "InterViews Reference Manual"
.SH NAME
StringTable \- map strings to unique pointers
.SH SYNOPSIS
.B #include <InterViews/strtable.h>
.SH DESCRIPTION
A string table is an index for character strings.
The table maps strings or substrings to a unique pointer
to type \fBStringId\fP.
The table guarantees that the same string will always be mapped
to the same pointer;
thus, one can quickly compare if two strings are equal
by comparing their precomputed pointers.
String tables use a static StringPool(3I) to manage
the storage of the characters.
.SH PUBLIC OPERATIONS
.TP
.B "StringTable(int size)"
Construct a string table of the given size.
The size will be rounded up to the next power of two
so that indexing the table does not require division
(just take the bitwise-and of the string's hash value and (size-1)).
.TP
.B "~StringTable()"
Free storage associated with the string table.
.TP
.B "StringId* Id(const char*)"
.ns
.TP
.B "StringId* Id(const char*, int)"
Convert a string (null-terminated) or substring (explicit length)
to a StringId.
If the string cannot be found, it will be entered into the table.
In any event, the pointer to the string table entry for the string
is returned.
.TP
.B "void Remove(const char*)"
.ns
.TP
.B "void Remove(const char*, int)"
Delete a string from the table.
This operation will not release any character storage,
only the storage associated with table entry.
.TP
.B "const char* StringId::Str()"
Return the string associated with a StringId.
.SH SEE ALSO
StringPool(3I)
