.TH Raster 3I "24 April 1989" "InterViews" "InterViews Reference Manual"
.SH NAME
Raster \- simple rasterized image data
.SH SYNOPSIS
.B #include <InterViews/raster.h>
.SH DESCRIPTION
A \fIRaster\fP is a two\-dimensional array of Colors that can be
rendered by a Painter.  Rasters can be constructed from data supplied
by the application program or from a region of a Canvas.  The only
operations currently defined on rasters are for accessing individual
raster cells.
.SH PUBLIC OPERATIONS
.TP
.B "Raster(Color** data, int width, int height)"
Create a raster from the data specified.  The data is formatted as a
two\-dimensional matrix of pointers to Colors, organized in row\-major
order.  The data is transferred into an internal format, so subsequent
changes in either the passed data or the raster will not affect the
other.  Passing nil to \fIdata\fP is equivalent to passing an array
with all cells containing a pointer to the predefined Color
\fIwhite\fP.
.TP
.B "Raster(Canvas*, Coord x0, Coord y0, int width, int height)"
Create a raster from the current contents of the Canvas.  The
coordinates \fIx0\fP and \fIy0\fP specify the lower left corner of the
region of the Canvas to use.
.TP
.B "Raster(Raster*)"
Create a copy of the given raster.
.TP
.B "int Width()"
.ns
.TP
.B "int Height()"
These operations return the size of the raster.
.TP
.B "Color* Peek(int x, int y)"
.ns
.TP
.B "void Poke(Color*, int x, int y)"
.ns
.TP
.B "boolean Contains(int x, int y)"
Operations for reading and writing individual cells in the raster.  If
the specified coordinates are not within the raster bounds,
\fIContains\fP returns false, \fIPeek\fP returns nil, and \fIPoke\fP
has no effect.
.SH "SEE ALSO"
Painter(3I), Transformer(3I)
