.TH ObjectStub 3I "29 May 1989" "InterViews" "InterViews Reference Manual"
.SH NAME
ObjectStub \- unpack remote messages
.SH SYNOPSIS
.B #include <InterViews/stub.h>
.SH DESCRIPTION
An object stub interprets byte stream messages by unpacking
parameters and calling the appropriate operation on another object.
Because object stubs are accessed by remote object spaces,
reference counts are used to determine when they can be deallocated.
.SH PUBLIC OPERATIONS
.TP
.B "ObjectStub()"
.ns
.TP
.B "~ObjectStub()"
When an object stub is created, its reference count is set to one.
When the stub is deleted, its reference count is decremented and
it is only destroyed if the count reaches zero.
.TP
.B "void Reference()"
Increment the reference count.
.TP
.B "boolean LastRef()"
Return true if the reference count is currently one.
.TP
.B "virtual void Message(Connection*, ObjectTag, int op, void*, int len)"
Handle a message for the object that the stub represents.
The message contains a connection that specifies the sender,
a tag that is usually the stub itself,
an opcode that is the method selector, and a varying-length
array of bytes.
The default Message operation does nothing.
.TP
.B "virtual void ChannelReady(int channel)"
Handle data that is pending on the given channel.
The channel is uninterpreted by the object space,
so the stub must read and interpret the data.
.TP
.B "virtual ObjectStub* Clone()"
Create a copy of the object represented by the stub.
Remote clients create a new instance by first finding
a prototype by name and then copying the object using Clone.
.SH "SEE ALSO"
ObjectSpace(3i)
