.TH Frame 3I "15 June 1987" "InterViews" "InterViews Reference Manual"
.SH NAME
Frame, TitleFrame, BorderFrame, ShadowFrame \- surrounding interactor
.SH SYNOPSIS
.B #include <InterViews/frame.h>
.SH DESCRIPTION
A frame is a monoscene subclass that outlines another interactor.
A title frame provides a banner in addition to the outline and
highlights the banner when the frame contains the input focus.
A border frame draws the outline using a solid pattern when
it contains the input focus and
using a gray pattern otherwise.
A shadow frame draws an outline with a drop shadow.
.SH PUBLIC OPERATIONS
.TP
.B "Frame(Interactor*, int width = 1)"
Construct a frame.
If the given interactor is not nil, it is inserted as the frame's component.
The frame extends \fIwidth\fP pixels outside of the interactor.
.TP
.B "TitleFrame(Banner*, Interactor*, int width = 1)"
Construct a title frame with the given banner.
.TP
.B "BorderFrame(Interactor*, int width = 1)"
Construct a border frame.
.TP
.B "ShadowFrame(Interactor*, int h = 1, int v = 1)"
Construct a shadow frame.
The \fIh\fP and \fIv\fP ShadowFrame parameters specify the width of the
horizontal and vertical shadows, respectively.  Positive values for these
parameters specify shadows falling to the right and below the interactor,
respectively; negative values specify shadows falling to the left and above.
.TP
.B "virtual void HandleInput(Event&)"
A frame listens for OnEvent and OffEvent to detect when it has input focus.
When an OnEvent is received, Frame::Handle calls Highlight(true);
when an OffEvent is received, it calls Highlight(false).
For any other event, it calls HandleInput.
Frame::HandleInput does nothing.
.TP
.B "virtual void Highlight(boolean)"
The base class Highlight operation does nothing.
.SH PROTECTED OPERATIONS
.TP
.B "Frame(Interactor*, int, int, int, int)"
This constructor is used by subclasses to explicitly set the widths 
of each line in the outline.  The integers specify the width of the
left, bottom, right, and top lines, respectively.
.SH SEE ALSO
Banner(3I), Event(3I), Scene(3I)
