.TH Cursor 3I "15 June 1987" "InterViews" "InterViews Reference Manual"
.SH NAME
Cursor \- pointing device image
.SH SYNOPSIS
.B #include <InterViews/cursor.h>
.SH DESCRIPTION
A cursor specifies the image that tracks a pointing device's position.
Cursors are defined by two bitmaps and a ``hot spot''.  A mask bitmap
specifies which pixels are to be drawn, and a pattern bitmap specifies
which pixels are in foreground color and which in background color.
The hot spot specifies the location of the pointing device relative to
the cursor's lower-left corner.
A number of common cursors are predefined and can be
referenced by global variables declared in the include file.
These include ``arrow'' (pointing to upper left),
``ltextcursor'' (an `I' text cursor with hot spot on the left),
``rtextcursor'' (hot spot on the right),
``lowerleft'' (an `L'),
``lowerright'' (mirrored `L'),
``upperleft'' (upside-down `L'),
``upperright'' (upside-down and mirrored `L'),
``crosshairs'', and ``hourglass''.
.PP
.SH PUBLIC OPERATIONS
.TP
.B "typedef int CursorPattern[cursorHeight];"
.TP
.B "Cursor(short x, short y, CursorPattern pat, CursorPattern mask, Color* f, Color* b)"
Create a cursor with the given data and a hot spot at (\fIx\fP,\ \fIy\fP).
Ones in \fIpat\fP specify
pixels which should be displayed in the foreground color \fIf\fP and
zeros specify pixels which should be in the background color \fIb\fP.
Ones in \fImask\fP specify which pixels should be visible.
The first pattern element defines the topmost row of pixels, and the least
significant bit of each element defines the rightmost column.
.TP
.B "Cursor(Bitmap* pat, Bitmap* mask, Color* f, Color* b)"
Create a cursor from the given bitmaps.  The hot spot is set to the
origin of the \fIpat\fP bitmap.
.TP
.B "Cursor(Font*, int pat, int mask, Color* f, Color* b)"
Create a cursor from font glyphs.  \fIPat\fP and \fImask\fP are the
font characters to use as the pattern and mask bitmaps, respectively.
The hot spot is set to the character origin.
.TP
.B "Cursor(int id, Color* f, Color* b)"
Create a ``standard'' cursor using a window system specific
identifier.  Particular values of \fIid\fP are usually defined in an
include file.  For example, standard X11 cursors are defined in the
file <X11/cursorfont.h>.
