.TH Color 3I "15 June 1987" "InterViews" "InterViews Reference Manual"
.SH NAME
Color \- colors for a painter
.SH SYNOPSIS
.B #include <InterViews/color.h>
.SH DESCRIPTION
A
.B Color
defines a mix of rgb (red, green, and blue) intensities.  The global
variables ``black'' and ``white'' point to predefined colors of zero
and full intensity output, respectively.  Note that the displayed
intensities of a color will depend on the characteristics of the
workstation.
.SH PUBLIC OPERATIONS
.TP
.B "Color(const char* name)"
Construct a color with intensities associated with \fIname\fP.
.TP
.B "Color(int red, int green, int blue)"
Construct a color with the specified red, green, and blue intensities.
Zero represents no intensity; 65535 represents full intensity.
.TP
.B "Color(int entry)"
Construct a color with intensities associated with a color map entry.
.TP
.B "void Intensities(int& red, int& green, int& blue)"
Get the intensities used to create the color.
.TP
.B "void DisplayIntensities(int& red, int& green, int& blue)"
Get the intensities used to display the color.
.TP
.B "int PixelValue()"
Return the color's index in its color map.
.TP
.B "boolean Valid()"
Return whether the color is meaningful.
This call can be used after Color(name)
to see if the name is recognized as a color.
.SH SEE ALSO
Painter(3I)
