.TH squares 1 "16 August 1988" "InterViews" "InterViews Reference Manual"
.SH NAME
squares \- InterViews demo program
.SH SYNOPSIS
\fBsquares\fP
.SH DESCRIPTION
\fISquares\fP is a simple program that demonstrates many of the
features of InterViews.  Running this program will give you a feel for
the capabilities of InterViews and for the default styles of
interactive objects.  Studying the \fIsquares\fP source code can help
explain some of the specific details of the InterViews classes.
.PP
Initially, \fIsquares\fP creates a single view of a list of squares.
The \fBbanner\fP at the top of the view displays information about the
version of the program.  The view is surrounded by a \fBborder
frame\fP, which indicates whether or not the program is the focus of
user input.  The border is drawn with a solid pattern if \fIsquares\fP
has input focus; otherwise a stippled pattern is used.
.PP
The squares view is contained in a \fBviewport\fP, which controls what
part of the view is visible.  Resizing the squares window will make
more or less of the squares view visible.  The viewport paints regions
outside the view's boundaries with a stippled pattern.  \fISquares\fP
provides several ways to perform operations on the viewport to adjust
the visible part of the view.  Pressing the right mouse button pops up
a \fBmenu\fP that can be used to zoom in or out on the view, to
restore it to normal size, or to center it within the viewport.  The
initial squares view also contains a pair of \fBscrollers\fP that can
be used to adjust the view if it is not completely visible.
.PP
Pressing the middle mouse button pops up the \fIsquares\fP command
menu.  Commands are provided to add a new square to the list, to
create a new squares view, to modify the appearance of the frame
around the view, to close a squares view, and to quit the program.
Note that closing the last squares view is equivalent to quitting.
Each squares view is a representation of the same list of squares; a
new square can be added through any view and will appear in all views.
However, modifying the appearance of one view or adjusting its
viewport will not affect the appearance of other views.
.PP
Selecting ``view\ setup'' from the command menu opens a ``meta-view''
for modifying the appearance of the squares view frame.  Several
characteristics of the interactive adjusters can be specified,
including their type (scrollers or panner), size (small, medium, or
large), and position in the view.  When the ``accept'' button is
pressed, the frame is reconstructed with the desired characteristics.
Pressing the ``cancel'' button leaves the frame unaltered.
.SH IMPLEMENTATION
The \fIsquares\fP implementation consists of a main program file
(``main.c'') and a pair of files for each of the four classes:
\fBsquares\fP, a list of varying size squares, \fBsquares view\fP, a
display of the squares, \fBsquares frame\fP, the frame around a view,
and \fBsquares meta view\fP, a dialog box for customizing a view's
frame.  Each class is defined in a header file (e.g., ``view.h''), and
the methods are implemented in a corresponding .c file (``view.c'').
.PP
The \fBsquares\fP class is derived from \fBsubject\fP.  A subject
contains a list of its views so that all the views can be updated when
the subject is modified.  When a new square is added, the subject
operation ``Notify'' is called to update the views.
.PP
The implementation of \fBsquares view\fP includes code to attach a new
view to the squares subject, to detach a view about to be deleted, and
to redraw the display of the squares.  When a new square is added, the
squares subject calls ``Update''.
.PP
\fBSquares frame\fP serves two purposes: it constructs the frame
around a squares view, including the banner and adjusters, and it
handles user input.  The appearance of the frame is determined by a
set of style parameters.  Modifications to the frame's appearance are
specified by altering style parameters (using the meta-view) and
rebuilding the frame.  A squares frame constructs the menus that are
used for user input.  It also creates the meta-view that provides
customization.
.PP
\fBSquares meta view\fP encapsulates the style parameters that specify
the appearance of a squares frame.  It is implemented as a dialog
containing a set of \fBbuttons\fP that allow the user to interactively
modify the style.  The buttons are composed with \fBboxes\fP and
\fBglue\fP so that the dialog maintains a pleasant appearance for a
range of sizes.  To see the glue stretch or shrink, try resizing the
dialog.
.PP
The main program creates a squares object and a frame (which contains
a view) and inserts the frame into the world.  It then calls ``Run'',
which simply reads and distributes events in an infinite loop.
.SH SEE ALSO
Banner(3I), Button(3I), Box(3I), Frame(3I), Glue(3I), Menu(3I),
Panner(3I), Scene(2I), Scroller(3I), World(3I)
