.TH INCLINK 1A "Dec 12 1988" "Allegro" "Allegro Reference Manual"

.SH NAME
klink, relink, tinclink \- incremental linker package

.SH SYNOPSIS
.B klink
[outfile]
.HP

.B relink
[-qsXxv] [-tinclink] [-o outfile] obj.o [obj.o ...] [-llib ...]
.HP

.B tinclink
[-v] [-o outfile] obj.o [obj.o ...]

.SH DESCRIPTION
.PN Inclink
provides functionality similar to the UNIX C program loader
.PN ld.
It combines several object programs into one,
resolves external references, and searches libraries.
.PP
The argument routines are linked together in the order specified.
The entry point of the output is the beginning of the first routine.

If the argument is a library, it is searched only once at the point
it is encountered in the argument list.
Only those routines defining an unresolved external reference are loaded.
.PP
.PN Inclink
differs from
.PN ld
in that after the initial pass,
subsequent links are done incrementally.
Upon the initial link
.PN inclink
creates a server for the executable.
All subsequent calls to
.PN inclink
for the same executable
are serviced by this server.

.SH INCLINK OVERVIEW
To run
.PN inclink
the allegro object space manager
.PN spaceman
needs to be running on your system.

Each program maintained by
.PN inclink
is associated with the full path name of an executable.
There is one
.PN inclink
server per executable file name.
.PP
Communication with the
.PN inclink
server is done using the client programs
.PN klink,
.PN relink
and
optionally
.PN tinclink.
These commands should be issued within the directory that
the target executable is residing.

.PP
.PN Relink
asks
.PN inclink
to link the files in the specified order into the executable.

.PN Klink
terminates an
.PN inclink
server.

.PP
By default,
.PN inclink
checks the update time of each object file and rereads only those
files that have changed.
However, in a network file system, these checks can become noticeable.
The
.PN -tinclink
option is provided in these situations to turn off the automatic
checks and rely on the user to inform
.PN inclink
of file changes using
.PN tinclink.
Library archives are checked for updates regardless of the
.PN -tinclink
option.

.SH "INCLINK AND CC"
The
.PN CC
command is modified at Stanford to use
.PN inclink
automatically when the environment variable
.PN linkerC
is set to
.PN "inclink".
In this case,
.PN klink
is the only
.PN inclink
command invoked directly by the user.

With
.PN linkerC
unset,
.PN CC
uses the default linker
.PN ld.


.SH OPTIONS
.PN Inclink
supports a subset of the options supported by
.PN ld
plus the two special
.PN inclink
options
.B -q
and
.B -v.
.TP
\fB\-l\fIx\fP
This option is an abbreviation for the library name `/lib/lib\fIx\fP.a',
where \fIx\fP is a string.
If that does not exist,
.PN inclink
tries `/usr/lib/lib\fIx\fP.a'.
If that does not exist,
.PN inclink
tries `/usr/local/lib/lib\fIx\fP.a'.
A library is searched when its name is
encountered, so the placement of a -l is significant.
The -l option should normally appear after the file names.
.TP
\fB\-o\fP \fIfile\fP
Use
.I file
as the
.PN inclink
output file, instead of a.out.
.TP
.B \-q
Quiet flag.  Less information is printed.
.TP
.B \-s
Removes the symbol table and relocation bits to save space
(this impairs the usefulness of the debuggers).
This information can also be removed by
.PN strip
(1).
.TP
.B \-tinclink
Informs
.PN inclink
not to use the object file update time for rereading files.
Instead, the user invokes rereads for user-defined files with the
.PN tinclink
command.  (Library archives are checked for updates regardless of
this option.)
.TP
.B \-X
Save local symbols except for those whose names begin with `L'
(labels generated by
.PN cc
(1)).
.TP
.B \-x
Discards local (non-global) symbols in the output symbol table;
only enters external symbols.  This option saves some space in the
output file.
.TP
.B \-v
Verbose flag.  Print more information.
.P

.SH EXAMPLES
The following is a makefile for `prog' using
.PN inclink.
.RS
.HP
.PD 0
.nf
prog: a.o b.o
relink \-X \-tinclink a.o b.o \-lc \-o prog
.HP
a.o: a.c
cc \-c a.c
tinclink a.o \-o prog
.HP
b.o: b.c
cc \-c y.c
tinclink y.o \-o prog
.fi
.RE
.PD
.PP

With the following makefile:
.RS
.HP
.PD 0
.nf
prog: a.o b.o
CC \-X a.o b.o \-o prog
.HP
a.o: a.c
CC \-c a.c
.HP
b.o: b.c
CC \-c b.c
.fi
.RE
.PD
.PP
using the Stanford-modified
.PN CC
command, just type
.RS
.HP
.PD 0
.nf
setenv linkerC inclink
.HP
make
.fi
.RE
.PD
.PP
to compile and link `prog'.

To revert to the default linker
.PN ld,
simply kill the
.PN inclink
server and unset the environment variable:
.RS
.HP
.PD 0
.nf
klink prog
.HP
unsetenv linkerC
.fi
.RE
.PD
.PP

.SH RESTRICTIONS
If the executable is removed while the server is still running,
a full rewrite instead of incremental write
(writing only the parts that have
been updated) will be performed on the subsequent link.

Flags affecting the symbol table (-s, -X, -s) cannot be modified
without restarting the inclink server.

.PN Inclink
currently only works with programs written for VAX machines.

All library modules need to be processed by
.PN ranlib.

Not all
.PN ld
options are supported.

.SH FILES
.ta \w'/usr/local/lib/lib*.a\ \ 'u
/lib/lib*.a		libraries
.br
/usr/lib/lib*.a		more libraries
.br
/usr/local/lib/lib*.a	still more libraries
.br
a.out			output file

.SH "SEE ALSO"
ld(1), as(1), cc(1), CC(1), ranlib(1), make(1)
