.TH genclass 1 "29 May 1989" "InterViews" "InterViews Reference Manual"
.SH NAME
genclass \- generate a class from a template
.SH SYNOPSIS
\fBgenclass\fP \fItemplate\fP \fIdest\fP \fIparam\fP=\fIvalue\fP ...
.SH DESCRIPTION
\fIGenclass\fP copies the file \fItemplate\fP to the file \fIdest\fP
substituting occurrences of \\\fIparam\fP with the associated \fIvalue\fP.
Any number of parameter-value pairs may be specified.
If several parameters have the same prefix, \fIgenclass\fP will substitute
for the one with the longest name.
.PP
\fIGenclass\fP is useful for generating an instance of
a parameterized C++ class.
For example, InterViews contains a hash table class defined as:
.sp 1
.nf
.in +4n
/*
 * Object association table.
 */

#ifndef \\Table_h
#define \\Table_h

#include <InterViews/defs.h>

class \\TableEntry;

class \\Table {
public:
    \\Table(int);
    ~\\Table();
    void Insert(\\TableKey, \\TableValue);
    boolean Find(\\TableValue&, \\TableKey);
    void Remove(\\TableKey);
private:
    int size;
    \\TableEntry** first;
    \\TableEntry** last;

    \\TableEntry* Probe(\\TableKey);
    \\TableEntry** ProbeAddr(\\TableKey);
};

#endif
.fi
.in -4n
.PP
To generate a hash table where the key is a \fBvoid*\fP and
the value is an \fBInteractor*\fP in the file \fIitable.h\fP,
one could use
.sp 1
.nf
.in +4n
genclass gentable.h itable.h \\
    Table=InteractorTable TableKey="void*" \\
    TableValue="class Interactor*"
.in -4n
.fi
.sp 1
The include directory <InterViews/Templates> contains
a set of useful template files.
.SH BUGS
The template files syntax should match the one proposed for C++,
but that won't help for substituting for the header name.
