.TH dclock 1 "27 April 1987" "InterViews" "InterViews Reference Manual"
.SH NAME
dclock \- digital clock
.SH SYNOPSIS
\fBdclock\fP [ \fB\-cmjd\fP ] [ \fBsize=\fP\fIx,y\fP ]
[ \fBpos=\fP\fIx,y\fP ]
[ \fB\-s\fP\fIslant\fP ] [ \fB\-t\fP\fIthickness\fP ]
[ \fB\-f\fP\fIrate\fP ]
.SH DESCRIPTION
\fIDclock\fP displays a scalable digital clock.
The time is updated from the local host clock every minute as a background
process.  The current date is displayed across the top of the window
in the format
.TP 8
\
Sat Aug 16 1986
.PP
(or some subset of such if there's not enough room).
Options to control the clock's appearance,
size and placement are as follows:
.TP 16
\fB\-c\fP 
Display in 12-hour format (\*(lq\fIc\fPivilian\*(rq time) \(em the
default.
.TP
\fB\-m\fP
Display in 24-hour format (\*(lq\fIm\fPilitary\*(rq time).
.TP
\fB\-j\fP
\*(lq\fIJ\fPohn's flag.\*(rq  Puts a tail on the digit `9'.
.TP
\fB\-d\fP
Do \fInot\fP display the current \fId\fPate across the top of the
clock view.
.TP
\fB\-b\fP
Display a \fIb\fPorder (horizontal line) between the date string and the
time display.
.TP
\fB\-T\fP
Do \fInot\fP display the \fIT\fPime in the clock view (leaving just the date).
.TP
\fB\-s\fP\fIslant\fP
Set the \fIslant\fP of the digits.  A \fIslant\fP of 100 (the maximum)
corresponds to a slant of one digit width.  A \fIslant\fP of 0 (the
minimum) is vertical.  Default is \fB\-s30\fP.  A special form is
\fB\-s\fP, which is equivalent to \fB\-s0\fP.
.TP
\fB\-t\fP\fIthickness\fP
Set the \fIthickness\fP of the digit segments.  Allowable values are
between 5 and 25.  A \fIthickness\fP of 25 results in segments which
are one quarter (25%) of the digit width. Default is \fB\-t15\fP.
.TP
\fB\-f\fP\fIrate\fP
Set the \fIrate\fP at which the segments fade when the time changes.
A value of 0 is fastest and 4 is slowest.  Default is \fB\-f4\fP.  A
special form is \fB\-f\fP, which is equivalent to \fB\-f0\fP.
.TP
\fBsize=\fP\fIx,y\fP
Set the width of \fIdclock\fP to \fIx\fP pixels and the height
to \fIy\fP pixels.
.TP
\fBpos=\fP\fIx,y\fP
Set the position of the top left corner of \fIdclock\fP to
(\fIx,y\fP), where (0,0) is the bottom left of the screen.
.PP
To exit \fIdclock\fP, type a `q' in the window.
