//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that member and base classes get properly destructed
// when an object of a derived class is destructed via a pointer
// to it which only has a "compile-time" type of "pointer-to-base".
//
// Note that in order for this test to work properly, the destructor
// for the base class should be explicitly declared to be virtual.

int member_destructor_calls = 0;
int middle_destructor_calls = 0;

struct member_type {
	int data_member;
	member_type () {}
	~member_type ();
};

struct base {
	int data_member;
	base () {}
	virtual ~base ();
};

struct middle : public base {
	member_type member1;
	member_type member2;
	middle () {}
	~middle ();		// should be implicitly virtual
};

struct derived : public middle {
	member_type member1;
	member_type member2;
	//~derived () {}
};

int main ()
{
	base* bp = new derived;
	delete bp;
	derived *dp = new derived;
	delete dp;
	return ((member_destructor_calls != 8) || (middle_destructor_calls != 2));
}

member_type::~member_type ()
{
	member_destructor_calls++;
}

base::~base ()
{
}

middle::~middle ()
{
	middle_destructor_calls++;
}
