//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that sub-word sized structs/classes are passed correctly
// if the struct/class has a constructor (i.e. ANY constructor).

struct base {
	int f1 : 8;
	int f2 : 8;

	base (int ii)
	{
	}
};

base global_base (7);

int test2 (base formal_base);

int main ()
{
	global_base.f1 = 0x55;
	global_base.f2 = 0xee;
	return test2 (global_base);
}

int test2 (base formal_base)
{
	if (formal_base.f1 != global_base.f1)
		return -1;
	if (formal_base.f2 != global_base.f2)
		return -1;
	return 0;
}
