//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that it is illegal to declare unary operators with
// less than one formal argument.  Note that type conversion
// operators, the operator(), and the operator-> are not
// tested here because they can only be class members, and
// thus, they always get one (implicit) parameter.

typedef unsigned long size_t;

struct base {
	int member;
};

// Unary +
int operator + ();		// ERROR

// unary -
int operator - ();		// ERROR

// unary & (i.e. address of)
int operator & ();		// ERROR

// unary * (i.e. dereference)
int operator * ();		// ERROR

int operator ~ ();		// ERROR

int operator ! ();		// ERROR

int operator ++ ();		// ERROR

int operator -- ();		// ERROR

void* operator new ();		// ERROR - needs a size_t

void operator delete ();	// ERROR
