//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that it is illegal to declare two overloaded functions or
// methods which differ only in that one argument is of a given type
// in one of the declarations while the same argument is a reference
// to the given type in the other declaration.
//
// Note that this *must* be illegal, because otherwise all calls to
// such overloaded functions/methods will be ambiguous.
//
// The presence of the constructor declaration for base causes G++ 1.34.1
// to segfault.

overload function;

void function (int i, int j, int k);

void function (int i, int& j, int k);	// ERROR: illegal overloading

class base {
	int member;
public:
	base ();
	void method (int i, base* j, int k);
	void method (int i, base*& j, int k);	// ERROR: illegal overloading
};

base* bp;

void test ()
{
	base base_object;

	base_object.method (7, bp, 9);		// possible error
}
