//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that that it is an error to declare a variable within a given
// scope and then to redeclare that variable within the same scope.
// Check that this is true whether or not the latter declaration has
// the same type.
//
// Also check that it is an error to try to overload a class data member
// as a class function member (or vise versa) within a given class.
//
// Cases:
//	global
//	within a function
//	within a method
//	within a struct
//	within a class
//	across visibility sections of a single class

int global_var;
int global_var;				// ERROR
float global_var;			// ERROR

struct structure {
	int field;
	int field;			// ERROR
	float field;			// ERROR
};

class base {
	int base_member_1;
	int base_member_1;		// ERROR
	float base_member_1;		// ERROR
	int base_member_2;
	int base_member_3;
	int base_member_4;
	int base_member_5 ();
	int base_member_6;
	int base_member_7 ();
public:
	int base_member_6;		// ERROR
	int base_member_7;		// ERROR - data member can't be overloaded
	base ();
};

class derived : private base {
	int base_member_2;		// OK - can overload inherited data members
	double base_member_3;		// OK - can even be a different type
	int base_member_4 ();		// OK
	int base_member_5;		// OK
public:
	derived ();
};

int test ()
{
	int local_var;
	int local_var;			// ERROR
	float local_var;		// ERROR

	local_var = 1;
	return 0;
}

base::base ()
{
	int local_var;
	int local_var;			// ERROR
	float local_var;		// ERROR

	local_var = 1;
}
