//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that a constant integer expression (which may include declared
// constant objects) can be used in contexts which require an integer
// constant expression.
//
// Cases:
//	array length specifications
//	bitfield length specifications
//	global object initializations

const int k2 = 2;
const int k4 = 4;
const int k8 = 8;

int global_var = k2+k4+k8;
const int global_const = k2+k4+k8;

char global_array[((k2+7)*k4)/(k8-1)];

struct base
{
	char member_array[((k2+7)*k4)/(k8-1)];
	unsigned int	bit_field_1:k2;
	unsigned int	bit_field_2:k2+k4;
	unsigned int	bit_field_3:7+k4;
	unsigned int	bit_field_4:7+(k4+k2);
	unsigned int	bit_field_5:(3+k4);
};

base global_base_object;

int main ()
{
	base local_base_object;
	char local_array[((k2+7)*k4)/(k8-1)];

	local_array[0] = 'x';
	local_base_object.bit_field_5 = 0x7f;
	return 0;
}
