//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that if a class has multiple constructors, and that if
// one constructor has some formal arguments and comes before
// another constructor which has no formal arguments, that the
// compiler doesn't issue errors for cases where the first call
// to a constructor has no actual arguments.

class base {
public:
	int i;
	base (int ii, int jj);
	base ();
};

int main ()
{
	base base_auto_object;
	base* base_object_ptr = new base;
	base_auto_object.i = 1;
	base_object_ptr->i = 1;
	return 0;
}

base base_static_object;

base::base ()
{
	i = 0;
}

base::base (int ii, int jj)
{
	i = ii + jj;
}
