/*****************************************************************************

	text.c

	This file contains FWF support code dealing with drawing text.

 *****************************************************************************/

#include <stdio.h>
#include <X11/Xatom.h>
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>

#include <Xfwf/SupportCode.h>

#define FontPad		1			/* Text Padding */
#define	FontAscent(f)	((f)->max_bounds.ascent)
#define	FontDescent(f)	((f)->max_bounds.descent)
#define	FontH(f)	(FontPad + FontAscent(f) + FontDescent(f) + FontPad)
#define	FontW(f,s)	XTextWidth(f,s,strlen(s))
#define	FontMaxCharW(f)	((f)->max_bounds.rbearing-(f)->min_bounds.lbearing+1)

/*---------------------------------------------------------------------------*

	void DrawJustifiedText(dpy,window,gc,font,justification,
		x,y,field_w,str)

	This routine draws the string <str> with the graphic context <gc>
	on the window <window>.  The <justification> parameter indicates what
	type of justification to do, XfwfJustifyLeft, XfwfJustifyCenter,
	or XfwfJustifyRight.

	Left justification draws the text proceeding to the right, with
	the upper left corner of the text placed at <x>,<y>. Right
	justification draws the text to the left, with the upper right
	corner at <x>,<y>.  Center justification draws the text centered
	between <x> and <x> + <field_w> - 1, with the top at <y>.
	Field width is only used for center justification.  The <font>
	parameter should match the font in the <gc> and is used to quickly
	obtained text extent information.

 *---------------------------------------------------------------------------*/

void DrawJustifiedText(dpy,window,gc,font,justification,x,y,field_w,str)
Display *dpy;
Window window;
GC gc;
XFontStruct *font;
int justification,x,y,field_w;
char *str;
{
	int txt_width,base_x,base_y;

	if (str == NULL) return;
	txt_width = FontW(font,str);
	base_y = y + FontPad + FontAscent(font);
	switch (justification)
	{
	    case XfwfJustifyLeft:
		base_x = x;
		break;
	    case XfwfJustifyRight:
		base_x = x - txt_width;
		break;
	    case XfwfJustifyCenter:
		base_x = x + (field_w - txt_width) / 2;
		break;
	    default:
		fprintf(stderr,"DrawJustifiedText: Bad Justification\n");
		return;
	}
	XDrawString(dpy,window,gc,base_x,base_y,str,strlen(str));
} /* End DrawJustifiedText */
