.\"remove .ig hn for full docs
.de hi
.ig eh
..
.de eh
..
.TH "" 3 "" "Version 3.0" "Free Widget Foundation"
.SH NAME
XfwfPullDown
.SH DESCRIPTION
A PullDown button looks like a normal button, but when it is clicked or
pressed, a menu drops down. The menu can be specified in two ways: as a
string or as a widget. If a string is given, it must be in the correct
syntax for the XfwfTextMenu widget and a widget will be created
automatically. If a widget is given instead, it must be a widget that is
able to pop up: in other words: a Shell widget or a subclass of Shell.

The most likely application of this widget is as a menu in a menu bar.  A
menu bar can be created, e.g., with a RowCol widget and a number of
PullDown buttons.

When the popup is passed in as a string in the \fImenu\fP resource, the widget
will call the \fIactivate\fP callback (see XfwfButton) when the user exits the
menu with a valid selection. It will also call the \fIchangeSelection\fP
callback (see below) when the user moves from one menu item to the next.
Neither of these callbacks will be called when the popup is passed in as a
ready-made widget in the \fIpopup\fP resource.

Note however, that the \fIcall_data\fP argument of the \fIactivate\fP callback will
contain the number of the selected item (0, 1, 2, etc.) and not the event,
as is the case in an XfwfButton widget.

.SS "Public variables"

.ps-2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfPullDown
Name	Class	Type	Default
XtNpopup	XtCPopup	Widget 	NULL 
XtNmenu	XtCMenu	String 	NULL 
XtNcascaded	XtCCascaded	Boolean 	False 
XtNhotkey	XtCHotkey	String 	NULL 
XtNmenuCursor	XtCMenuCursor	Cursor 	"arrow"
XtNprepare	XtCPrepare	Callback	NULL 
XtNchangeSelection	XtCChangeSelection	Callback	NULL 

.TE
.ps

.TP
.I "XtNpopup"
Two resources determine the menu. The \fIpopup\fP resource can be
pointed at the widget that should pop up when the button is pressed,
but when the \fIpopup\fP resource is NULL, the menu will be created
from the \fImenu\fP resource. If the \fIpopup\fP resource is set, it must
be set to a widget that is (a subclass of) a Shell widget.

	

.hi

.nf
Widget  popup = NULL 
.fi

.eh

.TP
.I "XtNmenu"
When \fIpopup\fP is \fINULL\fP, the widget will be created from the
textual description in \fImenu\fP. For the syntax of this string, see the
EzMenu(3).

	

.hi

.nf
String  menu = NULL 
.fi

.eh

.TP
.I "XtNcascaded"
When the button is part of a dialog or menu, that has already
caused a grab of the pointer, the resource \fIcascaded\fP should be
\fITrue\fP. If the button is inserted into an XfwfMenuBar, the resource is
set to \fITrue\fP automatically.

	

.hi

.nf
Boolean  cascaded = False 
.fi

.eh

.TP
.I "XtNhotkey"
The pull down button installs an event handler that catches all
keyboard events for the whole application and checks for a special key
combination. If that key is detected, the menu will be popped up.
Thus, the menu can be used even if the keyboard focus is somewhere
else. The \fIhotkey\fP resource is usually a string such as \fI"Alt<Key>a"\fP,
or \fI"Ctrl<Key>f"\fP.

When the \fIhotkey\fP resource is used, any \fIaccelerators\fP will be ignored.

	

.hi

.nf
String  hotkey = NULL 
.fi

.eh

.TP
.I "XtNmenuCursor"
The cursor shape that is used in the menu can be set with the
\fImenuCursor\fP resource. By default it is an arrow pointing to the upper
right.

	

.hi

.nf
Cursor  menuCursor = <String>"arrow"
.fi

.eh

.TP
.I "XtNprepare"
The \fIprepare\fP callback is invoked by the \fIprepare\fP action, normally just
before the menu is popped up.

	

.hi

.nf
<Callback> XtCallbackList  prepare = NULL 
.fi

.eh

.TP
.I "XtNchangeSelection"
When the user moves from one item to another in the menu that was created
from the \fImenu\fP resource, the \fIchangeSelection\fP callback is called, with
the number of the new selection as \fIcall_data\fP. This callback is called
even when the new selection is an inactive (grayed out) item. It is also
called when the mouse leaves the menu, in which case the argument will be
-1. This callback will notbe called when the menu is a ready-made widget,
passed in via the \fIpopup\fP resource.

	

.hi

.nf
<Callback> XtCallbackList  changeSelection = NULL 
.fi

.eh

.TP
.I "XtNframeWidth"
Since the most likely place for this type of button will be in a
menubar, the default frame width is reset to zero.

	

.hi

.nf
 frameWidth = 0 
.fi

.eh

.TP
.I "XtNshrinkToFit"
The \fIshrinkToFit\fP resource is set to a new default of \fITrue\fP.

	

.hi

.nf
 shrinkToFit = True 
.fi

.eh

.ps-2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfButton
Name	Class	Type	Default
XtNactivate	XtCActivate	Callback	NULL 

.TE
.ps

.ps-2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfLabel
Name	Class	Type	Default
XtNlabel	XtCLabel	String 	NULL 
XtNtablist	XtCTablist	String 	NULL 
XtNfont	XtCFont	FontStruct	XtDefaultFont 
XtNforeground	XtCForeground	Pixel 	XtDefaultForeground 
XtNalignment	XtCAlignment	Alignment 	0 
XtNtopMargin	XtCTopMargin	Dimension 	2 
XtNbottomMargin	XtCBottomMargin	Dimension 	2 
XtNleftMargin	XtCLeftMargin	Dimension 	2 
XtNrightMargin	XtCRightMargin	Dimension 	2 
XtNshrinkToFit	XtCShrinkToFit	Boolean 	False 
XtNrvStart	XtCRvStart	Int 	0 
XtNrvLength	XtCRvLength	Int 	0 

.TE
.ps

.ps-2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfBoard
Name	Class	Type	Default
XtNabs_x	XtCAbs_x	Position 	0 
XtNrel_x	XtCRel_x	Float 	"0.0"
XtNabs_y	XtCAbs_y	Position 	0 
XtNrel_y	XtCRel_y	Float 	"0.0"
XtNabs_width	XtCAbs_width	Position 	0 
XtNrel_width	XtCRel_width	Float 	"1.0"
XtNabs_height	XtCAbs_height	Position 	0 
XtNrel_height	XtCRel_height	Float 	"1.0"
XtNhunit	XtCHunit	Float 	"1.0"
XtNvunit	XtCVunit	Float 	"1.0"
XtNlocation	XtCLocation	String 	NULL 

.TE
.ps

.ps-2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfFrame
Name	Class	Type	Default
XtNcursor	XtCCursor	Cursor 	None 
XtNframeType	XtCFrameType	FrameType 	XfwfRaised 
XtNframeWidth	XtCFrameWidth	Dimension 	0 
XtNouterOffset	XtCOuterOffset	Dimension 	0 
XtNinnerOffset	XtCInnerOffset	Dimension 	0 
XtNshadowScheme	XtCShadowScheme	ShadowScheme 	XfwfAuto 
XtNtopShadowColor	XtCTopShadowColor	Pixel 	compute_topcolor 
XtNbottomShadowColor	XtCBottomShadowColor	Pixel 	compute_bottomcolor 
XtNtopShadowStipple	XtCTopShadowStipple	Bitmap 	NULL 
XtNbottomShadowStipple	XtCBottomShadowStipple	Bitmap 	NULL 

.TE
.ps

.ps-2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfCommon
Name	Class	Type	Default
XtNtraversalOn	XtCTraversalOn	Boolean 	True 
XtNhighlightThickness	XtCHighlightThickness	Dimension 	2 
XtNhighlightColor	XtCHighlightColor	Pixel 	XtDefaultForeground 
XtNhighlightPixmap	XtCHighlightPixmap	Pixmap 	None 
XtNnextTop	XtCNextTop	Callback	NULL 
XtNuserData	XtCUserData	Pointer	NULL 

.TE
.ps

.ps-2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Composite
Name	Class	Type	Default
XtNchildren	XtCChildren	WidgetList 	NULL 
insertPosition	XtCInsertPosition	XTOrderProc 	NULL 
numChildren	XtCNumChildren	Cardinal 	0 

.TE
.ps

.ps-2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Core
Name	Class	Type	Default
XtNx	XtCX	Position 	0 
XtNy	XtCY	Position 	0 
XtNwidth	XtCWidth	Dimension 	0 
XtNheight	XtCHeight	Dimension 	0 
borderWidth	XtCBorderWidth	Dimension 	0 
XtNcolormap	XtCColormap	Colormap 	NULL 
XtNdepth	XtCDepth	Int 	0 
destroyCallback	XtCDestroyCallback	XTCallbackList 	NULL 
XtNsensitive	XtCSensitive	Boolean 	True 
XtNtm	XtCTm	XTTMRec 	NULL 
ancestorSensitive	XtCAncestorSensitive	Boolean 	False 
accelerators	XtCAccelerators	XTTranslations 	NULL 
borderColor	XtCBorderColor	Pixel 	0 
borderPixmap	XtCBorderPixmap	Pixmap 	NULL 
background	XtCBackground	Pixel 	0 
backgroundPixmap	XtCBackgroundPixmap	Pixmap 	NULL 
mappedWhenManaged	XtCMappedWhenManaged	Boolean 	True 
XtNscreen	XtCScreen	Screen *	NULL 

.TE
.ps

.SS "Translations"

.nf
<Btn1Down>: prepare() open_menu() 
.fi

.nf
Button1<Enter>: prepare() open_menu() 
.fi

.nf
<Key>Return: prepare() open_menu() 
.fi

.nf
<Btn1Up>: popdown_maybe() 
.fi

.hi
.SS "Actions"

.TP
.I "note

\fInote\fP is for debugging only.

.hi

.nf
void note($, XEvent* event, String* params, Cardinal* num_params)
{
    static String Xeventname[] = {
	"", "", "KeyPress", "KeyRelease", "ButtonPress", "ButtonRelease",
	"MotionNotify", "EnterNotify", "LeaveNotify", "FocusIn",
	"FocusOut", "KeymapNotify", "Expose", "GraphicsExpose",
	"NoExpose", "VisisbilityNotify", "CreateNotify", "DestroyNotify",
	"UnmapNotify", "MapNotify", "MapRequest", "ReparentNotify",
	"ConfigureNotify", "ConfigureRequest", "GravityNotify",
	"ResizeRequest", "CirculateNotify", "CirculateRequest",
	"PropertyNotify", "SelectionClear", "SelectionRequest",
	"SelectionNotify", "ColormapNotify", "ClientMessage",
	"MappingNotify", };
    (void) fprintf(stderr, "%s received %s\\n",
		   XtName($), Xeventname[event->type]);
}
.fi

.eh

.TP
.I "prepare

The \fIprepare\fP action just calls the \fIprepare\fP callback functions, passing
the \fIXEvent\fP pointer in the \fIcall_data\fP argument.

.hi

.nf
void prepare($, XEvent* event, String* params, Cardinal* num_params)
{
    XtCallCallbackList($, $prepare, event);
}
.fi

.eh

.TP
.I "open_menu

The \fIopen_menu\fP action computes the coordinates of the menu, such that it
will appear directly below the button. A local grab is added, so that the
button itself will continu to receive events, even after the popped up menu
has grabbed the pointer and keyboard. The accelerators of the menu are
installed in the pulldown button, which will continue to have the focus.
It then pops up the menu.

.hi

.nf
void open_menu($, XEvent* event, String* params, Cardinal* num_params)
{
    Position x, y;

    if ($popup == NULL) return;
    /* fprintf(stderr, "open_menu \\"%s\\"\\n", XtName($)); */
    XtTranslateCoords($, 0, $height, x, y);
    XtVaSetValues($popup, XtNx, x, XtNy, y, NULL);
    if (! XfwfCallProcessMenu(XtParent($), $popup, $menuCursor))
	XtPopupSpringLoaded($popup);
}
.fi

.eh

.TP
.I "popdown_maybe

The \fIpodown_maybe\fP action only pops down the menu when the pointer
is outside the button. When the pointer is on the button, the menu
stays posted.

.hi

.nf
void popdown_maybe($, XEvent* event, String* params, Cardinal* num_params)
{
    Position x, y;

    switch (event->type) {
    case ButtonRelease:
    case ButtonPress:
	x = event->xbutton.x;
	y = event->xbutton.y;
	break;
    case MotionNotify:
	x = event->xmotion.x;
	y = event->xmotion.y;
	break;
    case EnterNotify:
    case LeaveNotify:
	x = event->xcrossing.x;
	y = event->xcrossing.y;
	break;
    default:
	XtAppWarning(XtWidgetToApplicationContext($),
		   "Incorrect event for popdown_maybe()");
    }
    if (x < 0 || $width <= x || y < 0 || $height <= y) XtPopdown($popup);
}
.fi

.eh

.hi

.hi
.SH "Importss"

.nf

.B incl
 <Xfwf/TextMenu.h>
.fi

.nf

.B incl
 <Xfwf/MenuBar.h>
.fi

.nf

.B incl
 <stdio.h>
.fi

.hi

.hi
.SS "Private variables"

When the popup menu is created from the \fImenu\fP resource, the
variable \fIown_popup\fP is set to \fITrue\fP. In this way it is possible to
destroy the popup again when it is no longer needed.

	

.nf
Boolean  own_popup
.fi

.hi

.hi
.SS "Methods"

.nf
class_initialize()
{
    XtRegisterGrabAction(open_menu, True, ButtonPressMask |
			 ButtonReleaseMask | EnterWindowMask |
			 LeaveWindowMask | PointerMotionMask,
			 GrabModeAsync, GrabModeAsync);
}
.fi

Both the \fIinitialize\fP and \fIset_values\fP methods need to create a new
menu widget, if the \fImenu\fP resource is set and the \fIpopup\fP resource
is not. A utility function is used to do the actual work. If both
\fIpopup\fP and \fImenu\fP are set, \fIpopup\fP is used and \fImenu\fP is
ignored.

.nf
initialize(Widget  request, $, ArgList  args, Cardinal * num_args)
{
    if ($menu) $menu = XtNewString($menu);
    if (! $popup  $menu) {
	$popup = XtVaCreatePopupShell
	    ("menu", xfwfTextMenuWidgetClass, $, XtNmenu, $menu, XtNcursor,
	     $menuCursor, NULL);
	$own_popup = True;
	XtAddCallback($popup, XtNactivate, activate_cb, $);
	XtAddCallback($popup, XtNchangeSelection, change_cb, $);
    } else
	$own_popup = False;
    if (! $popup  $hotkey) create_accelerator($);
}
.fi

\fIset_values\fP is similar. Changes in these resources never cause a redraw,
so the method always returns \fIFalse\fP. A change in \fImenu\fP is only recognized
if there is no change in \fIpopup\fP at the same time.

.nf
Boolean  set_values(Widget  old, Widget  request, $, ArgList  args, Cardinal * num_args)
{
    if ($old$menu != $menu) {
	XtFree($old$menu);
	$menu = XtNewString($menu);
    }
    if ($old$popup != $popup) {
	if ($own_popup  $old$popup) XtDestroyWidget($old$popup);
	$own_popup = False;
    } else if ($old$menu != $menu) {
	$popup = XtVaCreatePopupShell
	    ("menu", xfwfTextMenuWidgetClass, $, XtNmenu, $menu, XtNcursor,
	     $menuCursor, NULL);
	$own_popup = True;
	XtAddCallback($popup, XtNactivate, activate_cb, $);
	XtAddCallback($popup, XtNchangeSelection, change_cb, $);
    }
    if ($old$menuCursor != $menuCursor)
	if ($popup) XtVaSetValues($popup, XtNcursor, $menuCursor, NULL);
    if ($old$hotkey != $hotkey)
	create_accelerator($);
    return False;
}
.fi

.hi

.hi
.SH "Utilities"

\fIcreate_accelerator\fP takes the \fIhotkey\fP and expands it into a
correct \fIaccelerators\fP resource.

.nf
create_accelerator($)
{
    char s[100];
    XtAccelerators a;

    (void) strcpy(s, $hotkey);
    (void) strcat(s, ": prepare() open_menu()");
    a = XtParseAcceleratorTable(s);
    XtVaSetValues($, XtNaccelerators, a, NULL);
}
.fi

The \fIactivate_cb\fP routine is attached to the \fIactivate\fP callback of the
menu, but only if the menu is created by the PullDown widget itself. It
simply calls the PullDown widget's \fIactivate\fP callback. The \fIcall_data\fP
argument contains the number of the selected menu item.

.nf
activate_cb(Widget  menu, XtPointer  client_data, XtPointer  call_data)
{
    Widget $ = (Widget) client_data;

    XtCallCallbackList($, $activate, call_data);
}
.fi

The \fIchange_cb\fP routine is attached to the \fIchangeSelection\fP callback of
the menu, but only if the menu is created by the PullDown widget itself. It
simply calls the PullDown widget's \fIchangeSelection\fP callback. The
\fIcall_data\fP argument contains the number of the selected menu item.

.nf
change_cb(Widget  menu, XtPointer  client_data, XtPointer  call_data)
{
    Widget $ = (Widget) client_data;

    XtCallCallbackList($, $changeSelection, call_data);
}
.fi

.hi
