/* Generated by wbuild from "Prompt.w"
** (generator version $Revision: 2.0 $ of $Date: 93/07/06 16:08:04 $)
*/
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#line 993 "Prompt.w"
#include <ctype.h>
#line 994 "Prompt.w"
#include <stdio.h>
#line 995 "Prompt.w"
#include <X11/Xatom.h>
#line 996 "Prompt.w"
#include <X11/Xmu/Atoms.h>
#include <Xfwf/PromptP.h>
#line 306 "Prompt.w"
static void activate(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 315 "Prompt.w"
static void leave(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 330 "Prompt.w"
static void start_select(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 347 "Prompt.w"
static void extend_select(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 368 "Prompt.w"
static void end_select(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 386 "Prompt.w"
static void paste(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 396 "Prompt.w"
static void unselect(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 411 "Prompt.w"
static void cut(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 456 "Prompt.w"
static void self_insert(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 492 "Prompt.w"
static void bol(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 507 "Prompt.w"
static void eol(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 527 "Prompt.w"
static void left(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 545 "Prompt.w"
static void right(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 566 "Prompt.w"
static void delete(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 606 "Prompt.w"
static void backspace(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);

static XtActionsRec actionsList[] = {
{"activate", activate},
{"leave", leave},
{"start_select", start_select},
{"extend_select", extend_select},
{"end_select", end_select},
{"paste", paste},
{"unselect", unselect},
{"cut", cut},
{"self_insert", self_insert},
{"bol", bol},
{"eol", eol},
{"left", left},
{"right", right},
{"delete", delete},
{"backspace", backspace},
};

static char defaultTranslations[] = "\
<FocusIn>: focusIn() \n\
<FocusOut>: leave() focusOut() \n\
<Key>Up: traverseUp() \n\
<Key>Down: traverseDown() \n\
<Key>Next: traverseNext() \n\
~Shift<Key>Tab: traverseNext() \n\
<Key>Prior: traversePrev() \n\
Shift<Key>Tab: traversePrev() \n\
<Key>KP_Enter: traverseNextTop() \n\
<Key>Home: traverseHome() \n\
Shift<Btn1Down>: extend_select() \n\
<Btn1Down>: traverseCurrent() start_select() \n\
<Btn1Motion>: extend_select() \n\
<Btn1Up>: end_select() \n\
<Btn2Down>,<Btn2Up>: paste() \n\
<Key>BackSpace: cut() backspace() \n\
Ctrl<Key>d: cut() delete() \n\
<Key>Right: unselect() right() \n\
<Key>Left: unselect() left() \n\
Ctrl<Key>a: unselect() bol() \n\
Ctrl<Key>e: unselect() eol() \n\
<Key>Return: activate() \n\
<Key>: cut() self_insert() \n\
";
static void _resolve_inheritance(
#if NeedFunctionPrototypes
WidgetClass
#endif
);
#line 175 "Prompt.w"
static void initialize(
#if NeedFunctionPrototypes
Widget ,Widget,ArgList ,Cardinal *
#endif
);
#line 194 "Prompt.w"
static Boolean  set_values(
#if NeedFunctionPrototypes
Widget ,Widget ,Widget,ArgList ,Cardinal *
#endif
);
#line 225 "Prompt.w"
static void expose(
#if NeedFunctionPrototypes
Widget,XEvent *,Region 
#endif
);
#line 648 "Prompt.w"
static Boolean  find_cursor(
#if NeedFunctionPrototypes
Widget,XButtonEvent *,int *
#endif
);
#line 687 "Prompt.w"
static void find_cursor_in_line(
#if NeedFunctionPrototypes
Widget,XRectangle ,int ,int ,int ,int ,int *
#endif
);
#line 745 "Prompt.w"
static int  find_end_of_run(
#if NeedFunctionPrototypes
Widget,int 
#endif
);
#line 763 "Prompt.w"
static void insert_in_run(
#if NeedFunctionPrototypes
Widget,int ,int ,int 
#endif
);
#line 776 "Prompt.w"
static void delete_from_run(
#if NeedFunctionPrototypes
Widget,int ,int ,int 
#endif
);
#line 788 "Prompt.w"
static Boolean  matches(
#if NeedFunctionPrototypes
int ,int 
#endif
);
#line 805 "Prompt.w"
static void insert_char(
#if NeedFunctionPrototypes
Widget,int 
#endif
);
#line 842 "Prompt.w"
#define pattern_char(c) (c =='9'||c =='a'||c =='A'||c =='F'||c =='f'||c =='X'||c =='z'||c =='Z')


#line 846 "Prompt.w"
static void set_text_start(
#if NeedFunctionPrototypes
Widget
#endif
);
#line 905 "Prompt.w"
static Boolean  convert_proc(
#if NeedFunctionPrototypes
Widget,Atom *,Atom *,Atom *,XtPointer *,unsigned  long *,int *
#endif
);
#line 946 "Prompt.w"
static void lose_ownership_proc(
#if NeedFunctionPrototypes
Widget,Atom *
#endif
);
#line 955 "Prompt.w"
static void paste_callback(
#if NeedFunctionPrototypes
Widget,XtPointer ,Atom *,Atom *,XtPointer ,unsigned  long *,int *
#endif
);
#line 648 "Prompt.w"
/*ARGSUSED*/static Boolean  find_cursor(self,event,pos)Widget self;XButtonEvent * event;int * pos;
{
    XRectangle rect;
    int baseline, i, j;
    Dimension w;
    int x, y;

    if (! XtIsRealized(self)) return False;
    if (((XfwfPromptWidget)self)->xfwfLabel.label == NULL) return False;
    baseline = ((XfwfPromptWidget)self)->xfwfLabel.font->ascent + ((XfwfPromptWidget)self)->xfwfLabel.font->descent;
    ((XfwfPromptWidgetClass)self->core.widget_class)->xfwfCommon_class.compute_inside(self, &rect.x, &rect.y, &rect.width, &rect.height);
    rect.x += ((XfwfPromptWidget)self)->xfwfLabel.leftMargin;  rect.width -= ((XfwfPromptWidget)self)->xfwfLabel.leftMargin + ((XfwfPromptWidget)self)->xfwfLabel.rightMargin;
    rect.y += ((XfwfPromptWidget)self)->xfwfLabel.topMargin;  rect.height -= ((XfwfPromptWidget)self)->xfwfLabel.topMargin + ((XfwfPromptWidget)self)->xfwfLabel.bottomMargin;
    if (((XfwfPromptWidget)self)->xfwfLabel.alignment & XfwfTop)
	y = rect.y;
    else if (((XfwfPromptWidget)self)->xfwfLabel.alignment & XfwfBottom)
	y = rect.y + rect.height - ((XfwfPromptWidget)self)->xfwfLabel.nlines * baseline;
    else
	y = rect.y + (rect.height - ((XfwfPromptWidget)self)->xfwfLabel.nlines * baseline)/2;
    i = 0;
    j = 0;
    do {
	if (((XfwfPromptWidget)self)->xfwfLabel.label[i] == '\n' || ((XfwfPromptWidget)self)->xfwfLabel.label[i] == '\0') {
	    if (y <= event->y && event->y < y + baseline) {
		find_cursor_in_line(self, rect, event->x, event->y, j, i, pos);
		return True;
	    } else {
		j = i + 1;
		y += baseline;
	    }
	}
    } while (((XfwfPromptWidget)self)->xfwfLabel.label[i++]);
    return False;
}
#line 687 "Prompt.w"
/*ARGSUSED*/static void find_cursor_in_line(self,rect,mx,my,j,i,pos)Widget self;XRectangle  rect;int  mx;int  my;int  j;int  i;int * pos;
{
    Dimension w;
    int x;

    w = XfwfTextWidth(((XfwfPromptWidget)self)->xfwfLabel.font, ((XfwfPromptWidget)self)->xfwfLabel.label + j, i - j, ((XfwfPromptWidget)self)->xfwfLabel.tabs);
    if (((XfwfPromptWidget)self)->xfwfLabel.alignment & XfwfLeft)
	x = rect.x;
    else if (((XfwfPromptWidget)self)->xfwfLabel.alignment & XfwfRight)
	x = rect.x + rect.width - w;
    else
	x = rect.x + (rect.width - w)/2;
    if (x + w <= mx) {				/* Mouse right of the text */
	if (((XfwfPromptWidget)self)->xfwfPrompt.template == NULL)
	    *pos = i;
	else {					/* Find placeholder */
	    while (i > ((XfwfPromptWidget)self)->xfwfPrompt.text_start && ((XfwfPromptWidget)self)->xfwfPrompt.template[i] != ((XfwfPromptWidget)self)->xfwfPrompt.placeholder) i--;
	    *pos = i;
	}
    } else if (mx < x) {			/* Mouse left of the text */
	if (((XfwfPromptWidget)self)->xfwfPrompt.template == NULL)
	    *pos = j;
	else {					/* Find placeholder */
	    while (j > ((XfwfPromptWidget)self)->xfwfPrompt.text_start && ((XfwfPromptWidget)self)->xfwfPrompt.template[j] != ((XfwfPromptWidget)self)->xfwfPrompt.placeholder) j--;
	    *pos = j;
	}
    } else {					/* Mouse points in the text */
	for (w = 0; True; j++) {
	    w += XfwfTextWidth(((XfwfPromptWidget)self)->xfwfLabel.font, ((XfwfPromptWidget)self)->xfwfLabel.label + j, 1, ((XfwfPromptWidget)self)->xfwfLabel.tabs);
	    if (x + w >= mx) break;
	}
	if (((XfwfPromptWidget)self)->xfwfPrompt.template == NULL)
	    *pos = j;
	else if (j >= ((XfwfPromptWidget)self)->xfwfPrompt.text_start + ((XfwfPromptWidget)self)->xfwfPrompt.text_len)
	    *pos = ((XfwfPromptWidget)self)->xfwfPrompt.text_start + ((XfwfPromptWidget)self)->xfwfPrompt.text_len;
	else if (j <= ((XfwfPromptWidget)self)->xfwfPrompt.text_start)
	    *pos = ((XfwfPromptWidget)self)->xfwfPrompt.text_start;
	else {					/* Find nearest placeholder */
	    while (j > ((XfwfPromptWidget)self)->xfwfPrompt.text_start && ((XfwfPromptWidget)self)->xfwfPrompt.template[j] != ((XfwfPromptWidget)self)->xfwfPrompt.placeholder) j--;
	    *pos = j;
	}
    }
}
#line 745 "Prompt.w"
/*ARGSUSED*/static int  find_end_of_run(self,start)Widget self;int  start;
{
    int i, j;

    i = start + 1;
    j = i - ((XfwfPromptWidget)self)->xfwfPrompt.text_start;
    while (((XfwfPromptWidget)self)->xfwfPrompt.template[i] == ((XfwfPromptWidget)self)->xfwfPrompt.placeholder && ((XfwfPromptWidget)self)->xfwfPrompt.pattern[j] == ((XfwfPromptWidget)self)->xfwfPrompt.pattern[j-1]) {
	i++;
	j++;
    }
    return i;
}
#line 763 "Prompt.w"
/*ARGSUSED*/static void insert_in_run(self,start,end,c)Widget self;int  start;int  end;int  c;
{
    int i;

    for (i = end - 1; i > start; i--) ((XfwfPromptWidget)self)->xfwfPrompt.text[i] = ((XfwfPromptWidget)self)->xfwfPrompt.text[i-1];
    ((XfwfPromptWidget)self)->xfwfPrompt.text[start] = c;
}
#line 776 "Prompt.w"
/*ARGSUSED*/static void delete_from_run(self,start,end,filler)Widget self;int  start;int  end;int  filler;
{
    int i;

    for (i = start; i < end - 1; i++) ((XfwfPromptWidget)self)->xfwfPrompt.text[i] = ((XfwfPromptWidget)self)->xfwfPrompt.text[i+1];
    ((XfwfPromptWidget)self)->xfwfPrompt.text[end-1] = filler;
}
#line 788 "Prompt.w"
/*ARGSUSED*/static Boolean  matches(c,class)int  c;int  class;
{
    if (class == '9') return isdigit(c);
    if (class == 'a') return isalnum(c) || isspace(c);
    if (class == 'A') return isdigit(c) || isupper(c) || isspace(c);
    if (class == 'F')
	return isgraph(c) && c != '*' && c != '?' && c != '[' && c != ']';
    if (class == 'f') return isgraph(c);
    if (class == 'X') return isascii(c);
    if (class == 'z') return isalnum(c);
    if (class == 'Z') return isdigit(c) || isupper(c);
    XtWarning("Cannot happen: incorrect pattern");
    return True;
}
#line 805 "Prompt.w"
/*ARGSUSED*/static void insert_char(self,c)Widget self;int  c;
{
    int j;

    if (! ((XfwfPromptWidget)self)->xfwfPrompt.template) {
	j = strlen(((XfwfPromptWidget)self)->xfwfPrompt.text);
	((XfwfPromptWidget)self)->xfwfPrompt.text = XtRealloc(((XfwfPromptWidget)self)->xfwfPrompt.text, j + 2);
	((XfwfPromptWidget)self)->xfwfPrompt.text[j+1] = '\0';
	insert_in_run(self, ((XfwfPromptWidget)self)->xfwfLabel.rvStart, j + 1, c);
	((XfwfPromptWidget)self)->xfwfLabel.rvStart++;
    } else {
	if (((XfwfPromptWidget)self)->xfwfPrompt.template[((XfwfPromptWidget)self)->xfwfLabel.rvStart] != ((XfwfPromptWidget)self)->xfwfPrompt.placeholder) {
	    XBell(XtDisplay(self), 50);		/* At end of template */
	    return;
	}
	j = find_end_of_run(self, ((XfwfPromptWidget)self)->xfwfLabel.rvStart);
	if (matches(c, ((XfwfPromptWidget)self)->xfwfPrompt.pattern[((XfwfPromptWidget)self)->xfwfLabel.rvStart - ((XfwfPromptWidget)self)->xfwfPrompt.text_start])) {
	    insert_in_run(self, ((XfwfPromptWidget)self)->xfwfLabel.rvStart - ((XfwfPromptWidget)self)->xfwfPrompt.text_start, j - ((XfwfPromptWidget)self)->xfwfPrompt.text_start, c);
	    do {
		((XfwfPromptWidget)self)->xfwfLabel.rvStart++;
	    } while (((XfwfPromptWidget)self)->xfwfLabel.rvStart < ((XfwfPromptWidget)self)->xfwfPrompt.text_start + ((XfwfPromptWidget)self)->xfwfPrompt.text_len
		     && ((XfwfPromptWidget)self)->xfwfPrompt.template[((XfwfPromptWidget)self)->xfwfLabel.rvStart] != ((XfwfPromptWidget)self)->xfwfPrompt.placeholder);
	} else if (c == ((XfwfPromptWidget)self)->xfwfPrompt.template[j]) {
	    while (((XfwfPromptWidget)self)->xfwfPrompt.template[j] && ((XfwfPromptWidget)self)->xfwfPrompt.template[j] != ((XfwfPromptWidget)self)->xfwfPrompt.placeholder) j++;
	    ((XfwfPromptWidget)self)->xfwfLabel.rvStart = j;
	} else {
	    XBell(XtDisplay(self), 50);
	}
    }
}
#line 846 "Prompt.w"
/*ARGSUSED*/static void set_text_start(self)Widget self;
{
    int i, j, k;
    String newlabel;

    if (((XfwfPromptWidget)self)->xfwfPrompt.template == NULL) {
	newlabel = XtNewString(((XfwfPromptWidget)self)->xfwfPrompt.text);
	XtVaSetValues(self, XtNlabel, newlabel, NULL);
	XtFree(newlabel);
	return;
    }
    /*
     * Find start and end in template
     */
    for (i = 0; ((XfwfPromptWidget)self)->xfwfPrompt.template[i] && ((XfwfPromptWidget)self)->xfwfPrompt.template[i] != '_'; i++) ; /* skip */
    for (k = i, j = i; ((XfwfPromptWidget)self)->xfwfPrompt.template[j]; j++) if (((XfwfPromptWidget)self)->xfwfPrompt.template[j] == '_') k = j;
    ((XfwfPromptWidget)self)->xfwfPrompt.text_start = i;
    ((XfwfPromptWidget)self)->xfwfPrompt.text_len = k + 1 - i;
    /*
     * Check the pattern, first the length, then the contents
     */
    if (((XfwfPromptWidget)self)->xfwfPrompt.pattern == NULL) {
	((XfwfPromptWidget)self)->xfwfPrompt.pattern = XtMalloc((((XfwfPromptWidget)self)->xfwfPrompt.text_len + 1)*sizeof(char));
	((XfwfPromptWidget)self)->xfwfPrompt.pattern[0] = '\0';
    } else if (strlen(((XfwfPromptWidget)self)->xfwfPrompt.pattern) < ((XfwfPromptWidget)self)->xfwfPrompt.text_len) {
	((XfwfPromptWidget)self)->xfwfPrompt.pattern = XtRealloc(((XfwfPromptWidget)self)->xfwfPrompt.pattern, (((XfwfPromptWidget)self)->xfwfPrompt.text_len + 1)*sizeof(char));
    }
    for (i = strlen(((XfwfPromptWidget)self)->xfwfPrompt.pattern); i < ((XfwfPromptWidget)self)->xfwfPrompt.text_len; i++)
	((XfwfPromptWidget)self)->xfwfPrompt.pattern[i] = 'X';
    for (i = ((XfwfPromptWidget)self)->xfwfPrompt.text_start, k = 0; k < ((XfwfPromptWidget)self)->xfwfPrompt.text_len; i++, k++)
	if (((XfwfPromptWidget)self)->xfwfPrompt.template[i] == ((XfwfPromptWidget)self)->xfwfPrompt.placeholder && ! pattern_char(((XfwfPromptWidget)self)->xfwfPrompt.pattern[k])) {
	    XtWarning("Pattern doesn't match template");
	    ((XfwfPromptWidget)self)->xfwfPrompt.pattern[k] = 'X';
	}
    ((XfwfPromptWidget)self)->xfwfPrompt.pattern[k] = '\0';
    /*
     * Check the length of the text
     */
    if (((XfwfPromptWidget)self)->xfwfPrompt.text == NULL) {
	((XfwfPromptWidget)self)->xfwfPrompt.text = XtMalloc((((XfwfPromptWidget)self)->xfwfPrompt.text_len + 1)*sizeof(char));
	((XfwfPromptWidget)self)->xfwfPrompt.text[0] = '\0';
    } else if (strlen(((XfwfPromptWidget)self)->xfwfPrompt.text) < ((XfwfPromptWidget)self)->xfwfPrompt.text_len) {
	((XfwfPromptWidget)self)->xfwfPrompt.text = XtRealloc(XtNewString(((XfwfPromptWidget)self)->xfwfPrompt.text), (((XfwfPromptWidget)self)->xfwfPrompt.text_len + 1)*sizeof(char));
    }
    for (j = strlen(((XfwfPromptWidget)self)->xfwfPrompt.text); j < ((XfwfPromptWidget)self)->xfwfPrompt.text_len; j++)
	((XfwfPromptWidget)self)->xfwfPrompt.text[j] = ((XfwfPromptWidget)self)->xfwfPrompt.template[j+((XfwfPromptWidget)self)->xfwfPrompt.text_start];
    /*
     * Initialize the label
     */
    newlabel = XtNewString(((XfwfPromptWidget)self)->xfwfPrompt.template);
    for (i = ((XfwfPromptWidget)self)->xfwfPrompt.text_start, j = 0; j < ((XfwfPromptWidget)self)->xfwfPrompt.text_len; i++, j++)
	newlabel[i] = ((XfwfPromptWidget)self)->xfwfPrompt.text[j];
    ((XfwfPromptWidgetClass)self->core.widget_class)->xfwfLabel_class.set_label(self, newlabel);
    XtFree(newlabel);
}
#line 905 "Prompt.w"
/*ARGSUSED*/static Boolean  convert_proc(self,selection,target,type,value,length,format)Widget self;Atom * selection;Atom * target;Atom * type;XtPointer * value;unsigned  long * length;int * format;
{
    Display* d = XtDisplay(self);
    XSelectionRequestEvent* req = XtGetSelectionRequest(self, *selection, NULL);

    if (*target == XA_TARGETS(d)) {
	Atom* targetP;
	Atom* std_targets;
	unsigned long std_length;
	XmuConvertStandardSelection(self, req->time, selection, target,
				    type, (XtPointer*)&std_targets,
				    &std_length, format);
	*value = XtMalloc(sizeof(Atom) * (std_length + 1));
	targetP = *(Atom**) value;
	*targetP++ = XA_STRING;
	*length = std_length + (targetP - (*(Atom **) value));
	bcopy((char*)std_targets, (char*)targetP, sizeof(Atom)*std_length);
	XtFree((char*)std_targets);
	*type = XA_ATOM;
	*format = sizeof(Atom) * 8;
	return True;
    }
    if (*target == XA_STRING) {
	*type = XA_STRING;
	*length = sizeof(char) * (strlen(((XfwfPromptWidget)self)->xfwfPrompt.selection_buffer) + 1);
    	*value = XtNewString(((XfwfPromptWidget)self)->xfwfPrompt.selection_buffer);
    	*format = 8;
    	return True;
    }
    if (XmuConvertStandardSelection(self, req->time, selection, target,
				    type, value, length, format))
	return True;

    return False;
}
#line 946 "Prompt.w"
/*ARGSUSED*/static void lose_ownership_proc(self,selection)Widget self;Atom * selection;
{
}
#line 955 "Prompt.w"
/*ARGSUSED*/static void paste_callback(self,client_data,selection,type,value,length,format)Widget self;XtPointer  client_data;Atom * selection;Atom * type;XtPointer  value;unsigned  long * length;int * format;
{
    String data = (String) value;
    XfwfPromptInfo info;
    int i;
    String newlabel;

    if (value == NULL && *length == 0) {
	XBell(XtDisplay(self), 50);
	/* XtWarning("no selection or selection timed out, try again"); */
	return;
    }
    info.old = XtNewString(((XfwfPromptWidget)self)->xfwfPrompt.text);
    for (i = 0; i < *length && data[i]; i++)
	insert_char(self, data[i]);
    info.new = ((XfwfPromptWidget)self)->xfwfPrompt.text;
    info.result = XfwfComplete;
    XtCallCallbackList(self, ((XfwfPromptWidget)self)->xfwfPrompt.validate, &info);
    switch (info.result) {
    case XfwfReject: XtFree(((XfwfPromptWidget)self)->xfwfPrompt.text); ((XfwfPromptWidget)self)->xfwfPrompt.text = info.old; return;
    case XfwfAccept: XtFree(info.old); ((XfwfPromptWidget)self)->xfwfPrompt.complete = False; break;
    case XfwfComplete: XtFree(info.old); ((XfwfPromptWidget)self)->xfwfPrompt.complete = True; break;
    }
    if (((XfwfPromptWidget)self)->xfwfPrompt.template == NULL)
	((XfwfPromptWidgetClass)self->core.widget_class)->xfwfLabel_class.set_label(self, ((XfwfPromptWidget)self)->xfwfPrompt.text);
    else {
	newlabel = XtNewString(((XfwfPromptWidget)self)->xfwfPrompt.template);
	for (i = 0; i < ((XfwfPromptWidget)self)->xfwfPrompt.text_len; i++) newlabel[i+((XfwfPromptWidget)self)->xfwfPrompt.text_start] = ((XfwfPromptWidget)self)->xfwfPrompt.text[i];
	((XfwfPromptWidgetClass)self->core.widget_class)->xfwfLabel_class.set_label(self, newlabel);
	XtFree(newlabel);
    }
    XtFree(value);
}

static XtResource resources[] = {
#line 31 "Prompt.w"
{XtNtext,XtCText,XtRString,sizeof(((XfwfPromptRec*)NULL)->xfwfPrompt.text),XtOffsetOf(XfwfPromptRec,xfwfPrompt.text),XtRImmediate,(XtPointer)NULL },
#line 42 "Prompt.w"
{XtNtemplate,XtCTemplate,XtRString,sizeof(((XfwfPromptRec*)NULL)->xfwfPrompt.template),XtOffsetOf(XfwfPromptRec,xfwfPrompt.template),XtRImmediate,(XtPointer)NULL },
#line 67 "Prompt.w"
{XtNpattern,XtCPattern,XtRString,sizeof(((XfwfPromptRec*)NULL)->xfwfPrompt.pattern),XtOffsetOf(XfwfPromptRec,xfwfPrompt.pattern),XtRImmediate,(XtPointer)NULL },
#line 78 "Prompt.w"
{XtNvalidate,XtCValidate,XtRCallback,sizeof(((XfwfPromptRec*)NULL)->xfwfPrompt.validate),XtOffsetOf(XfwfPromptRec,xfwfPrompt.validate),XtRImmediate,(XtPointer)NULL },
#line 84 "Prompt.w"
{XtNleave,XtCLeave,XtRCallback,sizeof(((XfwfPromptRec*)NULL)->xfwfPrompt.leave),XtOffsetOf(XfwfPromptRec,xfwfPrompt.leave),XtRImmediate,(XtPointer)NULL },
#line 92 "Prompt.w"
{XtNactivate,XtCActivate,XtRCallback,sizeof(((XfwfPromptRec*)NULL)->xfwfPrompt.activate),XtOffsetOf(XfwfPromptRec,xfwfPrompt.activate),XtRImmediate,(XtPointer)NULL },
#line 97 "Prompt.w"
{XtNcomplete,XtCComplete,XtRBoolean,sizeof(((XfwfPromptRec*)NULL)->xfwfPrompt.complete),XtOffsetOf(XfwfPromptRec,xfwfPrompt.complete),XtRImmediate,(XtPointer)True },
#line 104 "Prompt.w"
{XtNplaceholder,XtCPlaceholder,XtRChar,sizeof(((XfwfPromptRec*)NULL)->xfwfPrompt.placeholder),XtOffsetOf(XfwfPromptRec,xfwfPrompt.placeholder),XtRImmediate,(XtPointer)'_'},
#line 108 "Prompt.w"
{XtNcursor,XtCCursor,XtRCursor,sizeof(((XfwfPromptRec*)NULL)->xfwfFrame.cursor),XtOffsetOf(XfwfPromptRec,xfwfFrame.cursor),XtRString,(XtPointer)"xterm"},
#line 113 "Prompt.w"
{XtNtraversalOn,XtCTraversalOn,XtRBoolean,sizeof(((XfwfPromptRec*)NULL)->xfwfCommon.traversalOn),XtOffsetOf(XfwfPromptRec,xfwfCommon.traversalOn),XtRImmediate,(XtPointer)True },
#line 117 "Prompt.w"
{XtNframeWidth,XtCFrameWidth,XtRDimension,sizeof(((XfwfPromptRec*)NULL)->xfwfFrame.frameWidth),XtOffsetOf(XfwfPromptRec,xfwfFrame.frameWidth),XtRImmediate,(XtPointer)2 },
#line 121 "Prompt.w"
{XtNframeType,XtCFrameType,XtRFrameType,sizeof(((XfwfPromptRec*)NULL)->xfwfFrame.frameType),XtOffsetOf(XfwfPromptRec,xfwfFrame.frameType),XtRImmediate,(XtPointer)XfwfSunken },
#line 125 "Prompt.w"
{XtNalignment,XtCAlignment,XtRAlignment,sizeof(((XfwfPromptRec*)NULL)->xfwfLabel.alignment),XtOffsetOf(XfwfPromptRec,xfwfLabel.alignment),XtRImmediate,(XtPointer)XfwfLeft },
};

XfwfPromptClassRec xfwfPromptClassRec = {
{ /* core_class part */
(WidgetClass) &xfwfLabelClassRec,
"XfwfPrompt",
sizeof(XfwfPromptRec),
NULL,
_resolve_inheritance,
FALSE,
initialize,
NULL,
XtInheritRealize,
actionsList,
15,
resources,
13,
NULLQUARK,
False ,
FALSE ,
False ,
False ,
NULL,
XtInheritResize,
expose,
set_values,
NULL,
XtInheritSetValuesAlmost,
NULL,
XtInheritAcceptFocus,
XtVersion,
NULL,
defaultTranslations,
XtInheritQueryGeometry,
XtInheritDisplayAccelerator,
NULL 
},
{ /* composite_class part */
XtInheritGeometryManager,
XtInheritChangeManaged,
XtInheritInsertChild,
XtInheritDeleteChild,
NULL
},
{ /* XfwfCommon_class part */
XtInherit_compute_inside,
XtInherit_highlight_border,
XtInherit_unhighlight_border,
XtInherit_would_accept_focus,
XtInherit_traverse,
XtInherit_choose_color,
XtInherit_lighter_color,
XtInherit_darker_color,
NULL ,
},
{ /* XfwfFrame_class part */
0
},
{ /* XfwfBoard_class part */
XtInherit_set_abs_location,
},
{ /* XfwfLabel_class part */
XtInherit_set_label,
},
{ /* XfwfPrompt_class part */
0
},
};
WidgetClass xfwfPromptWidgetClass = (WidgetClass) &xfwfPromptClassRec;
/*ARGSUSED*/
#line 306 "Prompt.w"
static void activate(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
    XtCallCallbackList(self, ((XfwfPromptWidget)self)->xfwfPrompt.activate, event);
}

/*ARGSUSED*/
#line 315 "Prompt.w"
static void leave(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
    if (event->type == FocusOut
	&& event->xfocus.detail != NotifyAncestor
	&& event->xfocus.detail != NotifyInferior
	&& event->xfocus.detail != NotifyNonlinear) return;
    XtCallCallbackList(self, ((XfwfPromptWidget)self)->xfwfPrompt.leave, ((XfwfPromptWidget)self)->xfwfPrompt.text);
}

/*ARGSUSED*/
#line 330 "Prompt.w"
static void start_select(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
    Position x, y;
    Dimension w, h;
    Cardinal pos;

    if (find_cursor(self, &event->xbutton, &((XfwfPromptWidget)self)->xfwfLabel.rvStart)) {
	((XfwfPromptWidget)self)->xfwfLabel.rvLength = 0;
	((XfwfPromptWidgetClass)self->core.widget_class)->xfwfCommon_class.compute_inside(self, &x, &y, &w, &h);
	XClearArea(XtDisplay(self), XtWindow(self), x, y, w, h, True);
    }
}

/*ARGSUSED*/
#line 347 "Prompt.w"
static void extend_select(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
    Position x, y;
    Dimension w, h;
    int pos, len, start;

    if (find_cursor(self, &event->xbutton, &pos)) {
	len = abs(pos - ((XfwfPromptWidget)self)->xfwfLabel.rvStart);
	start = min(pos, ((XfwfPromptWidget)self)->xfwfLabel.rvStart);
	if (len != ((XfwfPromptWidget)self)->xfwfLabel.rvLength || start != ((XfwfPromptWidget)self)->xfwfLabel.rvStart) {
	    ((XfwfPromptWidget)self)->xfwfLabel.rvLength = len;
	    ((XfwfPromptWidget)self)->xfwfLabel.rvStart = start;
	    ((XfwfPromptWidgetClass)self->core.widget_class)->xfwfCommon_class.compute_inside(self, &x, &y, &w, &h);
	    XClearArea(XtDisplay(self), XtWindow(self), x, y, w, h, True);
	}
    }
}

/*ARGSUSED*/
#line 368 "Prompt.w"
static void end_select(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
    if (((XfwfPromptWidget)self)->xfwfLabel.rvLength == 0) return;
    if (! XtOwnSelection(self, XA_PRIMARY, event->xbutton.time,
			 convert_proc, lose_ownership_proc, NULL)) {
	XtWarning("failed attempting to become selection owner.");
	return;
    }
    XtFree(((XfwfPromptWidget)self)->xfwfPrompt.selection_buffer);
    ((XfwfPromptWidget)self)->xfwfPrompt.selection_buffer = XtMalloc(sizeof(char) * (((XfwfPromptWidget)self)->xfwfLabel.rvLength + 1));
    (void) strncpy(((XfwfPromptWidget)self)->xfwfPrompt.selection_buffer, ((XfwfPromptWidget)self)->xfwfLabel.label + ((XfwfPromptWidget)self)->xfwfLabel.rvStart, ((XfwfPromptWidget)self)->xfwfLabel.rvLength);
    ((XfwfPromptWidget)self)->xfwfPrompt.selection_buffer[((XfwfPromptWidget)self)->xfwfLabel.rvLength] = '\0';
}

/*ARGSUSED*/
#line 386 "Prompt.w"
static void paste(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
    XtGetSelectionValue(self, XA_PRIMARY, XA_STRING, paste_callback, NULL,
			event->xbutton.time);
}

/*ARGSUSED*/
#line 396 "Prompt.w"
static void unselect(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
    Position x, y;
    Dimension w, h;

    if (((XfwfPromptWidget)self)->xfwfLabel.rvLength != 0) {
	((XfwfPromptWidget)self)->xfwfLabel.rvLength = 0;
	((XfwfPromptWidgetClass)self->core.widget_class)->xfwfCommon_class.compute_inside(self, &x, &y, &w, &h);
	XClearArea(XtDisplay(self), XtWindow(self), x, y, w, h, True);
    }
}

/*ARGSUSED*/
#line 411 "Prompt.w"
static void cut(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
    int j, i;
    XfwfPromptInfo info;
    String newlabel;

    if (((XfwfPromptWidget)self)->xfwfLabel.rvLength == 0) return;
    info.old = XtNewString(((XfwfPromptWidget)self)->xfwfPrompt.text);
    if (((XfwfPromptWidget)self)->xfwfPrompt.template == NULL) {
	j = strlen(((XfwfPromptWidget)self)->xfwfPrompt.text);
	i = min(((XfwfPromptWidget)self)->xfwfLabel.rvStart + ((XfwfPromptWidget)self)->xfwfLabel.rvLength, j) - 1;
	for (; i >= ((XfwfPromptWidget)self)->xfwfLabel.rvStart; i--, j--) delete_from_run(self, i, j, '\0');
    } else {
	i = min(((XfwfPromptWidget)self)->xfwfLabel.rvStart + ((XfwfPromptWidget)self)->xfwfLabel.rvLength, ((XfwfPromptWidget)self)->xfwfPrompt.text_start + ((XfwfPromptWidget)self)->xfwfPrompt.text_len) - 1;
	for (; i >= ((XfwfPromptWidget)self)->xfwfLabel.rvStart; i--) {
	    if (((XfwfPromptWidget)self)->xfwfPrompt.template[i] != ((XfwfPromptWidget)self)->xfwfPrompt.placeholder) continue;
	    j = find_end_of_run(self, i);
	    delete_from_run(self, i - ((XfwfPromptWidget)self)->xfwfPrompt.text_start, j - ((XfwfPromptWidget)self)->xfwfPrompt.text_start, ((XfwfPromptWidget)self)->xfwfPrompt.placeholder);
	}
    }
    info.new = ((XfwfPromptWidget)self)->xfwfPrompt.text;
    info.result = XfwfComplete;
    XtCallCallbackList(self, ((XfwfPromptWidget)self)->xfwfPrompt.validate, &info);
    switch (info.result) {
    case XfwfReject: XtFree(((XfwfPromptWidget)self)->xfwfPrompt.text); ((XfwfPromptWidget)self)->xfwfPrompt.text = info.old; return;
    case XfwfAccept: XtFree(info.old); ((XfwfPromptWidget)self)->xfwfPrompt.complete = False; break;
    case XfwfComplete: XtFree(info.old); ((XfwfPromptWidget)self)->xfwfPrompt.complete = True; break;
    }
    if (((XfwfPromptWidget)self)->xfwfPrompt.template == NULL) {
	((XfwfPromptWidgetClass)self->core.widget_class)->xfwfLabel_class.set_label(self, ((XfwfPromptWidget)self)->xfwfPrompt.text);
    } else {
	newlabel = XtNewString(((XfwfPromptWidget)self)->xfwfPrompt.template);
	for (j = 0; j < ((XfwfPromptWidget)self)->xfwfPrompt.text_len; j++) newlabel[j+((XfwfPromptWidget)self)->xfwfPrompt.text_start] = ((XfwfPromptWidget)self)->xfwfPrompt.text[j];
	((XfwfPromptWidgetClass)self->core.widget_class)->xfwfLabel_class.set_label(self, newlabel);
	XtFree(newlabel);
    }
    ((XfwfPromptWidget)self)->xfwfLabel.rvLength = 0;
}

/*ARGSUSED*/
#line 456 "Prompt.w"
static void self_insert(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
    KeySym keysym;
    int n, i;
    char buf[100];
    XfwfPromptInfo info;
    String newlabel;

    if (event->type != KeyPress && event->type != KeyRelease) {
	XtWarning("action <self_insert> can only handle keyboard events");
	return;
    }
    info.old = XtNewString(((XfwfPromptWidget)self)->xfwfPrompt.text);
    n = XLookupString(&event->xkey, buf, sizeof(buf), &keysym, &((XfwfPromptWidget)self)->xfwfPrompt.compose_stat);
    for (i = 0; i < n; i++) insert_char(self, buf[i]);
    info.new = ((XfwfPromptWidget)self)->xfwfPrompt.text;
    info.result = XfwfComplete;
    XtCallCallbackList(self, ((XfwfPromptWidget)self)->xfwfPrompt.validate, &info);
    switch (info.result) {
    case XfwfReject: XtFree(((XfwfPromptWidget)self)->xfwfPrompt.text); ((XfwfPromptWidget)self)->xfwfPrompt.text = info.old; return;
    case XfwfAccept: XtFree(info.old); ((XfwfPromptWidget)self)->xfwfPrompt.complete = False; break;
    case XfwfComplete: XtFree(info.old); ((XfwfPromptWidget)self)->xfwfPrompt.complete = True; break;
    }
    if (((XfwfPromptWidget)self)->xfwfPrompt.template == NULL)
	((XfwfPromptWidgetClass)self->core.widget_class)->xfwfLabel_class.set_label(self, ((XfwfPromptWidget)self)->xfwfPrompt.text);
    else {
	newlabel = XtNewString(((XfwfPromptWidget)self)->xfwfPrompt.template);
	for (i = 0; i < ((XfwfPromptWidget)self)->xfwfPrompt.text_len; i++) newlabel[i+((XfwfPromptWidget)self)->xfwfPrompt.text_start] = ((XfwfPromptWidget)self)->xfwfPrompt.text[i];
	((XfwfPromptWidgetClass)self->core.widget_class)->xfwfLabel_class.set_label(self, newlabel);
	XtFree(newlabel);
    }
}

/*ARGSUSED*/
#line 492 "Prompt.w"
static void bol(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
    Position x, y;
    Dimension w, h;

    if (((XfwfPromptWidget)self)->xfwfLabel.rvStart == ((XfwfPromptWidget)self)->xfwfPrompt.text_start) return;
    ((XfwfPromptWidget)self)->xfwfLabel.rvStart = ((XfwfPromptWidget)self)->xfwfPrompt.text_start;
    ((XfwfPromptWidgetClass)self->core.widget_class)->xfwfCommon_class.compute_inside(self, &x, &y, &w, &h);
    XClearArea(XtDisplay(self), XtWindow(self), x, y, w, h, True);
}

/*ARGSUSED*/
#line 507 "Prompt.w"
static void eol(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
    Position x, y;
    Dimension w, h;

    if (((XfwfPromptWidget)self)->xfwfPrompt.template == NULL) {
	if (((XfwfPromptWidget)self)->xfwfLabel.label[((XfwfPromptWidget)self)->xfwfLabel.rvStart] == '\0') return;
	do { ((XfwfPromptWidget)self)->xfwfLabel.rvStart++; } while (((XfwfPromptWidget)self)->xfwfLabel.label[((XfwfPromptWidget)self)->xfwfLabel.rvStart]);
    } else {
	if (((XfwfPromptWidget)self)->xfwfLabel.rvStart == ((XfwfPromptWidget)self)->xfwfPrompt.text_start + ((XfwfPromptWidget)self)->xfwfPrompt.text_len) return;
	((XfwfPromptWidget)self)->xfwfLabel.rvStart = ((XfwfPromptWidget)self)->xfwfPrompt.text_start + ((XfwfPromptWidget)self)->xfwfPrompt.text_len;
    }
    ((XfwfPromptWidgetClass)self->core.widget_class)->xfwfCommon_class.compute_inside(self, &x, &y, &w, &h);
    XClearArea(XtDisplay(self), XtWindow(self), x, y, w, h, True);
}

/*ARGSUSED*/
#line 527 "Prompt.w"
static void left(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
    Position x, y;
    Dimension w, h;

    if (((XfwfPromptWidget)self)->xfwfLabel.rvStart == ((XfwfPromptWidget)self)->xfwfPrompt.text_start) return;
    if (((XfwfPromptWidget)self)->xfwfPrompt.template == NULL)
	((XfwfPromptWidget)self)->xfwfLabel.rvStart--;
    else
	do { ((XfwfPromptWidget)self)->xfwfLabel.rvStart--; } while (((XfwfPromptWidget)self)->xfwfPrompt.template[((XfwfPromptWidget)self)->xfwfLabel.rvStart] != ((XfwfPromptWidget)self)->xfwfPrompt.placeholder);
    ((XfwfPromptWidgetClass)self->core.widget_class)->xfwfCommon_class.compute_inside(self, &x, &y, &w, &h);
    XClearArea(XtDisplay(self), XtWindow(self), x, y, w, h, True);
}

/*ARGSUSED*/
#line 545 "Prompt.w"
static void right(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
    Position x, y;
    Dimension w, h;

    if (((XfwfPromptWidget)self)->xfwfPrompt.template == NULL) {
	if (((XfwfPromptWidget)self)->xfwfLabel.label[((XfwfPromptWidget)self)->xfwfLabel.rvStart] == '\0') return;
	((XfwfPromptWidget)self)->xfwfLabel.rvStart++;
    } else {
	if (((XfwfPromptWidget)self)->xfwfLabel.rvStart == ((XfwfPromptWidget)self)->xfwfPrompt.text_start + ((XfwfPromptWidget)self)->xfwfPrompt.text_len) return;
	do { ((XfwfPromptWidget)self)->xfwfLabel.rvStart++; } while (((XfwfPromptWidget)self)->xfwfPrompt.template[((XfwfPromptWidget)self)->xfwfLabel.rvStart] != ((XfwfPromptWidget)self)->xfwfPrompt.placeholder);
    }
    ((XfwfPromptWidgetClass)self->core.widget_class)->xfwfCommon_class.compute_inside(self, &x, &y, &w, &h);
    XClearArea(XtDisplay(self), XtWindow(self), x, y, w, h, True);
}

/*ARGSUSED*/
#line 566 "Prompt.w"
static void delete(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
    int j;
    XfwfPromptInfo info;
    String newlabel;

    if (((XfwfPromptWidget)self)->xfwfPrompt.template == NULL) {
	if (! ((XfwfPromptWidget)self)->xfwfPrompt.text || ((XfwfPromptWidget)self)->xfwfPrompt.text[((XfwfPromptWidget)self)->xfwfLabel.rvStart] == '\0') return;
	info.old = XtNewString(((XfwfPromptWidget)self)->xfwfPrompt.text);
	j = strlen(((XfwfPromptWidget)self)->xfwfPrompt.text);
	delete_from_run(self, ((XfwfPromptWidget)self)->xfwfLabel.rvStart, j, '\0');
    } else {
	if (((XfwfPromptWidget)self)->xfwfPrompt.template[((XfwfPromptWidget)self)->xfwfLabel.rvStart] != ((XfwfPromptWidget)self)->xfwfPrompt.placeholder) return;
	info.old = XtNewString(((XfwfPromptWidget)self)->xfwfPrompt.text);
	j = find_end_of_run(self, ((XfwfPromptWidget)self)->xfwfLabel.rvStart) - ((XfwfPromptWidget)self)->xfwfPrompt.text_start;
	delete_from_run(self, ((XfwfPromptWidget)self)->xfwfLabel.rvStart - ((XfwfPromptWidget)self)->xfwfPrompt.text_start, j, ((XfwfPromptWidget)self)->xfwfPrompt.placeholder);
    }
    info.new = ((XfwfPromptWidget)self)->xfwfPrompt.text;
    info.result = XfwfComplete;
    XtCallCallbackList(self, ((XfwfPromptWidget)self)->xfwfPrompt.validate, &info);
    switch (info.result) {
    case XfwfReject: XtFree(((XfwfPromptWidget)self)->xfwfPrompt.text); ((XfwfPromptWidget)self)->xfwfPrompt.text = info.old; return;
    case XfwfAccept: XtFree(info.old); ((XfwfPromptWidget)self)->xfwfPrompt.complete = False; break;
    case XfwfComplete: XtFree(info.old); ((XfwfPromptWidget)self)->xfwfPrompt.complete = True; break;
    }
    if (((XfwfPromptWidget)self)->xfwfPrompt.template == NULL) {
	((XfwfPromptWidgetClass)self->core.widget_class)->xfwfLabel_class.set_label(self, ((XfwfPromptWidget)self)->xfwfPrompt.text);
    } else {
	newlabel = XtNewString(((XfwfPromptWidget)self)->xfwfPrompt.template);
	for (j = 0; j < ((XfwfPromptWidget)self)->xfwfPrompt.text_len; j++) newlabel[j+((XfwfPromptWidget)self)->xfwfPrompt.text_start] = ((XfwfPromptWidget)self)->xfwfPrompt.text[j];
	((XfwfPromptWidgetClass)self->core.widget_class)->xfwfLabel_class.set_label(self, newlabel);
	XtFree(newlabel);
    }
}

/*ARGSUSED*/
#line 606 "Prompt.w"
static void backspace(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
    int j;
    XfwfPromptInfo info;
    String newlabel;

    if (((XfwfPromptWidget)self)->xfwfLabel.rvStart == ((XfwfPromptWidget)self)->xfwfPrompt.text_start) return;
    info.old = XtNewString(((XfwfPromptWidget)self)->xfwfPrompt.text);
    if (((XfwfPromptWidget)self)->xfwfPrompt.template == NULL) {
	((XfwfPromptWidget)self)->xfwfLabel.rvStart--;
	j = strlen(((XfwfPromptWidget)self)->xfwfLabel.label);
	delete_from_run(self, ((XfwfPromptWidget)self)->xfwfLabel.rvStart, j, '\0');
    } else {
	do { ((XfwfPromptWidget)self)->xfwfLabel.rvStart--; } while (((XfwfPromptWidget)self)->xfwfPrompt.template[((XfwfPromptWidget)self)->xfwfLabel.rvStart] != ((XfwfPromptWidget)self)->xfwfPrompt.placeholder);
	j = find_end_of_run(self, ((XfwfPromptWidget)self)->xfwfLabel.rvStart) - ((XfwfPromptWidget)self)->xfwfPrompt.text_start;
	delete_from_run(self, ((XfwfPromptWidget)self)->xfwfLabel.rvStart - ((XfwfPromptWidget)self)->xfwfPrompt.text_start, j, ((XfwfPromptWidget)self)->xfwfPrompt.placeholder);
    }
    info.new = ((XfwfPromptWidget)self)->xfwfPrompt.text;
    info.result = XfwfComplete;
    XtCallCallbackList(self, ((XfwfPromptWidget)self)->xfwfPrompt.validate, &info);
    switch (info.result) {
    case XfwfReject: XtFree(((XfwfPromptWidget)self)->xfwfPrompt.text); ((XfwfPromptWidget)self)->xfwfPrompt.text = info.old; return;
    case XfwfAccept: XtFree(info.old); ((XfwfPromptWidget)self)->xfwfPrompt.complete = False; break;
    case XfwfComplete: XtFree(info.old); ((XfwfPromptWidget)self)->xfwfPrompt.complete = True; break;
    }
    if (((XfwfPromptWidget)self)->xfwfPrompt.template == NULL) {
	((XfwfPromptWidgetClass)self->core.widget_class)->xfwfLabel_class.set_label(self, ((XfwfPromptWidget)self)->xfwfPrompt.text);
    } else {
	newlabel = XtNewString(((XfwfPromptWidget)self)->xfwfPrompt.template);
	for (j = 0; j < ((XfwfPromptWidget)self)->xfwfPrompt.text_len; j++) newlabel[j+((XfwfPromptWidget)self)->xfwfPrompt.text_start] = ((XfwfPromptWidget)self)->xfwfPrompt.text[j];
	((XfwfPromptWidgetClass)self->core.widget_class)->xfwfLabel_class.set_label(self, newlabel);
	XtFree(newlabel);
    }
}

static void _resolve_inheritance(class)
WidgetClass class;
{
  XfwfPromptWidgetClass c = (XfwfPromptWidgetClass) class;
  XfwfPromptWidgetClass super;
  static CompositeClassExtensionRec extension_rec = {
    NULL, NULLQUARK, XtCompositeExtensionVersion,
    sizeof(CompositeClassExtensionRec), True};
  CompositeClassExtensionRec *ext;
  ext = (XtPointer)XtMalloc(sizeof(*ext));
  *ext = extension_rec;
  ext->next_extension = c->composite_class.extension;
  c->composite_class.extension = ext;
  if (class == xfwfPromptWidgetClass) return;
  super = (XfwfPromptWidgetClass)class->core_class.superclass;
}
#line 175 "Prompt.w"
/*ARGSUSED*/static void initialize(request,self,args,num_args)Widget  request;Widget self;ArgList  args;Cardinal * num_args;
{
    if (((XfwfPromptWidget)self)->xfwfLabel.label != NULL)
	XtWarning("The label resource of a Prompt should not be set");
    ((XfwfPromptWidget)self)->xfwfPrompt.text_start = 0;
    if (((XfwfPromptWidget)self)->xfwfPrompt.text != NULL) ((XfwfPromptWidget)self)->xfwfPrompt.text = XtNewString(((XfwfPromptWidget)self)->xfwfPrompt.text);
    if (((XfwfPromptWidget)self)->xfwfPrompt.template != NULL) ((XfwfPromptWidget)self)->xfwfPrompt.template = XtNewString(((XfwfPromptWidget)self)->xfwfPrompt.template);
    if (((XfwfPromptWidget)self)->xfwfPrompt.pattern != NULL) ((XfwfPromptWidget)self)->xfwfPrompt.pattern = XtNewString(((XfwfPromptWidget)self)->xfwfPrompt.pattern);
    set_text_start(self);
    while (((XfwfPromptWidget)self)->xfwfLabel.rvStart > ((XfwfPromptWidget)self)->xfwfPrompt.text_start + ((XfwfPromptWidget)self)->xfwfPrompt.text_len) ((XfwfPromptWidget)self)->xfwfLabel.rvStart--;
    while (((XfwfPromptWidget)self)->xfwfLabel.rvStart < ((XfwfPromptWidget)self)->xfwfPrompt.text_start) ((XfwfPromptWidget)self)->xfwfLabel.rvStart++;
    ((XfwfPromptWidget)self)->xfwfPrompt.selection_buffer = NULL;
}
#line 194 "Prompt.w"
/*ARGSUSED*/static Boolean  set_values(old,request,self,args,num_args)Widget  old;Widget  request;Widget self;ArgList  args;Cardinal * num_args;
{
    Boolean need_redisplay = False, reset_text = False;

    if (((XfwfPromptWidget)old)->xfwfPrompt.text != ((XfwfPromptWidget)self)->xfwfPrompt.text) {
	XtFree(((XfwfPromptWidget)old)->xfwfPrompt.text);
	((XfwfPromptWidget)self)->xfwfPrompt.text = XtNewString(((XfwfPromptWidget)self)->xfwfPrompt.text);
	reset_text = True;
    }
    if (((XfwfPromptWidget)old)->xfwfPrompt.template !=((XfwfPromptWidget)self)->xfwfPrompt.template) {
	XtFree(((XfwfPromptWidget)old)->xfwfPrompt.template);
	((XfwfPromptWidget)self)->xfwfPrompt.template = XtNewString(((XfwfPromptWidget)self)->xfwfPrompt.template);
	reset_text = True;
    }
    if (((XfwfPromptWidget)old)->xfwfPrompt.pattern != ((XfwfPromptWidget)self)->xfwfPrompt.pattern) {
	XtFree(((XfwfPromptWidget)old)->xfwfPrompt.pattern);
	((XfwfPromptWidget)self)->xfwfPrompt.pattern = XtNewString(((XfwfPromptWidget)self)->xfwfPrompt.pattern);
	reset_text = True;
    }
    if (reset_text || ((XfwfPromptWidget)old)->xfwfPrompt.placeholder != ((XfwfPromptWidget)self)->xfwfPrompt.placeholder) {
	set_text_start(self);
	need_redisplay = True;
    }
    return need_redisplay;
}
#line 225 "Prompt.w"
/*ARGSUSED*/static void expose(self,event,region)Widget self;XEvent * event;Region  region;
{
    Region reg;
    XRectangle rect;
    int baseline, i, j;
    Dimension w;
    int x, y;

    if (! XtIsRealized(self)) return;
    xfwfLabelClassRec.core_class.expose(self, event, region);
    if (((XfwfPromptWidget)self)->xfwfLabel.label == NULL) return;
    baseline = ((XfwfPromptWidget)self)->xfwfLabel.font->ascent + ((XfwfPromptWidget)self)->xfwfLabel.font->descent;
    ((XfwfPromptWidgetClass)self->core.widget_class)->xfwfCommon_class.compute_inside(self, &rect.x, &rect.y, &rect.width, &rect.height);
    rect.x += ((XfwfPromptWidget)self)->xfwfLabel.leftMargin;  rect.width -= ((XfwfPromptWidget)self)->xfwfLabel.leftMargin + ((XfwfPromptWidget)self)->xfwfLabel.rightMargin;
    rect.y += ((XfwfPromptWidget)self)->xfwfLabel.topMargin;  rect.height -= ((XfwfPromptWidget)self)->xfwfLabel.topMargin + ((XfwfPromptWidget)self)->xfwfLabel.bottomMargin;
    if (((XfwfPromptWidget)self)->xfwfLabel.alignment & XfwfTop)
	y = rect.y + ((XfwfPromptWidget)self)->xfwfLabel.font->ascent;
    else if (((XfwfPromptWidget)self)->xfwfLabel.alignment & XfwfBottom)
	y = rect.y + rect.height - ((XfwfPromptWidget)self)->xfwfLabel.nlines * baseline + ((XfwfPromptWidget)self)->xfwfLabel.font->ascent;
    else
	y = rect.y + (rect.height - ((XfwfPromptWidget)self)->xfwfLabel.nlines * baseline)/2 + ((XfwfPromptWidget)self)->xfwfLabel.font->ascent;
    for (i = 0, j = 0; True; i++) {
	if (((XfwfPromptWidget)self)->xfwfLabel.label[i] == '\n' || ((XfwfPromptWidget)self)->xfwfLabel.label[i] == '\0') {
	    if (j <= ((XfwfPromptWidget)self)->xfwfLabel.rvStart && ((XfwfPromptWidget)self)->xfwfLabel.rvStart <= i) {
		w = XfwfTextWidth(((XfwfPromptWidget)self)->xfwfLabel.font, ((XfwfPromptWidget)self)->xfwfLabel.label + j, i - j, ((XfwfPromptWidget)self)->xfwfLabel.tabs);
		if (((XfwfPromptWidget)self)->xfwfLabel.alignment & XfwfLeft) x = rect.x;
		else if (((XfwfPromptWidget)self)->xfwfLabel.alignment & XfwfRight) x = rect.x + rect.width - w;
		else x = rect.x + (rect.width - w)/2;
		x += XfwfTextWidth(((XfwfPromptWidget)self)->xfwfLabel.font, ((XfwfPromptWidget)self)->xfwfLabel.label + j, ((XfwfPromptWidget)self)->xfwfLabel.rvStart - j, ((XfwfPromptWidget)self)->xfwfLabel.tabs);
		XDrawLine(XtDisplay(self), XtWindow(self), ((XfwfPromptWidget)self)->xfwfLabel.gc, x, y -
			  ((XfwfPromptWidget)self)->xfwfLabel.font->ascent, x, y + ((XfwfPromptWidget)self)->xfwfLabel.font->descent);
		break;
	    }
	    j = i + 1;
	    y += baseline;
	}
    }
}
#line 137 "Prompt.w"
#line 140 "Prompt.w"
