.\"remove .ig hn for full docs
.de hi
.ig eh
..
.de eh
..
.TH "" 3 "" "Version 3.0" "Free Widget Foundation"
.SH NAME
XfwfAnimator
.SH DESCRIPTION
The animator widget cycles through a series of images (XImage
structures). Each image is displayed for a certain number of
milliseconds. After the last image, the animation can either start
over or stop with the last image displayed.

The animation must be started with \fIXfwfStartAnimation\fP and it may be
stopped with \fIXfwfStopAnimation\fP.

The widget uses the location resources (see XfwfBoard(3)) for
positioning only; the preferred size of the widget will be the size of
the largest image, plus room for the frame.

.SS "Public variables"

.ps-2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfAnimator
Name	Class	Type	Default
XtNimages	XtCImages	ImageList	NULL 
XtNintervals	XtCIntervals	CardinalList	NULL 
XtNdefaultInterval	XtCDefaultInterval	Cardinal 	500 
XtNcycle	XtCCycle	Boolean 	True 

.TE
.ps

.TP
.I "XtNimages"
The list of images can be specified in the resource file as a series
of filenames of files in XPM format. If it is set from an application,
the list must end with a \fINULL\fP. Every element is a pointer to an
\fIXImage\fP structure.

.hi

.nf
<ImageList> XImage ** images = NULL 
.fi

.eh

.TP
.I "XtNintervals"
The time that each image will be displayed can be set with
\fIintervals\fP. It is a list of cardinals, each representing a number of
milliseconds. The list must end with a zero. If there are insufficient
numbers in the list, the last number will be used as the interval for
any remaining images. If the list is empty (NULL), the interval will
be \fIdefaultInterval\fP (normally 500).

.hi

.nf
<CardinalList> Cardinal * intervals = NULL 
.fi

.eh

.TP
.I "XtNdefaultInterval"
If the list of intervals is empty, the interval will be
\fIdefaultInterval\fP milliseconds.

.hi

.nf
Cardinal  defaultInterval = 500 
.fi

.eh

.TP
.I "XtNcycle"
The animation repeats indefinitely by default. When the \fIcycle\fP
resource is set to \fIFalse\fP the animation sequence is shown once only,
for every call to \fIXfwfStartAnimation\fP.

.hi

.nf
Boolean  cycle = True 
.fi

.eh

.TP
.I "XtNframeType"
The default type of frame is set to `sunken'.

.hi

.nf
 frameType = XfwfSunken 
.fi

.eh

.TP
.I "XtNrel_width"
If there is no image to display, the widget has no obvious size. The
following defaults for the location resources create a 7 by 7 pixel
widget.

.hi

.nf
 rel_width = <String>"0.0"
.fi

.eh

.TP
.I "XtNabs_width"

.hi

.nf
 abs_width = 7 
.fi

.eh

.TP
.I "XtNrel_height"

.hi

.nf
 rel_height = <String>"0.0"
.fi

.eh

.TP
.I "XtNabs_height"

.hi

.nf
 abs_height = 7 
.fi

.eh

.ps-2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfBoard
Name	Class	Type	Default
XtNabs_x	XtCAbs_x	Position 	0 
XtNrel_x	XtCRel_x	Float 	"0.0"
XtNabs_y	XtCAbs_y	Position 	0 
XtNrel_y	XtCRel_y	Float 	"0.0"
XtNabs_width	XtCAbs_width	Position 	0 
XtNrel_width	XtCRel_width	Float 	"1.0"
XtNabs_height	XtCAbs_height	Position 	0 
XtNrel_height	XtCRel_height	Float 	"1.0"
XtNhunit	XtCHunit	Float 	"1.0"
XtNvunit	XtCVunit	Float 	"1.0"
XtNlocation	XtCLocation	String 	NULL 

.TE
.ps

.ps-2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfFrame
Name	Class	Type	Default
XtNcursor	XtCCursor	Cursor 	None 
XtNframeType	XtCFrameType	FrameType 	XfwfRaised 
XtNframeWidth	XtCFrameWidth	Dimension 	0 
XtNouterOffset	XtCOuterOffset	Dimension 	0 
XtNinnerOffset	XtCInnerOffset	Dimension 	0 
XtNshadowScheme	XtCShadowScheme	ShadowScheme 	XfwfAuto 
XtNtopShadowColor	XtCTopShadowColor	Pixel 	compute_topcolor 
XtNbottomShadowColor	XtCBottomShadowColor	Pixel 	compute_bottomcolor 
XtNtopShadowStipple	XtCTopShadowStipple	Bitmap 	NULL 
XtNbottomShadowStipple	XtCBottomShadowStipple	Bitmap 	NULL 

.TE
.ps

.ps-2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
XfwfCommon
Name	Class	Type	Default
XtNtraversalOn	XtCTraversalOn	Boolean 	True 
XtNhighlightThickness	XtCHighlightThickness	Dimension 	2 
XtNhighlightColor	XtCHighlightColor	Pixel 	XtDefaultForeground 
XtNhighlightPixmap	XtCHighlightPixmap	Pixmap 	None 
XtNnextTop	XtCNextTop	Callback	NULL 
XtNuserData	XtCUserData	Pointer	NULL 

.TE
.ps

.ps-2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Composite
Name	Class	Type	Default
XtNchildren	XtCChildren	WidgetList 	NULL 
insertPosition	XtCInsertPosition	XTOrderProc 	NULL 
numChildren	XtCNumChildren	Cardinal 	0 

.TE
.ps

.ps-2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Core
Name	Class	Type	Default
XtNx	XtCX	Position 	0 
XtNy	XtCY	Position 	0 
XtNwidth	XtCWidth	Dimension 	0 
XtNheight	XtCHeight	Dimension 	0 
borderWidth	XtCBorderWidth	Dimension 	0 
XtNcolormap	XtCColormap	Colormap 	NULL 
XtNdepth	XtCDepth	Int 	0 
destroyCallback	XtCDestroyCallback	XTCallbackList 	NULL 
XtNsensitive	XtCSensitive	Boolean 	True 
XtNtm	XtCTm	XTTMRec 	NULL 
ancestorSensitive	XtCAncestorSensitive	Boolean 	False 
accelerators	XtCAccelerators	XTTranslations 	NULL 
borderColor	XtCBorderColor	Pixel 	0 
borderPixmap	XtCBorderPixmap	Pixmap 	NULL 
background	XtCBackground	Pixel 	0 
backgroundPixmap	XtCBackgroundPixmap	Pixmap 	NULL 
mappedWhenManaged	XtCMappedWhenManaged	Boolean 	True 
XtNscreen	XtCScreen	Screen *	NULL 

.TE
.ps

.SS "Exports"

To start the animation an application should call
\fIXfwfStartAnimation\fP. If the animation is already running, it will be
restarted from the beginning.

.nf
XfwfStartAnimation( $)
.fi

.hi
{
    if (! XtIsSubclass($, xfwfAnimatorWidgetClass))
	XtWarning("Illegal widget type in XfwfStartAnimation");
    else
	$start_animation($);
}
.eh

The animation can be stopped with \fIXfwfStopAnimation\fP.

.nf
XfwfStopAnimation( $)
.fi

.hi
{
    if (! XtIsSubclass($, xfwfAnimatorWidgetClass))
	XtWarning("Illegal widget type in XfwfStopAnimation");
    else
	$stop_animation($);
}
.eh

.hi
.SH "Importss"

.nf

.B incl
 <X11/xpm.h>
.fi

.nf

.B incl
 <stdio.h>
.fi

.hi

.hi
.SS "Private variables"

The images will be changed by a time-out routine. The timer for that
routine is stored in \fItimer\fP.

.nf
XtIntervalId  timer
.fi

The current image.

.nf
int  cur_image
.fi

The current interval, if \fIintervals\fP is not \fINULL\fP.

.nf
int  cur_interval
.fi

The GC for drawing the image.

.nf
GC  image_gc
.fi

.hi

.hi
.SS "Methods"

\fIclass_initialize\fP installs the type converters for a list of images
and a list of cardinal numbers.

.nf
class_initialize()
{
    XtSetTypeConverter(XtRString, XtRImageList, cvtStringToImageList,
		       NULL, 0, XtCacheNone, NULL);
    XtSetTypeConverter(XtRString, XtRCardinalList, cvtStringToCardinalList,
		       NULL, 0, XtCacheNone, NULL);
}
.fi

The \fIinitialize\fP sets the (desired and actual) size of the widget to
the size of the largest image. The GC is initialized to all default
values.

.nf
initialize(Widget  request, $, ArgList  args, Cardinal * num_args)
{
    Dimension wd, ht, dummy1, dummy2;
    Position x, y;
    XImage **p;
    XtGCMask value_mask = 0;
    XGCValues values;

    $timer = NULL;
    $image_gc = XtGetGC($, value_mask, values);
    if ($images != NULL) {
	$compute_inside($, x, y, dummy1, dummy2);
	wd = 1; ht = 1;
	for (p = $images; *p; p++) {
	    if ((*p)->width > wd) wd = (*p)->width;
	    if ((*p)->height > ht) ht = (*p)->height;
	}
	XtVaSetValues($, XtNwidth, wd + 2*x, XtNheight, ht + 2*y, NULL);
    }
}
.fi

The \fIstart_animation\fP method is usually called by the
\fIXfwfStartAnimation\fP routine.  If an animation is already running, the
time-out function must be removed first. To draw the first image, the
routine calls the \fIexpose\fP method with the \fIevent\fP and \fIregion\fP
parameters set to \fINULL\fP.

.nf
start_animation($)
{
    Cardinal delay;

    if (! $images) return;
    if ($timer) XtRemoveTimeOut($timer);
    $cur_image = 0;
    $cur_interval = 0;
    if (! $intervals || $intervals[0] == 0)
	delay = $defaultInterval;
    else
	delay = $intervals[$cur_interval];
    $expose($, NULL, NULL);
    $timer = XtAppAddTimeOut(XtWidgetToApplicationContext($), delay,
			     next_image, $);
}
.fi

The \fIstop_animation\fP method simply removes the time-out function. It
leaves the current image undisturbed.

.nf
stop_animation($)
{
    if ($timer) {
	XtRemoveTimeOut($timer);
	$timer = NULL;
    }
}
.fi

The \fIexpose\fP method simply draws the current image (if any) against
the top left corner of the widget. It then calls the superclass's
\fIexpose\fP method to draw the frame.

.nf
expose($, XEvent * event, Region  region)
{
    Dimension wd, ht;
    Position x, y;

    if (! XtIsRealized($)) return;
    if (region != NULL)
	XSetRegion(XtDisplay($), $image_gc, region);
    $compute_inside($, x, y, wd, ht);
    if ($images) XPutImage(XtDisplay($), XtWindow($), $image_gc,
			   $images[$cur_image], 0, 0, x, y,
			   $images[$cur_image]->width,
			   $images[$cur_image]->height);
    if (region != NULL)
	XSetClipMask(XtDisplay($), $image_gc, None);
    #expose($, event, region);
}
.fi

.nf
Boolean  set_values(Widget  old, Widget  request, $, ArgList  args, Cardinal * num_args)
{
    Dimension wd, ht, dummy1, dummy2;
    Position x, y;
    XImage **p;
    Boolean restart = False;

    if ($old$images != $images) {
	if ($timer) restart = True;
	$stop_animation($);
	$compute_inside($, x, y, dummy1, dummy2);
	wd = 1; ht = 1;
	for (p = $images; *p; p++) {
	    if ((*p)->width > wd) wd = (*p)->width;
	    if ((*p)->height > ht) ht = (*p)->height;
	}
	XtVaSetValues($, XtNwidth, wd + 2*x, XtNheight, ht + 2*y, NULL);
    }
    if ($old$intervals != $intervals) {
	if ($timer) restart = True;
	$stop_animation($);
    }
    if (restart) $start_animation($);
    return False;
}
.fi

.hi

.hi
.SH "Utilities"

The timer callback routine checks if there is another image to
display, either the next image or the first image, if \fIcycle\fP is
\fITrue\fP. It determines the correct interval for the new image, which
can be the next number in \fIintervals\fP, or the previous number, if
there is no next, or the \fIdefaultInterval\fP, if there is no \fIinterval\fP
at all. It then re-installs itself as a time-out routine.

.nf
next_image(XtPointer  client_data, XtIntervalId * timer)
{
    Widget $ = (Widget) client_data;
    Cardinal delay;

    if ($images[$cur_image+1] == NULL) {
	if (! $cycle) return;			/* Nothing more */
	$cur_image = 0;
	$cur_interval = 0;
	if ($intervals == NULL || $intervals[0] == 0)
	    delay = $defaultInterval;
	else
	    delay = $intervals[0];
    } else {
	$cur_image++;
	if ($intervals == NULL)
	    delay = $defaultInterval;
	else if ($intervals[$cur_interval+1] == 0)
	    delay = $intervals[$cur_interval];
	else {
	    $cur_interval++;
	    delay = $intervals[$cur_interval];
	}
    }
    $expose($, NULL, NULL);
    $timer = XtAppAddTimeOut(XtWidgetToApplicationContext($), delay,
			     next_image, $);
}
.fi

The converter from a string to a list of images splits the string in
words separated by spaces and/or commas. Each word must be the name of
a file containing a pixmap in XPM format. The pixmap is read into an
\fIXImage\fP.

\fBdef\fP done(type, value) =
do {
      if (to->addr != NULL) {
	  if (to->size < sizeof(type)) {
	      to->size = sizeof(type);
	      return False;
	  }
	  *(type*)(to->addr) = (value);
      } else {
	  static type static_val;
	  static_val = (value);
	  to->addr = (XtPointer)static_val;
      }
      to->size = sizeof(type);
      return True;
  }while (0 )

.nf
Boolean  cvtStringToImageList(Display * display, XrmValuePtr  args, Cardinal * num_args, XrmValuePtr  from, XrmValuePtr  to, XtPointer * converter_data)
{
    String p;
    XImage *im, *shape, **list = NULL;
    int status, n = 0;
    Cardinal one = 1;

    if (*num_args != 0)
	XtAppErrorMsg
	    (XtDisplayToApplicationContext(display),
	     "cvtStringToImageList", "wrongParameters",
	     "XtToolkitError",
	     "String to image list type conversion needs no arguments", 
	     (String*) NULL, (Cardinal*) NULL);

    p = strtok((String) from->addr, " \\t\\n,");
    while (p) {
	status = XpmReadFileToImage(display, p, im, shape, NULL);
	switch (status) {
	case XpmOpenFailed:
	case XpmFileInvalid:
	case XpmNoMemory:
	    XtAppWarningMsg
		(XtDisplayToApplicationContext(display),
		 "cvtStringToImageList", "fileError",
		 "XtToolkitError",
		 "Failed to read image from \\"%s\\"",
		 p, one);
	    break;	    
	case XpmColorError:
	case XpmColorFailed:
	    XtAppWarningMsg
		(XtDisplayToApplicationContext(display),
		 "cvtStringToImageList", "allocColor",
		 "XtToolkitError",
		 "Could not get (all) colors for image \\"%s\\"",
		 p, one);
	case XpmSuccess:
	    n++;
	    list = (XImage**) XtRealloc((char*) list, n * sizeof(im));
	    list[n-1] = im;
	}
	p = strtok(NULL, " \\t\\n,");
    }
    if (n > 0) {
	n++;
	list = (XImage**) XtRealloc((char*) list, n * sizeof(im));
	list[n-1] = NULL;
    }
    done(XImage**, list);
}
.fi

.nf
Boolean  cvtStringToCardinalList(Display * display, XrmValuePtr  args, Cardinal * num_args, XrmValuePtr  from, XrmValuePtr  to, XtPointer * converter_data)
{
    String p;
    Cardinal *list = NULL;
    int n = 0, h, stat;

    if (*num_args != 0)
	XtAppErrorMsg
	    (XtDisplayToApplicationContext(display),
	     "cvtStringToCardinalList", "wrongParameters",
	     "XtToolkitError",
	     "String to cardinal list type conversion needs no arguments", 
	     (String*) NULL, (Cardinal*) NULL);

    p = (char *) from->addr;
    do {
	n++;
	list = (Cardinal*) XtRealloc((char*) list, n * sizeof(Cardinal));
	/* list[n-1] = strtoul(p, p, 0); */
	stat = sscanf(p, "%u%n", list[n-1], h);
	p = p + h;
    } while (stat == 1  list[n-1] != 0);
    list[n-1] = 0;
    done(Cardinal *, list);
}
.fi

.hi
