/* read_bitmap.c -- How to read a BITMAP *.  */

/* Copyright (C) 1988, 1990, 1992 Free Software Foundation, Inc.

   This file is part of GNU Finger.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <config.h>
#include <sys/types.h>
#include <sys/file.h>

#include <bitmap.h>

#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif

#ifndef L_SET
#define L_SET SEEK_SET
#define L_INCR SEEK_CUR
#endif /* !L_SET */

extern int errno;

BITMAP *
read_bitmap (user)
     char *user;
{
  BITMAP *face = (BITMAP *)NULL;
  char *filename = mugshot_filename (user, 1);
  int file;

  file = open (filename, O_RDONLY);
  free (filename);

  if (!file)
    return ((BITMAP *)NULL);

  face = (BITMAP *)xmalloc (sizeof (BITMAP));

  read (file, &face->width, sizeof (face->width));
  read (file, &face->height, sizeof (face->height));
  read (file, &face->rowlen, sizeof (face->rowlen));

  face->bits = (byte *)xmalloc (face->rowlen * face->height);
  read (file, face->bits, face->rowlen * face->height);

  close (file);
  return (face);
}

