/* What a finger/face bitmap looks like.  Everywhere.  Even if you
   don't have bitmaps. */

/* Copyright (C) 1988,1990,1992 Free Software Foundation, Inc.

   This file is part of GNU Finger.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#if !defined (_BITMAP_H_)
#define _BITMAP_H_

/* Boundary to which each row of the bitmap is expected to be padded. */
#define BOUNDARY 16
#define ROWBYTES(w) ((((w) + (BOUNDARY - 1)) / BOUNDARY) * (BOUNDARY / 8))

#define BYTESWAP(x) { char *t = (char *)&(x), u; u = *t; *t = t[1]; t[1] = u; }

#ifndef NULL
#define NULL 0x0
#endif

#ifndef byte
#define byte unsigned char
#endif

/* The structure that defines what a bitmap looks like. */
typedef struct {
  int width;			/* Width in bits. */
  int height;			/* Height in bits. */
  int rowlen;			/* Number of bytes in each row. */
  byte *bits;			/* Location of the bits. */
} BITMAP;

#if defined (MugShotPath)
#define MUGSHOT_PATH MugShotPath
#else
#define MUGSHOT_PATH "/usr/local/lib/mugshots:/usr/local/mugshots"
#endif

/* Useful functions supplied by this file. */

/* Modify the bitmap pointed to by FACE so that each row is
   padded to WORD_SIZE.  To pad to a single byte, WORD_SIZE should
   be 1, 16-bit boundary is 2, etc. */
void pad_face ();

/* Return a malloc'ed string which is the name of a mugshot file for USER.
   Search through the list of possible pathnames taken from the environment
   variable `MUGSHOT_PATH', or defaulting to the CPP variable MUGSHOT_PATH.
   If the file exists, return that name, otherwise return the first possible
   filename for USER. */
char *mugshot_filename ();	/* mugshot_filename (char *user) */

/* Some machines expect the bit ordering to be in one order, some in 
   another order.  This function changes the LSBit to MSBit in each
   byte of BITMAP. */
void reverse_image_bit_order ();

/* Some machines have 0 as white and 1 as black.  Swap the bits in BITMAP. */
void invert_image_bits ();

#endif  /* _BITMAP_H_ */
