/* estr.c generated by valac 0.56.17, the Vala compiler
 * generated from estr.vala, do not modify */

/* Dynamically-allocated strings with line ending encoding.

   Copyright (c) 2011-2020 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */

#define _GNU_SOURCE

#include "estr.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _immutable_estr_unref0(var) ((var == NULL) ? NULL : (var = (immutable_estr_unref (var), NULL)))
typedef struct _ParamSpecImmutableEstr ParamSpecImmutableEstr;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ImmutableEstrPrivate {
	gchar* _text;
	gsize _length;
	gchar* _eol;
};

struct _ParamSpecImmutableEstr {
	GParamSpec parent_instance;
};

struct _EstrPrivate {
	gsize buf_size;
};

static gint ImmutableEstr_private_offset;
static gpointer immutable_estr_parent_class = NULL;
ImmutableEstr* immutable_estr_empty = NULL;
static gint Estr_private_offset;
static gpointer estr_parent_class = NULL;

static gchar* immutable_estr_memrmem (ImmutableEstr* self,
                               gchar* s,
                               gsize slen,
                               gchar* t,
                               gsize tlen);
static void immutable_estr_finalize (ImmutableEstr * obj);
static GType immutable_estr_get_type_once (void);
static Estr* estr_new (void);
static Estr* estr_construct (GType object_type);
static void estr_resize (Estr* self,
                  gsize length);
static void estr_finalize (ImmutableEstr * obj);
static GType estr_get_type_once (void);

static inline gpointer
immutable_estr_get_instance_private (ImmutableEstr* self)
{
	return G_STRUCT_MEMBER_P (self, ImmutableEstr_private_offset);
}

ImmutableEstr*
immutable_estr_of (const gchar* text,
                   gsize length,
                   const gchar* eol)
{
	ImmutableEstr* es = NULL;
	ImmutableEstr* _tmp0_;
	ImmutableEstr* result;
#line 44 "src/estr.vala"
	g_return_val_if_fail (text != NULL, NULL);
#line 44 "src/estr.vala"
	g_return_val_if_fail (eol != NULL, NULL);
#line 45 "src/estr.vala"
	_tmp0_ = immutable_estr_new ();
#line 45 "src/estr.vala"
	es = _tmp0_;
#line 46 "src/estr.vala"
	immutable_estr_set_text (es, text);
#line 47 "src/estr.vala"
	immutable_estr_set_length (es, length);
#line 48 "src/estr.vala"
	immutable_estr_set_eol (es, eol);
#line 49 "src/estr.vala"
	result = es;
#line 49 "src/estr.vala"
	return result;
#line 117 "estr.c"
}

ImmutableEstr*
immutable_estr_substring (ImmutableEstr* self,
                          gsize pos,
                          gsize length)
{
	ImmutableEstr* es = NULL;
	ImmutableEstr* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	ImmutableEstr* result;
#line 52 "src/estr.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 53 "src/estr.vala"
	_tmp0_ = immutable_estr_new ();
#line 53 "src/estr.vala"
	es = _tmp0_;
#line 54 "src/estr.vala"
	_tmp1_ = self->priv->_text;
#line 54 "src/estr.vala"
	immutable_estr_set_text (es, _tmp1_ + pos);
#line 55 "src/estr.vala"
	immutable_estr_set_length (es, length);
#line 56 "src/estr.vala"
	_tmp2_ = self->priv->_eol;
#line 56 "src/estr.vala"
	immutable_estr_set_eol (es, _tmp2_);
#line 57 "src/estr.vala"
	result = es;
#line 57 "src/estr.vala"
	return result;
#line 150 "estr.c"
}

gsize
immutable_estr_prev_line (ImmutableEstr* self,
                          gsize o)
{
	gsize so = 0UL;
	gulong _tmp0_ = 0UL;
	gsize result;
#line 60 "src/estr.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 61 "src/estr.vala"
	so = immutable_estr_start_of_line (self, o);
#line 62 "src/estr.vala"
	if (so == ((gsize) 0)) {
#line 62 "src/estr.vala"
		_tmp0_ = G_MAXSIZE;
#line 168 "estr.c"
	} else {
		const gchar* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
#line 62 "src/estr.vala"
		_tmp1_ = self->priv->_eol;
#line 62 "src/estr.vala"
		_tmp2_ = strlen (_tmp1_);
#line 62 "src/estr.vala"
		_tmp3_ = _tmp2_;
#line 62 "src/estr.vala"
		_tmp0_ = (gulong) immutable_estr_start_of_line (self, so - _tmp3_);
#line 181 "estr.c"
	}
#line 62 "src/estr.vala"
	result = (gsize) _tmp0_;
#line 62 "src/estr.vala"
	return result;
#line 187 "estr.c"
}

gsize
immutable_estr_next_line (ImmutableEstr* self,
                          gsize o)
{
	gsize eo = 0UL;
	gulong _tmp0_ = 0UL;
	gsize _tmp1_;
	gsize result;
#line 65 "src/estr.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 66 "src/estr.vala"
	eo = immutable_estr_end_of_line (self, o);
#line 67 "src/estr.vala"
	_tmp1_ = self->priv->_length;
#line 67 "src/estr.vala"
	if (eo == _tmp1_) {
#line 67 "src/estr.vala"
		_tmp0_ = G_MAXSIZE;
#line 208 "estr.c"
	} else {
		const gchar* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
#line 67 "src/estr.vala"
		_tmp2_ = self->priv->_eol;
#line 67 "src/estr.vala"
		_tmp3_ = strlen (_tmp2_);
#line 67 "src/estr.vala"
		_tmp4_ = _tmp3_;
#line 67 "src/estr.vala"
		_tmp0_ = (gulong) (eo + _tmp4_);
#line 221 "estr.c"
	}
#line 67 "src/estr.vala"
	result = (gsize) _tmp0_;
#line 67 "src/estr.vala"
	return result;
#line 227 "estr.c"
}

static gchar*
immutable_estr_memrmem (ImmutableEstr* self,
                        gchar* s,
                        gsize slen,
                        gchar* t,
                        gsize tlen)
{
	gchar* result;
#line 70 "src/estr.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 71 "src/estr.vala"
	if (slen >= tlen) {
#line 242 "estr.c"
		gsize i = 0UL;
#line 72 "src/estr.vala"
		i = slen - tlen;
#line 246 "estr.c"
		{
			gboolean _tmp0_ = FALSE;
#line 73 "src/estr.vala"
			_tmp0_ = TRUE;
#line 73 "src/estr.vala"
			while (TRUE) {
#line 73 "src/estr.vala"
				if (!_tmp0_) {
#line 255 "estr.c"
					gsize _tmp1_;
#line 76 "src/estr.vala"
					_tmp1_ = i;
#line 76 "src/estr.vala"
					i = _tmp1_ - 1;
#line 76 "src/estr.vala"
					if (!(_tmp1_ != ((gsize) 0))) {
#line 76 "src/estr.vala"
						break;
#line 265 "estr.c"
					}
				}
#line 73 "src/estr.vala"
				_tmp0_ = FALSE;
#line 74 "src/estr.vala"
				if (memcmp (s + i, t, tlen) == 0) {
#line 75 "src/estr.vala"
					result = s + i;
#line 75 "src/estr.vala"
					return result;
#line 276 "estr.c"
				}
			}
		}
	}
#line 78 "src/estr.vala"
	result = NULL;
#line 78 "src/estr.vala"
	return result;
#line 285 "estr.c"
}

gsize
immutable_estr_start_of_line (ImmutableEstr* self,
                              gsize o)
{
	gchar* prev = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	gsize _tmp6_ = 0UL;
	gchar* _tmp7_;
	gsize result;
#line 81 "src/estr.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 82 "src/estr.vala"
	_tmp0_ = self->priv->_text;
#line 82 "src/estr.vala"
	_tmp1_ = self->priv->_eol;
#line 82 "src/estr.vala"
	_tmp2_ = self->priv->_eol;
#line 82 "src/estr.vala"
	_tmp3_ = strlen (_tmp2_);
#line 82 "src/estr.vala"
	_tmp4_ = _tmp3_;
#line 82 "src/estr.vala"
	_tmp5_ = immutable_estr_memrmem (self, (const gchar*) _tmp0_, (gsize) ((gssize) o), _tmp1_, (gsize) _tmp4_);
#line 82 "src/estr.vala"
	prev = _tmp5_;
#line 83 "src/estr.vala"
	_tmp7_ = prev;
#line 83 "src/estr.vala"
	if (_tmp7_ != NULL) {
#line 322 "estr.c"
		gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
#line 83 "src/estr.vala"
		_tmp8_ = prev;
#line 83 "src/estr.vala"
		_tmp9_ = self->priv->_text;
#line 83 "src/estr.vala"
		_tmp10_ = self->priv->_eol;
#line 83 "src/estr.vala"
		_tmp11_ = strlen (_tmp10_);
#line 83 "src/estr.vala"
		_tmp12_ = _tmp11_;
#line 83 "src/estr.vala"
		_tmp6_ = (_tmp8_ - _tmp9_) + _tmp12_;
#line 340 "estr.c"
	} else {
#line 83 "src/estr.vala"
		_tmp6_ = (gsize) 0;
#line 344 "estr.c"
	}
#line 83 "src/estr.vala"
	result = _tmp6_;
#line 83 "src/estr.vala"
	return result;
#line 350 "estr.c"
}

gsize
immutable_estr_end_of_line (ImmutableEstr* self,
                            gsize o)
{
	gchar* next = NULL;
	gchar* _tmp0_;
	gsize _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
	gsize _tmp7_ = 0UL;
	gchar* _tmp8_;
	gsize result;
#line 86 "src/estr.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 87 "src/estr.vala"
	_tmp0_ = self->priv->_text;
#line 87 "src/estr.vala"
	_tmp1_ = self->priv->_length;
#line 87 "src/estr.vala"
	_tmp2_ = self->priv->_eol;
#line 87 "src/estr.vala"
	_tmp3_ = self->priv->_eol;
#line 87 "src/estr.vala"
	_tmp4_ = strlen (_tmp3_);
#line 87 "src/estr.vala"
	_tmp5_ = _tmp4_;
#line 87 "src/estr.vala"
	_tmp6_ = memmem ((const gchar*) (_tmp0_ + o), (gsize) ((gssize) (_tmp1_ - o)), _tmp2_, (gsize) _tmp5_);
#line 87 "src/estr.vala"
	next = _tmp6_;
#line 88 "src/estr.vala"
	_tmp8_ = next;
#line 88 "src/estr.vala"
	if (_tmp8_ != NULL) {
#line 390 "estr.c"
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 88 "src/estr.vala"
		_tmp9_ = next;
#line 88 "src/estr.vala"
		_tmp10_ = self->priv->_text;
#line 88 "src/estr.vala"
		_tmp7_ = (gsize) (_tmp9_ - _tmp10_);
#line 399 "estr.c"
	} else {
		gsize _tmp11_;
#line 88 "src/estr.vala"
		_tmp11_ = self->priv->_length;
#line 88 "src/estr.vala"
		_tmp7_ = _tmp11_;
#line 406 "estr.c"
	}
#line 88 "src/estr.vala"
	result = _tmp7_;
#line 88 "src/estr.vala"
	return result;
#line 412 "estr.c"
}

gsize
immutable_estr_lines (ImmutableEstr* self)
{
	gchar* s = NULL;
	gchar* _tmp0_;
	gchar* next = NULL;
	gsize lines = 0UL;
	gsize result;
#line 91 "src/estr.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 92 "src/estr.vala"
	_tmp0_ = self->priv->_text;
#line 92 "src/estr.vala"
	s = _tmp0_;
#line 93 "src/estr.vala"
	next = NULL;
#line 94 "src/estr.vala"
	lines = (gsize) 0;
#line 433 "estr.c"
	{
		gsize len = 0UL;
		gsize _tmp1_;
#line 95 "src/estr.vala"
		_tmp1_ = self->priv->_length;
#line 95 "src/estr.vala"
		len = _tmp1_;
#line 441 "estr.c"
		{
			gboolean _tmp2_ = FALSE;
#line 95 "src/estr.vala"
			_tmp2_ = TRUE;
#line 95 "src/estr.vala"
			while (TRUE) {
#line 448 "estr.c"
				gchar* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gsize _tmp19_;
#line 95 "src/estr.vala"
				if (!_tmp2_) {
#line 459 "estr.c"
					gchar* _tmp3_;
					gchar* _tmp4_;
					const gchar* _tmp5_;
					gint _tmp6_;
					gint _tmp7_;
					gchar* _tmp8_;
					const gchar* _tmp9_;
					gint _tmp10_;
					gint _tmp11_;
#line 97 "src/estr.vala"
					_tmp3_ = next;
#line 97 "src/estr.vala"
					_tmp4_ = s;
#line 97 "src/estr.vala"
					_tmp5_ = self->priv->_eol;
#line 97 "src/estr.vala"
					_tmp6_ = strlen (_tmp5_);
#line 97 "src/estr.vala"
					_tmp7_ = _tmp6_;
#line 97 "src/estr.vala"
					len -= ((gsize) (_tmp3_ - _tmp4_)) + _tmp7_;
#line 97 "src/estr.vala"
					_tmp8_ = next;
#line 97 "src/estr.vala"
					_tmp9_ = self->priv->_eol;
#line 97 "src/estr.vala"
					_tmp10_ = strlen (_tmp9_);
#line 97 "src/estr.vala"
					_tmp11_ = _tmp10_;
#line 97 "src/estr.vala"
					s = _tmp8_ + _tmp11_;
#line 491 "estr.c"
				}
#line 95 "src/estr.vala"
				_tmp2_ = FALSE;
#line 96 "src/estr.vala"
				_tmp12_ = s;
#line 96 "src/estr.vala"
				_tmp13_ = self->priv->_eol;
#line 96 "src/estr.vala"
				_tmp14_ = self->priv->_eol;
#line 96 "src/estr.vala"
				_tmp15_ = strlen (_tmp14_);
#line 96 "src/estr.vala"
				_tmp16_ = _tmp15_;
#line 96 "src/estr.vala"
				_tmp17_ = memmem ((const gchar*) _tmp12_, (gsize) ((gssize) len), _tmp13_, (gsize) _tmp16_);
#line 96 "src/estr.vala"
				next = _tmp17_;
#line 96 "src/estr.vala"
				_tmp18_ = next;
#line 96 "src/estr.vala"
				if (!(_tmp18_ != NULL)) {
#line 96 "src/estr.vala"
					break;
#line 515 "estr.c"
				}
#line 98 "src/estr.vala"
				_tmp19_ = lines;
#line 98 "src/estr.vala"
				lines = _tmp19_ + 1;
#line 521 "estr.c"
			}
		}
	}
#line 99 "src/estr.vala"
	result = lines;
#line 99 "src/estr.vala"
	return result;
#line 529 "estr.c"
}

gsize
immutable_estr_len_with_eol (ImmutableEstr* self,
                             const gchar* eol_type)
{
	gsize _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gsize result;
#line 106 "src/estr.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 106 "src/estr.vala"
	g_return_val_if_fail (eol_type != NULL, 0UL);
#line 107 "src/estr.vala"
	_tmp0_ = self->priv->_length;
#line 107 "src/estr.vala"
	_tmp1_ = strlen (eol_type);
#line 107 "src/estr.vala"
	_tmp2_ = _tmp1_;
#line 107 "src/estr.vala"
	_tmp3_ = self->priv->_eol;
#line 107 "src/estr.vala"
	_tmp4_ = strlen (_tmp3_);
#line 107 "src/estr.vala"
	_tmp5_ = _tmp4_;
#line 107 "src/estr.vala"
	result = _tmp0_ + (immutable_estr_lines (self) * (_tmp2_ - _tmp5_));
#line 107 "src/estr.vala"
	return result;
#line 563 "estr.c"
}

ImmutableEstr*
immutable_estr_construct (GType object_type)
{
	ImmutableEstr* self = NULL;
#line 20 "src/estr.vala"
	self = (ImmutableEstr*) g_type_create_instance (object_type);
#line 20 "src/estr.vala"
	return self;
#line 574 "estr.c"
}

ImmutableEstr*
immutable_estr_new (void)
{
#line 20 "src/estr.vala"
	return immutable_estr_construct (TYPE_IMMUTABLE_ESTR);
#line 582 "estr.c"
}

gchar*
immutable_estr_get_text (ImmutableEstr* self)
{
	gchar* result;
	gchar* _tmp0_;
#line 27 "src/estr.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 27 "src/estr.vala"
	_tmp0_ = self->priv->_text;
#line 27 "src/estr.vala"
	result = _tmp0_;
#line 27 "src/estr.vala"
	return result;
#line 598 "estr.c"
}

void
immutable_estr_set_text (ImmutableEstr* self,
                         gchar* value)
{
#line 27 "src/estr.vala"
	g_return_if_fail (self != NULL);
#line 27 "src/estr.vala"
	self->priv->_text = value;
#line 609 "estr.c"
}

gsize
immutable_estr_get_length (ImmutableEstr* self)
{
	gsize result;
#line 28 "src/estr.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 28 "src/estr.vala"
	result = self->priv->_length;
#line 28 "src/estr.vala"
	return result;
#line 622 "estr.c"
}

void
immutable_estr_set_length (ImmutableEstr* self,
                           gsize value)
{
#line 28 "src/estr.vala"
	g_return_if_fail (self != NULL);
#line 28 "src/estr.vala"
	self->priv->_length = value;
#line 633 "estr.c"
}

const gchar*
immutable_estr_get_eol (ImmutableEstr* self)
{
	const gchar* result;
	const gchar* _tmp0_;
#line 29 "src/estr.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 29 "src/estr.vala"
	_tmp0_ = self->priv->_eol;
#line 29 "src/estr.vala"
	result = _tmp0_;
#line 29 "src/estr.vala"
	return result;
#line 649 "estr.c"
}

void
immutable_estr_set_eol (ImmutableEstr* self,
                        const gchar* value)
{
	gchar* _tmp0_;
#line 29 "src/estr.vala"
	g_return_if_fail (self != NULL);
#line 29 "src/estr.vala"
	_tmp0_ = g_strdup (value);
#line 29 "src/estr.vala"
	_g_free0 (self->priv->_eol);
#line 29 "src/estr.vala"
	self->priv->_eol = _tmp0_;
#line 665 "estr.c"
}

static void
value_immutable_estr_init (GValue* value)
{
#line 20 "src/estr.vala"
	value->data[0].v_pointer = NULL;
#line 673 "estr.c"
}

static void
value_immutable_estr_free_value (GValue* value)
{
#line 20 "src/estr.vala"
	if (value->data[0].v_pointer) {
#line 20 "src/estr.vala"
		immutable_estr_unref (value->data[0].v_pointer);
#line 683 "estr.c"
	}
}

static void
value_immutable_estr_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
#line 20 "src/estr.vala"
	if (src_value->data[0].v_pointer) {
#line 20 "src/estr.vala"
		dest_value->data[0].v_pointer = immutable_estr_ref (src_value->data[0].v_pointer);
#line 695 "estr.c"
	} else {
#line 20 "src/estr.vala"
		dest_value->data[0].v_pointer = NULL;
#line 699 "estr.c"
	}
}

static gpointer
value_immutable_estr_peek_pointer (const GValue* value)
{
#line 20 "src/estr.vala"
	return value->data[0].v_pointer;
#line 708 "estr.c"
}

static gchar*
value_immutable_estr_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
#line 20 "src/estr.vala"
	if (collect_values[0].v_pointer) {
#line 719 "estr.c"
		ImmutableEstr * object;
		object = collect_values[0].v_pointer;
#line 20 "src/estr.vala"
		if (object->parent_instance.g_class == NULL) {
#line 20 "src/estr.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 726 "estr.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 20 "src/estr.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 730 "estr.c"
		}
#line 20 "src/estr.vala"
		value->data[0].v_pointer = immutable_estr_ref (object);
#line 734 "estr.c"
	} else {
#line 20 "src/estr.vala"
		value->data[0].v_pointer = NULL;
#line 738 "estr.c"
	}
#line 20 "src/estr.vala"
	return NULL;
#line 742 "estr.c"
}

static gchar*
value_immutable_estr_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	ImmutableEstr ** object_p;
	object_p = collect_values[0].v_pointer;
#line 20 "src/estr.vala"
	if (!object_p) {
#line 20 "src/estr.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 757 "estr.c"
	}
#line 20 "src/estr.vala"
	if (!value->data[0].v_pointer) {
#line 20 "src/estr.vala"
		*object_p = NULL;
#line 763 "estr.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 20 "src/estr.vala"
		*object_p = value->data[0].v_pointer;
#line 767 "estr.c"
	} else {
#line 20 "src/estr.vala"
		*object_p = immutable_estr_ref (value->data[0].v_pointer);
#line 771 "estr.c"
	}
#line 20 "src/estr.vala"
	return NULL;
#line 775 "estr.c"
}

GParamSpec*
param_spec_immutable_estr (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	ParamSpecImmutableEstr* spec;
#line 20 "src/estr.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_IMMUTABLE_ESTR), NULL);
#line 20 "src/estr.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 20 "src/estr.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 20 "src/estr.vala"
	return G_PARAM_SPEC (spec);
#line 794 "estr.c"
}

gpointer
value_get_immutable_estr (const GValue* value)
{
#line 20 "src/estr.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_IMMUTABLE_ESTR), NULL);
#line 20 "src/estr.vala"
	return value->data[0].v_pointer;
#line 804 "estr.c"
}

void
value_set_immutable_estr (GValue* value,
                          gpointer v_object)
{
	ImmutableEstr * old;
#line 20 "src/estr.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_IMMUTABLE_ESTR));
#line 20 "src/estr.vala"
	old = value->data[0].v_pointer;
#line 20 "src/estr.vala"
	if (v_object) {
#line 20 "src/estr.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_IMMUTABLE_ESTR));
#line 20 "src/estr.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "src/estr.vala"
		value->data[0].v_pointer = v_object;
#line 20 "src/estr.vala"
		immutable_estr_ref (value->data[0].v_pointer);
#line 826 "estr.c"
	} else {
#line 20 "src/estr.vala"
		value->data[0].v_pointer = NULL;
#line 830 "estr.c"
	}
#line 20 "src/estr.vala"
	if (old) {
#line 20 "src/estr.vala"
		immutable_estr_unref (old);
#line 836 "estr.c"
	}
}

void
value_take_immutable_estr (GValue* value,
                           gpointer v_object)
{
	ImmutableEstr * old;
#line 20 "src/estr.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_IMMUTABLE_ESTR));
#line 20 "src/estr.vala"
	old = value->data[0].v_pointer;
#line 20 "src/estr.vala"
	if (v_object) {
#line 20 "src/estr.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_IMMUTABLE_ESTR));
#line 20 "src/estr.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "src/estr.vala"
		value->data[0].v_pointer = v_object;
#line 857 "estr.c"
	} else {
#line 20 "src/estr.vala"
		value->data[0].v_pointer = NULL;
#line 861 "estr.c"
	}
#line 20 "src/estr.vala"
	if (old) {
#line 20 "src/estr.vala"
		immutable_estr_unref (old);
#line 867 "estr.c"
	}
}

static void
immutable_estr_class_init (ImmutableEstrClass * klass,
                           gpointer klass_data)
{
	ImmutableEstr* _tmp0_;
#line 20 "src/estr.vala"
	immutable_estr_parent_class = g_type_class_peek_parent (klass);
#line 20 "src/estr.vala"
	((ImmutableEstrClass *) klass)->finalize = immutable_estr_finalize;
#line 20 "src/estr.vala"
	g_type_class_adjust_private_offset (klass, &ImmutableEstr_private_offset);
#line 38 "src/estr.vala"
	_tmp0_ = immutable_estr_of ("", (gsize) 0, IMMUTABLE_ESTR_eol_lf);
#line 38 "src/estr.vala"
	_immutable_estr_unref0 (immutable_estr_empty);
#line 38 "src/estr.vala"
	immutable_estr_empty = _tmp0_;
#line 888 "estr.c"
}

static void
immutable_estr_instance_init (ImmutableEstr * self,
                              gpointer klass)
{
#line 20 "src/estr.vala"
	self->priv = immutable_estr_get_instance_private (self);
#line 20 "src/estr.vala"
	self->ref_count = 1;
#line 899 "estr.c"
}

static void
immutable_estr_finalize (ImmutableEstr * obj)
{
	ImmutableEstr * self;
#line 20 "src/estr.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IMMUTABLE_ESTR, ImmutableEstr);
#line 20 "src/estr.vala"
	g_signal_handlers_destroy (self);
#line 29 "src/estr.vala"
	_g_free0 (self->priv->_eol);
#line 912 "estr.c"
}

static GType
immutable_estr_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_immutable_estr_init, value_immutable_estr_free_value, value_immutable_estr_copy_value, value_immutable_estr_peek_pointer, "p", value_immutable_estr_collect_value, "p", value_immutable_estr_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ImmutableEstrClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) immutable_estr_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ImmutableEstr), 0, (GInstanceInitFunc) immutable_estr_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType immutable_estr_type_id;
	immutable_estr_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ImmutableEstr", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ImmutableEstr_private_offset = g_type_add_instance_private (immutable_estr_type_id, sizeof (ImmutableEstrPrivate));
	return immutable_estr_type_id;
}

GType
immutable_estr_get_type (void)
{
	static volatile gsize immutable_estr_type_id__once = 0;
	if (g_once_init_enter (&immutable_estr_type_id__once)) {
		GType immutable_estr_type_id;
		immutable_estr_type_id = immutable_estr_get_type_once ();
		g_once_init_leave (&immutable_estr_type_id__once, immutable_estr_type_id);
	}
	return immutable_estr_type_id__once;
}

gpointer
immutable_estr_ref (gpointer instance)
{
	ImmutableEstr * self;
	self = instance;
#line 20 "src/estr.vala"
	g_atomic_int_inc (&self->ref_count);
#line 20 "src/estr.vala"
	return instance;
#line 948 "estr.c"
}

void
immutable_estr_unref (gpointer instance)
{
	ImmutableEstr * self;
	self = instance;
#line 20 "src/estr.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 20 "src/estr.vala"
		IMMUTABLE_ESTR_GET_CLASS (self)->finalize (self);
#line 20 "src/estr.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 962 "estr.c"
	}
}

static inline gpointer
estr_get_instance_private (Estr* self)
{
	return G_STRUCT_MEMBER_P (self, Estr_private_offset);
}

static Estr*
estr_construct (GType object_type)
{
	Estr* self = NULL;
#line 116 "src/estr.vala"
	self = (Estr*) immutable_estr_construct (object_type);
#line 116 "src/estr.vala"
	return self;
#line 980 "estr.c"
}

static Estr*
estr_new (void)
{
#line 116 "src/estr.vala"
	return estr_construct (TYPE_ESTR);
#line 988 "estr.c"
}

Estr*
estr_of_empty (const gchar* eol)
{
	Estr* es = NULL;
	Estr* _tmp0_;
	void* _tmp1_;
	Estr* result;
#line 121 "src/estr.vala"
	g_return_val_if_fail (eol != NULL, NULL);
#line 122 "src/estr.vala"
	_tmp0_ = estr_new ();
#line 122 "src/estr.vala"
	es = _tmp0_;
#line 123 "src/estr.vala"
	es->priv->buf_size = (gsize) ESTR_ALLOCATION_CHUNK_SIZE;
#line 124 "src/estr.vala"
	immutable_estr_set_length ((ImmutableEstr*) es, (gsize) 0);
#line 125 "src/estr.vala"
	_tmp1_ = g_malloc0 (es->priv->buf_size + 1);
#line 125 "src/estr.vala"
	immutable_estr_set_text ((ImmutableEstr*) es, _tmp1_);
#line 126 "src/estr.vala"
	immutable_estr_set_eol ((ImmutableEstr*) es, eol);
#line 127 "src/estr.vala"
	result = es;
#line 127 "src/estr.vala"
	return result;
#line 1018 "estr.c"
}

Estr*
estr_copy (ImmutableEstr* ies)
{
	Estr* es = NULL;
	Estr* _tmp0_;
	Estr* result;
#line 130 "src/estr.vala"
	g_return_val_if_fail (ies != NULL, NULL);
#line 131 "src/estr.vala"
	_tmp0_ = estr_of_empty (IMMUTABLE_ESTR_eol_lf);
#line 131 "src/estr.vala"
	es = _tmp0_;
#line 132 "src/estr.vala"
	estr_cat (es, ies);
#line 133 "src/estr.vala"
	result = es;
#line 133 "src/estr.vala"
	return result;
#line 1039 "estr.c"
}

void
estr_set_char (Estr* self,
               gsize pos,
               gchar c)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 140 "src/estr.vala"
	g_return_if_fail (self != NULL);
#line 141 "src/estr.vala"
	_tmp0_ = immutable_estr_get_text ((ImmutableEstr*) self);
#line 141 "src/estr.vala"
	_tmp1_ = _tmp0_;
#line 141 "src/estr.vala"
	_tmp1_[pos] = c;
#line 1057 "estr.c"
}

static void
estr_resize (Estr* self,
             gsize length)
{
	gboolean _tmp0_ = FALSE;
	gchar* _tmp4_;
	gchar* _tmp5_;
#line 148 "src/estr.vala"
	g_return_if_fail (self != NULL);
#line 149 "src/estr.vala"
	if (length > self->priv->buf_size) {
#line 149 "src/estr.vala"
		_tmp0_ = TRUE;
#line 1073 "estr.c"
	} else {
#line 149 "src/estr.vala"
		_tmp0_ = length < (self->priv->buf_size / 2);
#line 1077 "estr.c"
	}
#line 149 "src/estr.vala"
	if (_tmp0_) {
#line 1081 "estr.c"
		gchar* _tmp1_;
		gchar* _tmp2_;
		void* _tmp3_;
#line 150 "src/estr.vala"
		self->priv->buf_size = length + ESTR_ALLOCATION_CHUNK_SIZE;
#line 151 "src/estr.vala"
		_tmp1_ = immutable_estr_get_text ((ImmutableEstr*) self);
#line 151 "src/estr.vala"
		_tmp2_ = _tmp1_;
#line 151 "src/estr.vala"
		_tmp3_ = g_realloc (_tmp2_, self->priv->buf_size + 1);
#line 151 "src/estr.vala"
		immutable_estr_set_text ((ImmutableEstr*) self, _tmp3_);
#line 1095 "estr.c"
	}
#line 153 "src/estr.vala"
	immutable_estr_set_length ((ImmutableEstr*) self, length);
#line 154 "src/estr.vala"
	_tmp4_ = immutable_estr_get_text ((ImmutableEstr*) self);
#line 154 "src/estr.vala"
	_tmp5_ = _tmp4_;
#line 154 "src/estr.vala"
	_tmp5_[length] = '\0';
#line 1105 "estr.c"
}

void
estr_set_eol_from_text (Estr* self)
{
#line 159 "src/estr.vala"
	static const gint MAX_EOL_CHECK_COUNT = 3;
#line 1113 "estr.c"
	gboolean first_eol = FALSE;
	gsize total_eols = 0UL;
#line 158 "src/estr.vala"
	g_return_if_fail (self != NULL);
#line 160 "src/estr.vala"
	first_eol = TRUE;
#line 161 "src/estr.vala"
	total_eols = (gsize) 0;
#line 162 "src/estr.vala"
	immutable_estr_set_eol ((ImmutableEstr*) self, IMMUTABLE_ESTR_eol_lf);
#line 1124 "estr.c"
	{
		gsize i = 0UL;
#line 163 "src/estr.vala"
		i = (gsize) 0;
#line 1129 "estr.c"
		{
			gboolean _tmp0_ = FALSE;
#line 163 "src/estr.vala"
			_tmp0_ = TRUE;
#line 163 "src/estr.vala"
			while (TRUE) {
#line 1136 "estr.c"
				gboolean _tmp2_ = FALSE;
				gsize _tmp3_;
				gsize _tmp4_;
				gchar c = '\0';
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar _tmp7_;
				gboolean _tmp8_ = FALSE;
#line 163 "src/estr.vala"
				if (!_tmp0_) {
#line 1147 "estr.c"
					gsize _tmp1_;
#line 163 "src/estr.vala"
					_tmp1_ = i;
#line 163 "src/estr.vala"
					i = _tmp1_ + 1;
#line 1153 "estr.c"
				}
#line 163 "src/estr.vala"
				_tmp0_ = FALSE;
#line 163 "src/estr.vala"
				_tmp3_ = immutable_estr_get_length ((ImmutableEstr*) self);
#line 163 "src/estr.vala"
				_tmp4_ = _tmp3_;
#line 163 "src/estr.vala"
				if (i < _tmp4_) {
#line 163 "src/estr.vala"
					_tmp2_ = total_eols < ((gsize) MAX_EOL_CHECK_COUNT);
#line 1165 "estr.c"
				} else {
#line 163 "src/estr.vala"
					_tmp2_ = FALSE;
#line 1169 "estr.c"
				}
#line 163 "src/estr.vala"
				if (!_tmp2_) {
#line 163 "src/estr.vala"
					break;
#line 1175 "estr.c"
				}
#line 164 "src/estr.vala"
				_tmp5_ = immutable_estr_get_text ((ImmutableEstr*) self);
#line 164 "src/estr.vala"
				_tmp6_ = _tmp5_;
#line 164 "src/estr.vala"
				_tmp7_ = _tmp6_[i];
#line 164 "src/estr.vala"
				c = _tmp7_;
#line 165 "src/estr.vala"
				if (c == '\n') {
#line 165 "src/estr.vala"
					_tmp8_ = TRUE;
#line 1189 "estr.c"
				} else {
#line 165 "src/estr.vala"
					_tmp8_ = c == '\r';
#line 1193 "estr.c"
				}
#line 165 "src/estr.vala"
				if (_tmp8_) {
#line 1197 "estr.c"
					gchar* this_eol_type = NULL;
					gsize _tmp9_;
#line 167 "src/estr.vala"
					_tmp9_ = total_eols;
#line 167 "src/estr.vala"
					total_eols = _tmp9_ + 1;
#line 168 "src/estr.vala"
					if (c == '\n') {
#line 1206 "estr.c"
						gchar* _tmp10_;
#line 169 "src/estr.vala"
						_tmp10_ = g_strdup (IMMUTABLE_ESTR_eol_lf);
#line 169 "src/estr.vala"
						_g_free0 (this_eol_type);
#line 169 "src/estr.vala"
						this_eol_type = _tmp10_;
#line 1214 "estr.c"
					} else {
						gboolean _tmp11_ = FALSE;
						gsize _tmp12_;
						gsize _tmp13_;
#line 170 "src/estr.vala"
						_tmp12_ = immutable_estr_get_length ((ImmutableEstr*) self);
#line 170 "src/estr.vala"
						_tmp13_ = _tmp12_;
#line 170 "src/estr.vala"
						if (i == (_tmp13_ - 1)) {
#line 170 "src/estr.vala"
							_tmp11_ = TRUE;
#line 1227 "estr.c"
						} else {
							gchar* _tmp14_;
							gchar* _tmp15_;
							gchar _tmp16_;
#line 170 "src/estr.vala"
							_tmp14_ = immutable_estr_get_text ((ImmutableEstr*) self);
#line 170 "src/estr.vala"
							_tmp15_ = _tmp14_;
#line 170 "src/estr.vala"
							_tmp16_ = _tmp15_[i + 1];
#line 170 "src/estr.vala"
							_tmp11_ = _tmp16_ != '\n';
#line 1240 "estr.c"
						}
#line 170 "src/estr.vala"
						if (_tmp11_) {
#line 1244 "estr.c"
							gchar* _tmp17_;
#line 171 "src/estr.vala"
							_tmp17_ = g_strdup (IMMUTABLE_ESTR_eol_cr);
#line 171 "src/estr.vala"
							_g_free0 (this_eol_type);
#line 171 "src/estr.vala"
							this_eol_type = _tmp17_;
#line 1252 "estr.c"
						} else {
							gchar* _tmp18_;
							gsize _tmp19_;
#line 173 "src/estr.vala"
							_tmp18_ = g_strdup (IMMUTABLE_ESTR_eol_crlf);
#line 173 "src/estr.vala"
							_g_free0 (this_eol_type);
#line 173 "src/estr.vala"
							this_eol_type = _tmp18_;
#line 174 "src/estr.vala"
							_tmp19_ = i;
#line 174 "src/estr.vala"
							i = _tmp19_ + 1;
#line 1266 "estr.c"
						}
					}
#line 177 "src/estr.vala"
					if (first_eol) {
#line 1271 "estr.c"
						const gchar* _tmp20_;
#line 179 "src/estr.vala"
						_tmp20_ = this_eol_type;
#line 179 "src/estr.vala"
						immutable_estr_set_eol ((ImmutableEstr*) self, _tmp20_);
#line 180 "src/estr.vala"
						first_eol = FALSE;
#line 1279 "estr.c"
					} else {
						const gchar* _tmp21_;
						const gchar* _tmp22_;
						const gchar* _tmp23_;
#line 181 "src/estr.vala"
						_tmp21_ = immutable_estr_get_eol ((ImmutableEstr*) self);
#line 181 "src/estr.vala"
						_tmp22_ = _tmp21_;
#line 181 "src/estr.vala"
						_tmp23_ = this_eol_type;
#line 181 "src/estr.vala"
						if (g_strcmp0 (_tmp22_, _tmp23_) != 0) {
#line 183 "src/estr.vala"
							immutable_estr_set_eol ((ImmutableEstr*) self, IMMUTABLE_ESTR_eol_lf);
#line 184 "src/estr.vala"
							_g_free0 (this_eol_type);
#line 184 "src/estr.vala"
							break;
#line 1298 "estr.c"
						}
					}
#line 165 "src/estr.vala"
					_g_free0 (this_eol_type);
#line 1303 "estr.c"
				}
			}
		}
	}
}

void
estr_replace (Estr* self,
              gsize pos,
              ImmutableEstr* src)
{
	gchar* s = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 193 "src/estr.vala"
	g_return_if_fail (self != NULL);
#line 193 "src/estr.vala"
	g_return_if_fail (src != NULL);
#line 194 "src/estr.vala"
	_tmp0_ = immutable_estr_get_text (src);
#line 194 "src/estr.vala"
	_tmp1_ = _tmp0_;
#line 194 "src/estr.vala"
	s = _tmp1_;
#line 1328 "estr.c"
	{
		gsize len = 0UL;
		gsize _tmp2_;
		gsize _tmp3_;
#line 195 "src/estr.vala"
		_tmp2_ = immutable_estr_get_length (src);
#line 195 "src/estr.vala"
		_tmp3_ = _tmp2_;
#line 195 "src/estr.vala"
		len = _tmp3_;
#line 1339 "estr.c"
		{
			gboolean _tmp4_ = FALSE;
#line 195 "src/estr.vala"
			_tmp4_ = TRUE;
#line 195 "src/estr.vala"
			while (TRUE) {
#line 1346 "estr.c"
				gchar* next = NULL;
				gchar* _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				const gchar* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				gchar* _tmp12_;
				gsize _tmp13_ = 0UL;
				gchar* _tmp14_;
				gsize line_len = 0UL;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
#line 195 "src/estr.vala"
				if (!_tmp4_) {
#line 1365 "estr.c"
				}
#line 195 "src/estr.vala"
				_tmp4_ = FALSE;
#line 195 "src/estr.vala"
				if (!(len > ((gsize) 0))) {
#line 195 "src/estr.vala"
					break;
#line 1373 "estr.c"
				}
#line 196 "src/estr.vala"
				_tmp5_ = s;
#line 196 "src/estr.vala"
				_tmp6_ = immutable_estr_get_eol (src);
#line 196 "src/estr.vala"
				_tmp7_ = _tmp6_;
#line 196 "src/estr.vala"
				_tmp8_ = immutable_estr_get_eol (src);
#line 196 "src/estr.vala"
				_tmp9_ = _tmp8_;
#line 196 "src/estr.vala"
				_tmp10_ = strlen (_tmp9_);
#line 196 "src/estr.vala"
				_tmp11_ = _tmp10_;
#line 196 "src/estr.vala"
				_tmp12_ = memmem ((const gchar*) _tmp5_, (gsize) ((gssize) len), _tmp7_, (gsize) _tmp11_);
#line 196 "src/estr.vala"
				next = _tmp12_;
#line 197 "src/estr.vala"
				_tmp14_ = next;
#line 197 "src/estr.vala"
				if (_tmp14_ != NULL) {
#line 1397 "estr.c"
					gchar* _tmp15_;
					gchar* _tmp16_;
#line 197 "src/estr.vala"
					_tmp15_ = next;
#line 197 "src/estr.vala"
					_tmp16_ = s;
#line 197 "src/estr.vala"
					_tmp13_ = (gsize) (_tmp15_ - _tmp16_);
#line 1406 "estr.c"
				} else {
#line 197 "src/estr.vala"
					_tmp13_ = len;
#line 1410 "estr.c"
				}
#line 197 "src/estr.vala"
				line_len = _tmp13_;
#line 198 "src/estr.vala"
				_tmp17_ = immutable_estr_get_text ((ImmutableEstr*) self);
#line 198 "src/estr.vala"
				_tmp18_ = _tmp17_;
#line 198 "src/estr.vala"
				_tmp19_ = s;
#line 198 "src/estr.vala"
				memmove (_tmp18_ + pos, _tmp19_, line_len);
#line 199 "src/estr.vala"
				pos = pos + line_len;
#line 200 "src/estr.vala"
				len -= line_len;
#line 201 "src/estr.vala"
				_tmp20_ = next;
#line 201 "src/estr.vala"
				s = _tmp20_;
#line 202 "src/estr.vala"
				if (len > ((gsize) 0)) {
#line 1432 "estr.c"
					gchar* _tmp21_;
					gchar* _tmp22_;
					const gchar* _tmp23_;
					const gchar* _tmp24_;
					const gchar* _tmp25_;
					const gchar* _tmp26_;
					gint _tmp27_;
					gint _tmp28_;
					gchar* _tmp29_;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					gint _tmp32_;
					gint _tmp33_;
					const gchar* _tmp34_;
					const gchar* _tmp35_;
					gint _tmp36_;
					gint _tmp37_;
					const gchar* _tmp38_;
					const gchar* _tmp39_;
					gint _tmp40_;
					gint _tmp41_;
#line 203 "src/estr.vala"
					_tmp21_ = immutable_estr_get_text ((ImmutableEstr*) self);
#line 203 "src/estr.vala"
					_tmp22_ = _tmp21_;
#line 203 "src/estr.vala"
					_tmp23_ = immutable_estr_get_eol ((ImmutableEstr*) self);
#line 203 "src/estr.vala"
					_tmp24_ = _tmp23_;
#line 203 "src/estr.vala"
					_tmp25_ = immutable_estr_get_eol ((ImmutableEstr*) self);
#line 203 "src/estr.vala"
					_tmp26_ = _tmp25_;
#line 203 "src/estr.vala"
					_tmp27_ = strlen (_tmp26_);
#line 203 "src/estr.vala"
					_tmp28_ = _tmp27_;
#line 203 "src/estr.vala"
					memmove (_tmp22_ + pos, _tmp24_, (gsize) _tmp28_);
#line 204 "src/estr.vala"
					_tmp29_ = s;
#line 204 "src/estr.vala"
					_tmp30_ = immutable_estr_get_eol (src);
#line 204 "src/estr.vala"
					_tmp31_ = _tmp30_;
#line 204 "src/estr.vala"
					_tmp32_ = strlen (_tmp31_);
#line 204 "src/estr.vala"
					_tmp33_ = _tmp32_;
#line 204 "src/estr.vala"
					s = _tmp29_ + _tmp33_;
#line 205 "src/estr.vala"
					_tmp34_ = immutable_estr_get_eol (src);
#line 205 "src/estr.vala"
					_tmp35_ = _tmp34_;
#line 205 "src/estr.vala"
					_tmp36_ = strlen (_tmp35_);
#line 205 "src/estr.vala"
					_tmp37_ = _tmp36_;
#line 205 "src/estr.vala"
					len -= (gsize) _tmp37_;
#line 206 "src/estr.vala"
					_tmp38_ = immutable_estr_get_eol ((ImmutableEstr*) self);
#line 206 "src/estr.vala"
					_tmp39_ = _tmp38_;
#line 206 "src/estr.vala"
					_tmp40_ = strlen (_tmp39_);
#line 206 "src/estr.vala"
					_tmp41_ = _tmp40_;
#line 206 "src/estr.vala"
					pos = pos + _tmp41_;
#line 1504 "estr.c"
				}
			}
		}
	}
}

void
estr_cat (Estr* self,
          ImmutableEstr* src)
{
	gsize oldlen = 0UL;
	gsize _tmp0_;
	gsize _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
#line 211 "src/estr.vala"
	g_return_if_fail (self != NULL);
#line 211 "src/estr.vala"
	g_return_if_fail (src != NULL);
#line 212 "src/estr.vala"
	_tmp0_ = immutable_estr_get_length ((ImmutableEstr*) self);
#line 212 "src/estr.vala"
	_tmp1_ = _tmp0_;
#line 212 "src/estr.vala"
	oldlen = _tmp1_;
#line 213 "src/estr.vala"
	_tmp2_ = immutable_estr_get_eol ((ImmutableEstr*) self);
#line 213 "src/estr.vala"
	_tmp3_ = _tmp2_;
#line 213 "src/estr.vala"
	estr_insert (self, oldlen, immutable_estr_len_with_eol (src, _tmp3_));
#line 214 "src/estr.vala"
	estr_replace (self, oldlen, src);
#line 1538 "estr.c"
}

void
estr_remove (Estr* self,
             gsize pos,
             gsize size)
{
	gsize _tmp0_;
	gsize _tmp1_;
	gsize _tmp2_;
	gsize _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gsize _tmp8_;
	gsize _tmp9_;
	gsize _tmp10_;
	gsize _tmp11_;
#line 220 "src/estr.vala"
	g_return_if_fail (self != NULL);
#line 221 "src/estr.vala"
	_tmp0_ = immutable_estr_get_length ((ImmutableEstr*) self);
#line 221 "src/estr.vala"
	_tmp1_ = _tmp0_;
#line 221 "src/estr.vala"
	_vala_assert (pos <= _tmp1_, "pos <= length");
#line 222 "src/estr.vala"
	_tmp2_ = immutable_estr_get_length ((ImmutableEstr*) self);
#line 222 "src/estr.vala"
	_tmp3_ = _tmp2_;
#line 222 "src/estr.vala"
	_vala_assert (size <= (_tmp3_ - pos), "size <= length - pos");
#line 223 "src/estr.vala"
	_tmp4_ = immutable_estr_get_text ((ImmutableEstr*) self);
#line 223 "src/estr.vala"
	_tmp5_ = _tmp4_;
#line 223 "src/estr.vala"
	_tmp6_ = immutable_estr_get_text ((ImmutableEstr*) self);
#line 223 "src/estr.vala"
	_tmp7_ = _tmp6_;
#line 223 "src/estr.vala"
	_tmp8_ = immutable_estr_get_length ((ImmutableEstr*) self);
#line 223 "src/estr.vala"
	_tmp9_ = _tmp8_;
#line 223 "src/estr.vala"
	memmove (_tmp5_ + pos, (_tmp7_ + pos) + size, _tmp9_ - (pos + size));
#line 224 "src/estr.vala"
	_tmp10_ = immutable_estr_get_length ((ImmutableEstr*) self);
#line 224 "src/estr.vala"
	_tmp11_ = _tmp10_;
#line 224 "src/estr.vala"
	estr_resize (self, _tmp11_ - size);
#line 1592 "estr.c"
}

void
estr_insert (Estr* self,
             gsize pos,
             gsize size)
{
	gsize _tmp0_;
	gsize _tmp1_;
	gsize _tmp2_;
	gsize _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gsize _tmp8_;
	gsize _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
#line 230 "src/estr.vala"
	g_return_if_fail (self != NULL);
#line 231 "src/estr.vala"
	_tmp0_ = immutable_estr_get_length ((ImmutableEstr*) self);
#line 231 "src/estr.vala"
	_tmp1_ = _tmp0_;
#line 231 "src/estr.vala"
	_vala_assert (pos <= _tmp1_, "pos <= length");
#line 232 "src/estr.vala"
	_vala_assert ((pos + size) >= MAX (pos, size), "pos + size >= size_t.max (pos, size)");
#line 233 "src/estr.vala"
	_tmp2_ = immutable_estr_get_length ((ImmutableEstr*) self);
#line 233 "src/estr.vala"
	_tmp3_ = _tmp2_;
#line 233 "src/estr.vala"
	estr_resize (self, _tmp3_ + size);
#line 234 "src/estr.vala"
	_tmp4_ = immutable_estr_get_text ((ImmutableEstr*) self);
#line 234 "src/estr.vala"
	_tmp5_ = _tmp4_;
#line 234 "src/estr.vala"
	_tmp6_ = immutable_estr_get_text ((ImmutableEstr*) self);
#line 234 "src/estr.vala"
	_tmp7_ = _tmp6_;
#line 234 "src/estr.vala"
	_tmp8_ = immutable_estr_get_length ((ImmutableEstr*) self);
#line 234 "src/estr.vala"
	_tmp9_ = _tmp8_;
#line 234 "src/estr.vala"
	memmove ((_tmp5_ + pos) + size, _tmp7_ + pos, _tmp9_ - (pos + size));
#line 235 "src/estr.vala"
	_tmp10_ = immutable_estr_get_text ((ImmutableEstr*) self);
#line 235 "src/estr.vala"
	_tmp11_ = _tmp10_;
#line 235 "src/estr.vala"
	memset (_tmp11_ + pos, (gint) '\0', size);
#line 1648 "estr.c"
}

void
estr_move (Estr* self,
           gsize to,
           gsize from,
           gsize n)
{
	gsize _tmp0_;
	gsize _tmp1_;
	gsize _tmp2_;
	gsize _tmp3_;
	gsize _tmp4_;
	gsize _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
#line 238 "src/estr.vala"
	g_return_if_fail (self != NULL);
#line 239 "src/estr.vala"
	_tmp0_ = immutable_estr_get_length ((ImmutableEstr*) self);
#line 239 "src/estr.vala"
	_tmp1_ = _tmp0_;
#line 239 "src/estr.vala"
	_vala_assert (to <= _tmp1_, "to <= length");
#line 240 "src/estr.vala"
	_tmp2_ = immutable_estr_get_length ((ImmutableEstr*) self);
#line 240 "src/estr.vala"
	_tmp3_ = _tmp2_;
#line 240 "src/estr.vala"
	_vala_assert (from <= _tmp3_, "from <= length");
#line 241 "src/estr.vala"
	_tmp4_ = immutable_estr_get_length ((ImmutableEstr*) self);
#line 241 "src/estr.vala"
	_tmp5_ = _tmp4_;
#line 241 "src/estr.vala"
	_vala_assert (n <= (_tmp5_ - MAX (from, to)), "n <= length - size_t.max (from, to)");
#line 242 "src/estr.vala"
	_tmp6_ = immutable_estr_get_text ((ImmutableEstr*) self);
#line 242 "src/estr.vala"
	_tmp7_ = _tmp6_;
#line 242 "src/estr.vala"
	_tmp8_ = immutable_estr_get_text ((ImmutableEstr*) self);
#line 242 "src/estr.vala"
	_tmp9_ = _tmp8_;
#line 242 "src/estr.vala"
	memmove (_tmp7_ + to, _tmp9_ + from, n);
#line 1697 "estr.c"
}

void
estr_set (Estr* self,
          gsize pos,
          gint c,
          gsize n)
{
	gsize _tmp0_;
	gsize _tmp1_;
	gsize _tmp2_;
	gsize _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
#line 245 "src/estr.vala"
	g_return_if_fail (self != NULL);
#line 246 "src/estr.vala"
	_tmp0_ = immutable_estr_get_length ((ImmutableEstr*) self);
#line 246 "src/estr.vala"
	_tmp1_ = _tmp0_;
#line 246 "src/estr.vala"
	_vala_assert (pos <= _tmp1_, "pos <= length");
#line 247 "src/estr.vala"
	_tmp2_ = immutable_estr_get_length ((ImmutableEstr*) self);
#line 247 "src/estr.vala"
	_tmp3_ = _tmp2_;
#line 247 "src/estr.vala"
	_vala_assert (n <= (_tmp3_ - pos), "n <= length - pos");
#line 248 "src/estr.vala"
	_tmp4_ = immutable_estr_get_text ((ImmutableEstr*) self);
#line 248 "src/estr.vala"
	_tmp5_ = _tmp4_;
#line 248 "src/estr.vala"
	memset (_tmp5_ + pos, c, n);
#line 1732 "estr.c"
}

Estr*
estr_from_file (const gchar* filename,
                GError** error)
{
	gchar* s = NULL;
	gsize length = 0UL;
	gchar* _tmp0_ = NULL;
	gsize _tmp1_ = 0UL;
	Estr* es = NULL;
	Estr* _tmp2_;
	Estr* _tmp3_;
	Estr* _tmp4_;
	gchar* _tmp5_;
	Estr* _tmp6_;
	GError* _inner_error0_ = NULL;
	Estr* result;
#line 251 "src/estr.vala"
	g_return_val_if_fail (filename != NULL, NULL);
#line 254 "src/estr.vala"
	g_file_get_contents (filename, &_tmp0_, &_tmp1_, &_inner_error0_);
#line 254 "src/estr.vala"
	_g_free0 (s);
#line 254 "src/estr.vala"
	s = _tmp0_;
#line 254 "src/estr.vala"
	length = _tmp1_;
#line 254 "src/estr.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 254 "src/estr.vala"
		g_propagate_error (error, _inner_error0_);
#line 254 "src/estr.vala"
		_g_free0 (s);
#line 254 "src/estr.vala"
		return NULL;
#line 1769 "estr.c"
	}
#line 255 "src/estr.vala"
	_tmp2_ = estr_new ();
#line 255 "src/estr.vala"
	es = _tmp2_;
#line 256 "src/estr.vala"
	_tmp3_ = es;
#line 256 "src/estr.vala"
	immutable_estr_set_length ((ImmutableEstr*) _tmp3_, length);
#line 257 "src/estr.vala"
	_tmp4_ = es;
#line 257 "src/estr.vala"
	_tmp5_ = s;
#line 257 "src/estr.vala"
	s = NULL;
#line 257 "src/estr.vala"
	immutable_estr_set_text ((ImmutableEstr*) _tmp4_, _tmp5_);
#line 258 "src/estr.vala"
	_tmp6_ = es;
#line 258 "src/estr.vala"
	estr_set_eol_from_text (_tmp6_);
#line 259 "src/estr.vala"
	result = es;
#line 259 "src/estr.vala"
	_g_free0 (s);
#line 259 "src/estr.vala"
	return result;
#line 1797 "estr.c"
}

static void
estr_class_init (EstrClass * klass,
                 gpointer klass_data)
{
#line 111 "src/estr.vala"
	estr_parent_class = g_type_class_peek_parent (klass);
#line 111 "src/estr.vala"
	((ImmutableEstrClass *) klass)->finalize = estr_finalize;
#line 111 "src/estr.vala"
	g_type_class_adjust_private_offset (klass, &Estr_private_offset);
#line 1810 "estr.c"
}

static void
estr_instance_init (Estr * self,
                    gpointer klass)
{
#line 111 "src/estr.vala"
	self->priv = estr_get_instance_private (self);
#line 1819 "estr.c"
}

static void
estr_finalize (ImmutableEstr * obj)
{
	Estr * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 111 "src/estr.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ESTR, Estr);
#line 137 "src/estr.vala"
	_tmp0_ = immutable_estr_get_text ((ImmutableEstr*) self);
#line 137 "src/estr.vala"
	_tmp1_ = _tmp0_;
#line 137 "src/estr.vala"
	g_free (_tmp1_);
#line 111 "src/estr.vala"
	IMMUTABLE_ESTR_CLASS (estr_parent_class)->finalize (obj);
#line 1838 "estr.c"
}

static GType
estr_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EstrClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) estr_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Estr), 0, (GInstanceInitFunc) estr_instance_init, NULL };
	GType estr_type_id;
	estr_type_id = g_type_register_static (TYPE_IMMUTABLE_ESTR, "Estr", &g_define_type_info, 0);
	Estr_private_offset = g_type_add_instance_private (estr_type_id, sizeof (EstrPrivate));
	return estr_type_id;
}

GType
estr_get_type (void)
{
	static volatile gsize estr_type_id__once = 0;
	if (g_once_init_enter (&estr_type_id__once)) {
		GType estr_type_id;
		estr_type_id = estr_get_type_once ();
		g_once_init_leave (&estr_type_id__once, estr_type_id);
	}
	return estr_type_id__once;
}

