/*
 This file is part of GNU Taler
 (C) 2025 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
import {
  MerchantContractTokenKind,
} from "@gnu-taler/taler-util";
import test from "ava";
import {
  TokenMerchantVerificationResult,
  verifyTokenMerchant,
} from "./tokenSelection.js";

test("match trusted_domains and expected_domains against merchant", (t) => {
  const merchant0 = "https://Merchant.neT/";
  const merchant1 = "https://backend.Test.taLer.net/";
  const merchant2 = "https://backend.dEmo.taleR.nEt/";
  const merchant3 = "https://backend.deMo.evil.net/";

  // (merchantBaseUrl, tokenMerchantBaseUrl, tokenDetails)

  t.assert(
    verifyTokenMerchant(merchant0, merchant0, {
      class: MerchantContractTokenKind.Discount,
      expected_domains: [],
    }) === TokenMerchantVerificationResult.Automatic,
  );

  t.assert(
    verifyTokenMerchant(merchant1, merchant0, {
      class: MerchantContractTokenKind.Discount,
      expected_domains: [],
    }) === TokenMerchantVerificationResult.Unexpected,
  );

  t.assert(
    verifyTokenMerchant(merchant2, merchant1, {
      class: MerchantContractTokenKind.Discount,
      expected_domains: ["*.taler.Net"],
    }) === TokenMerchantVerificationResult.Automatic,
  );

  t.assert(
    verifyTokenMerchant(merchant3, merchant1, {
      class: MerchantContractTokenKind.Discount,
      expected_domains: ["*.taler.net"],
    }) === TokenMerchantVerificationResult.Unexpected,
  );

  t.assert(
    verifyTokenMerchant(merchant3, merchant1, {
      class: MerchantContractTokenKind.Discount,
      expected_domains: ["*"],
    }) === TokenMerchantVerificationResult.Automatic,
  );

  t.assert(
    verifyTokenMerchant(merchant2, merchant1, {
      class: MerchantContractTokenKind.Subscription,
      trusted_domains: ["*.taler.net"],
    }) === TokenMerchantVerificationResult.Automatic,
  );

  t.assert(
    verifyTokenMerchant(merchant3, merchant1, {
      class: MerchantContractTokenKind.Subscription,
      trusted_domains: ["*.taler.net"],
    }) === TokenMerchantVerificationResult.Untrusted,
  );

  t.assert(
    verifyTokenMerchant(merchant3, merchant1, {
      class: MerchantContractTokenKind.Subscription,
      trusted_domains: ["*.taler.net"],
    }) === TokenMerchantVerificationResult.Untrusted,
  );

  t.assert(
    verifyTokenMerchant(merchant3, merchant1, {
      class: MerchantContractTokenKind.Subscription,
      trusted_domains: ["*"],
    }) === TokenMerchantVerificationResult.Automatic,
  );
});
