package kawa.standard;
import kawa.lang.*;
import gnu.expr.*;
import gnu.mapping.Symbol;
import gnu.mapping.SimpleSymbol;

public class IfFeature
{
  public static boolean testFeature (Object form)
  {
    if (form instanceof SyntaxForm)
      {
	SyntaxForm sf = (SyntaxForm) form;
	form = sf.getDatum();
      }
    form = ((Translator) Compilation.getCurrent()).namespaceResolve(form);
    if (form instanceof String || form instanceof SimpleSymbol)
      return hasFeature(form.toString());
    return false;  // FIXME - return error
  }

  public static boolean hasFeature (String name)
  {
    if (name == "kawa")
      return true;
    if (name == "srfi-0") // cond-expand
      return true;
    //if (name == "srfi-1") return true; // lists - only if require used.
    if (name == "srfi-4") // Homogeneous numeric vector datatypes
      return true;
    if (name == "srfi-6") // Basic String Ports
      return true;
    if (name == "srfi-8") // receive: Binding to multiple values
      return true;
    if (name == "srfi-9") // Defining Record Types
      return true;
    if (name == "srfi-11") // let-values, let*-values
      return true;
    if (name == "srfi-16") // case-lambda
      return true;
    if (name == "srfi-17") // Generalized set!
      return true;
    if (name == "srfi-23") // Error reporting mechanism
      return true;
    if (name == "srfi-25") // Multi-dimensional Array Primitives
      return true;
    if (name == "srfi-26") // Notation for Specializing Parameters
      return true;
    if (name == "srfi-28") // Basic Format Strings
      return true;
    if (name == "srfi-30") // Nested Multi-line Comments.
      return true;
    if (name == "srfi-39") // Parameter objects
      return true;
    /* #ifdef use:java.text.Normalizer */
    if (name == "string-normalize-unicode")
      {
        /* #ifdef JAVA6COMPAT5 */
        // try
        //   {
        //     Class.forName("java.text.Normalizer");
        //     return true;
        //   }
        // catch (ClassNotFoundException ex)
        //   {
        //     return false;
        //   }
        /* #else */
        return true;
        /* #endif */
      }
    /* #endif */
    if (name == "in-http-server" || name == "in-servlet")
      {
        int mflags = ModuleContext.getContext().getFlags();
        if (name == "in-http-server")
          return (mflags & ModuleContext.IN_HTTP_SERVER) != 0;
        if (name == "in-servlet")
          return (mflags & ModuleContext.IN_SERVLET) != 0;
      }
    /* #ifdef JAVA6 */
    if (name == "java-6")
      return true;
    /* #endif */

    /* #ifdef JAVA7 */
    // if (name == "java-7")
    //  return true;
    /* #endif */

    String classExistsPrefix = "class-exists:";
    if (name.startsWith(classExistsPrefix))
      {
        name = name.substring(classExistsPrefix.length());
        try
          {
            Class.forName(name, false, IfFeature.class.getClassLoader());
            return true;
          }
        catch (ClassNotFoundException ex)
          {
            return false;
          }
      }

    Symbol provide_symbol = Symbol.valueOf(PROVIDE_PREFIX+name);
    Declaration decl = Compilation.getCurrent().lookup(provide_symbol, -1);
    if (decl!=null && ! decl.getFlag(Declaration.IS_UNKNOWN))
      return true;
    return false;
  }

  public static final String PROVIDE_PREFIX = "%provide%";

  public static boolean isProvide (Declaration decl)
  {
    return decl.getName().startsWith(PROVIDE_PREFIX);
  }
}
