# Technical Committee

_This document only makes sense with the rules from [the community document](community)_.

The Technical Committee (**TC**) is here to arbitrate and make decisions when
technical conflicts occur in the project.

The TC main role is to resolve technical conflicts.
It is therefore not a technical steering committee, but it is understood that
some decisions might impact the future of the project.

# Process

## Seizing

The TC can take possession of any technical matter that it sees fit.

To involve the TC in a matter, email tc@ or CC them on an ongoing discussion.

As members of TC are developers, they also can email tc@ to raise an issue.

## Announcement

The TC, once seized, must announce itself on the main mailing list, with a _[TC]_ tag.

The TC has 2 modes of operation: a RFC one and an internal one.

If the TC thinks it needs the input from the larger community, the TC can call
for a RFC. Else, it can decide by itself.

If the disagreement involves a member of the TC, that member should recuse
themselves from the decision.

The decision to use a RFC process or an internal discussion is a discretionary
decision of the TC.

The TC can also reject a seizure for a few reasons such as:
the matter was not discussed enough previously; it lacks expertise to reach a
beneficial decision on the matter; or the matter is too trivial.

### RFC call

In the RFC mode, one person from the TC posts on the mailing list the
technical question and will request input from the community.

The mail will have the following specification:
* a precise title
* a specific tag [TC RFC]
* a top-level email
* contain a precise question that does not exceed 100 words and that is answerable by developers
* may have an extra description, or a link to a previous discussion, if deemed necessary,
* contain a precise end date for the answers.

The answers from the community must be on the main mailing list and must have
the following specification:
* keep the tag and the title unchanged
* limited to 400 words
* a first-level, answering directly to the main email
* answering to the question.

Further replies to answers are permitted, as long as they conform to the
community standards of politeness, they are limited to 100 words, and are not
nested more than once. (max-depth=2)

After the end-date, mails on the thread will be ignored.

Violations of those rules will be escalated through the Community Committee.

After all the emails are in, the TC has 96 hours to give its final decision.
Exceptionally, the TC can request an extra delay, that will be notified on the
mailing list.

### Within TC

In the internal case, the TC has 96 hours to give its final decision.
Exceptionally, the TC can request an extra delay.


## Decisions

The decisions from the TC will be sent on the mailing list, with the _[TC]_ tag.

Internally, the TC should take decisions with a majority, or using
ranked-choice voting.

The decision from the TC should be published with a summary of the reasons that
lead to this decision.

The decisions from the TC are final, until the matters are reopened after
no less than one year.

