/* 
 *    Programmed By: Mohammed Isam Mohammed [mohammed_isam1984@yahoo.com]
 *    Copyright 2014, 2015, 2016, 2017, 2018 (c)
 * 
 *    file: dir.c
 *    This file is part of mino.
 *
 *    mino is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    mino is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with mino.  If not, see <http://www.gnu.org/licenses/>.
 */    

#include "defs.h"
#include "options.h"
#include <sys/ioctl.h>	//included for terminal size query
#include <dirent.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>

struct dirent **eps;
int epscount;

#define DIR_RETURN_ERROR()		\
do {					\
    msgBox(strerror(errno), OK, ERROR);	\
    if(chdir(oldcwd)) return 0;         \
    return 0;				\
} while(0)

static int one(const struct dirent *unused) 
{
  return 1;
}

char *getCwd()
{
    if(cwd != NULL) free(cwd);
    cwd = getcwd(NULL, 0);
    return cwd;
}

int scanDir(char *dir, char ***dirs, char ***files, int *totalDirs, int *totalFiles)
{
  int dcount = 0;
  int fcount = 0;
  int n;
  struct stat st;
  char *ldirs[MAXDIRS];
  char *lfiles[MAXFILES];
  char *oldcwd = getcwd(NULL, 0);
  if(eps != NULL)
  {
      for(n = 0; n < epscount; n++) free(eps[n]);
      free(eps);
      eps = NULL;
  }

  int x = chdir(dir);
  if(x == -1) DIR_RETURN_ERROR();

  if(!getCwd()) DIR_RETURN_ERROR();
  
  x = lstat(dir, &st);
  if(x == -1) DIR_RETURN_ERROR();
 
  if(S_ISDIR(st.st_mode)) 
  {
      n = scandir(dir, &eps, one, alphasort);
      if(n >= 0) 
      {
          int cnt;
          for(cnt = 0; cnt < n; ++cnt) 
          {
              x = lstat(eps[cnt]->d_name,&st);
              if(x == -1) DIR_RETURN_ERROR();
              if(S_ISDIR(st.st_mode))
              {
                  if(strcmp(eps[cnt]->d_name, ".") == 0) //ignore "."
                      continue;
                  ldirs[dcount++] = eps[cnt]->d_name;
              } 
              else 
              {
                  lfiles[fcount++] = eps[cnt]->d_name;
              }
          }
      }
      free(oldcwd);
      *totalDirs = dcount;
      *totalFiles = fcount;
      *dirs = (char **)malloc(sizeof(char **)*dcount);
      if(!*dirs) DIR_RETURN_ERROR();
      memcpy(*dirs, ldirs, sizeof(char **)*dcount);
      *files = (char **)malloc(sizeof(char **)*fcount);
      if(!*files) DIR_RETURN_ERROR();
      memcpy(*files, lfiles, sizeof(char **)*fcount);
      return 1;
  } 
  else 
  {
      char *tmp = (char *) malloc(strlen(dir)+21);
      if(!tmp) { msgBox("Insufficient memory", OK, ERROR); return 0; }
      sprintf(tmp, "Error opening dir:\n%s", dir);
      strcat(tmp, "\0");
      msgBox(tmp, OK, ERROR);
      free(tmp);
      free(oldcwd);
      return 0;
  }
}
