/*
 * File automatically generated by
 * gengen 1.0 by Lorenzo Bettini 
 * http://www.gnu.org/software/gengen
 */

#ifndef CC_SOURCE_GEN_CLASS_H
#define CC_SOURCE_GEN_CLASS_H

#include <string>
#include <iostream>

using std::string;
using std::ostream;

class cc_source_gen_class
{
 protected:
  string author;
  string classname;
  string genname;
  string headerfile;
  string methodbody;
  string othercomments;
  string package;
  string version;

 public:
  cc_source_gen_class()
  {
  }
  
  cc_source_gen_class(const string &_author, const string &_classname, const string &_genname, const string &_headerfile, const string &_methodbody, const string &_othercomments, const string &_package, const string &_version) :
    author (_author), classname (_classname), genname (_genname), headerfile (_headerfile), methodbody (_methodbody), othercomments (_othercomments), package (_package), version (_version)
  {
  }

  virtual ~cc_source_gen_class()
  {
  }

  static void
  generate_string(const string &s, ostream &stream, unsigned int indent)
  {
    if (!indent || s.find('\n') == string::npos)
      {
        stream << s;
        return;
      }

    string::size_type pos;
    string::size_type start = 0;
    string ind (indent, ' ');
    while ( (pos=s.find('\n', start)) != string::npos)
      {
        stream << s.substr (start, (pos+1)-start);
        start = pos+1;
        if (start+1 <= s.size ())
          stream << ind;
      }
    if (start+1 <= s.size ())
      stream << s.substr (start);
  }

  void set_author(const string &_author)
  {
    author = _author;
  }

  void set_classname(const string &_classname)
  {
    classname = _classname;
  }

  void set_genname(const string &_genname)
  {
    genname = _genname;
  }

  void set_headerfile(const string &_headerfile)
  {
    headerfile = _headerfile;
  }

  virtual void generate_methodbody(ostream &stream, unsigned int indent) = 0;

  void set_methodbody(const string &_methodbody)
  {
    methodbody = _methodbody;
  }

  void set_othercomments(const string &_othercomments)
  {
    othercomments = _othercomments;
  }

  void set_package(const string &_package)
  {
    package = _package;
  }

  void set_version(const string &_version)
  {
    version = _version;
  }

  void generate_cc_source(ostream &stream, unsigned int indent = 0)
  {
    string indent_str (indent, ' ');
    indent = 0;
  
    stream << "/*";
    stream << "\n";
    stream << indent_str;
    stream << " * File automatically generated by";
    stream << "\n";
    stream << indent_str;
    stream << " * ";
    generate_string (package, stream, indent + indent_str.length ());
    stream << " ";
    generate_string (version, stream, indent + indent_str.length ());
    stream << " ";
    generate_string (author, stream, indent + indent_str.length ());
    stream << "\n";
    stream << indent_str;
    stream << " * ";
    generate_string (othercomments, stream, indent + indent_str.length ());
    stream << "\n";
    stream << indent_str;
    stream << " */";
    stream << "\n";
    stream << indent_str;
    stream << "\n";
    stream << indent_str;
    stream << "#include \"";
    generate_string (headerfile, stream, indent + indent_str.length ());
    stream << "\"";
    stream << "\n";
    stream << indent_str;
    stream << "\n";
    stream << indent_str;
    stream << "void";
    stream << "\n";
    stream << indent_str;
    generate_string (classname, stream, indent + indent_str.length ());
    stream << "::generate_";
    generate_string (genname, stream, indent + indent_str.length ());
    stream << "(ostream &stream, unsigned int indent)";
    stream << "\n";
    stream << indent_str;
    if (methodbody.size () > 0)
      generate_string (methodbody, stream, indent + indent_str.length ());
    else
      generate_methodbody (stream, indent + indent_str.length ());
    stream << "\n";
    stream << indent_str;
  }
};

#endif // CC_SOURCE_GEN_CLASS_H
