.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
.TH XSetTextProperty 3X11 "Release 6" "X Version 11" "XLIB FUNCTIONS"
.SH NAME
XSetTextProperty, XGetTextProperty \- set and read text properties
.SH SYNTAX
void XSetTextProperty\^(\^\fIdisplay\fP, \fIw\fP, \fItext_prop\fP, \
\fIproperty\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      Window \fIw\fP\^;
.br
      XTextProperty *\fItext_prop\fP\^;
.br
      Atom \fIproperty\fP\^;
.LP
Status XGetTextProperty\^(\^\fIdisplay\fP, \fIw\fP, \fItext_prop_return\fP, \
\fIproperty\fP\^)
.br
       Display *\fIdisplay\fP\^;
.br
       Window \fIw\fP\^;
.br
       XTextProperty *\fItext_prop_return\fP\^;
.br
       Atom \fIproperty\fP\^;
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIproperty\fP 1i
Specifies the property name.
.IP \fItext_prop\fP 1i
Specifies the
.ZN XTextProperty
structure to be used.
.IP \fItext_prop_return\fP 1i
Returns the
.ZN XTextProperty
structure.
.SH DESCRIPTION
The
.ZN XSetTextProperty
function replaces the existing specified property for the named window 
with the data, type, format, and number of items determined 
by the value field, the encoding field, the format field, 
and the nitems field, respectively, of the specified
.ZN XTextProperty
structure.
If the property does not already exist,
.ZN XSetTextProperty
sets it for the specified window.
.LP
.ZN XSetTextProperty
can generate
.ZN BadAlloc ,
.ZN BadAtom ,
.ZN BadValue ,
and
.ZN BadWindow
errors.
.LP
The
.ZN XGetTextProperty 
function reads the specified property from the window
and stores the data in the returned
.ZN XTextProperty
structure.
It stores the data in the value field,
the type of the data in the encoding field,
the format of the data in the format field, 
and the number of items of data in the nitems field.
An extra byte containing null (which is not included in the nitems member) 
is stored at the end of the value field of text_prop_return.
The particular interpretation of the property's encoding 
and data as text is left to the calling application.
If the specified property does not exist on the window,
.ZN XGetTextProperty
sets the value field to NULL, 
the encoding field to
.ZN None , 
the format field to zero, 
and the nitems field to zero.
.LP
If it was able to read and store the data in the
.ZN XTextProperty
structure,
.ZN XGetTextProperty
returns a nonzero status; 
otherwise, it returns a zero status.
.LP
.ZN XGetTextProperty
can generate
.ZN BadAtom 
and
.ZN BadWindow
errors.
.SH PROPERTIES
.TP 1i
\s-1WM_CLIENT_MACHINE\s+1
The string name of the machine on which the client application is running.
.TP 1i
\s-1WM_COMMAND\s+1
The command and arguments, null-separated, used to invoke the
application.
.TP 1i
\s-1WM_ICON_NAME\s+1
The name to be used in an icon.
.TP 1i
\s-1WM_NAME\s+1
The name of the application.
.SH DIAGNOSTICS
.TP 1i
.ZN BadAlloc
The server failed to allocate the requested resource or server memory.
.TP 1i
.ZN BadAtom
A value for an Atom argument does not name a defined Atom.
.TP 1i
.ZN BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.  Any argument defined as a set of
alternatives can generate this error.
.TP 1i
.ZN BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
XAllocClassHint(3X11),
XAllocIconSize(3X11),
XAllocSizeHints(3X11),
XAllocWMHints(3X11),
XSetCommand(3X11),
XSetTransientForHint(3X11),
XSetWMClientMachine(3X11),
XSetWMColormapWindows(3X11),
XSetWMIconName(3X11),
XSetWMName(3X11),
XSetWMProperties(3X11),
XSetWMProtocols(3X11),
XStringListToTextProperty(3X11)
.br
\fI\*(xL\fP
