/* File: generic_button.c
 * Created: 4/4/92 by John Butare(jb7p@andrew.cmu.edu)
 * Description:
 *	
 * Modifications:
 */

/*
 * GenericButton
 */

#include "generic_button.h"

#include <IV-look/telltale.h>
#include <InterViews/action.h>
#include <InterViews/event.h>
#include <InterViews/listener.h>

#include <stream.h>

// Function:
//   Construct an instance.  Create a listener and set it listening.  If the
//   telltale exists initialize it to be enabled and not yet chosen.  If
//   the action exists attach it.

GenericButton::GenericButton(Telltale* t, Action* select) :
    MonoGlyph(nil), PointerHandler(), _enabled(true), _chosen(false)
{
  _select_action = select;
 Resource::ref(_select_action);
  _telltale = t;
 Resource::ref(_telltale);
  if (_telltale != nil) {
    _telltale->enable(enabled());
    _telltale->choose(chosen());
  }

  // create a Listener to sense X-events and tell it to accept
  // motion and mouse-button events and pass them to this instance

  _listener = new Listener(_telltale, this);
  _listener->button(true, Event::any);
  _listener->motion(true);
  body(_listener);
}

// Function:
//   Destruct the instance.  Unref the action and the telltale.

GenericButton::~GenericButton()
{
    Resource::unref(_select_action);
    Resource::unref(_telltale);
}

// Function:
//   If button is enabled support drag function by highlighting the
//   telltale only when the cursor is over the button.

void GenericButton::drag(Event& anEvent)
{
    if (enabled() && telltale() != nil) {
	telltale()->highlight(listener()->picks(anEvent.pointer_x(),
						anEvent.pointer_y()));
    }
}

// Function:
//   If button is enabled support release function by making sure
//   the telltale is no longer highlighted.

void GenericButton::release(Event& anEvent)
{
    if (enabled() && telltale() != nil) {
	telltale()->highlight(false);
    }
    PointerHandler::release(anEvent);
}

// Function:
//   If button is enabled, an action exists and the cursor is over the
//   button handle the commit function by executing the action.

void GenericButton::commit(Event& anEvent)
{
    if (enabled() && select_action() != nil &&
	listener()->picks(anEvent.pointer_x(), anEvent.pointer_y())) {
	select_action()->execute();
    }
}

// Function:
//   Choose or unchoose the button as desired and relay any change
//   to the telltale.

void GenericButton::choose(boolean state)
{
    _chosen = state;
    if ((telltale() != nil) && (telltale()->chosen() != state)) {
	telltale()->choose(state);
    }
}

// Function:
//   Enable or disable the button as desired and relay any change
//   to the telltale.

void GenericButton::enable(boolean state)
{
    _enabled = state;
    if ((telltale() != nil) && (telltale()->enabled() != state)) {
	telltale()->enable(state);
    }
}
