/*
 * Simulation
 */

#ifndef simulation_h
#define simulation_h

#include <InterViews/coord.h>
#include <InterViews/boolean.h>
#include <OS/list.h>

class Simulation;
class SimulationController;
class Action;

declareList(SimulationList, Simulation*);

/*
 * Simulation
 */

class Simulation {
public:
  Simulation(SimulationController* controller =nil);

  virtual void start();
  virtual void stop();
  virtual void pause();
  virtual void update();

  virtual void date(int month, int day, int year);
  int month();
  int day();
  int year();

  boolean running() const;
  void running(boolean b);

private:
  int _day;
  int _month;
  int _year;

  boolean _running;
  SimulationController* _controller;
};

inline boolean Simulation::running() const { return(_running); }
inline void Simulation::running(boolean b) { _running = b; }

inline void Simulation::date(int month, int day, int year) 
   { _month = month ; _day = day; _year = year; }

inline int Simulation::day() { return(_day); }

inline int Simulation::month() { return(_month); }

inline int Simulation::year() { return(_year); }

/*
 * DynamicSimulation
 */

class DynamicSimulation : public Simulation {
public:
  DynamicSimulation(SimulationController *controller);

  virtual void start();
  virtual void stop();
  virtual void update();

  virtual void time(int start, int stop, int step);

  int time_start();
  void time_start(int v);

  int time_stop();
  void time_stop(int v);

  int time_step();
  void time_step(int v);

  int time();
  boolean time_expired();

  void time_display_action(Action* action);

protected:
  Action* _time_display_action;

  int _update_counter;
  int _update_step;

  int _time_start;
  int _time_stop;
  int _time_counter;
  int _time_step;
};

inline void DynamicSimulation::time(int start, int stop, int step) 
   { _time_start = start ; _time_stop = stop; _time_step = step; }

inline int DynamicSimulation::time_start()
   { return(_time_start); }

inline void DynamicSimulation::time_start(int v)
   { _time_start = v; }

inline int DynamicSimulation::time_stop()
   { return(_time_stop); }

inline void DynamicSimulation::time_stop(int v)
   { _time_stop = v; }

inline int DynamicSimulation::time_step()
   { return(_time_step); }

inline void DynamicSimulation::time_step(int v)
{
  _time_step = v;

  if (_time_stop + _time_step > 86400 /* 60*60*24 */)
    _time_stop = 86400 - _time_step - 1;
}

inline int DynamicSimulation::time()
   { return(_time_counter); }

inline boolean DynamicSimulation::time_expired()
   { return(_time_counter >= _time_stop); }

inline void DynamicSimulation::time_display_action(Action* action)
   { _time_display_action = action; }

/*
 * SimulationController
 */

class SimulationList;

class SimulationController {
public:
   SimulationController();
   ~SimulationController();

   void append(Simulation* s);
   void remove(Simulation* s);
   boolean contains(Simulation* s);

   boolean running() const;
   void run();
   
private:
   long lookup(Simulation* s);

   boolean _running;
   SimulationList* _simulation_list;
};

/* The controller is running if it has any simulations */
inline boolean SimulationController::running() const
   { return(_simulation_list->count()); }

#endif
