#include <InterViews/event.h>
#include <InterViews/session.h>
#include <InterViews/display.h>
#include <InterViews/style.h>
#include <InterViews/bitmap.h>
#include <InterViews/cursor.h>
#include <InterViews/color.h>

#include <OS/string.h>

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>

#include <AIRSHED/database.h>
#include <AIRSHED/return_value.h>
#include <AIRSHED/client.h>
#include <AIRSHED/day_record.h>

#include "simulation.h"
#include "color_scale.h"
#include "gems.h"

Gems* Gems::_instance;

Gems::Gems(Session* session, Style* style, Display* display)
{
  _session = session;
  _simulation_controller = new SimulationController();

  if (style)
    _style = style;
  else
    _style = _session->style();

  if (display)
    _display = display;
  else
    _display = _session->default_display();

  cursor_init();

  if (_style->value_is_on("network"))
    _air_db = new client("Airshed", "Los Angeles");
  else
    _air_db = nil;

  _instance = this;

  _color_scale = new ColorScale(100);
  
}

Gems::~Gems()
{
  delete _session;
  delete _simulation_controller;
  delete _color_scale;


  // core dumps here if take out comment.  Wish I new why.
  // delete _hand_cursor;

  if (_air_db)
    _air_db->Network_Quit();
}

Gems* Gems::instance(Session* session, Style* style, Display* display)
{
  if (_instance)
    return(_instance);

  if (session == nil)
    Gems::error("Must pass session for initial creation\n");

  return(_instance = new Gems(session, style, display));
}

Cursor* Gems::cursor(CursorType t)
{
  switch (t) {
  case hand:
    return(_hand_cursor);
  }
}

void Gems::cursor_init()
{
  _hand_cursor = new Cursor(
       Bitmap::open(datapath("pictures/hand.bm")),
       Bitmap::open(datapath("pictures/handMask.bm")),
       _style->foreground(),
       _style->background()
   );
}

boolean Gems::dispatch()
{
  Event e;

  if (_session->pending()) {
    _session->read(e);
    e.handle();
  }
  return(!_session->done());
}

int Gems::run()
{
  Event e;
  
  do {
    if (_simulation_controller->running())
      _simulation_controller->run();
    
    _session->read(e);
    e.handle();
  } while (!_session->done());

  return(0);
}

char* Gems::datapath(char* append)
{
  String datapath;
  static char buf[50];

  if (append[0] == '/')
    return(append);

  if (!_style->find_attribute("datapath", datapath))
    error("Datpath attributed not defined.");

  strcpy(buf, datapath.string());
  if (append) strcat(buf, append);
  return(buf);
}

void Gems::error(char* message)
{
  fprintf(stderr, "Internal GEMS error\n");
  if (message)
    fprintf(stderr, "\t%s\n", message);
//  if (_air_db)
//    _air_db->Network_Quit();
  exit(1);
}

boolean Gems::color()
{
  Style* s = _style;

  if (s->value_is_on("monochrome") || s->value_is_on("Monochrome"))
    return(true);

  const Color* c1 = new Color(0.0, 0.0, 0.0, 1.0);
  const Color* c2 = new Color(1.0, 1.0, 1.0, 1.0);
  const Color* c3 = new Color(0.5, 0.5, 0.5, 1.0);
  if (!c1->distinguished(c2) || !c2->distinguished(c3))
    return(false);

  return(true);
}
