/*
 * planar figures
 */

#ifndef figure_h
#define figure_h

#include <InterViews/ptrhandler.h>
#include <InterViews/event.h>
#include <InterViews/patch.h>

class Brush;
class Color;
class Listener;
class FigureTool;

/*
 * Figure
 */
class Figure : public Patch, public PointerHandler {
public:
  virtual void press(Event&);  

  virtual void brush(const Brush*);
  virtual void stroke(const Color*);
  virtual void fill(const Color*);

  virtual const Color* stroke();

  virtual void button(boolean, EventButton = Event::any);
  virtual void motion(boolean);
  virtual void key(boolean);

  virtual void clear_points();
  virtual void add_point (Coord x, Coord y);
  virtual void point(int index, Coord& x, Coord& y);

protected:
    Figure(
       const Brush* brush, const Color* stroke, const Color* fill,
       boolean closed, boolean curved, int coords);
    virtual ~Figure();

  FigureTool* _tool;

private:

  Listener* _listener;
};

/*
 * Point
 */

class Point : public Figure {
public:
    Point(
       const Brush* brush =nil, const Color* stroke =nil, const Color* fill =nil,
       Coord x =0.0, Coord y =0.0);
protected:
    virtual ~Point();
};

/*
 * Line
 */

class Line : public Figure {
public:
    Line(
       const Brush* brush, const Color* stroke, const Color* fill,
       Coord x1, Coord y1, Coord x2, Coord y2);
protected:
    virtual ~Line ();
};

/*
 * Rectangle
 */

class Rectangle : public Figure {
public:
    Rectangle(const Brush* brush, const Color* stroke, const Color* fill,
	      Coord l, Coord b, Coord r, Coord t);
    virtual ~Rectangle ();
};

/*
 * Circle
 */

class Circle : public Figure {
public:
    Circle(const Brush* brush, const Color* stroke, const Color* fill,
	   Coord x, Coord y, Coord r);
protected:
    virtual ~Circle ();
};

/*
 * Ellipse
 */

class Ellipse : public Figure {
public:
    Ellipse(const Brush* brush, const Color* stroke, const Color* fill,
	    Coord x, Coord y, Coord rx, Coord ry);
protected:
    virtual ~Ellipse ();
};

/*
 * Open_BSpline
 */

class Open_BSpline : public Figure {
public:
    Open_BSpline(const Brush* brush, const Color* stroke, const Color* fill,
		 Coord* x, Coord* y, int count);
protected:
    virtual ~Open_BSpline ();
};

/*
 * Close_BSpline
 */

class Closed_BSpline : public Figure {
public:
    Closed_BSpline (const Brush* brush, const Color* stroke, const Color* fill,
		    Coord* x, Coord* y, int count);
protected:
    virtual ~Closed_BSpline ();
};

/*
 * Polyline
 */

class Polyline : public Figure {
public:
    Polyline(const Brush* brush, const Color* stroke, const Color* fill,
	     Coord* x, Coord* y, int count);
protected:
    virtual ~Polyline ();
};

/*
 * Polygon
 */

class Polygon : public Figure {
public:
    Polygon (const Brush* brush, const Color* stroke, const Color* fill,
	     Coord* x, Coord* y, int count);
protected:
    virtual ~Polygon ();
};

#endif
