/*
 * Copyright 1993,1994 Globetrotter Software, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Globetrotter Software not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Globetrotter Software makes
 * no representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * GLOBETROTTER SOFTWARE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO
 * EVENT SHALL GLOBETROTTER SOFTWARE BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 *
 * Author:  Jim McBeath, Globetrotter Software, jimmc@globes.com
 */
/* htserv.c - functions which are dependent on what HTTP server is running
 *
 * Jim McBeath, November 18, 1993
 */

#include "htimp.h"

extern char *getenv();
extern char *unescape(char *s,int eflag);

void
ImpProcessServerArgs(argc,argv,ci)
int argc;
char *argv[];
CommandInfo *ci;
{
	char *p;	/* path string */
	char *q;	/* query string */
	char *e;

#ifdef OLD_HTTPD
	if (argc<2) {
		ImpFatal("No program specified");
		/* NOTREACHED */
	}
	if (argc>3) {
		ImpFatal("Too many arguments");
		/* NOTREACHED */
	}
	p = argv[1];
	if (argc>2)
		q = argv[2];
	else
		q = 0;
#else
	p = getenv("PATH_INFO");
	q = getenv("QUERY_STRING");
#endif

	/* Check out program name */
	/* We are looking for either "/s/appname" to start program, or
	 * "/t/handle" to talk to an existing program. */
	if (*p++!='/') {
		ImpFatal("Bad path argument");
		/* NOTREACHED */
	}
	e = strchr(p,'/');
	if (!e) {
		ImpFatal("Bad path argument");
		/* NOTREACHED */
	}
	*e++ = 0;
	if (strcmp(p,"s")==0) {
		ci->mode = MODE_START;
		ci->app = e;
		if (q && q[0])
			ci->str = unescape(q,1);
	}
	else if (strcmp(p,"t")==0) {
		ci->mode = MODE_TALK;
		ci->handle = e;
		if (q && q[0])
			ci->str = unescape(q,1);
	}
	else if (strcmp(p,"q")==0) {
		ci->mode = MODE_QUIT;
		ci->handle = e;
	}
	else {
		ImpFatal("Bad mode in path argument");
		/* NOTREACHED */
	}
}

char *
ImpGetServerRoot()
{
	char *sr;

/* Used to be available in old httpd; not generally available now,
 * so it will typically use the built-in default; but you could set
 * SERVER_ROOT in a script that calls us if you need to.
 */
	sr = getenv("SERVER_ROOT");
	if (sr)
		return sr;
	return DEFAULT_SERVER_ROOT;
}

char *
ImpGetServerNameAndPort()
{
	char *sv;
#ifndef OLD_HTTP
	char *sp;
	static char *buf=0;
	int l;
#endif

#ifndef OLD_HTTP
	if (buf)
		return buf;
#endif
	sv = getenv("SERVER_NAME");
#ifdef OLD_HTTP	/* in old httpd, SERVER_NAME included the port number */
	if (sv)
		return sv;
#else
	sp = getenv("SERVER_PORT");
	if (sv) {
		if (!sp || strcmp(sp,"80")==0)
			return sv;	/* uses default port */
		l = strlen(sv) + strlen(sp) + 2;
		buf = ImpMalloc(l);
		sprintf(buf,"%s:%s",sv,sp);
		return buf;
	}
#endif
	return "localhost";	/* only needed for crude testing */
}

char *
ImpGetScriptName()
{
	char *sv;

/* This was not available in old httpd, so generally you would have set
 * the required value in the htimp.cf file.
 */
	sv = getenv("SCRIPT_NAME");
	if (sv)
		return sv;
	return DEFAULT_SCRIPT_FULL_NAME;
}

/* end */
