/*
 * Copyright 1993,1994 Globetrotter Software, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Globetrotter Software not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  Globetrotter Software makes
 * no representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * GLOBETROTTER SOFTWARE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO
 * EVENT SHALL GLOBETROTTER SOFTWARE BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 *
 * Author:  Jim McBeath, Globetrotter Software, jimmc@globes.com
 */
/* htprint.c - print out HTML messages and mime headers
 *
 * Jim McBeath, November 22, 1993
 */

#include <stdio.h>
#include <sys/types.h>
#include <varargs.h>
#include <errno.h>
#include "htimp.h"
#include "app.h"

extern char *ImpUnixErrstr();
char *ImpGetServerNameAndPort();
char *ImpGetScriptFullName();

void
ImpPrintImpURL(f)
FILE *f;
{
	char *sv;
	char *spn;

	sv = ImpGetServerNameAndPort();
	spn = ImpGetScriptFullName();
	fprintf(f,"http://%s%s",sv,spn);
}

void
ImpPrintThisURL(f,handle)
FILE *f;
char *handle;
{
	char *sv;
	char *spn;

	sv = ImpGetServerNameAndPort();
	spn = ImpGetScriptFullName();
	fprintf(f,"http://%s%s/t/%s",sv,spn,handle);
}

ImpMimeHeader(f)
FILE *f;
{
	fprintf(f,"Content-type: text/html\n\n");
}

ImpMsgHeader(f,title,second)
FILE *f;
char *title;
char *second;
{
	ImpMimeHeader(f);
	fprintf(f,"<head><title>%s</title></head>\n",title);
	fprintf(f,"<h2>%s</h2>\n%s\n",title,second);
}

/* Send back a header line with a redirection line looking like (for example)
 * "Location: http://host:80/cgi-bin/htimp/t/handle"
 */
ImpReplyRedirectToHandle(f,job)
FILE *f;
JobInfo *job;
{

	fprintf(f,"Content-type: text/html\n");
	fprintf(f,"Location: ");
	ImpPrintThisURL(f,job->handle);
	fprintf(f,"\n\n");
	fprintf(f,"<head><title>Try Again</title></head>>\n");
	fprintf(f,"Please select <a href=\"");
	ImpPrintThisURL(f,job->handle);
	fprintf(f,"\">here</a>\n");
}

ImpReplyMessage(f,first,second,fmt,plist)
FILE *f;
char *first;
char *second;
char *fmt;
va_list plist;
{
	ImpMsgHeader(f,first,second);
	fprintf(f,"<plaintext>\n");
	vfprintf(f,fmt,plist);
	fprintf(f,"\n");
}

ImpReplyError(f,fmt,va_alist)
FILE *f;
char *fmt;
va_dcl
{
	va_list plist;

	va_start(plist);
	ImpReplyMessage(f,"Error","",fmt,plist);
	va_end(plist);
}

ImpReplyInfo(f,fmt,va_alist)
FILE *f;
char *fmt;
va_dcl
{
	va_list plist;

	va_start(plist);
	ImpReplyMessage(f,"Info","",fmt,plist);
	va_end(plist);
}

ImpReplyInfoIndex(f,fmt,va_alist)
FILE *f;
char *fmt;
va_dcl
{
	va_list plist;

	va_start(plist);
	ImpReplyMessage(f,"Info","<isindex>",fmt,plist);
	va_end(plist);
}

void
ImpMessage(first,fmt,plist)
char *first;
char *fmt;
va_list plist;
{
	int e;
	int pflag=0;

	e = errno;
	ImpMsgHeader(stdout,first,"");
	printf("<plaintext>\n");
	if (fmt[0]=='+') {
		fmt++;
		pflag = 1;
	}
	vprintf(fmt,plist);
	if (pflag) {
		printf("\n%s\n",ImpUnixErrstr(e));
	}
	printf("\n");
}

/* end */
